//----------------------------------------------------------------------------
// RVStyle.hpp - bcbdcc32 generated hdr (DO NOT EDIT) rev: 0
// From: RVStyle.pas
//----------------------------------------------------------------------------
#ifndef RVStyleHPP
#define RVStyleHPP
//----------------------------------------------------------------------------
#include <RVScroll.hpp>
#include <RVMapWht.hpp>
#include <RVClasses.hpp>
#include <Registry.hpp>
#include <IniFiles.hpp>
#include <Forms.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Messages.hpp>
#include <Windows.hpp>
#include <System.hpp>
namespace Rvstyle
{
//-- type declarations -------------------------------------------------------
struct TRVScreenAndDevice
{
	int ppixScreen;
	int ppiyScreen;
	int ppixDevice;
	int ppiyDevice;
	int LeftMargin;
	int RightMargin;
} ;

typedef TRVScreenAndDevice *PRVScreenAndDevice;

enum TRVSaveFormat { rvsfText, rvsfHTML, rvsfRTF, rvsfRVF };

enum TRVLoadFormat { rvlfText, rvlfHTML, rvlfRTF, rvlfRVF, rvlfURL, rvlfOther };

enum TRVRTFSaveArea { rv_rtfs_TextStyle, rv_rtfs_ParaStyle, rv_rtfs_CellProps, rv_rtfs_RowProps, rv_rtfs_Doc 
	};

enum TRVHTMLSaveArea { rv_thms_Head, rv_thms_BodyAttribute, rv_thms_Body, rv_thms_End };

enum TRVReaderUnicode { rvruMixed, rvruNoUnicode, rvruOnlyUnicode };

enum TRVReaderStyleMode { rvrsUseSpecified, rvrsUseClosest, rvrsAddIfNeeded };

enum TRVFReaderStyleMode { rvf_sIgnore, rvf_sInsertMap, rvf_sInsertMerge };

enum TRVColorMode { rvcmColor, rvcmPrinterColor, rvcmGrayScale, rvcmBlackAndWhite, rvcmBlackOnWhite 
	};

typedef int TRVCodePage;

enum TRVItemBackgroundStyle { rvbsColor, rvbsStretched, rvbsTiled, rvbsCentered };

typedef void *TCheckpointData;

enum TRVTextDrawState { rvtsSelected, rvtsHover, rvtsItemStart, rvtsItemEnd, rvtsDrawItemStart, rvtsDrawItemEnd, 
	rvtsControlFocused };

typedef Set<TRVTextDrawState, rvtsSelected, rvtsControlFocused>  TRVTextDrawStates;

enum TRVPageBreakType { rvpbSoftPageBreak, rvpbPageBreak };

enum TRVBreakStyle { rvbsLine, rvbsRectangle, rvbs3d };

enum TRVVAlign { rvvaBaseline, rvvaMiddle };

enum TRVBorderStyle { rvbNone, rvbSingle, rvbDouble, rvbTriple, rvbThickInside, rvbThickOutside };

enum TRVListType { rvlstBullet, rvlstPicture, rvlstImageList, rvlstDecimal, rvlstLowerAlpha, rvlstUpperAlpha, 
	rvlstLowerRoman, rvlstUpperRoman, rvlstImageListCounter, rvlstUnicodeBullet };

enum TRVMarkerAlignment { rvmaLeft, rvmaRight, rvmaCenter };

enum TRVListLevelOption { rvloContinuous, rvloLevelReset, rvloLegalStyleNumbering };

typedef Set<TRVListLevelOption, rvloContinuous, rvloLegalStyleNumbering>  TRVListLevelOptions;

typedef System::AnsiString TRVMarkerFormatString;

enum TRVFOption { rvfoSavePicturesBody, rvfoSaveControlsBody, rvfoIgnoreUnknownPicFmt, rvfoIgnoreUnknownCtrls, 
	rvfoConvUnknownStylesToZero, rvfoConvLargeImageIdxToZero, rvfoSaveBinary, rvfoUseStyleNames, rvfoSaveBack, 
	rvfoLoadBack, rvfoSaveTextStyles, rvfoSaveParaStyles, rvfoSaveLayout, rvfoLoadLayout, rvfoSaveDocProperties, 
	rvfoLoadDocProperties };

typedef Set<TRVFOption, rvfoSavePicturesBody, rvfoLoadDocProperties>  TRVFOptions;

enum TRVFWarning { rvfwUnknownPicFmt, rvfwUnknownCtrls, rvfwConvUnknownStyles, rvfwConvLargeImageIdx, 
	rvfwConvToUnicode, rvfwConvFromUnicode, rvfwInvalidPicture };

typedef Set<TRVFWarning, rvfwUnknownPicFmt, rvfwInvalidPicture>  TRVFWarnings;

enum TRVControlAction { rvcaAfterRVFLoad, rvcaDestroy, rvcaMoveToUndoList, rvcaMoveFromUndoList, rvcaDestroyInUndoList, 
	rvcaBeforeRVFSave, rvcaAfterRVFSave };

enum TRVItemAction { rviaInserting, rviaInserted, rviaTextModifying, rviaDestroying, rviaMovingToUndoList 
	};

enum TRVProtectOption { rvprStyleProtect, rvprModifyProtect, rvprDeleteProtect, rvprConcateProtect, 
	rvprRVFInsertProtect, rvprDoNotAutoSwitch, rvprParaStartProtect, rvprSticking, rvprStickToTop, rvprStickToBottom 
	};

typedef Set<TRVProtectOption, rvprStyleProtect, rvprStickToBottom>  TRVProtectOptions;

enum TRVParaOption { rvpaoNoWrap, rvpaoReadOnly, rvpaoStyleProtect, rvpaoDoNotWantReturns };

typedef Set<TRVParaOption, rvpaoNoWrap, rvpaoDoNotWantReturns>  TRVParaOptions;

enum TRVTextOption { rvteoHTMLCode, rvteoRTFCode };

typedef Set<TRVTextOption, rvteoHTMLCode, rvteoRTFCode>  TRVTextOptions;

enum TRVSaveOption { rvsoOverrideImages, rvsoFirstOnly, rvsoMiddleOnly, rvsoLastOnly, rvsoDefault0Style, 
	rvsoNoHypertextImageBorders, rvsoImageSizes, rvsoForceNonTextCSS, rvsoUseCheckpointsNames, rvsoMarkersAsText, 
	rvsoInlineCSS, rvsoNoDefCSSStyle };

typedef Set<TRVSaveOption, rvsoOverrideImages, rvsoNoDefCSSStyle>  TRVSaveOptions;

enum TRVRTFOption { rvrtfSaveStyleSheet, rvrtfDuplicateUnicode, rvrtfSaveEMFAsWMF, rvrtfSaveJpegAsJpeg, 
	rvrtfSaveBitmapDefault, rvrtfSaveEMFDefault };

typedef Set<TRVRTFOption, rvrtfSaveStyleSheet, rvrtfSaveEMFDefault>  TRVRTFOptions;

enum TRVFontStyle { rvfsOverline, rvfsAllCaps };

typedef Set<TRVFontStyle, rvfsOverline, rvfsAllCaps>  TRVFontStyles;

enum TRVAlignment { rvaLeft, rvaRight, rvaCenter, rvaJustify };


enum TRVSaveCSSOption { rvcssOnlyDifference, rvcssIgnoreLeftAlignment, rvcssNoDefCSSStyle };

typedef Set<TRVSaveCSSOption, rvcssOnlyDifference, rvcssNoDefCSSStyle>  TRVSaveCSSOptions;

enum TRVFontInfoProperty { rvfiFontName, rvfiSize, rvfiCharset, rvfiUnicode, rvfiBold, rvfiItalic, rvfiUnderline, 
	rvfiStrikeout, rvfiOverline, rvfiAllCaps, rvfiVShift, rvfiColor, rvfiBackColor, rvfiJump, rvfiHoverBackColor, 
	rvfiHoverColor, rvfiJumpCursor, rvfiNextStyleNo, rvfiProtection, rvfiCharScale, rvfiBaseStyleNo, rvfiBiDiMode, 
	rvfiCharSpacing, rvfiHTMLCode, rvfiRTFCode };

enum TRVParaInfoProperty { rvpiFirstIndent, rvpiLeftIndent, rvpiRightIndent, rvpiSpaceBefore, rvpiSpaceAfter, 
	rvpiAlignment, rvpiNextParaNo, rvpiDefStyleNo, rvpiLineSpacing, rvpiLineSpacingType, rvpiBackground_Color, 
	rvpiBackground_BO_Left, rvpiBackground_BO_Top, rvpiBackground_BO_Right, rvpiBackground_BO_Bottom, rvpiBorder_Color, 
	rvpiBorder_Style, rvpiBorder_Width, rvpiBorder_InternalWidth, rvpiBorder_BO_Left, rvpiBorder_BO_Top, 
	rvpiBorder_BO_Right, rvpiBorder_BO_Bottom, rvpiBorder_Vis_Left, rvpiBorder_Vis_Top, rvpiBorder_Vis_Right, 
	rvpiBorder_Vis_Bottom, rvpiNoWrap, rvpiReadOnly, rvpiStyleProtect, rvpiDoNotWantReturns, rvpiBiDiMode 
	};

typedef Set<TRVFontInfoProperty, rvfiFontName, rvfiRTFCode>  TRVFontInfoProperties;

typedef Set<TRVParaInfoProperty, rvpiFirstIndent, rvpiBiDiMode>  TRVParaInfoProperties;

enum TRVLineSpacingType { rvlsPercent, rvlsSpaceBetween };

enum TRVStyleMergeMode { rvs_merge_SmartMerge, rvs_merge_Map, rvs_merge_Append };

enum TRVSelectionMode { rvsmChar, rvsmWord, rvsmParagraph };

enum TRVSelectionStyle { rvssItems, rvssLines };

class __declspec(delphiclass) TRVStyle;
typedef void __fastcall (__closure *TRVDrawTextBackEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int StyleNo, int Left, int Top, int Width, int Height, TRVTextDrawStates DrawState, bool &DoDefault
	);

typedef void __fastcall (__closure *TRVApplyStyleEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas, 
	int StyleNo, bool &DoDefault);

typedef void __fastcall (__closure *TRVApplyStyleColorEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int StyleNo, TRVTextDrawStates DrawState, bool &DoDefault);

typedef void __fastcall (__closure *TRVDrawStyleTextEvent)(TRVStyle* Sender, const System::AnsiString 
	s, Graphics::TCanvas* Canvas, int StyleNo, int SpaceBefore, int Left, int Top, int Width, int Height
	, TRVTextDrawStates DrawState, bool &DoDefault);

typedef void __fastcall (__closure *TRVStyleHoverSensitiveEvent)(TRVStyle* Sender, int StyleNo, bool 
	&Sensitive);

typedef void __fastcall (__closure *TRVDrawCheckpointEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int X, int Y, int ItemNo, int XShift, bool RaiseEvent, Controls::TControl* Control, bool &DoDefault
	);

typedef void __fastcall (__closure *TRVDrawPageBreakEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int Y, int XShift, TRVPageBreakType PageBreakType, Controls::TControl* Control, bool &DoDefault);
	

typedef void __fastcall (__closure *TRVDrawParaRectEvent)(TRVStyle* Sender, Graphics::TCanvas* Canvas
	, int ParaNo, const Windows::TRect &ARect, bool &DoDefault);

class __declspec(delphiclass) TCustomRVInfo;
class __declspec(pascalimplementation) TCustomRVInfo : public Classes::TCollectionItem
{
	typedef Classes::TCollectionItem inherited;
	
private:
	int FBaseStyleNo;
	System::AnsiString FName;
	bool FStandard;
	
protected:
	virtual bool __fastcall IsSimpleEqual(TCustomRVInfo* Value, bool IgnoreReferences, bool IgnoreID) = 0
		;
	virtual bool __fastcall IsSimpleEqualEx(TCustomRVInfo* Value, Rvclasses::TRVIntegerList* Mapping) = 0
		;
	virtual int __fastcall SimilarityValue(TCustomRVInfo* Value) = 0;
	
public:
	__fastcall virtual TCustomRVInfo(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs, const System::AnsiString DefName);
	
__published:
	__property int BaseStyleNo = {read=FBaseStyleNo, write=FBaseStyleNo, default=-1};
	__property System::AnsiString StyleName = {read=FName, write=FName, nodefault};
	__property bool Standard = {read=FStandard, write=FStandard, default=1};
public:
	/* TCollectionItem.Destroy */ __fastcall virtual ~TCustomRVInfo(void) { }
	
};

class __declspec(delphiclass) TFontInfo;
class __declspec(pascalimplementation) TFontInfo : public TCustomRVInfo
{
	typedef TCustomRVInfo inherited;
	
private:
	TRVBiDiMode FBiDiMode;
	bool FJump;
	Controls::TCursor FJumpCursor;
	Graphics::TFontName FFontName;
	int FSize;
	Graphics::TColor FColor;
	Graphics::TColor FBackColor;
	Graphics::TColor FHoverColor;
	Graphics::TColor FHoverBackColor;
	Graphics::TFontStyles FStyle;
	TRVFontStyles FStyleEx;
	int FVShift;
	int FNextStyleNo;
	bool FUnicode;
	TRVProtectOptions FProtection;
	TRVTextOptions FOptions;
	int FCharScale;
	int FCharSpacing;
	void __fastcall SingleSymbolsReader(Classes::TReader* reader);
	
protected:
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	virtual bool __fastcall IsSimpleEqual(TCustomRVInfo* Value, bool IgnoreReferences, bool IgnoreID);
	virtual bool __fastcall IsSimpleEqualEx(TCustomRVInfo* Value, Rvclasses::TRVIntegerList* Mapping);
	virtual int __fastcall SimilarityValue(TCustomRVInfo* Value);
	
public:
	__fastcall virtual TFontInfo(Classes::TCollection* Collection);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall AssignToLogFont(tagLOGFONTA &LogFont, Graphics::TCanvas* Canvas);
	void __fastcall Apply(Graphics::TCanvas* Canvas, Rvscroll::TRVBiDiMode DefBiDiMode);
	void __fastcall ApplyColor(Graphics::TCanvas* Canvas, TRVStyle* RVStyle, TRVTextDrawStates DrawState
		, bool Printing, TRVColorMode ColorMode);
	void __fastcall Draw(const System::AnsiString s, Graphics::TCanvas* Canvas, int ThisStyleNo, int SpaceBefore
		, int Left, int Top, int Width, int Height, TRVStyle* RVStyle, TRVTextDrawStates DrawState, bool Printing
		, bool PreviewCorrection, TRVColorMode ColorMode, Rvscroll::TRVBiDiMode DefBiDiMode);
	void __fastcall DrawVertical(const System::AnsiString s, Graphics::TCanvas* Canvas, int ThisStyleNo
		, int SpaceBefore, int Left, int Top, int Width, int Height, TRVStyle* RVStyle, TRVTextDrawStates 
		DrawState);
	bool __fastcall IsEqual(TFontInfo* Value, TRVFontInfoProperties IgnoreList);
	HIDESBASE void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	HIDESBASE void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs, bool JumpByDefault, Controls::TCursor DefJumpCursor);
	void __fastcall SaveCSSToStream(Classes::TStream* Stream, TFontInfo* BaseStyle, bool Multiline);
	
__published:
	__property Graphics::TFontName FontName = {read=FFontName, write=FFontName};
	__property int Size = {read=FSize, write=FSize, default=10};
	__property Graphics::TFontStyles Style = {read=FStyle, write=FStyle, default=0};
	__property int VShift = {read=FVShift, write=FVShift, default=0};
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=-2147483640};
	__property Graphics::TColor BackColor = {read=FBackColor, write=FBackColor, default=536870911};
	__property Graphics::TColor HoverBackColor = {read=FHoverBackColor, write=FHoverBackColor, default=536870911
		};
	__property Graphics::TColor HoverColor = {read=FHoverColor, write=FHoverColor, default=536870911};
	__property TRVFontStyles StyleEx = {read=FStyleEx, write=FStyleEx, default=0};
	__property bool Jump = {read=FJump, write=FJump, default=0};
	__property Controls::TCursor JumpCursor = {read=FJumpCursor, write=FJumpCursor, default=101};
	__property int CharScale = {read=FCharScale, write=FCharScale, default=100};
	__property int CharSpacing = {read=FCharSpacing, write=FCharSpacing, default=0};
	__property int NextStyleNo = {read=FNextStyleNo, write=FNextStyleNo, default=-1};
	__property Rvscroll::TRVBiDiMode BiDiMode = {read=FBiDiMode, write=FBiDiMode, default=0};
	__property bool Unicode = {read=FUnicode, write=FUnicode, default=0};
	__property TRVProtectOptions Protection = {read=FProtection, write=FProtection, default=0};
	__property TRVTextOptions Options = {read=FOptions, write=FOptions, default=0};
public:
	/* TCollectionItem.Destroy */ __fastcall virtual ~TFontInfo(void) { }
	
};

class __declspec(delphiclass) TCustomRVInfos;
class __declspec(pascalimplementation) TCustomRVInfos : public Classes::TCollection
{
	typedef Classes::TCollection inherited;
	
private:
	Classes::TPersistent* FOwner;
	
public:
	__fastcall TCustomRVInfos(System::TMetaClass* ItemClass, Classes::TPersistent* Owner);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall MergeWith(TCustomRVInfos* Styles, TRVStyleMergeMode Mode, Rvclasses::TRVIntegerList* 
		Mapping, Rvclasses::TRVIntegerList* TextStyleMapping);
public:
	/* TCollection.Destroy */ __fastcall virtual ~TCustomRVInfos(void) { }
	
};

class __declspec(delphiclass) TFontInfos;
class __declspec(pascalimplementation) TFontInfos : public TCustomRVInfos
{
	typedef TCustomRVInfos inherited;
	
private:
	TFontInfo* FInvalidItem;
	HIDESBASE TFontInfo* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TFontInfo* Value);
	TFontInfo* __fastcall GetInvalidItem(void);
	void __fastcall SetInvalidItem(TFontInfo* const Value);
	
public:
	int PixelsPerInch;
	__fastcall virtual ~TFontInfos(void);
	int __fastcall FindStyleWithFontStyle(int BaseStyle, Graphics::TFontStyles Value, Graphics::TFontStyles 
		Mask);
	int __fastcall FindStyleWithFontSize(int BaseStyle, int Size);
	int __fastcall FindStyleWithColor(int BaseStyle, Graphics::TColor Color, Graphics::TColor BackColor
		);
	int __fastcall FindStyleWithFontName(int BaseStyle, const Graphics::TFontName &FontName);
	int __fastcall FindSuchStyle(int BaseStyle, TFontInfo* Style, TRVFontInfoProperties Mask);
	int __fastcall FindStyleWithFont(int BaseStyle, Graphics::TFont* Font);
	HIDESBASE TFontInfo* __fastcall Add(void);
	TFontInfo* __fastcall AddFont( Graphics::TFontName &Name, int Size, Graphics::TColor Color, Graphics::TColor 
		BackColor, Graphics::TFontStyles Style);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, Controls::TCursor 
		DefJumpCursor);
	__property TFontInfo* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
	__property TFontInfo* InvalidItem = {read=GetInvalidItem, write=SetInvalidItem, nodefault};
public:
	/* TCustomRVInfos.Create */ __fastcall TFontInfos(System::TMetaClass* ItemClass, Classes::TPersistent* 
		Owner) : Rvstyle::TCustomRVInfos(ItemClass, Owner) { }
	
};

class __declspec(delphiclass) TRVRect;
class __declspec(pascalimplementation) TRVRect : public Classes::TPersistent
{
	typedef Classes::TPersistent inherited;
	
private:
	int FTop;
	int FLeft;
	int FRight;
	int FBottom;
	bool __fastcall IsEqualEx(TRVRect* Value, bool IgnL, bool IgnT, bool IgnR, bool IgnB);
	int __fastcall SimilarityValue(TRVRect* Value, int Weight);
	
public:
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall SetAll(int Value);
	void __fastcall InflateRect(Windows::TRect &Rect);
	void __fastcall InflateRectSaD(Windows::TRect &Rect, const TRVScreenAndDevice &sad);
	void __fastcall AssignToRect(Windows::TRect &Rect);
	void __fastcall AssignToRectIfGreater(Windows::TRect &Rect);
	bool __fastcall IsEqual(TRVRect* Value);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	
__published:
	__property int Left = {read=FLeft, write=FLeft, default=0};
	__property int Right = {read=FRight, write=FRight, default=0};
	__property int Top = {read=FTop, write=FTop, default=0};
	__property int Bottom = {read=FBottom, write=FBottom, default=0};
public:
	/* TObject.Create */ __fastcall TRVRect(void) : Classes::TPersistent() { }
	/* TObject.Destroy */ __fastcall virtual ~TRVRect(void) { }
	
};

class __declspec(delphiclass) TRVBooleanRect;
class __declspec(pascalimplementation) TRVBooleanRect : public Classes::TPersistent
{
	typedef Classes::TPersistent inherited;
	
private:
	bool FTop;
	bool FLeft;
	bool FRight;
	bool FBottom;
	bool __fastcall IsEqualEx(TRVBooleanRect* Value, bool IgnL, bool IgnT, bool IgnR, bool IgnB);
	
public:
	__fastcall TRVBooleanRect(bool DefValue);
	void __fastcall SetAll(bool Value);
	void __fastcall SetValues(bool ALeft, bool ATop, bool ARight, bool ABottom);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	bool __fastcall IsEqual(TRVBooleanRect* Value);
	bool __fastcall IsEqual2(bool ALeft, bool ATop, bool ARight, bool ABottom);
	bool __fastcall IsAllEqual(bool Value);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	
__published:
	__property bool Left = {read=FLeft, write=FLeft, default=1};
	__property bool Right = {read=FRight, write=FRight, default=1};
	__property bool Top = {read=FTop, write=FTop, default=1};
	__property bool Bottom = {read=FBottom, write=FBottom, default=1};
public:
	/* TObject.Destroy */ __fastcall virtual ~TRVBooleanRect(void) { }
	
};

class __declspec(delphiclass) TRVBorder;
class __declspec(pascalimplementation) TRVBorder : public Classes::TPersistent
{
	typedef Classes::TPersistent inherited;
	
private:
	Graphics::TColor FColor;
	TRVBorderStyle FStyle;
	int FWidth;
	int FInternalWidth;
	TRVBooleanRect* FVisibleBorders;
	TRVRect* FBorderOffsets;
	void __fastcall SetBorderOffsets(TRVRect* const Value);
	void __fastcall SetVisibleBorders(TRVBooleanRect* const Value);
	int __fastcall SimilarityValue(TRVBorder* Value);
	
protected:
	void __fastcall DoDraw(const Windows::TRect &Rect, Graphics::TCanvas* Canvas, int Width, int InternalWidth
		, int OnePixelWidth, TRVColorMode ColorMode);
	
public:
	__fastcall TRVBorder(void);
	__fastcall virtual ~TRVBorder(void);
	void __fastcall Draw(const Windows::TRect &Rect, Graphics::TCanvas* Canvas);
	void __fastcall DrawSaD(const Windows::TRect &Rect, Graphics::TCanvas* Canvas, const TRVScreenAndDevice 
		&sad, TRVColorMode ColorMode);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	bool __fastcall IsEqual(TRVBorder* Value);
	bool __fastcall IsEqual_Para(TRVBorder* Value, TRVParaInfoProperties IgnoreList);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	int __fastcall GetTotalWidth(void);
	
__published:
	__property int Width = {read=FWidth, write=FWidth, default=1};
	__property int InternalWidth = {read=FInternalWidth, write=FInternalWidth, default=1};
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=-2147483640};
	__property TRVBorderStyle Style = {read=FStyle, write=FStyle, default=0};
	__property TRVBooleanRect* VisibleBorders = {read=FVisibleBorders, write=SetVisibleBorders, nodefault
		};
	__property TRVRect* BorderOffsets = {read=FBorderOffsets, write=SetBorderOffsets, nodefault};
};

class __declspec(delphiclass) TRVBackgroundRect;
class __declspec(pascalimplementation) TRVBackgroundRect : public Classes::TPersistent
{
	typedef Classes::TPersistent inherited;
	
private:
	TRVRect* FBorderOffsets;
	Graphics::TColor FColor;
	void __fastcall SetBorderOffsets(TRVRect* const Value);
	int __fastcall SimilarityValue(TRVBackgroundRect* Value);
	
public:
	__fastcall TRVBackgroundRect(void);
	__fastcall virtual ~TRVBackgroundRect(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	void __fastcall PrepareDraw(Windows::TRect &Rect);
	void __fastcall PrepareDrawSaD(Windows::TRect &Rect, const TRVScreenAndDevice &sad);
	void __fastcall Draw(const Windows::TRect &Rect, Graphics::TCanvas* Canvas, bool Printing, TRVColorMode 
		ColorMode);
	bool __fastcall IsEqual(TRVBackgroundRect* Value);
	bool __fastcall IsEqual_Para(TRVBackgroundRect* Value, TRVParaInfoProperties IgnoreList);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	
__published:
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=536870911};
	__property TRVRect* BorderOffsets = {read=FBorderOffsets, write=SetBorderOffsets, nodefault};
};

class __declspec(delphiclass) TParaInfo;
class __declspec(pascalimplementation) TParaInfo : public TCustomRVInfo
{
	typedef TCustomRVInfo inherited;
	
private:
	int FFirstIndent;
	int FLeftIndent;
	int FRightIndent;
	int FSpaceBefore;
	int FSpaceAfter;
	int FLineSpacing;
	TRVLineSpacingType FLineSpacingType;
	TRVAlignment FAlignment;
	TRVBorder* FBorder;
	int FNextParaNo;
	TRVBackgroundRect* FBackground;
	TRVParaOptions FOptions;
	TRVBiDiMode FBiDiMode;
	int FDefStyleNo;
	void __fastcall SetBorder(TRVBorder* const Value);
	void __fastcall SetBackground(TRVBackgroundRect* const Value);
	bool __fastcall ExtraLineSpacing(void);
	
protected:
	virtual bool __fastcall IsSimpleEqual(TCustomRVInfo* Value, bool IgnoreReferences, bool IgnoreID);
	virtual bool __fastcall IsSimpleEqualEx(TCustomRVInfo* Value, Rvclasses::TRVIntegerList* Mapping);
	virtual int __fastcall SimilarityValue(TCustomRVInfo* Value);
	
public:
	__fastcall virtual TParaInfo(Classes::TCollection* Collection);
	__fastcall virtual ~TParaInfo(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	HIDESBASE void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	HIDESBASE void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	bool __fastcall IsEqual(TParaInfo* Value, TRVParaInfoProperties IgnoreList);
	void __fastcall SaveCSSToStream(Classes::TStream* Stream, TParaInfo* BaseStyle, bool Multiline, bool 
		IgnoreLeftAlignment, bool IgnoreLeftIndents);
	
__published:
	__property int FirstIndent = {read=FFirstIndent, write=FFirstIndent, default=0};
	__property int LeftIndent = {read=FLeftIndent, write=FLeftIndent, default=0};
	__property int RightIndent = {read=FRightIndent, write=FRightIndent, default=0};
	__property int SpaceBefore = {read=FSpaceBefore, write=FSpaceBefore, default=0};
	__property int SpaceAfter = {read=FSpaceAfter, write=FSpaceAfter, default=0};
	__property TRVAlignment Alignment = {read=FAlignment, write=FAlignment, default=0};
	__property TRVBorder* Border = {read=FBorder, write=SetBorder, nodefault};
	__property TRVBackgroundRect* Background = {read=FBackground, write=SetBackground, nodefault};
	__property int NextParaNo = {read=FNextParaNo, write=FNextParaNo, default=-1};
	__property int DefStyleNo = {read=FDefStyleNo, write=FDefStyleNo, default=-1};
	__property int LineSpacing = {read=FLineSpacing, write=FLineSpacing, default=100};
	__property TRVLineSpacingType LineSpacingType = {read=FLineSpacingType, write=FLineSpacingType, default=0
		};
	__property TRVParaOptions Options = {read=FOptions, write=FOptions, nodefault};
	__property Rvscroll::TRVBiDiMode BiDiMode = {read=FBiDiMode, write=FBiDiMode, default=0};
};

class __declspec(delphiclass) TParaInfos;
class __declspec(pascalimplementation) TParaInfos : public TCustomRVInfos
{
	typedef TCustomRVInfos inherited;
	
private:
	TParaInfo* FInvalidItem;
	HIDESBASE TParaInfo* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TParaInfo* Value);
	TParaInfo* __fastcall GetInvalidItem(void);
	void __fastcall SetInvalidItem(TParaInfo* const Value);
	
public:
	HIDESBASE TParaInfo* __fastcall Add(void);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section);
	int __fastcall FindSuchStyle(int BaseStyle, TParaInfo* Style, TRVParaInfoProperties Mask);
	int __fastcall FindStyleWithAlignment(int BaseStyle, TRVAlignment Alignment);
	__property TParaInfo* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
	__property TParaInfo* InvalidItem = {read=GetInvalidItem, write=SetInvalidItem, nodefault};
public:
	/* TCustomRVInfos.Create */ __fastcall TParaInfos(System::TMetaClass* ItemClass, Classes::TPersistent* 
		Owner) : Rvstyle::TCustomRVInfos(ItemClass, Owner) { }
	
public:
	/* TCollection.Destroy */ __fastcall virtual ~TParaInfos(void) { }
	
};

class __declspec(delphiclass) TRVMarkerFont;
class __declspec(pascalimplementation) TRVMarkerFont : public Graphics::TFont
{
	typedef Graphics::TFont inherited;
	
private:
	bool __fastcall StoreName(void);
	bool __fastcall StoreHeight(void);
	
public:
	__fastcall TRVMarkerFont(void);
	bool __fastcall IsEqual(Graphics::TFont* Font);
	bool __fastcall IsDefault(void);
	
__published:
	__property Color ;
	__property Name  = {stored=StoreName};
	__property Style ;
	__property Height  = {stored=StoreHeight};
public:
	/* TFont.Destroy */ __fastcall virtual ~TRVMarkerFont(void) { }
	
};

class __declspec(delphiclass) TRVListLevel;
class __declspec(pascalimplementation) TRVListLevel : public Classes::TCollectionItem
{
	typedef Classes::TCollectionItem inherited;
	
private:
	TRVListType FListType;
	Graphics::TPicture* FPicture;
	Controls::TCustomImageList* FImageList;
	int FImageIndex;
	System::AnsiString FFormatString;
	int FLeftIndent;
	int FFirstIndent;
	int FMarkerIndent;
	TRVMarkerAlignment FMarkerAlignment;
	TRVMarkerFont* FFont;
	TRVListLevelOptions FOptions;
	int FStartFrom;
	Graphics::TPicture* __fastcall GetPicture(void);
	void __fastcall SetPicture(Graphics::TPicture* const Value);
	TRVMarkerFont* __fastcall GetFont(void);
	void __fastcall SetFont(TRVMarkerFont* const Value);
	bool __fastcall StoreFont(void);
	bool __fastcall StorePicture(void);
	void __fastcall ImageListTagWriter(Classes::TWriter* Writer);
	void __fastcall ImageListTagReader(Classes::TReader* Reader);
	void __fastcall FormatStringCodeWriter(Classes::TWriter* Writer);
	void __fastcall FormatStringCodeReader(Classes::TReader* Reader);
	bool __fastcall StoreImageList(void);
	Classes::TPersistent* __fastcall GetRVFRVData(void);
	
protected:
	bool __fastcall IsSimpleEqual(TRVListLevel* Value);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	int __fastcall SimilarityValue(TRVListLevel* Value);
	
public:
	__fastcall virtual TRVListLevel(Classes::TCollection* Collection);
	__fastcall virtual ~TRVListLevel(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	System::AnsiString __fastcall GetHTMLOpenTagForCSS(void);
	System::AnsiString __fastcall GetIndentCSSForTextVersion(void);
	void __fastcall HTMLOpenTag(Classes::TStream* Stream, bool UseCSS);
	void __fastcall HTMLCloseTag(Classes::TStream* Stream, bool UseCSS);
	bool __fastcall HasPicture(void);
	bool __fastcall UsesFont(void);
	bool __fastcall HasNumbering(void);
	bool __fastcall HasVariableWidth(void);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	
__published:
	__property TRVListType ListType = {read=FListType, write=FListType, default=0};
	__property int StartFrom = {read=FStartFrom, write=FStartFrom, default=1};
	__property Controls::TCustomImageList* ImageList = {read=FImageList, write=FImageList, stored=StoreImageList
		, nodefault};
	__property int ImageIndex = {read=FImageIndex, write=FImageIndex, default=0};
	__property System::AnsiString FormatString = {read=FFormatString, write=FFormatString, stored=false
		, nodefault};
	__property int LeftIndent = {read=FLeftIndent, write=FLeftIndent, default=0};
	__property int FirstIndent = {read=FFirstIndent, write=FFirstIndent, default=10};
	__property int MarkerIndent = {read=FMarkerIndent, write=FMarkerIndent, default=0};
	__property TRVMarkerAlignment MarkerAlignment = {read=FMarkerAlignment, write=FMarkerAlignment, default=0
		};
	__property Graphics::TPicture* Picture = {read=GetPicture, write=SetPicture, stored=StorePicture, nodefault
		};
	__property TRVMarkerFont* Font = {read=GetFont, write=SetFont, stored=StoreFont, nodefault};
	__property TRVListLevelOptions Options = {read=FOptions, write=FOptions, default=3};
};

class __declspec(delphiclass) TRVListLevelCollection;
class __declspec(pascalimplementation) TRVListLevelCollection : public Classes::TCollection
{
	typedef Classes::TCollection inherited;
	
private:
	Classes::TPersistent* FOwner;
	HIDESBASE TRVListLevel* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TRVListLevel* const Value);
	
public:
	__fastcall TRVListLevelCollection(Classes::TPersistent* Owner);
	HIDESBASE TRVListLevel* __fastcall Add(void);
	bool __fastcall IsSimpleEqual(TRVListLevelCollection* Value);
	__property TRVListLevel* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
public:
	/* TCollection.Destroy */ __fastcall virtual ~TRVListLevelCollection(void) { }
	
};

class __declspec(delphiclass) TRVListInfo;
class __declspec(pascalimplementation) TRVListInfo : public TCustomRVInfo
{
	typedef TCustomRVInfo inherited;
	
private:
	TRVListLevelCollection* FLevels;
	bool FOneLevelPreview;
	int FListID;
	void __fastcall SetLevels(TRVListLevelCollection* const Value);
	int __fastcall GetListID(void);
	void __fastcall ReadListID(Classes::TReader* Reader);
	void __fastcall WriteListID(Classes::TWriter* Writer);
	
protected:
	virtual int __fastcall SimilarityValue(TCustomRVInfo* Value);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	
public:
	virtual bool __fastcall IsSimpleEqual(TCustomRVInfo* Value, bool IgnoreReferences, bool IgnoreID);
	virtual bool __fastcall IsSimpleEqualEx(TCustomRVInfo* Value, Rvclasses::TRVIntegerList* Mapping);
	__fastcall virtual TRVListInfo(Classes::TCollection* Collection);
	__fastcall virtual ~TRVListInfo(void);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	HIDESBASE void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	HIDESBASE void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section, const System::AnsiString 
		fs);
	bool __fastcall HasNumbering(void);
	bool __fastcall AllNumbered(void);
	bool __fastcall HasVariableWidth(void);
	__property int ListID = {read=GetListID, nodefault};
	
__published:
	__property TRVListLevelCollection* Levels = {read=FLevels, write=SetLevels, nodefault};
	__property bool OneLevelPreview = {read=FOneLevelPreview, write=FOneLevelPreview, default=0};
};

class __declspec(delphiclass) TRVListInfos;
class __declspec(pascalimplementation) TRVListInfos : public TCustomRVInfos
{
	typedef TCustomRVInfos inherited;
	
private:
	HIDESBASE TRVListInfo* __fastcall GetItem(int Index);
	HIDESBASE void __fastcall SetItem(int Index, TRVListInfo* const Value);
	void __fastcall RemoveImageList(Controls::TCustomImageList* ImageList);
	
public:
	Classes::TPersistent* FRVData;
	HIDESBASE TRVListInfo* __fastcall Add(void);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini, const System::AnsiString Section);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini, const System::AnsiString Section);
	int __fastcall FindSuchStyle(TRVListInfo* Style, bool AddIfNotFound);
	int __fastcall FindStyleWithLevels(TRVListLevelCollection* Levels, const System::AnsiString StyleNameForAdding
		, bool AddIfNotFound);
	__property TRVListInfo* Items[int Index] = {read=GetItem, write=SetItem/*, default*/};
public:
	/* TCustomRVInfos.Create */ __fastcall TRVListInfos(System::TMetaClass* ItemClass, Classes::TPersistent* 
		Owner) : Rvstyle::TCustomRVInfos(ItemClass, Owner) { }
	
public:
	/* TCollection.Destroy */ __fastcall virtual ~TRVListInfos(void) { }
	
};

typedef System::TMetaClass*TRVFontInfoClass;

typedef System::TMetaClass*TRVParaInfoClass;

typedef System::TMetaClass*TRVListInfoClass;

class __declspec(pascalimplementation) TRVStyle : public Classes::TComponent
{
	typedef Classes::TComponent inherited;
	
private:
	Graphics::TPicture* FInvalidPicture;
	Graphics::TColor FColor;
	Graphics::TColor FHoverColor;
	Graphics::TColor FSelColor;
	Graphics::TColor FSelTextColor;
	Graphics::TColor FInactiveSelColor;
	Graphics::TColor FInactiveSelTextColor;
	Graphics::TColor FCheckpointColor;
	Graphics::TColor FCheckpointEvColor;
	Controls::TCursor FJumpCursor;
	TFontInfos* FTextStyles;
	TParaInfos* FParaStyles;
	TRVListInfos* FListStyles;
	bool FFullRedraw;
	short FSpacesInTab;
	Graphics::TColor FPageBreakColor;
	Graphics::TColor FSoftPageBreakColor;
	TRVApplyStyleColorEvent FOnApplyStyleColor;
	TRVApplyStyleEvent FOnApplyStyle;
	TRVDrawStyleTextEvent FOnDrawStyleText;
	TRVStyleHoverSensitiveEvent FOnStyleHoverSensitive;
	TRVDrawTextBackEvent FOnDrawTextBack;
	TRVDrawCheckpointEvent FOnDrawCheckpoint;
	TRVDrawPageBreakEvent FOnDrawPageBreak;
	TRVDrawParaRectEvent FOnDrawParaBack;
	int FDefUnicodeStyle;
	TRVCodePage FDefCodePage;
	bool FUseSound;
	TRVSelectionMode FSelectionMode;
	TRVSelectionStyle FSelectionStyle;
	Controls::TCursor FLineSelectCursor;
	void __fastcall SetTextStyles(TFontInfos* Value);
	void __fastcall SetParaStyles(TParaInfos* Value);
	void __fastcall SetListStyles(TRVListInfos* Value);
	Graphics::TColor __fastcall GetHoverColorByColor(Graphics::TColor Color);
	Graphics::TPicture* __fastcall GetInvalidPicture(void);
	void __fastcall SetInvalidPicture(Graphics::TPicture* const Value);
	
protected:
	virtual void __fastcall ReadState(Classes::TReader* Reader);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	
public:
	int ItemNo;
	int OffsetInItem;
	Classes::TPersistent* RVData;
	void __fastcall ResetTextStyles(void);
	void __fastcall ResetParaStyles(void);
	__fastcall virtual TRVStyle(Classes::TComponent* AOwner);
	__fastcall virtual ~TRVStyle(void);
	virtual System::TMetaClass* __fastcall GetTextStyleClass(void);
	virtual System::TMetaClass* __fastcall GetParaStyleClass(void);
	virtual System::TMetaClass* __fastcall GetListStyleClass(void);
	int __fastcall AddTextStyle(void);
	void __fastcall DeleteTextStyle(int Index);
	void __fastcall SaveINI(const System::AnsiString FileName, const System::AnsiString Section);
	void __fastcall LoadINI(const System::AnsiString FileName, const System::AnsiString Section);
	void __fastcall SaveToINI(Inifiles::TIniFile* ini,  System::AnsiString Section);
	void __fastcall LoadFromINI(Inifiles::TIniFile* ini,  System::AnsiString Section);
	void __fastcall SaveCSSToStream(Classes::TStream* Stream, TRVSaveCSSOptions AOptions);
	bool __fastcall SaveCSS(const System::AnsiString FileName, TRVSaveCSSOptions AOptions);
	Graphics::TColor __fastcall GetHoverColor(int StyleNo);
	void __fastcall DrawTextBack(Graphics::TCanvas* Canvas, int ItemNo, int StyleNo, Classes::TPersistent* 
		RVData, int Left, int Top, int Width, int Height, TRVTextDrawStates DrawState);
	void __fastcall ApplyStyle(Graphics::TCanvas* Canvas, int StyleNo, Rvscroll::TRVBiDiMode DefBiDiMode
		);
	void __fastcall ApplyStyleColor(Graphics::TCanvas* Canvas, int StyleNo, TRVTextDrawStates DrawState
		, bool Printing, TRVColorMode ColorMode);
	void __fastcall DrawStyleText(const System::AnsiString s, Graphics::TCanvas* Canvas, int ItemNo, int 
		OffsetInItem, int StyleNo, Classes::TPersistent* RVData, int SpaceBefore, int Left, int Top, int Width
		, int Height, TRVTextDrawStates DrawState, bool Printing, bool PreviewCorrection, TRVColorMode ColorMode
		, Rvscroll::TRVBiDiMode DefBiDiMode);
	void __fastcall DrawCheckpoint(Graphics::TCanvas* Canvas, int X, int Y, int ItemNo, int XShift, bool 
		RaiseEvent, Controls::TControl* Control);
	void __fastcall DrawPageBreak(Graphics::TCanvas* Canvas, int Y, int XShift, TRVPageBreakType PageBreakType
		, Controls::TControl* Control);
	void __fastcall DrawParaBack(Graphics::TCanvas* Canvas, int ParaNo, const Windows::TRect &Rect, bool 
		Printing, TRVColorMode ColorMode);
	bool __fastcall StyleHoverSensitive(int StyleNo);
	
__published:
	__property TFontInfos* TextStyles = {read=FTextStyles, write=SetTextStyles, nodefault};
	__property TParaInfos* ParaStyles = {read=FParaStyles, write=SetParaStyles, nodefault};
	__property TRVListInfos* ListStyles = {read=FListStyles, write=SetListStyles, nodefault};
	__property short SpacesInTab = {read=FSpacesInTab, write=FSpacesInTab, default=8};
	__property Controls::TCursor JumpCursor = {read=FJumpCursor, write=FJumpCursor, default=101};
	__property Controls::TCursor LineSelectCursor = {read=FLineSelectCursor, write=FLineSelectCursor, default=106
		};
	__property bool FullRedraw = {read=FFullRedraw, write=FFullRedraw, default=0};
	__property bool UseSound = {read=FUseSound, write=FUseSound, default=1};
	__property Graphics::TColor Color = {read=FColor, write=FColor, default=-2147483643};
	__property Graphics::TColor HoverColor = {read=FHoverColor, write=FHoverColor, default=536870911};
	__property Graphics::TColor SelColor = {read=FSelColor, write=FSelColor, default=-2147483635};
	__property Graphics::TColor SelTextColor = {read=FSelTextColor, write=FSelTextColor, default=-2147483634
		};
	__property Graphics::TColor InactiveSelColor = {read=FInactiveSelColor, write=FInactiveSelColor, default=-2147483635
		};
	__property Graphics::TColor InactiveSelTextColor = {read=FInactiveSelTextColor, write=FInactiveSelTextColor
		, default=-2147483634};
	__property Graphics::TColor CheckpointColor = {read=FCheckpointColor, write=FCheckpointColor, default=32768
		};
	__property Graphics::TColor CheckpointEvColor = {read=FCheckpointEvColor, write=FCheckpointEvColor, 
		default=65280};
	__property Graphics::TColor PageBreakColor = {read=FPageBreakColor, write=FPageBreakColor, default=-2147483632
		};
	__property Graphics::TColor SoftPageBreakColor = {read=FSoftPageBreakColor, write=FSoftPageBreakColor
		, default=-2147483633};
	__property TRVSelectionMode SelectionMode = {read=FSelectionMode, write=FSelectionMode, default=1};
		
	__property TRVSelectionStyle SelectionStyle = {read=FSelectionStyle, write=FSelectionStyle, default=0
		};
	__property int DefUnicodeStyle = {read=FDefUnicodeStyle, write=FDefUnicodeStyle, default=-1};
	__property TRVCodePage DefCodePage = {read=FDefCodePage, write=FDefCodePage, default=0};
	__property Graphics::TPicture* InvalidPicture = {read=GetInvalidPicture, write=SetInvalidPicture, nodefault
		};
	__property TRVApplyStyleEvent OnApplyStyle = {read=FOnApplyStyle, write=FOnApplyStyle};
	__property TRVApplyStyleColorEvent OnApplyStyleColor = {read=FOnApplyStyleColor, write=FOnApplyStyleColor
		};
	__property TRVDrawStyleTextEvent OnDrawStyleText = {read=FOnDrawStyleText, write=FOnDrawStyleText};
		
	__property TRVStyleHoverSensitiveEvent OnStyleHoverSensitive = {read=FOnStyleHoverSensitive, write=
		FOnStyleHoverSensitive};
	__property TRVDrawTextBackEvent OnDrawTextBack = {read=FOnDrawTextBack, write=FOnDrawTextBack};
	__property TRVDrawCheckpointEvent OnDrawCheckpoint = {read=FOnDrawCheckpoint, write=FOnDrawCheckpoint
		};
	__property TRVDrawPageBreakEvent OnDrawPageBreak = {read=FOnDrawPageBreak, write=FOnDrawPageBreak};
		
	__property TRVDrawParaRectEvent OnDrawParaBack = {read=FOnDrawParaBack, write=FOnDrawParaBack};
};

//-- var, const, procedure ---------------------------------------------------
#define crJump (Byte)(101)
#define crRVFlipArrow (Byte)(106)
#define rvsNormal (Byte)(0)
#define rvsHeading (Byte)(1)
#define rvsSubheading (Byte)(2)
#define rvsKeyword (Byte)(3)
#define rvsJump1 (Byte)(4)
#define rvsJump2 (Byte)(5)
#define rvsBreak (Shortint)(-1)
#define rvsCheckpoint (Shortint)(-2)
#define rvsPicture (Shortint)(-3)
#define rvsHotspot (Shortint)(-4)
#define rvsComponent (Shortint)(-5)
#define rvsBullet (Shortint)(-6)
#define rvsBack (Shortint)(-7)
#define rvsVersionInfo (Shortint)(-8)
#define rvsDocProperty (Shortint)(-9)
#define rvsHotPicture (Shortint)(-10)
#define rvsListMarker (Shortint)(-11)
#define LAST_DEFAULT_STYLE_NO (Byte)(5)
#define rvsDefStyle (int)(2147483647)
extern TRVRTFOptions rvrtfDefault;
extern TRVFontInfoProperties RVAllFontInfoProperties;
extern TRVParaInfoProperties RVAllParaInfoProperties;
extern TRVParaInfoProperties RVAllParaBackgroundProperties;
extern TRVParaInfoProperties RVAllParaBorderProperties;
extern bool RichViewResetStandardFlag;
extern void __fastcall RVWrite(Classes::TStream* Stream, const System::AnsiString s);
extern void __fastcall RVWriteLn(Classes::TStream* Stream, const System::AnsiString s);
extern void __fastcall RVWriteX(Classes::TStream* Stream, const System::AnsiString s, bool Multiline
	);
//-- template instantiations -------------------------------------------------
template class Graphics::TFontStyles ;
template class TRVParaInfoProperties ;
template class TRVFontInfoProperties ;
template class TRVSaveCSSOptions ;
template class TRVFontStyles ;
template class TRVRTFOptions ;
template class TRVSaveOptions ;
template class TRVTextOptions ;
template class TRVParaOptions ;
template class TRVProtectOptions ;
template class TRVFWarnings ;
template class TRVFOptions ;
template class TRVListLevelOptions ;
template class TRVTextDrawStates ;

}	/* namespace Rvstyle */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Rvstyle;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// RVStyle
