//--------------------------------------------------------------------
// MS SQL Extended Stored Procedure Class Demo Project file: xprocdemovc.cpp
//
// Copyright (c) 2002-2003 Leonid Belousov
//
// www.bramc.ru/soft/
// mc@bramc.ru
//
//////////////////////////////////////////////////////////////////////


#include "..\xproc\xproc.h"
#include <fcntl.h>
#include <io.h>

using namespace XProc;

#ifdef __cplusplus
extern "C" {
#endif

__declspec(dllexport) RETCODE xp_Class(SRV_PROC *srvproc);

#ifdef __cplusplus
}
#endif


RETCODE xp_Class(SRV_PROC *srvproc)
{
	CXProc xproc(srvproc);
	CxpParams& p = xproc.Params();

	size_t cnt = 0;

	if (p.size()) {
		char* s = p[0].GetAnsiText();
		
		cnt = 21 + strlen(s);
		char* answer = new char[cnt];
		memset(answer, 0, cnt);
		strcat(answer, "You've just passed: ");

		p[0].SetVarchar(strcat(answer, s));
		delete answer; delete s;
	}

	CxpFields& fd = xproc.Fields();
    
	cnt = 300;
	fd[2].SetName("300 bytes of BLOB");	// Give the name to a 3rd recordset field

 	// Just a dummy multiplicator value from 2nd optional input parameter
	int nDummy = 1;	
	if ((p.size() > 1) && (p[1].DataType() == ftInteger)) {
		nDummy = p[1].GetInt();
	}

	SYSTEMTIME st;

 	// Make recordset of 20 rows and 3 columns: Int, Datetime, and Image
	for (int i = 0; i < 20; i++) {
		// Field #1
		fd[0].SetInt(i * nDummy);
		// Field #2
		GetSystemTime(&st); fd[1].SetDateTime(st);		
		// Field #3
		void* p = malloc(cnt); memset(p, i, cnt); fd[2].SetImage(p, (ULONG)cnt); free(p);
		// Send a recordset row back to SQL Server
		fd.Next();
	}

	return 1;
};
