//<html><pre>
// KEHOME/java/putdata.java
// Sep/1/2003

// usage:
//	java putdata kbfile
//	subject predicate object
//	...
//	CONTROL-Z
// example:
//	java putdata C:/home/ke/data/tap.rdf
//	DickMcCullough type Person
//	DickMcCullough label "Richard H. McCullough"
//	CONTROL-Z

import java.io.*;
import java.util.regex.*;

import edu.stanford.TAP.Abbrev;
import edu.stanford.TAP.Client;
import edu.stanford.TAP.Resource;
import edu.stanford.TAP.XML;
import edu.stanford.TAP.KB;

import edu.stanford.TAP.KB_MemHash;
import edu.stanford.TAP.Import_Guess;
import edu.stanford.TAP.Export_RDF;
import edu.stanford.TAP.Export_MCF;

/**
*	read TAP KB location from command line
*	create TAP KB client
*	read sentence(s) from standard input
*	parse to subject predicate object
*	assert sentence(s) to TAP KB file
*/
public class putdata
{
    public static String kbFile; // needs to be global ???

    public static void main(String argv[])
    throws IOException
    {
	String info      = "# INFO: putdata: ";
	String error     = "# ERROR: putdata: ";
	String debug     = "no";

	String Subflag   = "includeSubClasses=yes";
	String Superflag = "includeSuperClasses=yes";
	String flags     = "";

	String kbfile = argv[0];
	kbFile = kbfile;
	Client tap = new Client(kbFile);

	BufferedReader in = new BufferedReader(
		new InputStreamReader(System.in));
	String line = "";
for (
	int linenumber = 0;
	line != null;
	++linenumber
) {
	System.err.print("pd$ ");
	try {
		line = in.readLine();
	} catch(IOException e) {
		return;
	}
	if (line == null) return;

	String[] sentence = Pattern.compile(" ").split(line);
	String subject   = sentence[0];
	String predicate = sentence[1];
	String object    = sentence[2];

	if (debug == "yes") {
	  System.err.println(info + "kbfile = "    + kbfile);
	  System.err.println(info + "subject = "   + subject);
	  System.err.println(info + "predicate = " + predicate);
	  System.err.println(info + "object = "    + object);
	}

	put_data(subject,predicate,object);
} // end for

    } // end main()

/**
*	translate Qnames to URIs
*	assert sentence to TAP KB file
*/
    public static void put_data(
	String subject,
	String predicate,
	String object
    )
    {
	String info  = "# INFO: put_data: ";
	String debug = "no";
	String flags = "";
	
	String uriSubject = Qname.GetNameURI(subject);
	String uriPredicate = Qname.GetNameURI(predicate);
	String uriObject = Qname.GetNameURI(object);

	if (debug == "yes") {
	  System.out.println("# INFO: PutData: kbFile = "       + kbFile);
	  System.out.println("# INFO: PutData: uriSubject = "   + uriSubject);
	  System.out.println("# INFO: PutData: uriPredicate = " + uriPredicate);
	  System.out.println("# INFO: PutData: uriObject = "    + uriObject);
	}

	KB kb = new KB_MemHash();
	Import_Guess.LoadFile(kb, kbFile);
	kb.Assert(uriSubject,uriPredicate,uriObject);
	FileOutputStream out = null;
	try {
            out = new FileOutputStream(kbFile);
	}
	catch(FileNotFoundException e) {
            System.out.println("Couldn't open output file " + kbFile);
            return;
	}
	if(kbFile.endsWith(".rdf")) {
            Export_RDF.DoSerialize(out, kb);
	}
	else if(kbFile.endsWith(".mcf")) {
            Export_MCF.DoSerialize(out, kb);
	}
	return;
    } // end put_data()

} // end class

//</pre></html>
