/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.TAP;

import edu.stanford.TAP.Attribute;
import edu.stanford.TAP.NamespacedTag;
import edu.stanford.TAP.XML;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Abbrev {
    static boolean init = false;
    static Hashtable stdlabels = new Hashtable();
    static Hashtable stdns = new Hashtable();
    static Hashtable stdattrs = new Hashtable();
    static Hashtable stdkbs = new Hashtable();
    static String deflang = "en";

    public static String GetStdLabel(String string) {
        if (!init) {
            Abbrev.InitDefaults();
        }
        Enumeration enumeration = stdlabels.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!stdlabels.get(string2).equals(string)) continue;
            return string2;
        }
        return null;
    }

    public static String GetStdLabelURL(String string) {
        if (!init) {
            Abbrev.InitDefaults();
        }
        return (String)stdlabels.get(string);
    }

    public static String GetStdTag(String string) {
        if (!init) {
            Abbrev.InitDefaults();
        }
        Enumeration enumeration = stdlabels.keys();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)stdlabels.get(string3);
            if (!string.startsWith(string4) || !Abbrev.IsStandardTag(string2 = string.substring(string4.length()))) continue;
            return string2;
        }
        return string;
    }

    public static void AddStdLabel(String string, String string2) {
        if (!init) {
            Abbrev.InitDefaults();
        }
        stdlabels.put(string2, string);
    }

    public static void LoadNamespaces(String string) {
        if (!init) {
            Abbrev.InitDefaults();
        }
        try {
            FileReader fileReader = new FileReader(string);
            LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
            String string2 = lineNumberReader.readLine();
            while (string2 != null) {
                int n = 0;
                while (n < string2.length()) {
                    if (Character.isWhitespace(string2.charAt(n))) break;
                    ++n;
                }
                if (n != string2.length()) {
                    String string3 = string2.substring(0, n);
                    while (n < string2.length()) {
                        if (!Character.isWhitespace(string2.charAt(n))) break;
                        ++n;
                    }
                    String string4 = string2.substring(n, string2.length());
                    Abbrev.AddStdLabel(string4.trim(), string3.trim());
                }
                string2 = lineNumberReader.readLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static Vector GetStdLabels() {
        if (!init) {
            Abbrev.InitDefaults();
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = stdlabels.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector.addElement(string);
        }
        return vector;
    }

    public static boolean IsStandardTag(String string) {
        if (!init) {
            Abbrev.InitDefaults();
        }
        NamespacedTag namespacedTag = XML.SplitNamespace(string);
        if (namespacedTag.url == "") {
            return stdns.get(string) != null;
        }
        return stdns.get(namespacedTag.tag) != null;
    }

    public static String GetTagLabel(String string) {
        if (!init) {
            Abbrev.InitDefaults();
        }
        return (String)stdns.get(string);
    }

    public static String GetTagURL(String string) {
        String string2;
        if (!init) {
            Abbrev.InitDefaults();
        }
        if ((string2 = Abbrev.GetTagLabel(string)) != null) {
            return Abbrev.GetStdLabelURL(string2);
        }
        return null;
    }

    public static void AddTagLabel(String string, String string2) {
        if (!init) {
            Abbrev.InitDefaults();
        }
        stdns.put(string, string2);
    }

    public static Vector GetStandardAttributes(String string) {
        if (!init) {
            Abbrev.InitDefaults();
        }
        return (Vector)stdattrs.get(string);
    }

    public static void AddStandardAttribute(String string, String string2, String string3) {
        Vector<Attribute> vector;
        if (!init) {
            Abbrev.InitDefaults();
        }
        if ((vector = (Vector<Attribute>)stdattrs.get(string)) == null) {
            vector = new Vector<Attribute>();
            stdattrs.put(string, vector);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            if (!attribute.name.equals(string2)) continue;
            attribute.value = string3;
            return;
        }
        vector.addElement(new Attribute(string2, string3));
    }

    public static String GetKBLabel(String string) {
        if (!init) {
            Abbrev.InitDefaults();
        }
        Enumeration enumeration = stdkbs.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!stdkbs.get(string2).equals(string)) continue;
            return string2;
        }
        return null;
    }

    public static String GetKBURL(String string) {
        if (!init) {
            Abbrev.InitDefaults();
        }
        return (String)stdkbs.get(string);
    }

    public static Vector GetKBLabels() {
        if (!init) {
            Abbrev.InitDefaults();
        }
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = stdkbs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            vector.addElement(string);
        }
        return vector;
    }

    public static void AddKB(String string, String string2) {
        if (!init) {
            Abbrev.InitDefaults();
        }
        stdkbs.put(string, string2);
    }

    public static boolean NeedsNamespace(String string) {
        if (!init) {
            Abbrev.InitDefaults();
        }
        if (Abbrev.IsStandardTag(string)) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (!Character.isLetter(string.charAt(n))) {
                return string.charAt(n) != ':';
            }
            ++n;
        }
        return true;
    }

    public static void InitDefaults() {
        if (!init) {
            init = true;
            stdlabels.put("SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
            stdlabels.put("a", "http://tap.stanford.edu/2002/05/GetDataSchema#");
            stdlabels.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            stdlabels.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
            stdlabels.put("dc", "http://purl.org/dc/elements/1.1/");
            stdlabels.put("daml", "http://www.daml.org/2001/03/daml+oil#");
            stdns.put("Envelope", "SOAP-ENV");
            stdns.put("Body", "SOAP-ENV");
            stdns.put("encodingStyle", "SOAP-ENV");
            stdns.put("Fault", "SOAP-ENV");
            stdns.put("instanceOf", "a");
            stdns.put("term", "a");
            stdns.put("GetData", "a");
            stdns.put("PutData", "a");
            stdns.put("Data", "a");
            stdns.put("oid", "a");
            stdns.put("arcs", "a");
            stdns.put("Identify", "a");
            stdns.put("namespace", "a");
            stdns.put("startAt", "a");
            stdns.put("stepSize", "a");
            stdns.put("Node", "a");
            stdns.put("NotFound", "a");
            stdns.put("Disambiguate", "a");
            stdns.put("subClassOf", "rdfs");
            stdns.put("Class", "rdfs");
            stdns.put("label", "rdfs");
            stdns.put("comment", "rdfs");
            stdns.put("domain", "rdfs");
            stdns.put("range", "rdfs");
            stdns.put("RDF", "rdf");
            stdns.put("ID", "rdf");
            stdns.put("Property", "rdf");
            stdns.put("Description", "rdf");
            stdns.put("Seq", "rdf");
            stdns.put("li", "rdf");
            stdns.put("about", "rdf");
            stdns.put("resource", "rdf");
            stdns.put("type", "rdf");
            stdns.put("parseType", "rdf");
            stdns.put("Resource", "rdf");
            stdns.put("title", "dc");
            stdns.put("date", "dc");
            stdns.put("versionInfo", "daml");
            stdns.put("Ontology", "daml");
            stdns.put("item", "daml");
            stdns.put("oneOf", "daml");
            stdns.put("MaxCardinality", "daml");
            stdns.put("List", "daml");
            stdns.put("UniqueProperty", "daml");
            stdns.put("ObjectProperty", "daml");
            stdns.put("DatatypeProperty", "daml");
            stdns.put("Restriction", "daml");
            stdns.put("onProperty", "daml");
            stdns.put("toClass", "daml");
            Abbrev.AddStandardAttribute("label", "xml:lang", deflang);
            Abbrev.AddStandardAttribute("title", "xml:lang", deflang);
            Abbrev.AddStandardAttribute("term", "xml:lang", deflang);
            stdkbs.put("tap", "http://tap.stanford.edu/data/");
        }
    }
}

