/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.TAP;

import edu.stanford.TAP.Cursor;
import edu.stanford.TAP.CursorFilter;
import edu.stanford.TAP.CursorSource;
import edu.stanford.TAP.Description;
import edu.stanford.TAP.Error;
import edu.stanford.TAP.KB;
import edu.stanford.TAP.NamespacedTag;
import edu.stanford.TAP.Request;
import edu.stanford.TAP.Restriction;
import edu.stanford.TAP.XML;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public abstract class KB {
    public static int LEX_DISTANCE_PENALTY = 1;
    public static int LEX_TOO_MANY_PENALTY = 2;
    public static Random rgen = new Random();
    String kburl = null;
    int seqnum = 0;
    static String[] defaultStops = new String[]{"a", "an", "the", "for", "and", "of"};
    static String[] lexarcs = new String[]{"title", "label", "plural", "adjective"};

    public abstract void Shutdown();

    public abstract Cursor GetSources(String var1, String var2);

    public abstract Cursor GetTargets(String var1, String var2);

    public abstract Cursor GetArcs(String var1);

    public abstract Cursor GetArcsIn(String var1);

    public abstract boolean HasAssertion(String var1, String var2, String var3);

    public abstract void AddAssertion(String var1, String var2, String var3);

    public abstract void Unassert(String var1, String var2, String var3);

    public abstract void RemoveNode(String var1);

    public abstract Cursor GetAllNodes();

    public abstract Cursor GetLexiconMatches(String var1);

    public void Assert(String string, String string2, String string3) {
        if (string.equals("Node")) {
            string = "Resource";
        }
        if (string.equals("PropertyType")) {
            string = "Property";
        }
        if (string3.equals("Node")) {
            string3 = "Resource";
        }
        if (string3.equals("PropertyType")) {
            string3 = "Property";
        }
        if (string.length() != 0 && string2.length() != 0 && string3.length() != 0 && !this.HasAssertion(string, string2, string3)) {
            this.AddAssertion(string, string2, string3);
        }
    }

    public String AssertDescription(Description description) {
        Object object = description.GetRestrictionValue("oid");
        String string = null;
        string = object != null && object instanceof String ? (String)object : this.NewOid();
        Vector vector = description.GetRestrictionSet();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Restriction restriction = (Restriction)enumeration.nextElement();
            String string2 = restriction.GetArc();
            String string3 = restriction.GetTargetType();
            Object object2 = restriction.GetTarget();
            String string4 = null;
            string4 = string3.equals("description") ? this.AssertDescription((Description)object2) : (String)object2;
            if (string2.equals("oid")) continue;
            this.Assert(string, string2, string4);
        }
        return string;
    }

    public Description DescriptionFromNode(String string, boolean bl) {
        Description description = new Description(null);
        if (bl) {
            description.AddArcTarget("oid", string);
        }
        Cursor cursor = this.GetArcs(string);
        String string2 = cursor.Next();
        while (string2 != null) {
            Cursor cursor2 = this.GetTargets(string, string2);
            String string3 = cursor2.Next();
            while (string3 != null) {
                description.AddArcTarget(string2, string3);
                string3 = cursor2.Next();
            }
            cursor2.Release();
            string2 = cursor.Next();
        }
        cursor.Release();
        return description;
    }

    public void CopyAssertions(String string, String string2) {
        Description description = this.DescriptionFromNode(string, false);
        Vector vector = description.GetRestrictionSet();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Restriction restriction = (Restriction)enumeration.nextElement();
            String string3 = restriction.GetArc();
            String string4 = (String)restriction.GetTarget();
            if (string3.equals("oid")) continue;
            this.Assert(string2, string3, string4);
        }
    }

    public boolean HasNode(String string) {
        int n = 0;
        while (n < string.length()) {
            if (Character.isWhitespace(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        Cursor cursor = this.GetArcs(string);
        String string2 = cursor.Next();
        cursor.Release();
        return string2 != null;
    }

    public String GetSource(String string, String string2) {
        Cursor cursor = this.GetSources(string, string2);
        String string3 = cursor.Next();
        cursor.Release();
        return string3;
    }

    public String GetTarget(String string, String string2) {
        Cursor cursor = this.GetTargets(string, string2);
        String string3 = cursor.Next();
        cursor.Release();
        return string3;
    }

    public Cursor EnumerateSubClasses(String string) {
        Cursor cursor = this.GetSources(string, "subClassOf");
        class EscFilter
        implements CursorFilter {
            private final /* synthetic */ KB this$0;

            EscFilter(KB kB) {
                this.this$0 = kB;
            }

            public String FilterItem(Cursor cursor, String string) {
                KB kB = cursor.GetKnowledgeBase();
                cursor.AddCursor(kB.EnumerateSubClasses(string));
                return string;
            }
        }
        cursor.AddOutputFilter(new EscFilter(this));
        return cursor;
    }

    public Cursor EnumerateSuperClasses(String string) {
        Cursor cursor = this.GetTargets(string, "subClassOf");
        class EspcFilter
        implements CursorFilter {
            private final /* synthetic */ KB this$0;

            EspcFilter(KB kB) {
                this.this$0 = kB;
            }

            public String FilterItem(Cursor cursor, String string) {
                KB kB = cursor.GetKnowledgeBase();
                cursor.AddCursor(kB.EnumerateSuperClasses(string));
                return string;
            }
        }
        cursor.AddOutputFilter(new EspcFilter(this));
        return cursor;
    }

    public Cursor GetReferences(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        Cursor cursor = null;
        cursor = bl ? this.GetTargets(string, string2) : this.GetSources(string, string2);
        if (bl3) {
            Cursor cursor2 = this.EnumerateSubClasses(string);
            String string3 = cursor2.Next();
            while (string3 != null) {
                Cursor cursor3 = this.GetReferences(string3, string2, bl, bl2, bl3);
                cursor.AddCursor(cursor3);
                string3 = cursor2.Next();
            }
            cursor2.Release();
        } else if (bl2) {
            Cursor cursor4 = this.EnumerateSuperClasses(string);
            String string4 = cursor4.Next();
            while (string4 != null) {
                Cursor cursor5 = this.GetReferences(string4, string2, bl, bl2, bl3);
                cursor.AddCursor(cursor5);
                string4 = cursor4.Next();
            }
        }
        return cursor;
    }

    public boolean StringHasWord(String string, String string2) {
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        int n = string.length();
        int n2 = string2.indexOf(string);
        if (n2 == -1) {
            return false;
        }
        if (n2 > 0 && Character.isLetterOrDigit(string2.charAt(n2 - 1))) {
            return false;
        }
        return string2.length() <= n2 || !Character.isLetterOrDigit(string2.charAt(n2 + n));
    }

    public boolean TitleHasWord(String string, String string2) {
        Cursor cursor = this.GetLexicalArcTargets(string2);
        boolean bl = false;
        String string3 = cursor.Next();
        while (string3 != null) {
            if (this.StringHasWord(string, string3)) {
                bl = true;
                break;
            }
            string3 = cursor.Next();
        }
        cursor.Release();
        return bl;
    }

    public boolean IsIgnoredWord(String string) {
        int n = 0;
        while (n < string.length()) {
            if (!Character.isWhitespace(string.charAt(n))) {
                int n2 = 0;
                while (n2 < defaultStops.length) {
                    if (string.equals(defaultStops[n2])) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    public String MakeTitle(String string) {
        NamespacedTag namespacedTag = XML.SplitNamespace(string);
        String string2 = namespacedTag.tag;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string2.length()) {
            if (n > 0 && Character.isLowerCase(string2.charAt(n - 1)) && Character.isUpperCase(string2.charAt(n))) {
                stringBuffer.append(' ');
            }
            if (!Character.isLetterOrDigit(string2.charAt(n))) {
                stringBuffer.append(' ');
            } else {
                stringBuffer.append(string2.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public Vector SplitWords(String string) {
        string = string.toLowerCase();
        int n = 0;
        Vector<String> vector = new Vector<String>();
        while (n < string.length()) {
            int n2 = n;
            while (n2 < string.length()) {
                if (Character.isWhitespace(string.charAt(n2))) break;
                ++n2;
            }
            vector.addElement(string.substring(n, n2));
            n = n2;
            while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
                ++n;
            }
        }
        return vector;
    }

    public int RemoveSet(String string, String string2) {
        Cursor cursor = this.GetTargets(string, string2);
        String string3 = cursor.Next();
        int n = 0;
        while (string3 != null) {
            this.Unassert(string, string2, string3);
            string3 = cursor.Next();
            ++n;
        }
        cursor.Release();
        return n;
    }

    public String GetInstanceOf(String string) {
        return this.GetTarget(string, "type");
    }

    public boolean IsInstanceOf(String string, String string2) {
        Cursor cursor = this.GetTargets(string, "type");
        boolean bl = false;
        String string3 = cursor.Next();
        while (string3 != null) {
            if (string3.equals(string2) || this.IsSubClassOf(string3, string2)) {
                bl = true;
                break;
            }
            string3 = cursor.Next();
        }
        cursor.Release();
        return bl;
    }

    public boolean IsSubClassOf(String string, String string2) {
        boolean bl = false;
        Cursor cursor = this.GetTargets(string, "subClassOf");
        String string3 = cursor.Next();
        while (string3 != null) {
            if (string3.equals(string2)) {
                bl = true;
                break;
            }
            if (!string3.equals(string) && this.IsSubClassOf(string3, string2)) {
                bl = true;
                break;
            }
            string3 = cursor.Next();
        }
        cursor.Release();
        return bl;
    }

    private boolean _WalkAncestorCursor(Cursor cursor, String string) {
        String string2 = cursor.Next();
        boolean bl = false;
        string2 = cursor.Next();
        while (string2 != null) {
            if (this.IsAncestor(string, string2)) {
                bl = true;
                break;
            }
            string2 = cursor.Next();
        }
        cursor.Release();
        return bl;
    }

    public boolean IsAncestor(String string, String string2) {
        Cursor cursor;
        if (string.equals(string2)) {
            return true;
        }
        if (string2.equals("Class") || string2.equals("Resource")) {
            return false;
        }
        if (this.IsInstanceOf(string2, string)) {
            return true;
        }
        if (!this.IsInstanceOf(string2, "Class") && this._WalkAncestorCursor(cursor = this.GetTargets(string2, "type"), string)) {
            return true;
        }
        cursor = this.GetTargets(string2, "subClassOf");
        return this._WalkAncestorCursor(cursor, string);
    }

    public int Replace(String string, String string2, String string3, String string4) {
        int n = 0;
        if (this.HasAssertion(string, string2, string3)) {
            this.Unassert(string, string2, string3);
            this.Assert(string, string2, string4);
            n = 1;
        }
        return n;
    }

    public String[] GetLexiconArcs() {
        return lexarcs;
    }

    public boolean IsLexiconArc(String string) {
        int n = 0;
        while (n < lexarcs.length) {
            if (lexarcs[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Cursor GetLexicalArcTargets(String string) {
        Cursor cursor = new Cursor(this);
        int n = 0;
        while (n < lexarcs.length) {
            Cursor cursor2 = this.GetTargets(string, lexarcs[n]);
            cursor.AddCursor(cursor2);
            ++n;
        }
        return cursor;
    }

    public String GetURL() {
        return this.kburl;
    }

    public void SetURL(String string) {
        this.kburl = string;
    }

    public String AddNamespace(String string) {
        if (this.kburl == null || this.kburl.length() == 0) {
            return string;
        }
        if (this.kburl.endsWith("/") || this.kburl.endsWith("#")) {
            return this.kburl + string;
        }
        return this.kburl + (string.startsWith("#") ? "" : "#") + string;
    }

    public String StripNamespace(String string) {
        if (this.kburl != null && string.startsWith(this.kburl)) {
            string = string.substring(this.kburl.length());
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        return string;
    }

    public String GetLexiconMatchArc(String string, String string2) {
        String[] stringArray = this.GetLexiconArcs();
        Vector vector = this.SplitWords(string);
        int n = 0;
        while (n < stringArray.length) {
            Cursor cursor = this.GetTargets(string2, stringArray[n]);
            boolean bl = false;
            String string3 = cursor.Next();
            while (string3 != null) {
                int n2 = 0;
                while (n2 < vector.size()) {
                    String string4 = (String)vector.elementAt(n2);
                    if (!this.StringHasWord(string4, string3)) break;
                    ++n2;
                }
                if (n2 >= vector.size()) {
                    bl = true;
                    break;
                }
                string3 = cursor.Next();
            }
            cursor.Release();
            if (bl) {
                return stringArray[n];
            }
            ++n;
        }
        return null;
    }

    public Cursor GetLexiconMatchesConstrained(String string, Vector vector) {
        Cursor cursor = this.GetSortedLexiconMatches(string);
        cursor.RestrictNodes(vector);
        return cursor;
    }

    private Vector SortLexiconMatchesArray(String string, Cursor cursor) {
        Vector vector = this.SplitWords(string);
        Vector<sortedNode> vector2 = new Vector<sortedNode>();
        String string2 = cursor.Next();
        while (string2 != null) {
            int n = -1000000;
            Cursor cursor2 = this.GetLexicalArcTargets(string2);
            String string3 = cursor2.Next();
            while (string3 != null) {
                int n2 = 0;
                Vector vector3 = this.SplitWords(string3);
                int n3 = 0;
                Enumeration enumeration = vector3.elements();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    int n4 = 0;
                    int n5 = n3;
                    while (n5 < vector3.size() && !string4.equals((String)vector3.elementAt(n5))) {
                        ++n5;
                        ++n4;
                    }
                    if (n5 >= vector3.size()) {
                        n4 = 0;
                        while (n5 != -1) {
                            if (string4.equals((String)vector3.elementAt(n5))) break;
                            --n5;
                            ++n4;
                        }
                    }
                    if (n5 >= 0 && n5 < vector3.size()) {
                        n3 = n5;
                    }
                    n2 -= n4 * LEX_DISTANCE_PENALTY;
                }
                if ((n2 -= (vector3.size() - vector.size()) * LEX_TOO_MANY_PENALTY) > n) {
                    n = n2;
                }
                string3 = cursor2.Next();
            }
            String string5 = this.GetTarget(string2, "sortPriority");
            int n6 = string5 == null ? 0 : Integer.parseInt(string5);
            vector2.addElement(new sortedNode(string2, n, n6));
            string2 = cursor.Next();
        }
        class ByScoreAndPriority
        implements Comparator {
            private final /* synthetic */ KB this$0;

            ByScoreAndPriority(KB kB) {
                this.this$0 = kB;
            }

            public int compare(Object object, Object object2) {
                sortedNode sortedNode2 = (sortedNode)object;
                sortedNode sortedNode3 = (sortedNode)object2;
                if (sortedNode2.score != sortedNode3.score) {
                    return sortedNode3.score < sortedNode2.score ? -1 : 1;
                }
                if (sortedNode3.sortPriority == sortedNode3.sortPriority) {
                    return 0;
                }
                return sortedNode3.sortPriority < sortedNode2.sortPriority ? -1 : 1;
            }
        }
        Collections.sort(vector2, new ByScoreAndPriority(this));
        return vector2;
    }

    public Cursor GetSortedLexiconMatches(String string) {
        return this.SortLexiconMatches(string, this.GetLexiconMatches(string));
    }

    public Cursor SortLexiconMatches(String string, Cursor cursor) {
        Cursor cursor2 = new Cursor(this);
        Vector vector = this.SortLexiconMatchesArray(string, cursor);
        class SlmSource
        implements CursorSource {
            Vector res;
            int pos;
            private final /* synthetic */ KB this$0;

            public SlmSource(KB kB, Vector vector) {
                this.this$0 = kB;
                this.res = vector;
                this.pos = 0;
            }

            public String NextItem(Cursor cursor) {
                if (this.pos >= this.res.size()) {
                    return null;
                }
                E e = this.res.elementAt(this.pos);
                sortedNode sortedNode2 = e != null ? (sortedNode)e : null;
                String string = null;
                if (sortedNode2 != null) {
                    string = sortedNode2.node;
                    ++this.pos;
                }
                return string;
            }
        }
        cursor2.AddDataSource(new SlmSource(this, vector));
        cursor.Release();
        return cursor2;
    }

    public boolean WalkAssertion(String string, String string2, String string3) {
        boolean bl = false;
        Cursor cursor = this.GetTargets(string, string2);
        String string4 = cursor.Next();
        while (string4 != null) {
            if (string3.equals(string4) || this.IsSubClassOf(string4, string3)) {
                bl = true;
                break;
            }
            string4 = cursor.Next();
        }
        cursor.Release();
        return bl;
    }

    public boolean MatchAssertion(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        String string4 = string;
        String string5 = string3;
        if (bl) {
            string4 = string3;
            string5 = string;
        }
        if (bl3) {
            return this.WalkAssertion(string4, string2, string5);
        }
        if (this.HasAssertion(string4, string2, string5)) {
            return true;
        }
        if (bl2) {
            Cursor cursor = this.EnumerateSuperClasses(string3);
            String string6 = cursor.Next();
            while (string6 != null) {
                if (this.MatchAssertion(string, string2, string6, bl, bl2, bl3)) {
                    cursor.Release();
                    return true;
                }
                string6 = cursor.Next();
            }
            cursor.Release();
        }
        return false;
    }

    public void Copy(KB kB) {
        Cursor cursor = kB.GetAllNodes();
        String string = cursor.Next();
        while (string != null) {
            Cursor cursor2 = kB.GetArcs(string);
            String string2 = cursor2.Next();
            while (string2 != null) {
                Cursor cursor3 = kB.GetTargets(string, string2);
                String string3 = cursor3.Next();
                while (string3 != null) {
                    this.Assert(string, string2, string3);
                    string3 = cursor3.Next();
                }
                cursor3.Release();
                string2 = cursor2.Next();
            }
            cursor2.Release();
            string = cursor.Next();
        }
        cursor.Release();
    }

    public String NewOid() {
        long l = System.currentTimeMillis();
        int n = this.seqnum++;
        int n2 = rgen.nextInt(100000);
        return "Anon_" + l + "_" + n + "_" + n2;
    }

    public boolean IsNewOid(String string) {
        return string.startsWith("Anon_");
    }

    public boolean OidMatchesRestriction(String string, Restriction restriction) {
        String string2 = restriction.GetArc();
        String string3 = restriction.GetTargetType();
        Object object = restriction.GetTarget();
        boolean bl = restriction.IsFlagSet("inverse");
        boolean bl2 = restriction.IsFlagSet("includeSuperClasses");
        boolean bl3 = restriction.IsFlagSet("includeSubClasses");
        if (string3.equals("string")) {
            String string4 = (String)object;
            if (this.HasNode(string4)) {
                return this.MatchAssertion(string, string2, string4, bl, bl2, bl3);
            }
            return this.HasAssertion(string, string2, string4);
        }
        if (string3.equals("description")) {
            Description description = (Description)object;
            Cursor cursor = this.Identify(description);
            String string5 = null;
            string5 = cursor.Next();
            while (string5 != null) {
                if (this.MatchAssertion(string, string2, string5, bl, bl2, bl3)) break;
                string5 = cursor.Next();
            }
            cursor.Release();
            return string5 != null;
        }
        return false;
    }

    public boolean OidInSubset(String string, Description description) {
        Vector vector = description.GetRestrictionSet();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Restriction restriction = (Restriction)enumeration.nextElement();
            if (this.OidMatchesRestriction(string, restriction)) continue;
            return false;
        }
        return true;
    }

    public Cursor GetRestrictionMatches(Restriction restriction) {
        String string = restriction.GetArc();
        String string2 = restriction.GetTargetType();
        Object object = restriction.GetTarget();
        Cursor cursor = null;
        if (string.equals("title")) {
            cursor = !string2.equals("string") ? new Cursor(this) : this.GetSources((String)object, "title");
        } else if (string.equals("term")) {
            cursor = !string2.equals("string") ? new Cursor(this) : this.GetSortedLexiconMatches((String)object);
        } else if (string.equals("oid")) {
            cursor = new Cursor(this);
            if (string2.equals("string")) {
                String string3 = (String)object;
                if (this.HasNode(string3)) {
                    cursor.AddResult(string3);
                }
            } else {
                Error.Report("Invalid target type with oid");
            }
        } else {
            boolean bl = restriction.IsFlagSet("inverse");
            boolean bl2 = restriction.IsFlagSet("includeSuperClasses");
            boolean bl3 = restriction.IsFlagSet("includeSubClasses");
            if (string2.equals("string")) {
                cursor = this.GetReferences((String)object, string, bl, bl2, bl3);
            } else if (string2.equals("description")) {
                cursor = new Cursor(this);
                Cursor cursor2 = this.Identify((Description)object);
                class GrmSource
                implements CursorSource {
                    Cursor tgtcursor;
                    String arc;
                    Cursor srccursor;
                    boolean inverse;
                    boolean walksupers;
                    boolean walksubs;
                    private final /* synthetic */ KB this$0;

                    public GrmSource(KB kB, Cursor cursor, String string, boolean bl, boolean bl2, boolean bl3) {
                        this.this$0 = kB;
                        this.tgtcursor = cursor;
                        this.arc = string;
                        this.srccursor = null;
                        this.inverse = bl;
                        this.walksupers = bl2;
                        this.walksubs = bl3;
                    }

                    public String NextItem(Cursor cursor) {
                        KB kB = cursor.GetKnowledgeBase();
                        String string = null;
                        while (true) {
                            if (this.srccursor == null) {
                                String string2 = this.tgtcursor.Next();
                                if (string2 == null) {
                                    this.tgtcursor.Release();
                                    return null;
                                }
                                this.srccursor = kB.GetReferences(string2, this.arc, this.inverse, this.walksupers, this.walksubs);
                            }
                            if ((string = this.srccursor.Next()) != null) {
                                return string;
                            }
                            this.srccursor.Release();
                            this.srccursor = null;
                        }
                    }
                }
                cursor.AddDataSource(new GrmSource(this, cursor2, string, bl, bl2, bl3));
            }
        }
        return cursor;
    }

    public Cursor Identify(Description description) {
        Object object;
        Vector vector = description.GetRestrictionSet();
        int n = 0;
        n = 0;
        while (n < vector.size()) {
            object = (Restriction)vector.elementAt(n);
            String string = ((Restriction)object).GetArc();
            if (string.equals("oid") || string.equals("term") || string.equals("title")) break;
            ++n;
        }
        if (n >= vector.size()) {
            n = 0;
        }
        object = this.GetRestrictionMatches((Restriction)vector.elementAt(n));
        class IdFilter
        implements CursorFilter {
            int iternum;
            Vector rc;
            private final /* synthetic */ KB this$0;

            public IdFilter(KB kB, int n, Vector vector) {
                this.this$0 = kB;
                this.iternum = n;
                this.rc = vector;
            }

            public String FilterItem(Cursor cursor, String string) {
                KB kB = cursor.GetKnowledgeBase();
                int n = 0;
                while (n < this.rc.size()) {
                    Restriction restriction = (Restriction)this.rc.elementAt(n);
                    if (n != this.iternum && !kB.OidMatchesRestriction(string, restriction)) {
                        return null;
                    }
                    ++n;
                }
                return string;
            }
        }
        ((Cursor)object).AddOutputFilter(new IdFilter(this, n, vector));
        return object;
    }

    public Vector GetData(Request request) {
        Description description = request.GetDescription();
        Description description2 = request.GetProperties();
        Vector<Cursor> vector = new Vector<Cursor>();
        Cursor cursor = this.Identify(description);
        if (description2 == null || request.WantProperty("Identify")) {
            vector.addElement(cursor);
            return vector;
        }
        String string = cursor.Next();
        String string2 = null;
        if (string != null) {
            string2 = cursor.Next();
        }
        cursor.Release();
        if (string != null && string2 != null) {
            vector.addElement(this.Identify(description));
            return vector;
        }
        cursor = new Cursor(this);
        vector.addElement(cursor);
        if (string == null) {
            return vector;
        }
        cursor.AddResult(string);
        Vector vector2 = description2.GetRestrictionSet();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            String string3;
            Cursor cursor2;
            Restriction restriction = (Restriction)enumeration.nextElement();
            String string4 = restriction.GetArc();
            Cursor cursor3 = null;
            if (restriction.IsFlagSet("includeSuperClasses")) {
                cursor3 = this.EnumerateSuperClasses(string);
            } else if (restriction.IsFlagSet("includeSubClasses")) {
                cursor3 = this.EnumerateSubClasses(string);
            }
            if (restriction.IsFlagSet("inverse")) {
                if (string4.equals("arcs")) {
                    cursor2 = this.GetArcsIn(string);
                    cursor2.AddCursor(this.GetSources(string, string4));
                    cursor2.AddOutputFilter(new seenFilter());
                } else {
                    cursor2 = this.GetSources(string, string4);
                }
                if (cursor3 != null) {
                    string3 = cursor3.Next();
                    while (string3 != null) {
                        cursor2.AddCursor(this.GetSources(string3, string4));
                        string3 = cursor3.Next();
                    }
                }
                vector.addElement(cursor2);
                continue;
            }
            if (string4.equals("arcs")) {
                cursor2 = this.GetArcs(string);
                cursor2.AddCursor(this.GetTargets(string, string4));
                cursor2.AddOutputFilter(new seenFilter());
            } else {
                cursor2 = this.GetTargets(string, string4);
            }
            if (cursor3 != null) {
                string3 = cursor3.Next();
                while (string3 != null) {
                    cursor2.AddCursor(this.GetTargets(string3, string4));
                    string3 = cursor3.Next();
                }
            }
            vector.addElement(cursor2);
        }
        return vector;
    }

    public boolean RestrictionsMatch(Restriction restriction, Restriction restriction2) {
        String string = restriction.GetArc();
        String string2 = restriction.GetTargetType();
        Object object = restriction.GetTarget();
        String string3 = restriction2.GetArc();
        String string4 = restriction2.GetTargetType();
        Object object2 = restriction2.GetTarget();
        if (!string.equals(string3)) {
            return false;
        }
        if (restriction.IsFlagSet("inverse") != restriction2.IsFlagSet("inverse")) {
            return false;
        }
        if (string2.equals("string") && string4.equals("string")) {
            String string5 = (String)object;
            String string6 = (String)object2;
            if (string5.equals(string6)) {
                return true;
            }
            return this.HasNode(string5) && this.HasNode(string6) && this.IsSubClassOf(string5, string6);
        }
        if (string2.equals("description") && string4.equals("description")) {
            return this.IsSubset((Description)object, (Description)object2);
        }
        if (string2.equals("description") && string4.equals("string")) {
            return this.OidInSubset((String)object2, (Description)object);
        }
        if (string2.equals("string") && string4.equals("description")) {
            return this.OidInSubset((String)object, (Description)object2);
        }
        return false;
    }

    public boolean IsSubset(Description description, Description description2) {
        Vector vector = description.GetRestrictionSet();
        Vector vector2 = description2.GetRestrictionSet();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Restriction restriction = (Restriction)enumeration.nextElement();
            boolean bl = false;
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Restriction restriction2 = (Restriction)enumeration2.nextElement();
                if (!this.RestrictionsMatch(restriction2, restriction)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public Vector SubsumeNodes(String string, Vector vector) {
        Vector vector2 = vector;
        int n = 0;
        while (n < vector2.size()) {
            String string2 = (String)vector2.elementAt(n);
            int n2 = 0;
            while (n2 < vector2.size()) {
                String string3;
                if (n2 != n && !string2.equals(string3 = (String)vector2.elementAt(n2)) && this.HasAssertion(string2, string, string3)) {
                    vector2.removeElementAt(n);
                    --n;
                    break;
                }
                ++n2;
            }
            ++n;
        }
        return vector2;
    }

    public int Save(OutputStream outputStream) {
        if (!(this instanceof Serializable)) {
            Error.Report("This KB does not support serialization");
            return -1;
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            Error.Report("Failed to save KB", iOException);
            return -1;
        }
        return 0;
    }

    public static KB Load(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            KB kB = (KB)objectInputStream.readObject();
            fileInputStream.close();
            return kB;
        }
        catch (IOException iOException) {
            Error.Report("Failed to load KB at " + string, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Error.Report("Failed to load KB at " + string + " due to unresolved classes", classNotFoundException);
        }
        return null;
    }

    private class seenFilter
    implements CursorFilter {
        Hashtable t = new Hashtable();

        public String FilterItem(Cursor cursor, String string) {
            if (this.t.get(string) != null) {
                return null;
            }
            this.t.put(string, "1");
            return string;
        }
    }

    class sortedNode {
        public String node;
        public int score;
        public int sortPriority;

        public sortedNode(String string, int n, int n2) {
            this.node = string;
            n = this.score;
            n2 = this.sortPriority;
        }
    }
}

