/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.TAP;

import edu.stanford.TAP.Abbrev;
import edu.stanford.TAP.Cursor;
import edu.stanford.TAP.CursorSource;
import edu.stanford.TAP.KB;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class KB_MemHash
extends KB
implements Serializable {
    Hashtable nodes = new Hashtable();
    Hashtable lexicon = new Hashtable();

    public void Shutdown() {
    }

    private Node CreateNode(String string) {
        Node node = (Node)this.nodes.get(string);
        if (node == null) {
            node = new Node(string);
            this.nodes.put(string, node);
        }
        return node;
    }

    private Node FindNode(String string) {
        return (Node)this.nodes.get(string);
    }

    public Cursor GetSources(String string, String string2) {
        string = this.StripNamespace(string);
        string2 = this.StripNamespace(string2);
        Node node = this.FindNode(string);
        Cursor cursor = new Cursor(this);
        if (node != null) {
            Vector vector = node.GetInverseAssertionList();
            gsSource gsSource2 = new gsSource(string2, vector);
            cursor.AddDataSource(gsSource2);
        }
        return cursor;
    }

    public Cursor GetTargets(String string, String string2) {
        string = this.StripNamespace(string);
        string2 = this.StripNamespace(string2);
        Node node = this.FindNode(string);
        Cursor cursor = new Cursor(this);
        if (node != null) {
            Vector vector = node.GetAssertionList();
            gtSource gtSource2 = new gtSource(string2, vector);
            cursor.AddDataSource(gtSource2);
        }
        return cursor;
    }

    public Cursor GetArcs(String string) {
        string = this.StripNamespace(string);
        Cursor cursor = new Cursor(this);
        Node node = this.FindNode(string);
        if (node != null) {
            Vector vector = node.GetAssertionList();
            gaSource gaSource2 = new gaSource(vector);
            cursor.AddDataSource(gaSource2);
        }
        return cursor;
    }

    public Cursor GetArcsIn(String string) {
        string = this.StripNamespace(string);
        Cursor cursor = new Cursor(this);
        Node node = this.FindNode(string);
        if (node != null) {
            Vector vector = node.GetInverseAssertionList();
            gaSource gaSource2 = new gaSource(vector);
            cursor.AddDataSource(gaSource2);
        }
        return cursor;
    }

    public boolean HasAssertion(String string, String string2, String string3) {
        string = this.StripNamespace(string);
        string2 = this.StripNamespace(string2);
        string3 = this.StripNamespace(string3);
        Cursor cursor = this.GetTargets(string, string2);
        boolean bl = false;
        String string4 = cursor.Next();
        while (string4 != null) {
            if ((string4 = this.StripNamespace(string4)).equals(string3)) {
                bl = true;
                break;
            }
            string4 = cursor.Next();
        }
        cursor.Release();
        return bl;
    }

    public void AddAssertion(String string, String string2, String string3) {
        string = this.StripNamespace(string);
        string2 = this.StripNamespace(string2);
        string3 = this.StripNamespace(string3);
        Node node = this.CreateNode(string);
        Node node2 = this.CreateNode(string2);
        Node node3 = this.CreateNode(string3);
        Assertion assertion = new Assertion(node, node2, node3);
        node.AddAssertion(assertion);
        node3.AddInverseAssertion(assertion);
        if (this.IsLexiconArc(string2)) {
            this.AddToLexicon(string3, string);
        }
    }

    public void Unassert(String string, String string2, String string3) {
        if (!this.HasAssertion(string = this.StripNamespace(string), string2 = this.StripNamespace(string2), string3 = this.StripNamespace(string3))) {
            return;
        }
        if (this.IsLexiconArc(string2)) {
            this.RemoveTitleFromLexicon(string, string3);
        }
        Node node = this.FindNode(string);
        Node node2 = this.FindNode(string3);
        node.RemoveAssertion(string2, string3);
        node2.RemoveInverseAssertion(string, string2);
    }

    public void RemoveNode(String string) {
        Node node = this.FindNode(string = this.StripNamespace(string));
        if (node != null) {
            Vector vector = node.GetAssertionList();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Assertion assertion = (Assertion)enumeration.nextElement();
                Node node2 = assertion.GetArcNode();
                Node node3 = assertion.GetTargetNode();
                node3.RemoveInverseAssertion(string, node2.AsText());
            }
            this.RemoveFromLexicon(string);
            this.nodes.remove(string);
        }
    }

    public Cursor GetAllNodes() {
        Cursor cursor = new Cursor(this);
        cursor.AddDataSource(new ganSource(this.nodes.keys()));
        return cursor;
    }

    private void RemoveFromLexicon(String string) {
        Cursor cursor = this.GetLexicalArcTargets(string);
        String string2 = cursor.Next();
        while (string2 != null) {
            this.RemoveTitleFromLexicon(string, string2);
            string2 = cursor.Next();
        }
    }

    private void RemoveTitleFromLexicon(String string, String string2) {
        int n;
        Object object;
        Vector vector = this.SplitWords(string2);
        Cursor cursor = this.GetLexicalArcTargets(string);
        String string3 = cursor.Next();
        while (string3 != null) {
            if (!string3.equals(string2)) {
                Vector vector2 = this.SplitWords(string3);
                int n2 = 0;
                while (n2 < vector2.size()) {
                    object = (String)vector2.elementAt(n2);
                    n = 0;
                    while (n < vector.size()) {
                        if (((String)object).equals((String)vector.elementAt(n))) {
                            vector.removeElementAt(n);
                            --n;
                        }
                        ++n;
                    }
                    ++n2;
                }
            }
            string3 = cursor.Next();
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            String string4 = (String)vector.elementAt(n3);
            object = (Vector)this.lexicon.get(string4);
            if (object != null) {
                n = 0;
                while (n < ((Vector)object).size()) {
                    if (((String)((Vector)object).elementAt(n)).equals(string)) {
                        ((Vector)object).removeElementAt(n);
                        --n;
                    }
                    ++n;
                }
            }
            ++n3;
        }
    }

    private void AddToLexicon(String string, String string2) {
        Vector vector = this.SplitWords(string);
        Node node = this.FindNode(string2);
        int n = 0;
        while (n < vector.size()) {
            String string3 = (String)vector.elementAt(n);
            if (!this.IsIgnoredWord(string3)) {
                Vector<Node> vector2 = (Vector<Node>)this.lexicon.get(string3);
                if (vector2 != null) {
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < vector2.size()) {
                        Node node2 = (Node)vector2.elementAt(n2);
                        if (node2.AsText().equals(string2)) {
                            bl = true;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        vector2.addElement(node);
                    }
                } else {
                    vector2 = new Vector<Node>();
                    vector2.addElement(node);
                    this.lexicon.put(string3, vector2);
                }
            }
            ++n;
        }
    }

    public Cursor GetLexiconMatches(String string) {
        Object object;
        Object object2;
        Vector vector = this.SplitWords(string);
        Cursor cursor = new Cursor(this);
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        while (n3 < vector.size()) {
            object2 = (String)vector.elementAt(n3);
            object = (Vector)this.lexicon.get(object2);
            if (object == null) break;
            int n4 = ((Vector)object).size();
            if (n == -1 || n2 == -1 || n4 < n2) {
                n = n3;
                n2 = n4;
            }
            ++n3;
        }
        if (n3 < vector.size() || n2 == -1) {
            return cursor;
        }
        object2 = (Vector)this.lexicon.get((String)vector.elementAt(n));
        object = new glmSource(vector, n, (Vector)object2);
        cursor.AddDataSource((CursorSource)object);
        return cursor;
    }

    class glmSource
    implements CursorSource {
        Vector words;
        int wordnum;
        Vector nodelist;
        int nodenum;

        public glmSource(Vector vector, int n, Vector vector2) {
            this.words = vector;
            this.wordnum = n;
            this.nodelist = vector2;
            this.nodenum = 0;
        }

        public String NextItem(Cursor cursor) {
            KB kB = cursor.GetKnowledgeBase();
            String string = null;
            while (string == null) {
                Node node = this.nodenum < this.nodelist.size() ? this.nodelist.elementAt(this.nodenum) : null;
                if (node == null) {
                    return null;
                }
                ++this.nodenum;
                String string2 = node.AsText();
                boolean bl = true;
                int n = 0;
                while (n < this.words.size()) {
                    if (n != this.wordnum && !KB_MemHash.this.TitleHasWord((String)this.words.elementAt(n), string2)) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
                if (!bl) continue;
                string = string2;
            }
            if (string != null && Abbrev.NeedsNamespace(string)) {
                string = KB_MemHash.this.AddNamespace(string);
            }
            return string;
        }
    }

    class ganSource
    implements CursorSource {
        Enumeration e;

        public ganSource(Enumeration enumeration) {
            this.e = enumeration;
        }

        public String NextItem(Cursor cursor) {
            KB kB = cursor.GetKnowledgeBase();
            while (this.e.hasMoreElements()) {
                String string = (String)this.e.nextElement();
                if (!kB.HasNode(string)) continue;
                if (Abbrev.NeedsNamespace(string)) {
                    string = kB.AddNamespace(string);
                }
                return string;
            }
            return null;
        }
    }

    class gaSource
    implements CursorSource {
        Vector aset;
        int pos;

        public gaSource(Vector vector) {
            this.aset = vector;
            this.pos = 0;
        }

        public String NextItem(Cursor cursor) {
            KB kB = cursor.GetKnowledgeBase();
            String string = null;
            boolean bl = false;
            while (this.pos < this.aset.size()) {
                Assertion assertion = (Assertion)this.aset.elementAt(this.pos);
                string = assertion.GetArcNode().AsText();
                bl = false;
                int n = 0;
                while (n < this.pos) {
                    Assertion assertion2 = (Assertion)this.aset.elementAt(n);
                    if (assertion2.GetArcNode().AsText().equals(string)) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                ++this.pos;
                if (!bl) break;
            }
            if (bl) {
                return null;
            }
            if (string != null && Abbrev.NeedsNamespace(string)) {
                string = kB.AddNamespace(string);
            }
            return string;
        }
    }

    class gtSource
    implements CursorSource {
        String arc;
        Vector asList;
        int pos;

        public gtSource(String string, Vector vector) {
            this.arc = string;
            this.asList = vector;
            this.pos = 0;
        }

        public String NextItem(Cursor cursor) {
            Assertion assertion = this.pos < this.asList.size() ? (Assertion)this.asList.elementAt(this.pos) : null;
            while (assertion != null) {
                Node node = assertion.GetArcNode();
                Node node2 = assertion.GetTargetNode();
                ++this.pos;
                Assertion assertion2 = assertion = this.pos < this.asList.size() ? (Assertion)this.asList.elementAt(this.pos) : null;
                if (!node.AsText().equals(this.arc)) continue;
                String string = node2.AsText();
                if (KB_MemHash.this.HasNode(string) && Abbrev.NeedsNamespace(string)) {
                    string = KB_MemHash.this.AddNamespace(string);
                }
                return string;
            }
            return null;
        }
    }

    class gsSource
    implements CursorSource {
        String arc;
        Vector invasList;
        int pos;

        public gsSource(String string, Vector vector) {
            this.arc = string;
            this.invasList = vector;
            this.pos = 0;
        }

        public String NextItem(Cursor cursor) {
            KB kB = cursor.GetKnowledgeBase();
            Assertion assertion = this.pos < this.invasList.size() ? (Assertion)this.invasList.elementAt(this.pos) : null;
            while (assertion != null) {
                Node node = assertion.GetSourceNode();
                Node node2 = assertion.GetArcNode();
                ++this.pos;
                Assertion assertion2 = assertion = this.pos < this.invasList.size() ? (Assertion)this.invasList.elementAt(this.pos) : null;
                if (!node2.AsText().equals(this.arc)) continue;
                String string = node.AsText();
                if (Abbrev.NeedsNamespace(string)) {
                    string = kB.AddNamespace(string);
                }
                return string;
            }
            return null;
        }
    }

    class Assertion
    implements Serializable {
        Node source;
        Node arc;
        Node target;

        public Assertion(Node node, Node node2, Node node3) {
            this.source = node;
            this.arc = node2;
            this.target = node3;
        }

        public Node GetSourceNode() {
            return this.source;
        }

        public Node GetArcNode() {
            return this.arc;
        }

        public Node GetTargetNode() {
            return this.target;
        }
    }

    class Node
    implements Serializable {
        String oid;
        Vector as;
        Vector invas;

        public Node(String string) {
            this.oid = string;
            this.as = new Vector();
            this.invas = new Vector();
        }

        public String AsText() {
            return this.oid;
        }

        public Vector GetAssertionList() {
            return this.as;
        }

        public void SetAssertionList(Vector vector) {
            this.as = vector;
        }

        public Vector GetInverseAssertionList() {
            return this.invas;
        }

        public void SetInverseAssertionList(Vector vector) {
            this.invas = vector;
        }

        public void AddAssertion(Assertion assertion) {
            this.as.addElement(assertion);
        }

        public void AddInverseAssertion(Assertion assertion) {
            this.invas.addElement(assertion);
        }

        public void RemoveAssertion(String string, String string2) {
            int n = 0;
            while (n < this.as.size()) {
                Assertion assertion = (Assertion)this.as.elementAt(n);
                if (assertion.GetArcNode().AsText().equals(string) && assertion.GetTargetNode().AsText().equals(string2)) {
                    this.as.removeElementAt(n);
                    break;
                }
                ++n;
            }
        }

        public void RemoveInverseAssertion(String string, String string2) {
            int n = 0;
            while (n < this.invas.size()) {
                Assertion assertion = (Assertion)this.invas.elementAt(n);
                if (assertion.GetArcNode().AsText().equals(string2) && assertion.GetSourceNode().AsText().equals(string)) {
                    this.invas.removeElementAt(n);
                    break;
                }
                ++n;
            }
        }
    }
}

