{$IFDEF FIB_INTERFACE}
procedure ReadUseBooleanField(Reader: TReader);
procedure WriteUseBooleanField(Writer: TWriter);


procedure ReadSQLINT64ToBCD(Reader: TReader);
procedure WriteSQLINT64ToBCD(Writer: TWriter);



procedure ReadImportDefaultValues(Reader: TReader);
procedure WriteImportDefaultValues(Writer: TWriter);

procedure ReadGetOrderInfo(Reader: TReader);
procedure WriteGetOrderInfo(Writer: TWriter);

procedure ReadSetRequiredFields(Reader: TReader);
procedure WriteSetRequiredFields(Writer: TWriter);

procedure ReadSetReadOnlyFields(Reader: TReader);
procedure WriteSetReadOnlyFields(Writer: TWriter);

procedure ReadApplyRepositary(Reader: TReader);
procedure WriteApplyRepositary(Writer: TWriter);

procedure ReadAskRecordCount(Reader: TReader);
procedure WriteAskRecordCount(Writer: TWriter);

procedure ReadWaitEndMasterScroll(Reader: TReader);
procedure WriteWaitEndMasterScroll(Writer: TWriter);

procedure ReadForceMasterRefresh(Reader: TReader);
procedure WriteForceMasterRefresh(Writer: TWriter);

procedure ReadForceOpen (Reader: TReader);
procedure WriteForceOpen(Writer: TWriter);

procedure ReadNoForceIsNull (Reader: TReader);
procedure WriteNoForceIsNull(Writer: TWriter);

procedure ReadOV(Reader: TReader);


procedure DefineProperties(Filer: TFiler); override;
{$ENDIF}

{$IFDEF FIB_IMPLEMENT}
procedure TFIBCustomDataSet.ReadGetOrderInfo(Reader: TReader);
begin
 if Reader.ReadBoolean then
  PrepareOptions:=PrepareOptions+[psGetOrderInfo]
 else
  PrepareOptions:=PrepareOptions-[psGetOrderInfo]
end;

procedure TFIBCustomDataSet.WriteGetOrderInfo(Writer: TWriter);
begin
 Writer.WriteBoolean(psGetOrderInfo in PrepareOptions)
end;


procedure TFIBCustomDataSet.ReadImportDefaultValues(Reader: TReader);
begin
 if Reader.ReadBoolean then
  PrepareOptions:=PrepareOptions+[pfImportDefaultValues]
 else
  PrepareOptions:=PrepareOptions-[pfImportDefaultValues]
end;

procedure TFIBCustomDataSet.WriteImportDefaultValues(Writer: TWriter);
begin
 Writer.WriteBoolean(pfImportDefaultValues in PrepareOptions)
end;

procedure TFIBCustomDataSet.ReadSQLINT64ToBCD(Reader: TReader);
begin
 if Reader.ReadBoolean then
  PrepareOptions:=PrepareOptions+[psSQLINT64ToBCD]
 else
  PrepareOptions:=PrepareOptions-[psSQLINT64ToBCD]
end;

procedure TFIBCustomDataSet.WriteSQLINT64ToBCD(Writer: TWriter);
begin
 Writer.WriteBoolean(psSQLINT64ToBCD in PrepareOptions)
end;

procedure TFIBCustomDataSet.ReadUseBooleanField(Reader: TReader);
begin
 if Reader.ReadBoolean then
  PrepareOptions:=PrepareOptions+[psUseBooleanField]
 else
  PrepareOptions:=PrepareOptions-[psUseBooleanField]
end;

procedure TFIBCustomDataSet.WriteUseBooleanField(Writer: TWriter);
begin
 Writer.WriteBoolean(psUseBooleanField in PrepareOptions)
end;

procedure TFIBCustomDataSet.ReadSetRequiredFields(Reader: TReader);
begin
 if Reader.ReadBoolean then
  PrepareOptions:=PrepareOptions+[pfSetRequiredFields]
 else
  PrepareOptions:=PrepareOptions-[pfSetRequiredFields]
end;

procedure TFIBCustomDataSet.WriteSetRequiredFields(Writer: TWriter);
begin
 Writer.WriteBoolean(pfSetRequiredFields in PrepareOptions)
end;

procedure TFIBCustomDataSet.ReadSetReadOnlyFields(Reader: TReader);
begin
 if Reader.ReadBoolean then
  PrepareOptions:=PrepareOptions+[pfSetReadOnlyFields]
 else
  PrepareOptions:=PrepareOptions-[pfSetReadOnlyFields]
end;

procedure TFIBCustomDataSet.WriteSetReadOnlyFields(Writer: TWriter);
begin
 Writer.WriteBoolean(pfSetReadOnlyFields in PrepareOptions)
end;

procedure TFIBCustomDataSet.ReadApplyRepositary(Reader: TReader);
begin
 if Reader.ReadBoolean then
  PrepareOptions:=PrepareOptions+[psApplyRepositary]
 else
  PrepareOptions:=PrepareOptions-[psApplyRepositary]
end;

procedure TFIBCustomDataSet.WriteApplyRepositary(Writer: TWriter);
begin
 Writer.WriteBoolean(psApplyRepositary in PrepareOptions)
end;

procedure TFIBCustomDataSet.ReadAskRecordCount(Reader: TReader);
begin
 if Reader.ReadBoolean then
  PrepareOptions:=PrepareOptions+[psAskRecordCount]
 else
  PrepareOptions:=PrepareOptions-[psAskRecordCount]
end;

procedure TFIBCustomDataSet.WriteAskRecordCount(Writer: TWriter);
begin
 Writer.WriteBoolean(psAskRecordCount in PrepareOptions)
end;

procedure TFIBCustomDataSet.ReadWaitEndMasterScroll(Reader: TReader);
begin
 if Reader.ReadBoolean then
  DetailConditions:=DetailConditions+[dcWaitEndMasterScroll]
 else
  DetailConditions:=DetailConditions-[dcWaitEndMasterScroll]
end;

procedure TFIBCustomDataSet.WriteWaitEndMasterScroll(Writer: TWriter);
begin
 Writer.WriteBoolean(dcWaitEndMasterScroll in DetailConditions)
end;

procedure TFIBCustomDataSet.ReadForceMasterRefresh(Reader: TReader);
begin
 if Reader.ReadBoolean then
  DetailConditions:=DetailConditions+[dcForceMasterRefresh]
 else
  DetailConditions:=DetailConditions-[dcForceMasterRefresh]
end;

procedure TFIBCustomDataSet.WriteForceMasterRefresh(Writer: TWriter);
begin
 Writer.WriteBoolean(dcForceMasterRefresh in DetailConditions)
end;

procedure TFIBCustomDataSet.ReadForceOpen(Reader: TReader);
begin
 if Reader.ReadBoolean then
  DetailConditions:=DetailConditions+[dcForceOpen]
 else
  DetailConditions:=DetailConditions-[dcForceOpen]
end;


procedure TFIBCustomDataSet.WriteForceOpen(Writer: TWriter);
begin
 Writer.WriteBoolean(dcForceOpen in DetailConditions)
end;

procedure TFIBCustomDataSet.ReadNoForceIsNull (Reader: TReader);
begin
 if Reader.ReadBoolean then
  Options:=Options+[poNoForceIsNull]
 else
  Options:=Options-[poNoForceIsNull]
end;

procedure TFIBCustomDataSet.WriteNoForceIsNull(Writer: TWriter);
begin
 Writer.WriteBoolean(poNoForceIsNull in Options)
end;

procedure TFIBCustomDataSet.ReadOV(Reader: TReader);
begin
 Reader.ReadBoolean
end;

procedure TFIBCustomDataSet.DefineProperties(Filer: TFiler);
begin
 inherited;
 Filer.DefineProperty('poUseBooleanField',
  ReadUseBooleanField, WriteUseBooleanField,
   true
 );


 Filer.DefineProperty('poImportDefaultValues',
  ReadImportDefaultValues, WriteImportDefaultValues,
   not (pfImportDefaultValues in PrepareOptions)
 );

 Filer.DefineProperty('poGetOrderInfo',
  ReadGetOrderInfo, WriteGetOrderInfo,
   not (psGetOrderInfo in PrepareOptions)
 );

 Filer.DefineProperty('poSetRequiredFields',
  ReadSetRequiredFields, WriteSetRequiredFields,
   (pfSetRequiredFields in PrepareOptions)
 );

 Filer.DefineProperty('poSetReadOnlyFields',
  ReadSetReadOnlyFields, WriteSetReadOnlyFields,
   (pfSetReadOnlyFields in PrepareOptions)
 );


 Filer.DefineProperty('poSQLINT64ToBCD',
  ReadSQLINT64ToBCD, WriteSQLINT64ToBCD,
   true
 );

 Filer.DefineProperty('poApplyRepositary',
  ReadApplyRepositary, WriteApplyRepositary,
   (psApplyRepositary in PrepareOptions)
 );

 Filer.DefineProperty('poAskRecordCount',
  ReadAskRecordCount, WriteAskRecordCount,
   (psAskRecordCount in PrepareOptions)
 );

 Filer.DefineProperty('WaitEndMasterScroll',
  ReadWaitEndMasterScroll, WriteWaitEndMasterScroll,
   (dcWaitEndMasterScroll in DetailConditions)
 );

 Filer.DefineProperty('dcForceMasterRefresh',
  ReadForceMasterRefresh, WriteForceMasterRefresh,
   (dcForceMasterRefresh in DetailConditions)
 );

 Filer.DefineProperty('dcForceOpen',
  ReadForceOpen, WriteForceOpen,
   (dcForceOpen in DetailConditions)
 );

 Filer.DefineProperty('poForceIsNull',
  ReadNoForceIsNull, WriteNoForceIsNull,
    (poNoForceIsNull in Options)
 );


 Filer.DefineProperty('ObjectView',  ReadOV, nil,   false );

end;

////End  PrepareOptions Stream
{$ENDIF}
