{$IFDEF FIB_INTERFACE}
 procedure ReadQueryStartTransaction (Reader: TReader);
 procedure WriteQueryStartTransaction(Writer: TWriter);

 procedure ReadQueryAutoCommit (Reader: TReader);
 procedure WriteQueryAutoCommit(Writer: TWriter);


 procedure ReadQueryTrimChar (Reader: TReader);
 procedure WriteQueryTrimChar(Writer: TWriter);

 procedure ReadQueryNoForceIsNull (Reader: TReader);
 procedure WriteQueryNoForceIsNull(Writer: TWriter);



 procedure DefineProperties(Filer: TFiler); override;

{$ENDIF}

{$IFDEF FIB_IMPLEMENT}
procedure TFIBQuery.ReadQueryTrimChar (Reader: TReader);
begin
 if Reader.ReadBoolean then
   Options:=Options+[qoTrimCharFields]
 else
   Options:=Options-[qoTrimCharFields];
end;

procedure TFIBQuery.WriteQueryTrimChar(Writer: TWriter);
begin
 Writer.WriteBoolean(qoTrimCharFields in Options);
end;

procedure TFIBQuery.ReadQueryStartTransaction (Reader: TReader);
begin
 if Reader.ReadBoolean then
   Options:=Options+[qoStartTransaction]
 else
   Options:=Options-[qoStartTransaction];
end;

procedure TFIBQuery.WriteQueryStartTransaction(Writer: TWriter);
begin
 Writer.WriteBoolean(qoStartTransaction in Options)
end;


procedure TFIBQuery.ReadQueryAutoCommit (Reader: TReader);
begin
  if Reader.ReadBoolean then
   Options:=Options+[qoAutoCommit]
 else
   Options:=Options-[qoAutoCommit];
end;

procedure TFIBQuery.WriteQueryAutoCommit(Writer: TWriter);
begin
 Writer.WriteBoolean(qoAutoCommit in Options)
end;


procedure TFIBQuery.ReadQueryNoForceIsNull (Reader: TReader);
begin
 if Reader.ReadBoolean then
   Options:=Options+[qoNoForceIsNull]
 else
   Options:=Options-[qoNoForceIsNull];
end;

procedure TFIBQuery.WriteQueryNoForceIsNull(Writer: TWriter);
begin
 Writer.WriteBoolean(qoNoForceIsNull in Options)
end;

procedure TFIBQuery.DefineProperties(Filer: TFiler);

begin
  inherited;
  Filer.DefineProperty('qoAutoCommit',
   ReadQueryAutoCommit, WriteQueryAutoCommit,
   (qoAutoCommit in Options)
  );

  Filer.DefineProperty('qoStartTransaction',
   ReadQueryStartTransaction, WriteQueryStartTransaction,
   (qoStartTransaction in Options)
  );

  Filer.DefineProperty('qoTrimCharFields',
   ReadQueryTrimChar , WriteQueryTrimChar,
   (qoTrimCharFields in Options)
  );

  Filer.DefineProperty('qoNoForceIsNull',
   ReadQueryNoForceIsNull, WriteQueryNoForceIsNull,
   qoNoForceIsNull in Options
  );


end;

{$ENDIF}
