{***************************************************************}
{ FIBPlus - component library for direct access to Firebird and }
{ Interbase databases                                           }
{                                                               }
{    FIBPlus is based in part on the product                    }
{    Free IB Components, written by Gregory H. Deatz for        }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.            }
{    mailto:gdeatz@hlmdd.com                                    }
{                                                               }
{    Copyright (c) 1998-2001 Serge Buzadzhy                     }
{    Contact: buzz@devrace.com                                  }
{                                                               }
{ ------------------------------------------------------------- }
{    FIBPlus home page      : http://www.fibplus.net/           }
{    FIBPlus support e-mail : fibplus@devrace.com               }
{ ------------------------------------------------------------- }
{                                                               }
{  Please see the file License.txt for full license information }
{***************************************************************}


unit RegFIBPlus;

interface
{$I FIBPlus.inc}
uses
 {$IFDEF MSWINDOWS}
  Classes,Sysutils,DB,
  pFIBDataSet,pFIBDatabase,
  pFIBQuery, DSContainer,pFIBStatistic,SIBFIBEA,
  {$IFNDEF NO_MONITOR}
   FIBSQLMonitor,
  {$ENDIF}
  pFIBErrorHandler,
  pFIBStoredProc,
  {$IFDEF FOR_ALL} pFIBProps {$ELSE}sbFIBProps {$ENDIF}
  {$IFDEF  INC_SERVICE_SUPPORT}
     ,IB_Services, IB_Install
  {$ENDIF}
;

 {$ENDIF}
 {$IFDEF LINUX}
  Classes,SysUtils,DB,
  pFIBDataSet,pFIBDatabase,
  pFIBQuery, DSContainer,
  pFIBErrorHandler,

  pFIBStoredProc,
  {$IFDEF FOR_ALL} pFIBProps {$ELSE}sbFIBProps {$ENDIF}
  {$IFDEF  INC_SERVICE_SUPPORT}
   ,IB_Services, IB_Install
  {$ENDIF}
  ;
 {$ENDIF}



procedure Register;

implementation

uses //DsgnIntf,
{$IFNDEF NO_REGISTRY}
 RegUtils,
{$ENDIF}
FIBDataSet,FIBQuery,FIBDatabase,SqlTxtRtns,StrUtil,
 pFIBDataInfo
;

const FIBPalette='FIBPlus';

{$R fibplus.dcr}

procedure Register;
begin
 {$IFNDEF ONLY_PLUS}
  RegisterComponents(FIBPalette, [TFIBDataSet]);
  RegisterComponents(FIBPalette, [TFIBQuery]);
  RegisterComponents(FIBPalette, [TFIBDatabase, TFIBTransaction]);
 {$ENDIF}

  RegisterComponents(FIBPalette,
   [TpFIBDatabase,TpFIBDataSet,TpFIBTransaction,TpFIBQuery,TpFIBStoredProc,
    TpFIBUpdateObject,    TDataSetsContainer,
    TpFibErrorHandler
   ]
  );
//  RegisterComponents('FIBPlus', [TSIBfibEventAlerter]);
 {$IFNDEF LINUX}
  RegisterComponents(FIBPalette, [TpFIBStatistic  ,TSIBfibEventAlerter]);
 {$ENDIF}
 {$IFNDEF NO_MONITOR}
  RegisterComponents(FIBPalette, [TFIBSQLMonitor]);
 {$ENDIF}

  {$IFDEF  INC_SERVICE_SUPPORT}
  RegisterComponents('FIBPlusServices', [
       TpFIBServerProperties,
       TpFIBConfigService,
       TpFIBLicensingService,
       TpFIBLogService,
       TpFIBStatisticalService,
       TpFIBBackupService,
       TpFIBRestoreService,
       TpFIBValidationService,
       TpFIBSecurityService,
       TpFIBInstall,
       TpFIBUnInstall

    ]);
   {$ENDIF}

end;

end.
