// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'FIBDataSet.pas' rev: 6.00

#ifndef FIBDataSetHPP
#define FIBDataSetHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Variants.hpp>	// Pascal unit
#include <FMTBcd.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <ExtCtrls.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <StdFuncs.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <FIBMiscellaneous.hpp>	// Pascal unit
#include <FIBQuery.hpp>	// Pascal unit
#include <FIBDatabase.hpp>	// Pascal unit
#include <DBParsers.hpp>	// Pascal unit
#include <DBConsts.hpp>	// Pascal unit
#include <DBCommon.hpp>	// Pascal unit
#include <DB.hpp>	// Pascal unit
#include <pFIBFieldsDescr.hpp>	// Pascal unit
#include <pFIBProps.hpp>	// Pascal unit
#include <fib.hpp>	// Pascal unit
#include <IB_Externals.hpp>	// Pascal unit
#include <IB_Intf.hpp>	// Pascal unit
#include <ibase.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Fibdataset
{
//-- type declarations -------------------------------------------------------
typedef System::TDateTime *PDateTime;

typedef Fibmiscellaneous::TFIBBlobStream* TBlobDataArray[1];

typedef Fibmiscellaneous::TFIBBlobStream* *PBlobDataArray;

#pragma pack(push, 1)
struct TFieldData
{
	bool fdIsNull;
} ;
#pragma pack(pop)

typedef TFieldData *PFieldData;

#pragma option push -b-
enum TCachedUpdateStatus { cusUnmodified, cusModified, cusInserted, cusDeleted, cusUninserted };
#pragma option pop

#pragma pack(push, 1)
struct TRecordData
{
	Db::TBookmarkFlag rdBookmarkFlag;
	int rdRecordNumber;
	TCachedUpdateStatus rdCachedUpdateStatus;
	Db::TUpdateStatus rdUpdateStatus;
	unsigned rdSavedOffset;
	TFieldData rdFields[1];
} ;
#pragma pack(pop)

typedef TRecordData *PRecordData;

class DELPHICLASS TFIBStringField;
class PASCALIMPLEMENTATION TFIBStringField : public Db::TStringField 
{
	typedef Db::TStringField inherited;
	
private:
	bool FEmptyStrToNull;
	bool FDefaultValueEmptyString;
	AnsiString __fastcall GetAsDB_KEY();
	
public:
	__fastcall virtual TFIBStringField(Classes::TComponent* AOwner);
	__fastcall virtual ~TFIBStringField(void);
	/* virtual class method */ virtual void __fastcall CheckTypeSize(TMetaClass* vmt, int Value);
	virtual AnsiString __fastcall GetAsString();
	virtual Variant __fastcall GetAsVariant();
	HIDESBASE bool __fastcall GetValue(AnsiString &Value);
	bool __fastcall IsDBKey(void);
	virtual void __fastcall SetAsString(const AnsiString Value);
	__property bool DefaultValueEmptyString = {read=FDefaultValueEmptyString, write=FDefaultValueEmptyString, nodefault};
	
__published:
	__property bool EmptyStrToNull = {read=FEmptyStrToNull, write=FEmptyStrToNull, nodefault};
};


class DELPHICLASS TFIBIntegerField;
class PASCALIMPLEMENTATION TFIBIntegerField : public Db::TIntegerField 
{
	typedef Db::TIntegerField inherited;
	
private:
	bool FIsTimeField;
	
protected:
	virtual bool __fastcall GetAsBoolean(void);
	virtual void __fastcall SetAsBoolean(bool Value);
	virtual void __fastcall GetText(AnsiString &Text, bool DisplayText);
	virtual void __fastcall SetText(const AnsiString Value);
	int __fastcall GetHours(void);
	int __fastcall GetMinutes(void);
	int __fastcall GetSeconds(void);
	
public:
	__fastcall virtual TFIBIntegerField(Classes::TComponent* AOwner);
	virtual bool __fastcall IsValidChar(char InputChar);
	__property int Hours = {read=GetHours, nodefault};
	__property int Minutes = {read=GetMinutes, nodefault};
	__property int Seconds = {read=GetSeconds, nodefault};
	
__published:
	__property bool IsTimeField = {read=FIsTimeField, write=FIsTimeField, default=0};
public:
	#pragma option push -w-inl
	/* TField.Destroy */ inline __fastcall virtual ~TFIBIntegerField(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFIBDateField;
class PASCALIMPLEMENTATION TFIBDateField : public Db::TDateField 
{
	typedef Db::TDateField inherited;
	
public:
	#pragma option push -w-inl
	/* TDateField.Create */ inline __fastcall virtual TFIBDateField(Classes::TComponent* AOwner) : Db::TDateField(AOwner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TField.Destroy */ inline __fastcall virtual ~TFIBDateField(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFIBTimeField;
class PASCALIMPLEMENTATION TFIBTimeField : public Db::TTimeField 
{
	typedef Db::TTimeField inherited;
	
public:
	#pragma option push -w-inl
	/* TTimeField.Create */ inline __fastcall virtual TFIBTimeField(Classes::TComponent* AOwner) : Db::TTimeField(AOwner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TField.Destroy */ inline __fastcall virtual ~TFIBTimeField(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFIBDateTimeField;
class PASCALIMPLEMENTATION TFIBDateTimeField : public Db::TDateTimeField 
{
	typedef Db::TDateTimeField inherited;
	
public:
	#pragma option push -w-inl
	/* TDateTimeField.Create */ inline __fastcall virtual TFIBDateTimeField(Classes::TComponent* AOwner) : Db::TDateTimeField(AOwner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TField.Destroy */ inline __fastcall virtual ~TFIBDateTimeField(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFIBBlobField;
class PASCALIMPLEMENTATION TFIBBlobField : public Db::TBlobField 
{
	typedef Db::TBlobField inherited;
	
public:
	#pragma option push -w-inl
	/* TBlobField.Create */ inline __fastcall virtual TFIBBlobField(Classes::TComponent* AOwner) : Db::TBlobField(AOwner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TField.Destroy */ inline __fastcall virtual ~TFIBBlobField(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFIBSmallIntField;
class PASCALIMPLEMENTATION TFIBSmallIntField : public Db::TSmallintField 
{
	typedef Db::TSmallintField inherited;
	
protected:
	virtual bool __fastcall GetAsBoolean(void);
	virtual void __fastcall SetAsBoolean(bool Value);
public:
	#pragma option push -w-inl
	/* TSmallintField.Create */ inline __fastcall virtual TFIBSmallIntField(Classes::TComponent* AOwner) : Db::TSmallintField(AOwner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TField.Destroy */ inline __fastcall virtual ~TFIBSmallIntField(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFIBFloatField;
class PASCALIMPLEMENTATION TFIBFloatField : public Db::TFloatField 
{
	typedef Db::TFloatField inherited;
	
private:
	bool FRoundByScale;
	int __fastcall GetScale(void);
	
protected:
	virtual void __fastcall SetAsFloat(double Value);
	virtual void __fastcall GetText(AnsiString &Text, bool DisplayText);
	
public:
	__fastcall virtual TFIBFloatField(Classes::TComponent* AOwner);
	__property int Scale = {read=GetScale, nodefault};
	
__published:
	__property bool RoundByScale = {read=FRoundByScale, write=FRoundByScale, default=1};
public:
	#pragma option push -w-inl
	/* TField.Destroy */ inline __fastcall virtual ~TFIBFloatField(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFIBBCDField;
class PASCALIMPLEMENTATION TFIBBCDField : public Db::TBCDField 
{
	typedef Db::TBCDField inherited;
	
private:
	bool FRoundByScale;
	bool FDataAsComp;
	int __fastcall GetScale(void);
	int __fastcall ServerType(void);
	
protected:
	/* virtual class method */ virtual void __fastcall CheckTypeSize(TMetaClass* vmt, int Value);
	virtual System::Currency __fastcall GetAsCurrency(void);
	virtual AnsiString __fastcall GetAsString();
	virtual Variant __fastcall GetAsVariant();
	virtual int __fastcall GetDataSize(void);
	virtual void __fastcall GetText(AnsiString &Text, bool DisplayText);
	HIDESBASE bool __fastcall GetValue(System::Currency &Value);
	virtual void __fastcall SetAsString(const AnsiString Value);
	virtual void __fastcall SetAsCurrency(System::Currency Value);
	virtual System::Comp __fastcall GetAsComp(void);
	Extended __fastcall GetAsExtended(void);
	virtual void __fastcall SetAsComp(System::Comp Value);
	void __fastcall SetAsExtended(Extended Value);
	virtual Fmtbcd::TBcd __fastcall GetAsBcd();
	virtual void __fastcall SetAsBcd(const Fmtbcd::TBcd &Value);
	
public:
	__fastcall virtual TFIBBCDField(Classes::TComponent* AOwner);
	HIDESBASE bool __fastcall GetData(void * Buffer);
	virtual void __fastcall Assign(Classes::TPersistent* Source);
	__property Fmtbcd::TBcd AsBcd = {read=GetAsBCD, write=SetAsBCD};
	__property int Scale = {read=GetScale, nodefault};
	__property System::Comp AsComp = {read=GetAsComp, write=SetAsComp};
	__property Extended AsExtended = {read=GetAsExtended, write=SetAsExtended};
	__property Extended Value = {read=GetAsExtended, write=SetAsExtended};
	
__published:
	__property Size  = {default=8};
	__property bool RoundByScale = {read=FRoundByScale, write=FRoundByScale, nodefault};
public:
	#pragma option push -w-inl
	/* TField.Destroy */ inline __fastcall virtual ~TFIBBCDField(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFIBBooleanField;
class PASCALIMPLEMENTATION TFIBBooleanField : public Db::TBooleanField 
{
	typedef Db::TBooleanField inherited;
	
private:
	AnsiString FStringFalse;
	AnsiString FStringTrue;
	
protected:
	bool __fastcall StoreStrFalse(void);
	bool __fastcall StoreStrTrue(void);
	virtual int __fastcall GetAsInteger(void);
	virtual void __fastcall SetAsString(const AnsiString Value);
	virtual void __fastcall SetAsInteger(int Value);
	virtual void __fastcall SetAsBoolean(bool Value);
	virtual int __fastcall GetDataSize(void);
	virtual AnsiString __fastcall GetAsString();
	virtual bool __fastcall GetAsBoolean(void);
	virtual Variant __fastcall GetAsVariant();
	
public:
	__fastcall virtual TFIBBooleanField(Classes::TComponent* AOwner);
	
__published:
	__property AnsiString StringFalse = {read=FStringFalse, write=FStringFalse, stored=StoreStrFalse};
	__property AnsiString StringTrue = {read=FStringTrue, write=FStringTrue, stored=StoreStrTrue};
public:
	#pragma option push -w-inl
	/* TField.Destroy */ inline __fastcall virtual ~TFIBBooleanField(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFIBArrayField;
class PASCALIMPLEMENTATION TFIBArrayField : public Db::TBytesField 
{
	typedef Db::TBytesField inherited;
	
private:
	char *FOldValueBuffer;
	Fibquery::TFIBXSQLVAR* __fastcall GetFIBXSQLVAR(void);
	
protected:
	virtual void __fastcall GetText(AnsiString &Text, bool DisplayText);
	int __fastcall GetDimCount(void);
	Db::TFieldType __fastcall GetElementType(void);
	Ibase::TISC_ARRAY_BOUND __fastcall GetDimension(int Index);
	int __fastcall GetArraySize(void);
	void __fastcall SaveOldBuffer(void);
	void __fastcall RestoreOldBuffer(void);
	Ibase::TGDS_QUAD __fastcall GetArrayId();
	virtual Variant __fastcall GetAsVariant();
	virtual void __fastcall SetAsVariant(const Variant &Value);
	
public:
	__fastcall virtual TFIBArrayField(Classes::TComponent* AOwner);
	__fastcall virtual ~TFIBArrayField(void);
	__property int DimensionCount = {read=GetDimCount, nodefault};
	__property Db::TFieldType ElementType = {read=GetElementType, nodefault};
	__property Ibase::TISC_ARRAY_BOUND Dimension[int Index] = {read=GetDimension};
	__property int ArraySize = {read=GetArraySize, nodefault};
	__property Ibase::TGDS_QUAD ArrayID = {read=GetArrayId};
};


#pragma option push -b-
enum TFIBUpdateAction { uaFail, uaAbort, uaSkip, uaRetry, uaApply, uaApplied };
#pragma option pop

typedef void __fastcall (__closure *TFIBUpdateErrorEvent)(Db::TDataSet* DataSet, Fib::EFIBError* E, Db::TUpdateKind UpdateKind, TFIBUpdateAction &UpdateAction);

typedef void __fastcall (__closure *TFIBUpdateRecordEvent)(Db::TDataSet* DataSet, Db::TUpdateKind UpdateKind, TFIBUpdateAction &UpdateAction);

typedef Set<TCachedUpdateStatus, cusUnmodified, cusUninserted>  TFIBUpdateRecordTypes;

typedef void __fastcall (__closure *TOnFetchRecord)(Fibquery::TFIBQuery* FromQuery, int RecordNumber, bool &StopFetching);

#pragma option push -b-
enum TDispositionFieldType { dfNormal, dfRRecNumber, dfWRecNumber, dfRWRecNumber };
#pragma option pop

#pragma option push -b-
enum TExtLocateOption { eloCaseInsensitive, eloPartialKey, eloWildCards, eloInSortedDS, eloNearest, eloInFetchedRecords };
#pragma option pop

typedef Set<TExtLocateOption, eloCaseInsensitive, eloInFetchedRecords>  TExtLocateOptions;

#pragma pack(push, 4)
struct TSortFieldInfo
{
	AnsiString FieldName;
	int InDataSetIndex;
	int InOrderIndex;
	bool Asc;
} ;
#pragma pack(pop)

class DELPHICLASS TFIBDataLink;
class DELPHICLASS TFIBCustomDataSet;
class PASCALIMPLEMENTATION TFIBCustomDataSet : public Db::TDataSet 
{
	typedef Db::TDataSet inherited;
	
protected:
	Fibdatabase::TFIBBase* FBase;
	int FBlobCacheOffset;
	Classes::TList* FBlobStreamList;
	int FBufferChunks;
	char *FBufferCache;
	char *FOldBufferCache;
	unsigned FBufferChunkSize;
	unsigned FCacheSize;
	unsigned FOldCacheSize;
	unsigned FBPos;
	unsigned FOBPos;
	unsigned FBEnd;
	unsigned FOBEnd;
	bool FCachedUpdates;
	int FCalcFieldsOffset;
	int FCurrentRecord;
	int FDeletedRecords;
	TFIBDataLink* FSourceLink;
	char *FModelBuffer;
	char *FOldBuffer;
	bool FOpen;
	bool FPrepared;
	Fibquery::TFIBQuery* FQDelete;
	Fibquery::TFIBQuery* FQInsert;
	Fibquery::TFIBQuery* FQRefresh;
	Fibquery::TFIBQuery* FQSelect;
	Fibquery::TFIBQuery* FQUpdate;
	int FRecordBufferSize;
	int FRecordCount;
	int FRecordSize;
	int vDisableScrollCount;
	Classes::TNotifyEvent FDatabaseDisconnecting;
	Classes::TNotifyEvent FDatabaseDisconnected;
	Classes::TNotifyEvent FDatabaseFree;
	TFIBUpdateErrorEvent FOnUpdateError;
	TFIBUpdateRecordEvent FOnUpdateRecord;
	Classes::TNotifyEvent FTransactionEnding;
	Classes::TNotifyEvent FTransactionEnded;
	Classes::TNotifyEvent FTransactionFree;
	bool FUpdatesPending;
	TFIBUpdateRecordTypes FUpdateRecordTypes;
	bool FUniDirectional;
	Db::TDataSetErrorEvent FOnGetRecordError;
	Pfibprops::TpFIBDsOptions FOptions;
	Pfibprops::TDetailConditions FDetailConditions;
	int vInspectRecno;
	TDispositionFieldType vTypeDispositionField;
	int vFilteredRecCounts;
	Extctrls::TTimer* vTimerForDetail;
	Extctrls::TTimer* vScrollTimer;
	int FDisableCOCount;
	Pfibprops::TpPrepareOptions FPrepareOptions;
	bool vInCachRefresh;
	bool vInRefresh;
	bool vSelectSQLTextChanged;
	Fibdatabase::TFIBTransaction* FUpdateTransaction;
	bool FAutoCommit;
	int FWaitEndMasterInterval;
	Db::TFieldNotifyEvent FOnFieldChange;
	bool vInSort;
	Db::TDataSetState vPredState;
	int vrdFieldCount;
	Dbparsers::TExpressionParser* FFilterParser;
	
private:
	bool __fastcall StoreUpdTransaction(void);
	void __fastcall SetOnEndScroll(Db::TDataSetNotifyEvent Event);
	bool __fastcall GetDefaultFields(void);
	void __fastcall ClearBlobStreamList(void);
	
protected:
	void __fastcall ReadUseBooleanField(Classes::TReader* Reader);
	void __fastcall WriteUseBooleanField(Classes::TWriter* Writer);
	void __fastcall ReadSQLINT64ToBCD(Classes::TReader* Reader);
	void __fastcall WriteSQLINT64ToBCD(Classes::TWriter* Writer);
	void __fastcall ReadImportDefaultValues(Classes::TReader* Reader);
	void __fastcall WriteImportDefaultValues(Classes::TWriter* Writer);
	void __fastcall ReadGetOrderInfo(Classes::TReader* Reader);
	void __fastcall WriteGetOrderInfo(Classes::TWriter* Writer);
	void __fastcall ReadSetRequiredFields(Classes::TReader* Reader);
	void __fastcall WriteSetRequiredFields(Classes::TWriter* Writer);
	void __fastcall ReadSetReadOnlyFields(Classes::TReader* Reader);
	void __fastcall WriteSetReadOnlyFields(Classes::TWriter* Writer);
	void __fastcall ReadApplyRepositary(Classes::TReader* Reader);
	void __fastcall WriteApplyRepositary(Classes::TWriter* Writer);
	void __fastcall ReadAskRecordCount(Classes::TReader* Reader);
	void __fastcall WriteAskRecordCount(Classes::TWriter* Writer);
	void __fastcall ReadWaitEndMasterScroll(Classes::TReader* Reader);
	void __fastcall WriteWaitEndMasterScroll(Classes::TWriter* Writer);
	void __fastcall ReadForceMasterRefresh(Classes::TReader* Reader);
	void __fastcall WriteForceMasterRefresh(Classes::TWriter* Writer);
	void __fastcall ReadForceOpen(Classes::TReader* Reader);
	void __fastcall WriteForceOpen(Classes::TWriter* Writer);
	void __fastcall ReadNoForceIsNull(Classes::TReader* Reader);
	void __fastcall WriteNoForceIsNull(Classes::TWriter* Writer);
	void __fastcall ReadOV(Classes::TReader* Reader);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	unsigned __fastcall GetAvailableRecordRooms(void);
	void __fastcall SetAvailableRecordRooms(unsigned Value);
	virtual void __fastcall ShiftBuffer(const int FromRecNo, const int Distance);
	Ibase::TXSQLVAR __fastcall GetXSQLVAR(Db::TField* Fld);
	short __fastcall GetFieldScale(Db::TNumericField* Fld);
	virtual void __fastcall SetUpdateTransaction(Fibdatabase::TFIBTransaction* Value);
	Fibdatabase::TFIBTransaction* __fastcall GetUpdateTransaction(void);
	Db::TGetResult __fastcall AdjustCurrentRecord(void * Buffer, Db::TGetMode GetMode);
	virtual bool __fastcall CanEdit(void);
	virtual bool __fastcall CanInsert(void);
	virtual bool __fastcall CanDelete(void);
	virtual void __fastcall CheckInactive(void);
	void __fastcall CheckEditState(void);
	void __fastcall CheckInsertMode(void * Buffer);
	void __fastcall UpdateBlobInfo(void * Buff, bool IsPost, bool ClearModified);
	void __fastcall CopyRecordBuffer(void * Source, void * Dest);
	void __fastcall DoDatabaseDisconnecting(System::TObject* Sender);
	void __fastcall DoDatabaseDisconnected(System::TObject* Sender);
	void __fastcall DoDatabaseFree(System::TObject* Sender);
	void __fastcall DoTransactionEnding(System::TObject* Sender);
	void __fastcall DoTransactionEnded(System::TObject* Sender);
	void __fastcall DoTransactionFree(System::TObject* Sender);
	void __fastcall FetchCurrentRecordToBuffer(Fibquery::TFIBQuery* Qry, int RecordNumber, char * Buffer, bool DoWriteToCach);
	char * __fastcall GetActiveBuf(void);
	Fibdatabase::TFIBDatabase* __fastcall GetDatabase(void);
	Ibase::PISC_DB_HANDLE __fastcall GetDBHandle(void);
	Classes::TStrings* __fastcall GetDeleteSQL(void);
	Classes::TStrings* __fastcall GetInsertSQL(void);
	Fibquery::TFIBXSQLDA* __fastcall GetParams(void);
	Classes::TStrings* __fastcall GetRefreshSQL(void);
	Classes::TStrings* __fastcall GetSelectSQL(void);
	Fibquery::TFIBSQLTypes __fastcall GetStatementType(void);
	Classes::TStrings* __fastcall GetUpdateSQL(void);
	Fibdatabase::TFIBTransaction* __fastcall GetTransaction(void);
	Ibase::PISC_TR_HANDLE __fastcall GetTRHandle(void);
	virtual void __fastcall InternalDeleteRecord(Fibquery::TFIBQuery* Qry, void * Buff);
	virtual bool __fastcall InternalLocate(const AnsiString KeyFields, const Variant &KeyValues, TExtLocateOptions Options);
	virtual void __fastcall InternalPostRecord(Fibquery::TFIBQuery* Qry, void * Buff);
	bool __fastcall InternalRefreshRow(Fibquery::TFIBQuery* Qry, void * Buff);
	void __fastcall InternalRevertRecord(int RecordNumber, bool WithUnInserted);
	bool __fastcall IsVisibleStat(char * Buffer);
	virtual bool __fastcall IsVisible(char * Buffer);
	void __fastcall SaveOldBuffer(char * Buffer);
	void __fastcall SetBufferChunks(int Value);
	void __fastcall SetDatabase(Fibdatabase::TFIBDatabase* Value);
	void __fastcall SetDeleteSQL(Classes::TStrings* Value);
	void __fastcall SetInsertSQL(Classes::TStrings* Value);
	void __fastcall SetQueryParams(Fibquery::TFIBQuery* Qry, void * Buffer);
	void __fastcall SetRefreshSQL(Classes::TStrings* Value);
	void __fastcall SetSelectSQL(Classes::TStrings* Value);
	void __fastcall SetUpdateSQL(Classes::TStrings* Value);
	void __fastcall SetTransaction(Fibdatabase::TFIBTransaction* Value);
	void __fastcall SetUpdateRecordTypes(TFIBUpdateRecordTypes Value);
	HIDESBASE void __fastcall SetUniDirectional(bool Value);
	virtual void __fastcall SetPrepareOptions(Pfibprops::TpPrepareOptions Value);
	void __fastcall SourceChanged(void);
	void __fastcall SourceDisabled(void);
	void __fastcall SQLChanging(System::TObject* Sender);
	int __fastcall AdjustPosition(char * FCache, unsigned Offset, int Origin);
	void __fastcall ReadCache(char * FCache, unsigned Offset, int Origin, char * Buffer);
	void __fastcall WriteCache(char * FCache, unsigned Offset, int Origin, char * Buffer);
	void __fastcall ReadRecordCache(int RecordNumber, char * Buffer, bool ReadOldBuffer);
	void __fastcall WriteRecordCache(int RecordNumber, char * Buffer);
	char * __fastcall GetNewBuffer(void);
	char * __fastcall GetOldBuffer(void);
	DYNAMIC bool __fastcall IsFiltered(void);
	Pfibfieldsdescr::TFIBFieldDescrList* vFieldDescrList;
	int vIgnoreLocReno;
	bool vControlsEnabled;
	Db::TDataSetNotifyEvent FOnEnableControls;
	Db::TDataSetNotifyEvent FOnDisableControls;
	Db::TDataSetNotifyEvent FOnEndScroll;
	bool vInsertRecordRunning;
	bool vAppendRecordRunning;
	bool vBufferShifted;
	bool FCachedActive;
	bool FIllusionActive;
	virtual void __fastcall DataEvent(Db::TDataEvent Event, int Info);
	virtual void __fastcall SetStateFieldValue(Db::TDataSetState State, Db::TField* Field, const Variant &Value);
	void __fastcall DoOnDisableControls(Db::TDataSet* DataSet);
	void __fastcall DoOnEnableControls(Db::TDataSet* DataSet);
	virtual char * __fastcall AllocRecordBuffer(void);
	virtual void __fastcall InternalDoBeforeOpen(void);
	virtual void __fastcall DoBeforeOpen(void);
	virtual void __fastcall DoAfterOpen(void);
	virtual void __fastcall DoBeforeClose(void);
	virtual void __fastcall DoAfterClose(void);
	virtual void __fastcall DoBeforeCancel(void);
	virtual void __fastcall DoAfterCancel(void);
	virtual void __fastcall DoBeforeDelete(void);
	virtual void __fastcall DoBeforeEdit(void);
	virtual void __fastcall DoBeforeInsert(void);
	virtual void __fastcall DoBeforeScroll(void);
	virtual void __fastcall DoAfterScroll(void);
	virtual void __fastcall DoBeforePost(void);
	virtual void __fastcall DoAfterInsert(void);
	virtual void __fastcall DoAfterPost(void);
	virtual void __fastcall DoAfterDelete(void);
	void __fastcall DoOnEndScroll(System::TObject* Sender);
	virtual void __fastcall DoBeforeRefresh(void);
	virtual void __fastcall DoAfterRefresh(void);
	virtual void __fastcall DoOnPostError(Db::TDataSet* DataSet, Db::EDatabaseError* E, Db::TDataAction &Action);
	virtual void __fastcall FreeRecordBuffer(char * &Buffer);
	virtual void __fastcall GetBookmarkData(char * Buffer, void * Data);
	virtual Db::TBookmarkFlag __fastcall GetBookmarkFlag(char * Buffer);
	virtual bool __fastcall GetCanModify(void);
	virtual Db::TDataSource* __fastcall GetDataSource(void);
	virtual TMetaClass* __fastcall GetFieldClass(Db::TFieldType FieldType);
	virtual int __fastcall GetRecNo(void);
	int __fastcall GetRealRecNo(void);
	virtual Db::TGetResult __fastcall GetRecord(char * Buffer, Db::TGetMode GetMode, bool DoCheck);
	virtual int __fastcall GetRecordCount(void);
	virtual Word __fastcall GetRecordSize(void);
	virtual void __fastcall InternalAddRecord(void * Buffer, bool Append);
	virtual void __fastcall InternalCancel(void);
	virtual void __fastcall InternalClose(void);
	virtual void __fastcall InternalDelete(void);
	virtual void __fastcall InternalFirst(void);
	virtual void __fastcall InternalGotoBookmark(void * Bookmark);
	virtual void __fastcall InternalHandleException(void);
	virtual void __fastcall InternalInitFieldDefs(void);
	virtual void __fastcall InternalInitRecord(char * Buffer);
	virtual void __fastcall InternalLast(void);
	virtual void __fastcall InternalOpen(void);
	virtual void __fastcall InternalPost(void);
	virtual void __fastcall InternalRefresh(void);
	virtual void __fastcall InternalSetToRecord(char * Buffer);
	virtual bool __fastcall IsCursorOpen(void);
	virtual void __fastcall SetBookmarkFlag(char * Buffer, Db::TBookmarkFlag Value);
	virtual void __fastcall SetBookmarkData(char * Buffer, void * Data);
	void __fastcall SetCachedUpdates(bool Value);
	void __fastcall SetDataSource(Db::TDataSource* Value);
	void __fastcall SetOptions(Pfibprops::TpFIBDsOptions Value);
	virtual void __fastcall SetFieldData(Db::TField* Field, void * Buffer)/* overload */;
	virtual void __fastcall SetRecNo(int Value);
	bool __fastcall MasterFieldsChanged(void);
	void __fastcall SetParamsFromMaster(void);
	void __fastcall ForceEndWaitMaster(void);
	void __fastcall ExprParserCreate(const AnsiString Text, Db::TFilterOptions Options);
	void __fastcall SetFilterData(const AnsiString Text, Db::TFilterOptions Options);
	virtual void __fastcall SetFilterOptions(Db::TFilterOptions Value);
	virtual void __fastcall SetFilterText(const AnsiString Value);
	bool FInApplyUpdates;
	bool FIsClientSorting;
	Variant FSortFields;
	TOnFetchRecord FBeforeFetchRecord;
	TOnFetchRecord FAfterFetchRecord;
	Classes::TStringList* FRelationTables;
	bool vInOpenByTimer;
	int FCountUpdatesPending;
	Controls::TCursor FSQLScreenCursor;
	Pfibprops::TSQLs* FSQLs;
	bool FInClone;
	bool __fastcall IsValidBuffer(char * FCache);
	void __fastcall PackMemory(char * &FCache);
	bool __fastcall GetAllFetched(void);
	void __fastcall OpenByTimer(System::TObject* Sender);
	void __fastcall DoCloseOpen(System::TObject* Sender);
	bool __fastcall GetWaitEndMasterScroll(void);
	void __fastcall SetWaitEndMasterScroll(bool Value);
	Pfibprops::TDetailConditions __fastcall GetDetailConditions(void);
	void __fastcall SetDetailConditions(Pfibprops::TDetailConditions Value);
	bool __fastcall IsSorted(void);
	void __fastcall SynchronizeBuffers(const bool ExecEvent, const bool ToFibCach);
	void __fastcall DoOnSelectFetch(int RecordNumber, bool &StopFetching);
	void __fastcall PrepareAdditionalInfo(void);
	void __fastcall RefreshMasterDS(void);
	void __fastcall AutoStartUpdateTransaction(void);
	void __fastcall AutoCommitUpdateTransaction(void);
	__property Fibquery::TFIBXSQLDA* Params = {read=GetParams};
	__property bool Prepared = {read=FPrepared, nodefault};
	__property Fibquery::TFIBQuery* QDelete = {read=FQDelete};
	__property Fibquery::TFIBQuery* QInsert = {read=FQInsert};
	__property Fibquery::TFIBQuery* QRefresh = {read=FQRefresh};
	__property Fibquery::TFIBQuery* QSelect = {read=FQSelect};
	__property Fibquery::TFIBQuery* QUpdate = {read=FQUpdate};
	__property Fibquery::TFIBSQLTypes StatementType = {read=GetStatementType, nodefault};
	__property bool UpdatesPending = {read=FUpdatesPending, nodefault};
	__property int BufferChunks = {read=FBufferChunks, write=SetBufferChunks, nodefault};
	__property bool CachedUpdates = {read=FCachedUpdates, write=SetCachedUpdates, nodefault};
	__property Classes::TStrings* DeleteSQL = {read=GetDeleteSQL, write=SetDeleteSQL};
	__property Classes::TStrings* InsertSQL = {read=GetInsertSQL, write=SetInsertSQL};
	__property Classes::TStrings* RefreshSQL = {read=GetRefreshSQL, write=SetRefreshSQL};
	__property Classes::TStrings* SelectSQL = {read=GetSelectSQL, write=SetSelectSQL};
	__property bool UniDirectional = {read=FUniDirectional, write=SetUniDirectional, nodefault};
	__property TFIBUpdateRecordTypes UpdateRecordTypes = {read=FUpdateRecordTypes, write=SetUpdateRecordTypes, nodefault};
	__property Classes::TStrings* UpdateSQL = {read=GetUpdateSQL, write=SetUpdateSQL};
	__property Classes::TNotifyEvent DatabaseDisconnecting = {read=FDatabaseDisconnecting, write=FDatabaseDisconnecting};
	__property Classes::TNotifyEvent DatabaseDisconnected = {read=FDatabaseDisconnected, write=FDatabaseDisconnected};
	__property Classes::TNotifyEvent DatabaseFree = {read=FDatabaseFree, write=FDatabaseFree};
	__property TFIBUpdateErrorEvent OnUpdateError = {read=FOnUpdateError, write=FOnUpdateError};
	__property TFIBUpdateRecordEvent OnUpdateRecord = {read=FOnUpdateRecord, write=FOnUpdateRecord};
	__property Classes::TNotifyEvent TransactionEnding = {read=FTransactionEnding, write=FTransactionEnding};
	__property Classes::TNotifyEvent TransactionEnded = {read=FTransactionEnded, write=FTransactionEnded};
	__property Classes::TNotifyEvent TransactionFree = {read=FTransactionFree, write=FTransactionFree};
	__property int DisableCOCount = {read=FDisableCOCount, nodefault};
	
private:
	Pfibprops::TConditions* __fastcall GetConditions(void);
	void __fastcall SetConditions(Pfibprops::TConditions* Value);
	
public:
	void __fastcall ApplyConditions(void);
	
__published:
	__property Pfibprops::TConditions* Conditions = {read=GetConditions, write=SetConditions};
	
public:
	__fastcall virtual TFIBCustomDataSet(Classes::TComponent* AOwner);
	__fastcall virtual ~TFIBCustomDataSet(void);
	
private:
	bool vInGotoBookMark;
	
public:
	virtual void __fastcall Resync(Db::TResyncMode Mode);
	virtual bool __fastcall BookmarkValid(void * Bookmark);
	void __fastcall PackBuffer(void);
	void __fastcall CloseOpen(const bool DoFetchAll);
	void __fastcall StartTransaction(void);
	void __fastcall BatchInput(Fibquery::TFIBBatchInputStream* InputObject);
	void __fastcall BatchOutput(Fibquery::TFIBBatchOutputStream* OutputObject);
	TCachedUpdateStatus __fastcall CachedUpdateStatus(void);
	virtual void __fastcall CancelUpdates(void);
	void __fastcall CheckDatasetClosed(const AnsiString Reason);
	void __fastcall CheckDatasetOpen(const AnsiString Reason);
	void __fastcall CheckNotUniDirectional(void);
	void __fastcall FetchAll(void);
	virtual void __fastcall Prepare(void);
	void __fastcall RecordModified(bool Value);
	HIDESBASE void __fastcall InsertRecord(const System::TVarRec * Values, const int Values_Size);
	HIDESBASE void __fastcall AppendRecord(const System::TVarRec * Values, const int Values_Size);
	void __fastcall RevertRecord(void);
	void __fastcall Undelete(void);
	void __fastcall DisableScrollEvents(void);
	void __fastcall EnableScrollEvents(void);
	void __fastcall DisableCloseOpenEvents(void);
	void __fastcall EnableCloseOpenEvents(void);
	Variant __fastcall ArrayFieldValue(Db::TField* Field);
	void __fastcall SetArrayValue(Db::TField* Field, const Variant &Value);
	Variant __fastcall GetElementFromValue(Db::TField* Field, const int * Indexes, const int Indexes_Size);
	void __fastcall SetArrayElementValue(Db::TField* Field, const Variant &Value, const int * Indexes, const int Indexes_Size);
	AnsiString __fastcall GetRelationTableName(System::TObject* Field);
	AnsiString __fastcall GetRelationFieldName(Db::TField* Field);
	void __fastcall SwapRecords(int Recno1, int Recno2);
	virtual void __fastcall MoveRecord(int OldRecno, int NewRecno);
	void __fastcall DoSortEx(const int * Fields, const int Fields_Size, const bool * Ordering, const int Ordering_Size)/* overload */;
	void __fastcall DoSortEx(Classes::TStrings* Fields, const bool * Ordering, const int Ordering_Size)/* overload */;
	virtual void __fastcall DoSort(const System::TVarRec * Fields, const int Fields_Size, const bool * Ordering, const int Ordering_Size);
	AnsiString __fastcall GetFieldOrigin(Db::TField* Fld);
	Db::TField* __fastcall FieldByOrigin(const AnsiString aOrigin);
	AnsiString __fastcall DomainForField(const Variant &Fld);
	bool __fastcall IsSortedField(Db::TField* Field, TSortFieldInfo &FieldSortOrder);
	int __fastcall SortFieldsCount(void);
	TSortFieldInfo __fastcall SortFieldInfo(int OrderIndex);
	AnsiString __fastcall SortedFields();
	__property Variant SortFields = {read=FSortFields};
	__property bool Sorted = {read=IsSorted, nodefault};
	__property Classes::TStringList* RelationTables = {read=FRelationTables};
	__property bool CachedActive = {read=FCachedActive, nodefault};
	virtual int __fastcall CompareBookmarks(void * Bookmark1, void * Bookmark2);
	bool __fastcall BlobModified(Db::TField* Field);
	virtual Classes::TStream* __fastcall CreateBlobStream(Db::TField* Field, Db::TBlobStreamMode Mode);
	virtual bool __fastcall GetCurrentRecord(char * Buffer);
	virtual bool __fastcall GetFieldData(Db::TField* Field, void * Buffer)/* overload */;
	Variant __fastcall RecordFieldValue(Db::TField* Field, int RecNumber);
	virtual bool __fastcall Locate(const AnsiString KeyFields, const Variant &KeyValues, Db::TLocateOptions Options);
	bool __fastcall ExtLocate(const AnsiString KeyFields, const Variant &KeyValues, TExtLocateOptions Options);
	bool __fastcall LocateNext(const AnsiString KeyFields, const Variant &KeyValues, Db::TLocateOptions Options);
	bool __fastcall ExtLocateNext(const AnsiString KeyFields, const Variant &KeyValues, TExtLocateOptions Options);
	void __fastcall RefreshFilters(void);
	virtual Variant __fastcall Lookup(const AnsiString KeyFields, const Variant &KeyValues, const AnsiString ResultFields);
	virtual int __fastcall Translate(char * Src, char * Dest, bool ToOem);
	virtual Db::TUpdateStatus __fastcall UpdateStatus(void);
	virtual bool __fastcall IsSequenced(void);
	__property bool DefaultFields = {read=GetDefaultFields, nodefault};
	void __fastcall CacheDelete(void);
	void __fastcall CacheOpen(void);
	Db::TField* __fastcall CreateCalcFieldAs(Db::TField* Field);
	void __fastcall CopyFieldsStructure(TFIBCustomDataSet* Source, bool RecreateFields);
	void __fastcall CopyFieldsProperties(TFIBCustomDataSet* Source, TFIBCustomDataSet* Destination);
	void __fastcall OpenAsClone(TFIBCustomDataSet* DataSet);
	void __fastcall Clone(TFIBCustomDataSet* DataSet, bool RecreateFields);
	bool __fastcall CanCloneFromDataSet(TFIBCustomDataSet* DataSet);
	Db::TField* __fastcall FieldByRelName(const AnsiString FName);
	int __fastcall FetchNext(unsigned FetchCount);
	void __fastcall ReopenLocate(const AnsiString LocateFieldNames);
	void __fastcall FullRefresh(void);
	__property unsigned CacheSize = {read=FCacheSize, nodefault};
	__property Ibase::PISC_DB_HANDLE DBHandle = {read=GetDBHandle};
	__property Ibase::PISC_TR_HANDLE TRHandle = {read=GetTRHandle};
	__property bool AllFetched = {read=GetAllFetched, nodefault};
	__property int WaitEndMasterInterval = {read=FWaitEndMasterInterval, write=FWaitEndMasterInterval, nodefault};
	__property bool WaitEndMasterScroll = {read=GetWaitEndMasterScroll, write=SetWaitEndMasterScroll, nodefault};
	__property unsigned AvailableRecordRooms = {read=GetAvailableRecordRooms, write=SetAvailableRecordRooms, nodefault};
	
__published:
	__property Fibdatabase::TFIBDatabase* Database = {read=GetDatabase, write=SetDatabase};
	__property Fibdatabase::TFIBTransaction* Transaction = {read=GetTransaction, write=SetTransaction};
	__property TOnFetchRecord BeforeFetchRecord = {read=FBeforeFetchRecord, write=FBeforeFetchRecord};
	__property TOnFetchRecord AfterFetchRecord = {read=FAfterFetchRecord, write=FAfterFetchRecord};
	__property Db::TDataSetErrorEvent OnGetRecordError = {read=FOnGetRecordError, write=FOnGetRecordError};
	__property Pfibprops::TpFIBDsOptions Options = {read=FOptions, write=SetOptions, nodefault};
	__property Pfibprops::TDetailConditions DetailConditions = {read=GetDetailConditions, write=SetDetailConditions, stored=false, nodefault};
	__property Fibdatabase::TFIBTransaction* UpdateTransaction = {read=GetUpdateTransaction, write=SetUpdateTransaction, stored=StoreUpdTransaction};
	__property Pfibprops::TpPrepareOptions PrepareOptions = {read=FPrepareOptions, write=SetPrepareOptions, stored=false, nodefault};
	__property bool AutoCommit = {read=FAutoCommit, write=FAutoCommit, default=0};
	__property Db::TFieldNotifyEvent OnFieldChange = {read=FOnFieldChange, write=FOnFieldChange};
	__property Db::TDataSetNotifyEvent OnEnableControls = {read=FOnEnableControls, write=FOnEnableControls};
	__property Db::TDataSetNotifyEvent OnDisableControls = {read=FOnDisableControls, write=FOnDisableControls};
	__property Db::TDataSetNotifyEvent OnEndScroll = {read=FOnEndScroll, write=SetOnEndScroll};
	__property Controls::TCursor SQLScreenCursor = {read=FSQLScreenCursor, write=FSQLScreenCursor, default=0};
	__property Pfibprops::TSQLs* SQLs = {read=FSQLs, write=FSQLs, stored=false};
	
/* Hoisted overloads: */
	
protected:
	inline void __fastcall  SetFieldData(Db::TField* Field, void * Buffer, bool NativeFormat){ TDataSet::SetFieldData(Field, Buffer, NativeFormat); }
	
public:
	inline bool __fastcall  GetFieldData(int FieldNo, void * Buffer){ return TDataSet::GetFieldData(FieldNo, Buffer); }
	inline bool __fastcall  GetFieldData(Db::TField* Field, void * Buffer, bool NativeFormat){ return TDataSet::GetFieldData(Field, Buffer, NativeFormat); }
	
};


class PASCALIMPLEMENTATION TFIBDataLink : public Db::TDetailDataLink 
{
	typedef Db::TDetailDataLink inherited;
	
protected:
	TFIBCustomDataSet* FDataSet;
	virtual void __fastcall ActiveChanged(void);
	virtual void __fastcall RecordChanged(Db::TField* Field);
	virtual void __fastcall CheckBrowseMode(void);
	virtual void __fastcall DataSetChanged(void);
	virtual Db::TDataSet* __fastcall GetDetailDataSet(void);
	
public:
	__fastcall TFIBDataLink(TFIBCustomDataSet* ADataSet);
	__fastcall virtual ~TFIBDataLink(void);
};


#pragma pack(push, 4)
struct TFIBBookmark
{
	int bRecordNumber;
	int bActiveRecord;
} ;
#pragma pack(pop)

class DELPHICLASS TFIBDataSet;
class PASCALIMPLEMENTATION TFIBDataSet : public TFIBCustomDataSet 
{
	typedef TFIBCustomDataSet inherited;
	
private:
	bool __fastcall DoStoreActive(void);
	
public:
	__property Params ;
	__property Prepared ;
	__property QDelete ;
	__property QInsert ;
	__property QRefresh ;
	__property QSelect ;
	__property QUpdate ;
	__property StatementType ;
	__property UpdatesPending ;
	__property Bof ;
	__property Bookmark ;
	__property Designer ;
	__property Eof ;
	__property FieldCount ;
	__property FieldDefs ;
	__property Fields ;
	__property FieldValues ;
	__property Found ;
	__property Modified ;
	__property RecordCount ;
	__property State ;
	
__published:
	__property BufferChunks ;
	__property CachedUpdates ;
	__property UniDirectional ;
	__property UpdateRecordTypes ;
	__property UpdateSQL ;
	__property DeleteSQL ;
	__property InsertSQL ;
	__property RefreshSQL ;
	__property SelectSQL ;
	__property Filter ;
	__property FilterOptions  = {default=0};
	__property DatabaseDisconnecting ;
	__property DatabaseDisconnected ;
	__property DatabaseFree ;
	__property OnUpdateError ;
	__property OnUpdateRecord ;
	__property TransactionEnding ;
	__property TransactionEnded ;
	__property TransactionFree ;
	__property Active  = {stored=DoStoreActive, default=0};
	__property AutoCalcFields  = {default=1};
	__property DataSource  = {read=GetDataSource, write=SetDataSource};
	__property AfterCancel ;
	__property AfterClose ;
	__property AfterDelete ;
	__property AfterEdit ;
	__property AfterInsert ;
	__property AfterOpen ;
	__property AfterPost ;
	__property AfterScroll ;
	__property BeforeCancel ;
	__property BeforeClose ;
	__property BeforeDelete ;
	__property BeforeEdit ;
	__property BeforeInsert ;
	__property BeforeOpen ;
	__property BeforePost ;
	__property BeforeScroll ;
	__property OnCalcFields ;
	__property OnDeleteError ;
	__property OnEditError ;
	__property OnNewRecord ;
	__property OnPostError ;
	__property BeforeRefresh ;
	__property AfterRefresh ;
public:
	#pragma option push -w-inl
	/* TFIBCustomDataSet.Create */ inline __fastcall virtual TFIBDataSet(Classes::TComponent* AOwner) : TFIBCustomDataSet(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TFIBCustomDataSet.Destroy */ inline __fastcall virtual ~TFIBDataSet(void) { }
	#pragma option pop
	
};


class DELPHICLASS TFIBDSBlobStream;
class PASCALIMPLEMENTATION TFIBDSBlobStream : public Classes::TStream 
{
	typedef Classes::TStream inherited;
	
protected:
	bool FModified;
	Db::TField* FField;
	Fibmiscellaneous::TFIBBlobStream* FBlobStream;
	
public:
	__fastcall TFIBDSBlobStream(Db::TField* AField, Fibmiscellaneous::TFIBBlobStream* ABlobStream, Db::TBlobStreamMode Mode);
	__fastcall virtual ~TFIBDSBlobStream(void);
	virtual int __fastcall Read(void *Buffer, int Count);
	virtual int __fastcall Seek(int Offset, Word Origin)/* overload */;
	virtual void __fastcall SetSize(int NewSize)/* overload */;
	virtual int __fastcall Write(const void *Buffer, int Count);
	
/* Hoisted overloads: */
	
public:
	inline __int64 __fastcall  Seek(const __int64 Offset, Classes::TSeekOrigin Origin){ return TStream::Seek(Offset, Origin); }
	
protected:
	inline void __fastcall  SetSize(const __int64 NewSize){ TStream::SetSize(NewSize); }
	
};


#pragma option push -b-
enum TFIBFilterType { ftByField, ftCopy };
#pragma option pop

//-- var, const, procedure ---------------------------------------------------
static const Shortint BufferCacheSize = 0x20;
static const Shortint UniCache = 0x2;
extern PACKAGE TMetaClass*DefaultFieldClasses[22];
extern PACKAGE void __fastcall Register(void);
extern PACKAGE int __fastcall RecordDataLength(int n);
extern PACKAGE void __fastcall FilterOut(TFIBCustomDataSet* FromDS);
extern PACKAGE void __fastcall ClearRecordCache(TFIBCustomDataSet* FromDS);
extern PACKAGE void __fastcall Sort(TFIBCustomDataSet* DataSet, const System::TVarRec * aFields, const int aFields_Size, const bool * Ordering, const int Ordering_Size);

}	/* namespace Fibdataset */
using namespace Fibdataset;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// FIBDataSet
