// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'FIBSQLMonitor.pas' rev: 6.00

#ifndef FIBSQLMonitorHPP
#define FIBSQLMonitorHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <IB_Services.hpp>	// Pascal unit
#include <DB.hpp>	// Pascal unit
#include <FIBDatabase.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <FIBDataSet.hpp>	// Pascal unit
#include <ibase.hpp>	// Pascal unit
#include <FIBQuery.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Fibsqlmonitor
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TFIBTraceFlag { tfQPrepare, tfQExecute, tfQFetch, tfConnect, tfTransact, tfService, tfMisc };
#pragma option pop

typedef Set<TFIBTraceFlag, tfQPrepare, tfMisc>  TFIBTraceFlags;

typedef void __fastcall (__closure *TSQLEvent)(AnsiString EventText, System::TDateTime EventTime);

class DELPHICLASS TFIBCustomSQLMonitor;
class PASCALIMPLEMENTATION TFIBCustomSQLMonitor : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	HWND FHWnd;
	TSQLEvent FOnSQLEvent;
	TFIBTraceFlags FTraceFlags;
	bool FActive;
	void __fastcall MonitorWndProc(Messages::TMessage &Message);
	void __fastcall SetActive(const bool Value);
	void __fastcall SetTraceFlags(TFIBTraceFlags aTraceFlags);
	
protected:
	__property TSQLEvent OnSQL = {read=FOnSQLEvent, write=FOnSQLEvent};
	__property TFIBTraceFlags TraceFlags = {read=FTraceFlags, write=SetTraceFlags, nodefault};
	__property bool Active = {read=FActive, write=SetActive, default=1};
	
public:
	__fastcall virtual TFIBCustomSQLMonitor(Classes::TComponent* AOwner);
	__fastcall virtual ~TFIBCustomSQLMonitor(void);
	void __fastcall Release(void);
	__property HWND Handle = {read=FHWnd, nodefault};
};


class DELPHICLASS TFIBSQLMonitor;
class PASCALIMPLEMENTATION TFIBSQLMonitor : public TFIBCustomSQLMonitor 
{
	typedef TFIBCustomSQLMonitor inherited;
	
__published:
	__property OnSQL ;
	__property TraceFlags ;
	__property Active  = {default=1};
public:
	#pragma option push -w-inl
	/* TFIBCustomSQLMonitor.Create */ inline __fastcall virtual TFIBSQLMonitor(Classes::TComponent* AOwner) : TFIBCustomSQLMonitor(AOwner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TFIBCustomSQLMonitor.Destroy */ inline __fastcall virtual ~TFIBSQLMonitor(void) { }
	#pragma option pop
	
};


class DELPHICLASS TMonitorHookOptions;
class DELPHICLASS TFIBSQLMonitorHook;
class PASCALIMPLEMENTATION TFIBSQLMonitorHook : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	bool FActive;
	bool vEventsCreated;
	TMonitorHookOptions* FOptions;
	bool FOptimizing;
	void __fastcall CreateEvents(void);
	
protected:
	void __fastcall WriteSQLData(const AnsiString Text, TFIBTraceFlag DataType);
	
public:
	__fastcall TFIBSQLMonitorHook(void);
	__fastcall virtual ~TFIBSQLMonitorHook(void);
	void __fastcall TerminateWriteThread(void);
	Byte __fastcall SQLString(int k);
	void __fastcall RegisterMonitor(TFIBCustomSQLMonitor* SQLMonitor);
	void __fastcall UnregisterMonitor(TFIBCustomSQLMonitor* SQLMonitor);
	void __fastcall ReleaseMonitor(TFIBCustomSQLMonitor* Arg);
	virtual void __fastcall SQLPrepare(Fibquery::TFIBQuery* qry);
	virtual void __fastcall SQLExecute(Fibquery::TFIBQuery* qry);
	virtual void __fastcall SQLFetch(Fibquery::TFIBQuery* qry);
	virtual void __fastcall DBConnect(Fibdatabase::TFIBDatabase* db);
	virtual void __fastcall DBDisconnect(Fibdatabase::TFIBDatabase* db);
	virtual void __fastcall TRStart(Fibdatabase::TFIBTransaction* tr);
	virtual void __fastcall TRCommit(Fibdatabase::TFIBTransaction* tr);
	virtual void __fastcall TRCommitRetaining(Fibdatabase::TFIBTransaction* tr);
	virtual void __fastcall TRRollback(Fibdatabase::TFIBTransaction* tr);
	virtual void __fastcall TRRollbackRetaining(Fibdatabase::TFIBTransaction* tr);
	virtual void __fastcall ServiceAttach(Ib_services::TpFIBCustomService* service);
	virtual void __fastcall ServiceDetach(Ib_services::TpFIBCustomService* service);
	virtual void __fastcall ServiceQuery(Ib_services::TpFIBCustomService* service);
	virtual void __fastcall ServiceStart(Ib_services::TpFIBCustomService* service);
	void __fastcall SendMisc(AnsiString Msg);
	bool __fastcall GetEnabled(void);
	int __fastcall GetMonitorCount(void);
	void __fastcall SetEnabled(const bool Value);
	__property bool Enabled = {read=GetEnabled, write=SetEnabled, default=1};
};


class PASCALIMPLEMENTATION TMonitorHookOptions : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	TFIBSQLMonitorHook* FOwner;
	
protected:
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation);
	
public:
	__fastcall virtual ~TMonitorHookOptions(void);
public:
	#pragma option push -w-inl
	/* TComponent.Create */ inline __fastcall virtual TMonitorHookOptions(Classes::TComponent* AOwner) : Classes::TComponent(AOwner) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const Word WM_MIN_FIBSQL_MONITOR = 0x400;
static const Word WM_MAX_FIBSQL_MONITOR = 0x600;
static const Word WM_FIBSQL_SQL_EVENT = 0x401;
extern PACKAGE TFIBSQLMonitorHook* __fastcall MonitorHook(void);
extern PACKAGE void __fastcall EnableMonitoring(void);
extern PACKAGE void __fastcall DisableMonitoring(void);
extern PACKAGE bool __fastcall MonitoringEnabled(void);

}	/* namespace Fibsqlmonitor */
using namespace Fibsqlmonitor;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// FIBSQLMonitor
