/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.RandomAccessFile;

class SwissReader {
    public static int EC = 1;
    public static int Comments = 2;
    public static int Description = 4;
    public static int AltName = 8;
    public static int Reaction = 16;
    public static int Cofactors = 32;
    public static int Diseases = 64;
    public static int Prosite = 128;
    public static int SwissProt = 256;
    public static int End = 1024;
    public static int References = SwissProt + Prosite;
    public static int All = 65535 - End;
    static String[] CategoryNames = new String[]{"EC number", "Comment", "Name", "Also known as", "Reaction", "Cofactors", "Related diseases", "Prosite", "SwissProt", "End of record"};
    public RandomAccessFile f;
    String file;

    public SwissReader(String _file) {
        this.file = _file;
        try {
            this.f = new RandomAccessFile(this.file, "r");
        }
        catch (IOException iOException) {
            System.out.println("Cant open built in database " + _file + ".");
        }
    }

    static int category(String x) {
        if (x.startsWith(Enzyme.EC)) {
            return EC;
        }
        if (x.startsWith(Enzyme.Comments)) {
            return Comments;
        }
        if (x.startsWith(Enzyme.Description)) {
            return Description;
        }
        if (x.startsWith(Enzyme.AltName)) {
            return AltName;
        }
        if (x.startsWith(Enzyme.Reaction)) {
            return Reaction;
        }
        if (x.startsWith(Enzyme.Cofactors)) {
            return Cofactors;
        }
        if (x.startsWith(Enzyme.Diseases)) {
            return Diseases;
        }
        if (x.startsWith(Enzyme.Prosite)) {
            return Prosite;
        }
        if (x.startsWith(Enzyme.SwissProt)) {
            return SwissProt;
        }
        if (x.startsWith(Enzyme.End)) {
            return End;
        }
        return -1;
    }

    public Strings getAbout(String EC) {
        return this.getAbout(EC, 0);
    }

    public Strings getAbout(String EC, int filter) {
        if (filter == 0) {
            filter = All;
        }
        Strings s = new Strings(5, 5);
        boolean i = false;
        try {
            String e;
            int cmp;
            Enzyme E = new Enzyme(EC);
            if (E.n == null) {
                s.add("ER Wrong EC number: '" + EC + "'");
                s.add(Enzyme.End);
                return s;
            }
            long a = 0L;
            long b = this.f.length();
            int loops = 0;
            do {
                long p;
                Enzyme X;
                if ((cmp = E.compareTo(X = new Enzyme(e = this.getNextEnzymeAt(p = (a + b) / 2L)))) < 0) {
                    b = p;
                    continue;
                }
                if (cmp <= 0) break;
                a = p;
            } while (b - a >= 3L && loops++ < 200);
            do {
                if (cmp != 0) {
                    throw new IOException("Dichotomic search failed.");
                }
                e = this.readLine();
                if (!SwissReader.ok(e, filter)) continue;
                s.add(e);
            } while (!e.startsWith(Enzyme.End));
        }
        catch (IOException iOException) {
            s.add("ER EC number not found in the database.");
            s.add(Enzyme.End);
        }
        return s;
    }

    static String getCategoryName(int c) {
        int r = 0;
        while (c != 0) {
            c /= 2;
            ++r;
        }
        return CategoryNames[r - 1];
    }

    public String getNextEnzymeAt(long pos) {
        String e;
        try {
            byte b;
            this.f.seek(pos);
            while ((b = this.f.readByte()) != 10 && b != 13) {
            }
            while (!(e = this.readLine()).startsWith(Enzyme.EC)) {
            }
            e = sx.getContent(e);
        }
        catch (IOException iOException) {
            return "Z.Z.Z.Z";
        }
        return e;
    }

    static boolean ok(String x, int filt) {
        return (SwissReader.category(x) & filt) != 0;
    }

    /*
     * Exception decompiling
     */
    String readLine() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    String xreadLine() throws IOException {
        StringBuffer e = new StringBuffer(200);
        int b = this.f.read();
        if (b != 10 && b != 13) {
            e.append((char)b);
        }
        while ((b = (int)this.f.readByte()) != 10 && b != 13) {
            e.append((char)b);
        }
        return e.toString().trim();
    }
}

