/* chainmem.c - This file is a part of Floke Integrity
 *      Copyright (C) 2000 Jon Wickmann
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Written by Jon Wickmann <jon.wickmann@excite.com>, 2000.
 * For contact information please see http://www.angelfire.com/wi/wickmann/contact.html
 * Floke Integrity http://www.angelfire.com/wi/wickmann/floke.html
 * Please observe modification guidelines in the documentation
 *
 * History:
 * File last modified 2000.09.14. JWi
 *  */

#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include "flokecore.h"


struct myentry
{
   unsigned char firstname[25];
   unsigned char familyname[25];
   unsigned char email[25];
   unsigned char  phone[25];
   struct myentry *next;
   struct myentry *prev;
} *currentpoint, *start, *prior;

int	myindex;
BOOL memDisAllocAll(struct myentry *block);
BOOL memPrev(void);
BOOL memNext(void);
BOOL memInit(void);

BOOL memInit(void)
{
	start = (struct myentry *)malloc(sizeof(struct myentry)); //allocate
	start->prev=0; // no prev alloc
	start->next=0; // no next alloc yet
	currentpoint=start; // sett cur pos to start
	return 1;
}

BOOL memNext(void)
{
	prior=currentpoint;
	if (currentpoint->next!=0)
		{
			currentpoint=prior->next;
			return TRUE;
		}

	currentpoint=(struct myentry *)malloc(sizeof(struct myentry)); //allocate
	if (currentpoint==0)
		{
			return FALSE;
		}
	currentpoint->firstname[0]=0;
	currentpoint->familyname[0]=0;
	currentpoint->phone[0]=0;
	currentpoint->email[0]=0;

	currentpoint->prev=prior;
	currentpoint->next=0;
	prior->next=currentpoint;
	return TRUE;


}

BOOL memPrev(void)
{
	prior=currentpoint;
	if (currentpoint->prev==0)
		{
			return FALSE;
		}
	currentpoint=prior->prev;
	return TRUE;
}

BOOL memDisAllocAll(struct myentry *block)
{
	struct myentry *holder;

	holder=block->next;
	free(block);
	if (holder !=0)
		{
			memDisAllocAll(holder);
		}
	return TRUE;
}

struct direntry *memAllocdir(struct direntry *inPrev) //Function to allocate and set dir entries
{
	struct direntry *temp;

	temp=(struct direntry *)malloc(sizeof(struct direntry));
	if (temp!=NULL)
		{
			temp->next=NULL;
			temp->prev=inPrev;
			temp->dirname[0]=0;
			temp->dirname[1]=0;
			temp->firstsub=NULL;
			temp->firstfile=NULL; // No indexed files yet!
		}
	if (temp==NULL)
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELONE)
				{
					fprintf(errverboseout,"memAllocdir : Memory allocation error\n");
				}
			#endif
		}

	return temp;

}
struct fileentry *memAllocfile(struct fileentry *inPrev) //Function to allocate and set file entries
{
	struct fileentry *temp;

	temp=(struct fileentry *)malloc(sizeof(struct fileentry));
	if (temp!=NULL)
		{
			temp->next=NULL;
			temp->prev=inPrev;
			temp->filename[0]=0;
			temp->filename[1]=0;
			temp->status=INITIAL;  // By default all files are allocated as INITIAL
		}
	if (temp==NULL)
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELONE)
				{
					fprintf(errverboseout,"memAllocfile : Memory allocation error\n");
				}
			#endif
		}

	return temp;
}

void dumpallfileentries(struct fileentry *curfileentry)
{
	if(curfileentry!=NULL)
		{
			if(curfileentry->filename[0]!=NIL)
				{
					#ifdef DEBUGHELPERS
					if (verbose>ERRVERBOSELEVELFOUR)
						{
							fprintf(errverboseout,"dumpallfileentries File Name %s \n", curfileentry->filename);
							fprintf(errverboseout,"dumpallfileentries Hash %08x %08x %08x %08x %08x\n",curfileentry->hash[0],curfileentry->hash[1],curfileentry->hash[2],curfileentry->hash[3],curfileentry->hash[4]);
							if(curfileentry->status==OKAY)
								{
									fprintf(errverboseout,"dumpallfileentries status==OKAY\n");
								}
							if(curfileentry->status==CHANGED)
								{
									fprintf(errverboseout,"dumpallfileentries status==CHANGED\n");
								}
							if(curfileentry->status==INITIAL)
								{
									fprintf(errverboseout,"dumpallfileentries status==INITIAL\n");
								}
						}
					#endif
				}


			if(curfileentry->next!=NULL)
				{
					dumpallfileentries(curfileentry->next);
				}
		}
}

void disAllocateallfileentries(struct fileentry *curfileentry)
{
	if(curfileentry!=NULL)
		{
			if(curfileentry->filename[0]!=NIL)
				{
					#ifdef DEBUGHELPERS
					if (verbose>ERRVERBOSELEVELFOUR)
						{
							fprintf(errverboseout,"disAllocatepallfileentries File Name %s \n", curfileentry->filename);
							fprintf(errverboseout,"disAllocatepallfileentries Hash %08x %08x %08x %08x %08x\n",curfileentry->hash[0],curfileentry->hash[1],curfileentry->hash[2],curfileentry->hash[3],curfileentry->hash[4]);
							if(curfileentry->status==OKAY)
								{
									fprintf(errverboseout,"disAllocateallfileentries status==OKAY\n");
								}
							if(curfileentry->status==CHANGED)
								{
									fprintf(errverboseout,"disAllocateallfileentries status==CHANGED\n");
								}
							if(curfileentry->status==INITIAL)
								{
									fprintf(errverboseout,"disAllocateallfileentries status==INITIAL\n");
								}
						}
					#endif
				}


			if(curfileentry->next!=NULL)
				{
					disAllocateallfileentries(curfileentry->next);
				}
			free(curfileentry);
		}
}

void dumpalldirentries(struct direntry *curdirentry)
{

	if(curdirentry!=NULL)
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELFOUR)
				{
					fprintf(errverboseout,"dumpalldirentries Dir Name %s \n", curdirentry->dirname);
				}
			#endif
			if(curdirentry->firstfile!=NULL)
				{
					dumpallfileentries(curdirentry->firstfile);
				}


		}
	if(curdirentry->next!=NULL)
		{
			dumpalldirentries(curdirentry->next);
		}
}


void disAllocatealldirentries(struct direntry *curdirentry)
{

	if(curdirentry!=NULL)
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELFOUR)
				{
					fprintf(errverboseout,"disAllocatealldirentries Dir Name %s \n", curdirentry->dirname);
				}
			#endif
			if(curdirentry->firstfile!=NULL)
				{
					disAllocateallfileentries(curdirentry->firstfile);
				}



			if(curdirentry->firstsub!=NULL)
				{
					disAllocatealldirentries(curdirentry->firstsub);
				}
			if(curdirentry->next!=NULL)
				{
					disAllocatealldirentries(curdirentry->next);
				}
			free(curdirentry);
		}
}

void dumpeveryentry(struct direntry *curdirentry)
{

	struct direntry *tempdirentry;

	if(curdirentry->dirname[0]!=NIL)
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELFOUR)
				{
					fprintf(errverboseout,"dumpeveryentry Dir Name %s \n", curdirentry->dirname);
				}
			#endif
			dumpallfileentries(curdirentry->firstfile);

			tempdirentry=curdirentry->firstsub;
			if(tempdirentry!=NULL)
				{
					if(tempdirentry->dirname[0]!=NIL)
						{
							dumpeveryentry(curdirentry->firstsub);
						}
				}
			if(curdirentry->next!=NULL)
				{
					dumpeveryentry(curdirentry->next);
				}
		}



}

void filedumpalldirentries(FILE *f, struct direntry *curdirentry)
{

	if(curdirentry!=NULL)
		{
			fwrite(dirmarker, sizeof(unsigned char), 2,f);
			fprintf(f,"%s\n", curdirentry->dirname);


		}
	if(curdirentry->next!=NULL)
		{
			filedumpalldirentries(f, curdirentry->next);
		}
}

void filedumpeveryentry(FILE *f, struct direntry *curdirentry)
{

	struct direntry *tempdirentry;

	if(curdirentry->dirname[0]!=NIL)
		{
			fwrite(dirmarker, sizeof(unsigned char), 2,f);
			fprintf(f,"%s\n", curdirentry->dirname);
			filedumpallfileentries(f, curdirentry->firstfile);
		}
			//tempdirentry=curdirentry->firstsub;
	if(curdirentry->firstsub!=NULL)
		{
			filedumpeveryentry(f, curdirentry->firstsub);

		}
	if(curdirentry->next!=NULL)
		{
			filedumpeveryentry(f, curdirentry->next);
		}



}

void filedumpallfileentries(FILE *f, struct fileentry *curfileentry)
{
	if(curfileentry!=NULL)
		{
			if(curfileentry->filename[0]!=NIL)
				{
					fprintf(f,"%s\n", curfileentry->filename);
					if(hash==MD5)
						{
							fwrite(curfileentry->hash, sizeof(unsigned long), 4,f);
						}
					if(hash==SHA1)
						{
							fwrite(curfileentry->hash, sizeof(unsigned long), 5,f);
						}
					if(hash==RMD160)
						{
							fwrite(curfileentry->hash, sizeof(unsigned long), 5,f);
						}
					if(hash==TIGER)
						{
							fwrite(curfileentry->hashbig, sizeof(unsigned long long), 3,f);
						}
				}
		}

	if(curfileentry!=NULL)
		{
			if(curfileentry->next!=NULL)
				{
					filedumpallfileentries(f, curfileentry->next);
				}
		}
}

