/* proccess.c - This file is a part of Floke Integrity
 *      Copyright (C) 2000 Jon Wickmann
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Written by Jon Wickmann <jon.wickmann@excite.com>, 2000.
 * For contact information please see http://www.angelfire.com/wi/wickmann/contact.html
 * Floke Integrity http://www.angelfire.com/wi/wickmann/floke.html
 * Please observe modification guidelines in the documentation
 *
 * History:
 * File last modified 2000.09.14. JWi
 *  */
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include <stdio.h>
#include "flokecore.h"

char basepath[MAX_PATH]; // Global basepath
char searchmarker[]="|";


void proccessfile(char filename[MAX_PATH],char basepath[MAX_PATH])
{
	int i,j;
	unsigned long hashbuffer[5];
	unsigned char pathandfilename[MAX_PATH];



	files++; //Increase the number of scanned files (for the report engine)
	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELFOUR)
		{
			fprintf(errverboseout,"proccessfile File Name %s \n",filename);
		}
	#endif
	i=0;
	for (i=0;i<MAX_PATH;i++)
		{
			memcurfile->filename[i]=filename[i];
		}


	j=0;
	i=0;

			while (basepath[i]!=NIL)
				{
					pathandfilename[i]=basepath[i];
					i++;
				}
			while (filename[j]!=NIL)
				{
					pathandfilename[i]=filename[j];
					j++;
					i++;
				}
			pathandfilename[i]=NIL;



	do_hash(memcurfile,pathandfilename);
	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELFOUR)
		{
			if(hash!=TIGER)
				{
					fprintf(errverboseout,"proccessfile File Name %s \n", memcurfile->filename);
					fprintf(errverboseout,"proccessfile Hash %08x %08x %08x %08x %08x\n",memcurfile->hash[0],memcurfile->hash[1],memcurfile->hash[2],memcurfile->hash[3],memcurfile->hash[4]);
				}

			if(hash==TIGER)
				{
					fprintf(errverboseout,"proccessfile File Name %s \n", memcurfile->filename);
					fprintf(errverboseout,"proccessfile Hash %08x %08x %08x\n",memcurfile->hashbig[0],memcurfile->hashbig[1],memcurfile->hashbig[2]);
				}
		}
	#endif

	//sha_file("c:\\io.dos",hashbuffer);
	//sha_file(pathandfilename,hashbuffer);
/*
	memcurfile->hash[0]=hashbuffer[0];
	memcurfile->hash[1]=hashbuffer[1];
	memcurfile->hash[2]=hashbuffer[2];
	memcurfile->hash[3]=hashbuffer[3];
	memcurfile->hash[4]=hashbuffer[4];

	fprintf(errverboseout,"proccessfile File Name %s \n", memcurfile->filename);
	fprintf(errverboseout,"proccessfile Hash %08x %08x %08x %08x %08x\n",memcurfile->hash[0],memcurfile->hash[1],memcurfile->hash[2],memcurfile->hash[3],memcurfile->hash[4]);
	//fprintf(errverboseout,"From memory at once File Name %s \n", memcurfile->filename);
	*/
	mempriorfile=memcurfile;
	memcurfile=memAllocfile(mempriorfile);
	mempriorfile->next=memcurfile;

}

void proccessdir(char dirname[MAX_PATH])
{
	int i;

	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELFOUR)
		{
			fprintf(errverboseout,"proccessdir Dir Name %s \n",dirname);
		}
	#endif

	for (i=0;i<MAX_PATH;i++)
		{
			memcurdir->dirname[i]=dirname[i];
		}

	mempriordir=memcurdir;
	memcurdir=memAllocdir(mempriordir);
	mempriordir->next=memcurdir;

}

void proccesssearch() //Function should be changed to accept several search patterns like "*.exe|*.com|*.sys ....", options to define digest algorithm and such as well
{
	int i;
	char temppath[MAX_PATH];
	BOOL firstpattern=TRUE;

	//Initial memory allocation
	memstartfile=memAllocfile(NULL);
	memcurfile=memstartfile;
	memstartdir=memAllocdir(NULL);
	memcurdir=memstartdir;
	memcurdir->firstfile=memcurfile;

	//Register first dir
	for (i=0;i<MAX_PATH;i++)
		{
			memcurdir->dirname[i]=startpath[i];
		}

	memcurdir->firstfile=memcurfile;
	//my_findfiles(startpath,searchpattern);
	//my_finddirs(startpath);
	//dumpalldirentries(memstartdir);
	memstartdir->firstfile=memstartfile;
	memstartdir->next=memAllocdir(NULL);

	char tempsearchpattern[SEARCHPATTERNLENGHT];
	unsigned int searchpatterncounter=0;
	int tempsearchpatterncounter=0;

	while(searchpatterncounter<SEARCHPATTERNLENGHT)
		{
			tempsearchpattern[tempsearchpatterncounter]=searchpattern[searchpatterncounter];
			if(tempsearchpattern[tempsearchpatterncounter]==searchmarker[0])
				{
					tempsearchpattern[tempsearchpatterncounter]=NIL;
					if(memcurdir==NULL)
						{
							memcurdir=memAllocdir(NULL);
						}
					mempriordir=memcurdir;
					memcurdir=memAllocdir(mempriordir);
					mempriordir->next=memcurdir;
					memcurdir->next=memAllocdir(memcurdir);
					memcurdir->firstfile=memAllocfile(NULL);
					#ifdef DEBUGHELPERS
					if (verbose>ERRVERBOSELEVELONE)
						{
							fprintf(errverboseout,"proccessearch : tempsearchpattern %s\n",tempsearchpattern);
						}
					#endif
					for (i=0;i<MAX_PATH;i++)
						{
							memcurdir->dirname[i]=startpath[i];
						}
					if(firstpattern==TRUE)
						{
							firstpattern=FALSE;
							memstartdir=memcurdir;
						}
					proccesssearchnext(memcurdir,tempsearchpattern);
					tempsearchpatterncounter=-1;
				}
			tempsearchpatterncounter++;
			searchpatterncounter++;
		}

	//proccesssearchnext(memstartdir,searchpattern);

}

void proccesssearchnext(struct direntry *dir, char searchpattern[SEARCHPATTERNLENGHT])
{
	struct direntry *temp1,*temp2;
	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELFOUR)
				{
					fprintf(errverboseout,"proccesssearchnext Dir Name %s \n",dir->dirname);
				}
	#endif
	if(dir==NULL)
		{
				#ifdef DEBUGHELPERS
				if (verbose>ERRVERBOSELEVELONE)
						{
					fprintf(errverboseout,"proccesssearchnext: input direntry=NULL\n");
						}
				#endif
		}

	if(dir->next==NULL)
		{
				#ifdef DEBUGHELPERS
				if (verbose>ERRVERBOSELEVELONE)
				{
					fprintf(errverboseout,"proccesssearchnext: input direntry->next=NULL\n");
				}
				#endif
		}

	//my_findfiles(dir->dirname,searchpattern);
	//if(dir->next!=NULL)
	//	{
			temp2=dir->next;
			memcurfile=memAllocfile(NULL);
			dir->firstfile=memcurfile;
			memcurdir=memAllocdir(NULL);
			temp2->firstsub=memcurdir;
			//my_findfiles(temp2->dirname,searchpattern);
			if(my_findfiles(dir->dirname,searchpattern)==FALSE) //Added 2000.09.01.
				{
					free(memcurfile);
					dir->firstfile=NULL;
				}
			my_finddirs(dir->dirname);
			temp1=temp2->firstsub;

			if(temp1->dirname[0]!=NIL)
				{
					#ifdef DEBUGHELPERS
					if (verbose>ERRVERBOSELEVELFOUR)
						{
							fprintf(errverboseout,"proccesssearchnext: temp1->dirname[0]!=NIL\n");
						}
					#endif
					proccesssearchnext(temp2->firstsub,searchpattern);
				}
			if(dir->next!=NULL)
				{
					temp1=dir->next;
					if(temp1->dirname[0]!=NIL)
						{
							proccesssearchnext(dir->next,searchpattern);
						}
				}
	//	}

}

BOOL do_hash(struct fileentry *infileentry, unsigned char inpathandfilename[MAX_PATH])
{
	if(hash==SHA1)
		{
			SHA1_CONTEXT *tmp;
			char tmpbuffer[1024];
			fpos_t filesize;
			FILE *tmpfile;
			size_t readsize;

			tmpfile=fopen(inpathandfilename,"rb");
			if(tmpfile==NULL)
				{
					infileentry->status=ACCES_DENIED;  //Set status
					return FALSE;
				}
			//fseek(tmpfile,0, SEEK_END); //ADD err on !0
			//fgetpos(tmpfile, &filesize); //ADD err on !0

			//tmpbuffer=(unsigned char *)malloc(1000*64);
			//fseek(tmpfile,0, SEEK_SET);




			tmp=(SHA1_CONTEXT *)malloc(sizeof(SHA1_CONTEXT));

			sha1_init(tmp);
			//readsize=1;
			unsigned int i=0;
					for(i=0;i==(1024);i++)
						{
							tmpbuffer[i]=0;
						}
			while(readsize=fread(tmpbuffer, sizeof(char),1024, tmpfile))
				{
					//readsize=fread(tmpbuffer, sizeof(unsigned char),1024, tmpfile);
					sha1_write(tmp,tmpbuffer,readsize);
					unsigned int i=0;
					for(i=0;i==(1024);i++)
						{
							tmpbuffer[i]=0;
						}
				}
			sha1_final(tmp);

			/*if(tmp->h0==0xdeadbeef)
				{
					infileentry->status=ACCES_DENIED;  //Set status
					return FALSE;
				}*/
			infileentry->hash[0]=tmp->h0;
			infileentry->hash[1]=tmp->h1;
			infileentry->hash[2]=tmp->h2;
			infileentry->hash[3]=tmp->h3;
			infileentry->hash[4]=tmp->h4;
			free(tmp);

			fclose(tmpfile);


		}
	if(hash==MD5)
		{
			MD5_CONTEXT *tmp;
			char tmpbuffer[1024];
			fpos_t filesize;
			FILE *tmpfile;
			size_t readsize;

			tmpfile=fopen(inpathandfilename,"rb");
			if(tmpfile==NULL)
				{
					infileentry->status=ACCES_DENIED;  //Set status
					return FALSE;
				}
			//fseek(tmpfile,0, SEEK_END); //ADD err on !0
			//fgetpos(tmpfile, &filesize); //ADD err on !0

			//tmpbuffer=(unsigned char *)malloc(1000*64);
			//fseek(tmpfile,0, SEEK_SET);




			tmp=(MD5_CONTEXT *)malloc(sizeof(MD5_CONTEXT));

			md5_init(tmp);
			//readsize=1;
			unsigned int i=0;
					for(i=0;i==(1024);i++)
						{
							tmpbuffer[i]=0;
						}
			while(readsize=fread(tmpbuffer, sizeof(char),1024, tmpfile))
				{
					//readsize=fread(tmpbuffer, sizeof(unsigned char),1024, tmpfile);
					md5_write(tmp,tmpbuffer,readsize);
					unsigned int i=0;
					for(i=0;i==(1024);i++)
						{
							tmpbuffer[i]=0;
						}
				}
			md5_final(tmp);
			//#define rol(n,x)  ( ((x) << (n)) | ((x) >> (32-(n))) )
			//rol(tmp->A,1);
			infileentry->hash[0]=tmp->A;
			infileentry->hash[1]=tmp->B;
			infileentry->hash[2]=tmp->C;
			infileentry->hash[3]=tmp->D;
			//infileentry->hash[4]=tmp->h4;
			free(tmp);

			fclose(tmpfile);


		}
	if(hash==RMD160)
		{
			RMD160_CONTEXT *tmp;
			char tmpbuffer[1024];
			fpos_t filesize;
			FILE *tmpfile;
			size_t readsize;

			tmpfile=fopen(inpathandfilename,"rb");
			if(tmpfile==NULL)
				{
					infileentry->status=ACCES_DENIED;  //Set status
					return FALSE;
				}
			//fseek(tmpfile,0, SEEK_END); //ADD err on !0
			//fgetpos(tmpfile, &filesize); //ADD err on !0

			//tmpbuffer=(unsigned char *)malloc(1000*64);
			//fseek(tmpfile,0, SEEK_SET);




			tmp=(RMD160_CONTEXT *)malloc(sizeof(RMD160_CONTEXT));

			rmd160_init(tmp);
			//readsize=1;
			unsigned int i=0;
					for(i=0;i==(1024);i++)
						{
							tmpbuffer[i]=0;
						}
			while(readsize=fread(tmpbuffer, sizeof(char),1024, tmpfile))
				{
					//readsize=fread(tmpbuffer, sizeof(unsigned char),1024, tmpfile);
					rmd160_write(tmp,tmpbuffer,readsize);
					unsigned int i=0;
					for(i=0;i==(1024);i++)
						{
							tmpbuffer[i]=0;
						}
				}
			rmd160_final(tmp);
			infileentry->hash[0]=tmp->h0;
			infileentry->hash[1]=tmp->h1;
			infileentry->hash[2]=tmp->h2;
			infileentry->hash[3]=tmp->h3;
			infileentry->hash[4]=tmp->h4;
			free(tmp);

			fclose(tmpfile);


		}
#ifdef HAVE_U64_TYPEDEF
	if(hash==TIGER)
		{
			TIGER_CONTEXT *tmp;
			char tmpbuffer[1024];
			fpos_t filesize;
			FILE *tmpfile;
			size_t readsize;

			tmpfile=fopen(inpathandfilename,"rb");
			if(tmpfile==NULL)
				{
					infileentry->status=ACCES_DENIED;  //Set status
					return FALSE;
				}
			//fseek(tmpfile,0, SEEK_END); //ADD err on !0
			//fgetpos(tmpfile, &filesize); //ADD err on !0

			//tmpbuffer=(unsigned char *)malloc(1000*64);
			//fseek(tmpfile,0, SEEK_SET);




			tmp=(TIGER_CONTEXT *)malloc(sizeof(TIGER_CONTEXT));

			tiger_init(tmp);
			//readsize=1;
			unsigned int i=0;
					for(i=0;i==(1024);i++)
						{
							tmpbuffer[i]=0;
						}
			while(readsize=fread(tmpbuffer, sizeof(char),1024, tmpfile))
				{
					//readsize=fread(tmpbuffer, sizeof(unsigned char),1024, tmpfile);
					tiger_write(tmp,tmpbuffer,readsize);
					unsigned int i=0;
					for(i=0;i==(1024);i++)
						{
							tmpbuffer[i]=0;
						}
				}
			tiger_final(tmp);
			/*
			infileentry->hash[0]=tmp->h0;
			infileentry->hash[1]=tmp->h1;
			infileentry->hash[2]=tmp->h2;
			infileentry->hash[3]=tmp->h3;
			infileentry->hash[4]=tmp->h4;
			*/
			infileentry->hashbig[0]=tmp->h0;
			infileentry->hashbig[1]=tmp->h1;
			infileentry->hashbig[2]=tmp->h2;
			free(tmp);

			fclose(tmpfile);


		}
#endif /* HAVE_U64_TYPEDEF */
	return TRUE;
}
