REM     The personal text editor.
REM     Copyright (C) Sandul Yura Valentinovich.
REM     (R) Friday, 25 April 2003 year.
REM
REM     This program is free software; you can redistribute it and/or modify
REM it under the terms of the GNU General Public License as published by the
REM Free Software Foundation; either version 2 of the License, or (at your
REM option) any later version.
REM     This program is distributed in the hope that it will be useful, but
REM WITHOUT ANY WARRANTY; without even the implied warranty of
REM MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
REM Public License for more details.
REM     You should have received a copy of the GNU General Public License
REM along with this program; if not, write to the Free Software Foundation,
REM Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
REM
REM $DYNAMIC
DECLARE SUB ScratchScreen ()
DECLARE SUB DeleteBackSymbol ()
DECLARE SUB InsertLine ()
DECLARE SUB OutBox (Title$, Message$)
DECLARE SUB Control ()
DECLARE SUB Calendar (DayValue%, MonthValue%, YearValue%, Title$, Message$)
DECLARE SUB CursorRight ()
DECLARE SUB CursorUp ()
DECLARE SUB CursorDown ()
DECLARE SUB CursorLeft ()
DECLARE SUB CursorHome ()
DECLARE SUB CursorEnd ()
DECLARE SUB PageUp ()
DECLARE SUB PageDown ()
DECLARE SUB DeleteCurrentSymbol ()
DECLARE SUB MakeWindow (WindowColumn%, WindowRow%, WindowWidth%, WindowHeight%, Title%, Title$, Message%, Message$, Status%, Status$)
DECLARE FUNCTION CalendarBox% (DayValue%, MonthValue%, YearValue%, Title$, Message$)
DECLARE FUNCTION DayName$ (DayNumber%)
DECLARE FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION DaysCount# (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION InputBox% (Title$, Message$, InputLine$)
DECLARE FUNCTION LeapYear% (YearValue%)
DECLARE FUNCTION MenuBox% (ItemsCount%, Items$())
DECLARE FUNCTION MessageBox% (Title$, Message$)
DECLARE FUNCTION MonthDays% (MonthValue%, YearValue%)
DECLARE FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
DECLARE FUNCTION MonthName$ (MonthNumber%)
DECLARE FUNCTION StandartStatus$ ()
OPTION BASE 1
CONST TextLines% = 100
CONST LineLength% = 256
CONST False% = 0
CONST True% = NOT False%
DIM SHARED Text$(TextLines%)
DIM SHARED LinePosition%
DIM SHARED CursorPosition%
DIM SHARED TextPosition%
DIM SHARED PagePosition%
DIM SHARED StatusLine$
DIM SHARED Language%
DIM Key$
DIM English$
DIM Russian$
DIM TextFileName$
DIM PrinterName$
DIM LinesPerPage%
DIM Index%
DIM OldSecond%
DIM WorkLine$
DIM Work%
DIM Work$
DIM WorkDay%
DIM WorkMonth%
DIM WorkYear%
DIM Days%(42)
DIM MenuItems$(16)
SCREEN 0, 1, 0, 0
LinePosition% = 1
CursorPosition% = 1
TextPosition% = 1
PagePosition% = 1
TextFileName$ = "Text.txt"
PrinterName$ = "Prn"
LinesPerPage% = 55
English$ = "`1234567890-=qwertyuiop[]asdfghjkl;'zxcvbnm,./\~!@#$%^&*()_+QWERTYUIOP{}ASDFGHJKL:" + CHR$(34) + "ZXCVBNM<>?|"
Russian$ = "1234567890-=㪥뢠஫ᬨ.\!" + CHR$(34) + ";%:?*()_+,/"
Language% = False%
OldSecond% = VAL(MID$(TIME$, 7, 2))
StatusLine$ = StandartStatus$
CALL ScratchScreen
CALL OutBox("Text editor.", "The personal text editor. (C) Copyright Sandul Yura Valentinovich. (R) Friday, 25 April 2003 year. All rights reserved. This text editor is Public Domain FreeWare. It's based on the GNU General Public License.")
CALL ScratchScreen
DO
 Key$ = ""
 WHILE Key$ = ""
  IF OldSecond% <> VAL(MID$(TIME$, 7, 2)) THEN
   OldSecond% = VAL(MID$(TIME$, 7, 2))
   StatusLine$ = StandartStatus$
   CALL ScratchScreen
  END IF
  Key$ = INKEY$
 WEND
 SELECT CASE LEN(Key$)
 CASE 1
   IF Language% THEN IF INSTR(English$, Key$) > 0 THEN Key$ = MID$(Russian$, INSTR(English$, Key$), 1)
   SELECT CASE Key$
   CASE CHR$(8)
     CALL DeleteBackSymbol
   CASE CHR$(13)
     CALL InsertLine
   CASE CHR$(27)
     MenuItems$(1) = "Save file (" + TextFileName$ + ".)."
     MenuItems$(2) = "Save file as."
     MenuItems$(3) = "Load file."
     MenuItems$(4) = "Print."
     MenuItems$(5) = "Change printer name (current=" + PrinterName$ + ".)."
     MenuItems$(6) = "Change lines per page count for printing (current=" + LTRIM$(STR$(LinesPerPage%)) + ".)."
     MenuItems$(7) = "Find text."
     MenuItems$(8) = "Replace text."
     MenuItems$(9) = "New file."
     MenuItems$(10) = "Change system date."
     MenuItems$(11) = "Change system time."
     MenuItems$(12) = "Reboot computer."
     MenuItems$(13) = "Calendar."
     MenuItems$(14) = "Insert calendar."
     IF Language% THEN MenuItems$(15) = "Change language (current=Russian.)." ELSE MenuItems$(15) = "Change language (current=English.)."
     MenuItems$(16) = "Quit."
     SELECT CASE MenuBox%(16, MenuItems$())
     CASE 1
       StatusLine$ = "Saving file. Please waith..."
       CALL ScratchScreen
       ON ERROR GOTO CannotOpenFileForSave
       OPEN TextFileName$ FOR OUTPUT AS #1
       ON ERROR GOTO 0
       FOR Index% = 1 TO TextLines%
        ON ERROR GOTO CannotWriteToFileForSave
        PRINT #1, Text$(Index%)
        ON ERROR GOTO 0
       NEXT Index%
       CLOSE #1
     CASE 2
       StatusLine$ = "Saving file as other name. Please waith..."
       CALL ScratchScreen
       WorkLine$ = ""
       IF InputBox%("Saving file as other name.", "Please enter new file name.", WorkLine$) THEN
        CALL ScratchScreen
        WorkLine$ = LTRIM$(RTRIM$(WorkLine$))
        WorkLine$ = UCASE$(LEFT$(WorkLine$, 1)) + LCASE$(MID$(WorkLine$, 2))
        IF (WorkLine$ = "") OR (LEN(WorkLine$) > 12) OR (INSTR(WorkLine$, "\") > 0) OR (INSTR(WorkLine$, "/") > 0) OR (INSTR(WorkLine$, "?") > 0) OR (INSTR(WorkLine$, "*") > 0) THEN
         CALL OutBox("Saving file as other name.", "Invalid file name.")
        ELSE
         ON ERROR GOTO CannotOpenFileForSaveAs
         OPEN WorkLine$ FOR OUTPUT AS #1
         ON ERROR GOTO 0
         FOR Index% = 1 TO TextLines%
          ON ERROR GOTO CannotWriteToFileForSaveAs
          PRINT #1, Text$(Index%)
          ON ERROR GOTO 0
         NEXT Index%
         CLOSE #1
         TextFileName$ = WorkLine$
        END IF
       END IF
     CASE 3
       StatusLine$ = "Load file. Please waith..."
       CALL ScratchScreen
       IF MessageBox%("Load file.", "Save current file before load new?") THEN
        StatusLine$ = "Saving file. Please waith..."
        CALL ScratchScreen
        ON ERROR GOTO CannotOpenFileForSave
        OPEN TextFileName$ FOR OUTPUT AS #1
        ON ERROR GOTO 0
        FOR Index% = 1 TO TextLines%
         ON ERROR GOTO CannotWriteToFileForSave
         PRINT #1, Text$(Index%)
         ON ERROR GOTO 0
        NEXT Index%
        CLOSE #1
        StatusLine$ = "Load file. Please waith..."
        CALL ScratchScreen
       END IF
       WorkLine$ = ""
       IF InputBox%("Load file.", "Please enter file name for load it.", WorkLine$) THEN
        CALL ScratchScreen
        WorkLine$ = LTRIM$(RTRIM$(WorkLine$))
        WorkLine$ = UCASE$(LEFT$(WorkLine$, 1)) + LCASE$(MID$(WorkLine$, 2))
        IF (WorkLine$ = "") OR (LEN(WorkLine$) > 12) OR (INSTR(WorkLine$, "\") > 0) OR (INSTR(WorkLine$, "/") > 0) OR (INSTR(WorkLine$, "?") > 0) OR (INSTR(WorkLine$, "*") > 0) THEN
         CALL OutBox("Load file.", "Invalid file name.")
        ELSE
         ON ERROR GOTO CannotOpenFileForLoad
         OPEN WorkLine$ FOR INPUT AS #1
         ON ERROR GOTO 0
         FOR Index% = 1 TO TextLines%
          Text$(Index%) = ""
         NEXT Index%
         Index% = 1
         DO WHILE NOT EOF(1)
          ON ERROR GOTO CannotReadFromFileForLoad
          LINE INPUT #1, Work$
          ON ERROR GOTO 0
          Text$(Index%) = ""
          Work$ = LEFT$(RTRIM$(Work$), LineLength%)
          WHILE Work$ <> ""
           IF ASC(Work$) < ASC(SPACE$(1)) THEN Text$(Index%) = Text$(Index%) + SPACE$(1) ELSE Text$(Index%) = Text$(Index%) + LEFT$(Work$, 1)
           Work$ = MID$(Work$, 2)
          WEND
          Index% = Index% + 1
          IF Index% = TextLines% + 1 THEN
           CALL OutBox("Load file.", "Input file is too big. Loaded first " + LTRIM$(STR$(TextLines%)) + " lines.")
           CALL ScratchScreen
           EXIT DO
          END IF
         LOOP
         CLOSE #1
         TextFileName$ = WorkLine$
         LinePosition% = 1
         CursorPosition% = 1
         TextPosition% = 1
         PagePosition% = 1
        END IF
       END IF
     CASE 4
       StatusLine$ = "Printing text. Please waith..."
       CALL ScratchScreen
       ON ERROR GOTO CannotOpenPrinter
       OPEN PrinterName$ FOR OUTPUT AS #1
       ON ERROR GOTO 0
       CALL OutBox("Print.", "Please insert paper.")
       CALL ScratchScreen
       Work% = 0
       FOR Index% = 1 TO TextLines%
        ON ERROR GOTO CannotWriteToPrinter
        PRINT #1, Text$(Index%)
        ON ERROR GOTO 0
        Work% = Work% + 1
        IF Work% = LinesPerPage% THEN
         ON ERROR GOTO CannotWriteToPrinter
         PRINT #1, CHR$(12)
         ON ERROR GOTO 0
         CALL OutBox("Print.", "Please insert paper.")
         CALL ScratchScreen
         Work% = 0
        END IF
       NEXT Index%
       CLOSE #1
     CASE 5
       StatusLine$ = "Change printer name."
       CALL ScratchScreen
       WorkLine$ = ""
       IF InputBox%("Change printer name.", "Please enter new printer name.", WorkLine$) THEN
        CALL ScratchScreen
        WorkLine$ = LTRIM$(RTRIM$(WorkLine$))
        WorkLine$ = UCASE$(LEFT$(WorkLine$, 1)) + LCASE$(MID$(WorkLine$, 2))
        IF (WorkLine$ = "") OR (LEN(WorkLine$) > 12) OR (INSTR(WorkLine$, "\") > 0) OR (INSTR(WorkLine$, "/") > 0) OR (INSTR(WorkLine$, "?") > 0) OR (INSTR(WorkLine$, "*") > 0) THEN CALL OutBox("Change printer name.", "Invalid printer name.") ELSE PrinterName$ = WorkLine$
       END IF
     CASE 6
       StatusLine$ = "Change lines per page count for printing."
       CALL ScratchScreen
       WorkLine$ = ""
       IF InputBox%("Change lines per page count for printing.", "Please enter new value from 0 to 32767 as count of lines per page.", WorkLine$) THEN
        CALL ScratchScreen
        WorkLine$ = LTRIM$(RTRIM$(UCASE$(WorkLine$)))
        IF (VAL(WorkLine$) < 0) OR (VAL(WorkLine$) > 32767) THEN CALL OutBox("Change printer name.", "Invalid printer name.") ELSE LinesPerPage% = VAL(WorkLine$)
       END IF
     CASE 7
       StatusLine$ = "Find text."
       CALL ScratchScreen
       WorkLine$ = ""
       IF InputBox%("Find text.", "Please enter text line for find it.", WorkLine$) THEN
        CALL ScratchScreen
        FOR Index% = 1 TO TextLines% + 1
         IF Index% = TextLines% + 1 THEN
          CALL OutBox("Find text.", "Text is not found.")
          EXIT FOR
         END IF
         IF INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) > 0 THEN
          LinePosition% = INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))
          CursorPosition% = INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))
          TextPosition% = Index%
          PagePosition% = Index%
          CALL Control
          EXIT FOR
         END IF
        NEXT Index%
       END IF
     CASE 8
       StatusLine$ = "Replace text."
       CALL ScratchScreen
       WorkLine$ = ""
       IF InputBox%("Replace text.", "Please enter text line for find it.", WorkLine$) THEN
        CALL ScratchScreen
        Work$ = ""
        IF InputBox%("Replace text.", "Please enter text line for replace it.", Work$) THEN
         CALL ScratchScreen
         Work% = False%
         FOR Index% = 1 TO TextLines% + 1
          IF Index% = TextLines% + 1 THEN
           CALL OutBox("Replace text.", "Replacement is ended.")
           EXIT FOR
          END IF
          IF INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) > 0 THEN
           IF Work% THEN
            Text$(Index%) = MID$(Text$(Index%), 1, INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))) + Work$ + MID$(Text$(Index%), INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) + LEN(WorkLine$))
           ELSE
            LinePosition% = INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))
            CursorPosition% = INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))
            TextPosition% = Index%
            PagePosition% = Index%
            CALL Control
            StatusLine$ = "Replace this occurence? (Enter=Yes,Tab=Skip,SpaceBar=All,Esc=Cancel."
            CALL ScratchScreen
            DO
             Key$ = INKEY$
            LOOP UNTIL (Key$ = CHR$(13)) OR (Key$ = CHR$(9)) OR (Key$ = SPACE$(1)) OR (Key$ = CHR$(27))
            SELECT CASE Key$
            CASE CHR$(13)
              Text$(Index%) = MID$(Text$(Index%), 1, INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))) + Work$ + MID$(Text$(Index%), INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) + LEN(WorkLine$))
            CASE SPACE$(1)
              Work% = True%
              Text$(Index%) = MID$(Text$(Index%), 1, INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))) + Work$ + MID$(Text$(Index%), INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) + LEN(WorkLine$))
            CASE CHR$(27)
              EXIT FOR
            END SELECT
           END IF
          END IF
         NEXT Index%
        END IF
       END IF
     CASE 9
       StatusLine$ = "New file."
       CALL ScratchScreen
       IF MessageBox%("New file.", "Save file before new?") THEN
        StatusLine$ = "Saving file. Please waith..."
        CALL ScratchScreen
        ON ERROR GOTO CannotOpenFileForSave
        OPEN TextFileName$ FOR OUTPUT AS #1
        ON ERROR GOTO 0
        FOR Index% = 1 TO TextLines%
         ON ERROR GOTO CannotWriteToFileForSave
         PRINT #1, Text$(Index%)
         ON ERROR GOTO 0
        NEXT Index%
        CLOSE #1
       END IF
       StatusLine$ = "New file."
       CALL ScratchScreen
       FOR Index% = 1 TO TextLines%
        Text$(Index%) = ""
       NEXT Index%
       LinePosition% = 1
       CursorPosition% = 1
       TextPosition% = 1
       PagePosition% = 1
     CASE 10
       StatusLine$ = "Change system date."
       CALL ScratchScreen
       WorkDay% = VAL(MID$(DATE$, 4, 2))
       WorkMonth% = VAL(LEFT$(DATE$, 2))
       WorkYear% = VAL(MID$(DATE$, 7, 4))
       IF CalendarBox%(WorkDay%, WorkMonth%, WorkYear%, "Change system date.", "Please select new date.") THEN
        IF (WorkYear% < 1980) OR (WorkYear% > 2099) THEN
         CALL OutBox("Change system date.", "Invalid year.")
        ELSE
         DATE$ = STRING$(2 - LEN(LTRIM$(STR$(WorkMonth%))), "0") + LTRIM$(STR$(WorkMonth%)) + "-" + STRING$(2 - LEN(LTRIM$(STR$(WorkDay%))), "0") + LTRIM$(STR$(WorkDay%)) + "-" + STRING$(4 - LEN(LTRIM$(STR$(WorkYear%))), "0") + LTRIM$(STR$(WorkYear%))
         CALL OutBox("Change system date.", "System date is succefully changed.")
         OldSecond% = NOT VAL(MID$(TIME$, 7, 2))
        END IF
       END IF
     CASE 11
       StatusLine$ = "Change system time."
       CALL ScratchScreen
       WorkLine$ = TIME$
       IF InputBox%("Change system time.", "Please enter new time.", WorkLine$) THEN
        WorkLine$ = LTRIM$(RTRIM$(UCASE$(WorkLine$)))
        IF (WorkLine$ = "") OR (INSTR(WorkLine$, ":") = 0) THEN
         CALL OutBox("Change system time.", "Invalid time line.")
        ELSE
         IF (VAL(RTRIM$(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1))) < 0) OR (VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)) > 23) THEN
          CALL OutBox("Change system time.", "Invalid hour value.")
         ELSE
          Work$ = STRING$(2 - LEN(LTRIM$(STR$(VAL(RTRIM$(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)))))), "0") + LTRIM$(STR$(VAL(RTRIM$(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)))))
          WorkLine$ = LTRIM$(MID$(WorkLine$, INSTR(WorkLine$, ":") + 1))
          IF (WorkLine$ = "") OR (INSTR(WorkLine$, ":") = 0) THEN
           CALL OutBox("Change system time.", "Invalid time line.")
          ELSE
           IF (VAL(RTRIM$(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1))) < 0) OR (VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)) > 59) THEN
            CALL OutBox("Change system time.", "Invalid minute value.")
           ELSE
            Work$ = Work$ + ":" + STRING$(2 - LEN(LTRIM$(STR$(VAL(RTRIM$(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)))))), "0") + LTRIM$(STR$(VAL(RTRIM$(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)))))
            WorkLine$ = LTRIM$(MID$(WorkLine$, INSTR(WorkLine$, ":") + 1))
            IF WorkLine$ = "" THEN
             CALL OutBox("Change system time.", "Invalid time line.")
            ELSE
             IF (VAL(WorkLine$) < 0) OR (VAL(WorkLine$) > 59) THEN
              CALL OutBox("Change system time.", "Invalid second value.")
             ELSE
              Work$ = Work$ + ":" + STRING$(2 - LEN(LTRIM$(STR$(VAL(WorkLine$)))), "0") + LTRIM$(STR$(VAL(WorkLine$)))
              TIME$ = Work$
              CALL OutBox("Change system time.", "System time is succefully changed.")
              OldSecond% = NOT VAL(MID$(TIME$, 7, 2))
             END IF
            END IF
           END IF
          END IF
         END IF
        END IF
       END IF
     CASE 12
       StatusLine$ = "Reboot computer."
       CALL ScratchScreen
       IF MessageBox%("Reboot computer.", "Save file before reboot?") THEN
        StatusLine$ = "Saving file. Please waith..."
        CALL ScratchScreen
        ON ERROR GOTO CannotOpenFileForSave
        OPEN TextFileName$ FOR OUTPUT AS #1
        ON ERROR GOTO 0
        FOR Index% = 1 TO TextLines%
         ON ERROR GOTO CannotWriteToFileForSave
         PRINT #1, Text$(Index%)
         ON ERROR GOTO 0
        NEXT Index%
        CLOSE #1
       END IF
       StatusLine$ = "Rebooting computer."
       CALL ScratchScreen
       COLOR 7, 0
       CLS
       LOCATE 1, 1, 1, 7, 8
       DEF SEG = &HF000
       CALL Absolute(&HFFF0)
     CASE 13
       StatusLine$ = "Calendar."
       CALL ScratchScreen
       CALL Calendar(VAL(MID$(DATE$, 4, 2)), VAL(LEFT$(DATE$, 2)), VAL(MID$(DATE$, 7, 4)), "Calendar.", "")
     CASE 14
       StatusLine$ = "Insert calendar."
       CALL ScratchScreen
       WorkDay% = VAL(MID$(DATE$, 4, 2))
       WorkMonth% = VAL(LEFT$(DATE$, 2))
       WorkYear% = VAL(MID$(DATE$, 7, 4))
       IF CalendarBox%(WorkDay%, WorkMonth%, WorkYear%, "Insert calendar.", "Please select date for the calendar.") THEN
        IF (TextLines% - TextPosition%) < 10 THEN
         CALL OutBox("Insert calendar.", "Current line is too big.")
        ELSE
         CALL ScratchScreen
         Text$(TextPosition%) = MID$(Text$(TextPosition%), 1, LinePosition% - 1) + SPACE$(INT((23 - LEN(MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + ".")) / 2)) + MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + "." + SPACE$(INT((23 - LEN(MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + ".")) / 2)) + MID$(Text$(TextPosition%), LinePosition%)
         IF LEN(Text$(TextPosition% + 1)) < LinePosition% THEN Text$(TextPosition% + 1) = Text$(TextPosition% + 1) + SPACE$(LinePosition% - LEN(Text$(TextPosition% + 1)))
         Text$(TextPosition% + 1) = MID$(Text$(TextPosition% + 1), 1, LinePosition% - 1) + " Mo Tu We Th Fr Sa Su " + MID$(Text$(TextPosition% + 1), LinePosition%)
         FOR Index% = 1 TO 42
          Days%(Index%) = 0
         NEXT Index%
         Work% = 1
         FOR Index% = DayOfWeek%(1, WorkMonth%, WorkYear%) TO 42
          Days%(Index%) = Work%
          Work% = Work% + 1
          IF Work% = MonthDaysCount%(WorkMonth%, WorkYear%) + 1 THEN EXIT FOR
         NEXT Index%
         WorkLine$ = ""
         Work% = 2
         FOR Index% = 1 TO 42
          IF Days%(Index%) = 0 THEN
           WorkLine$ = WorkLine$ + SPACE$(3)
          ELSE
           IF Days%(Index%) = WorkDay% THEN WorkLine$ = WorkLine$ + "*" + STRING$(2 - LEN(LTRIM$(STR$(Days%(Index%)))), ASC(SPACE$(1))) + LTRIM$(STR$(Days%(Index%))) ELSE WorkLine$ = WorkLine$ + SPACE$(1) + STRING$(2 - LEN(LTRIM$(STR$(Days%(Index%)))), ASC(SPACE$(1))) + LTRIM$(STR$(Days%(Index%)))
          END IF
          IF LEN(WorkLine$) = 21 THEN
           IF LEN(Text$(TextPosition% + Work%)) < LinePosition% THEN Text$(TextPosition% + Work%) = Text$(TextPosition% + Work%) + SPACE$(LinePosition% - LEN(Text$(TextPosition% + Work%)))
           Text$(TextPosition% + Work%) = MID$(Text$(TextPosition% + Work%), 1, LinePosition% - 1) + WorkLine$ + SPACE$(1) + MID$(Text$(TextPosition% + Work%), LinePosition%)
           WorkLine$ = ""
           Work% = Work% + 1
          END IF
         NEXT Index%
         IF LEN(Text$(TextPosition% + Work%)) < LinePosition% THEN Text$(TextPosition% + Work%) = Text$(TextPosition% + Work%) + SPACE$(LinePosition% - LEN(Text$(TextPosition% + Work%)))
         Text$(TextPosition% + Work%) = MID$(Text$(TextPosition% + Work%), 1, LinePosition% - 1) + "Current date: " + DayName$(DayOfWeek%(VAL(MID$(DATE$, 4, 2)), VAL(LEFT$(DATE$, 2)), VAL(MID$(DATE$, 7, 4)))) + ", " + LTRIM$(STR$(VAL(MID$(DATE$, 4, 2)))) + SPACE$(1) + MonthName$(VAL(LEFT$(DATE$, 2))) + SPACE$(1) + LTRIM$(STR$(VAL(MID$(DATE$, 7, 4)))) + " year, time: " + TIME$ + "." + MID$(Text$(TextPosition% + Work%), LinePosition%)
        END IF
       END IF
     CASE 15
       Language% = NOT Language%
     CASE 16
       StatusLine$ = "Quit."
       CALL ScratchScreen
       IF MessageBox%("Quit.", "Save file before quit?") THEN
        StatusLine$ = "Saving file. Please waith..."
        CALL ScratchScreen
        ON ERROR GOTO CannotOpenFileForSave
        OPEN TextFileName$ FOR OUTPUT AS #1
        ON ERROR GOTO 0
        FOR Index% = 1 TO TextLines%
         ON ERROR GOTO CannotWriteToFileForSave
         PRINT #1, Text$(Index%)
         ON ERROR GOTO 0
        NEXT Index%
        CLOSE #1
       END IF
       EXIT DO
     END SELECT
     StatusLine$ = StandartStatus$
     CALL ScratchScreen
   CASE ELSE
     IF LinePosition% = LineLength% THEN
      IF TextPosition% < TextLines% THEN
       LinePosition% = 1
       CursorPosition% = 1
       TextPosition% = TextPosition% + 1
       PagePosition% = PagePosition% + 1
       Text$(TextPosition%) = MID$(Text$(TextPosition%), 1, CursorPosition% - 1) + Key$ + MID$(Text$(TextPosition%), CursorPosition%)
       CALL CursorRight
      END IF
     ELSE
      IF LEN(Text$(TextPosition%)) < LineLength% THEN
       Text$(TextPosition%) = MID$(Text$(TextPosition%), 1, CursorPosition% - 1) + Key$ + MID$(Text$(TextPosition%), CursorPosition%)
       CALL CursorRight
      END IF
     END IF
   END SELECT
 CASE 2
   SELECT CASE RIGHT$(Key$, 1)
   CASE CHR$(72)
     CALL CursorUp
   CASE CHR$(80)
     CALL CursorDown
   CASE CHR$(75)
     CALL CursorLeft
   CASE CHR$(77)
     CALL CursorRight
   CASE CHR$(71)
     CALL CursorHome
   CASE CHR$(79)
     CALL CursorEnd
   CASE CHR$(73)
     CALL PageUp
   CASE CHR$(81)
     CALL PageDown
   CASE CHR$(83)
     CALL DeleteCurrentSymbol
   END SELECT
 END SELECT
TextWork:
LOOP
COLOR 7, 0
CLS
LOCATE 1, 1, 1, 7, 8
END
CannotOpenFileForSave:
 IF MessageBox%("Save file.", "Cannot open file for save. Retry opening?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CALL ScratchScreen
  RESUME TextWork
 END IF
CannotWriteToFileForSave:
 IF MessageBox%("Save file.", "Cannot write to file for save. Retry writing?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CLOSE #1
  KILL TextFileName$
  CALL ScratchScreen
  RESUME TextWork
 END IF
CannotOpenFileForSaveAs:
 IF MessageBox%("Saving file as other name.", "Cannot open file for save. Retry opening?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CALL ScratchScreen
  RESUME TextWork
 END IF
CannotWriteToFileForSaveAs:
 IF MessageBox%("Saving file as other name.", "Cannot write to file for save. Retry writing?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CLOSE #1
  KILL WorkLine$
  CALL ScratchScreen
  RESUME TextWork
 END IF
CannotOpenFileForLoad:
 IF MessageBox%("Load file.", "Cannot open file for load. Retry opening?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CALL ScratchScreen
  RESUME TextWork
 END IF
CannotReadFromFileForLoad:
 IF MessageBox%("Load file.", "Cannot read from file for load. Retry reading?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CLOSE #1
  FOR Index% = 1 TO TextLines%
   Text$(Index%) = ""
  NEXT Index%
  CALL ScratchScreen
  RESUME TextWork
 END IF
CannotOpenPrinter:
 IF MessageBox%("Print text.", "Cannot open printer. Retry opening?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CALL ScratchScreen
  RESUME TextWork
 END IF
CannotWriteToPrinter:
 IF MessageBox%("Print text.", "Cannot write to printer. Retry writing?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CLOSE #1
  CALL ScratchScreen
  RESUME TextWork
 END IF

SUB Calendar (DayValue%, MonthValue%, YearValue%, Title$, Message$)
 DIM WorkDay%
 DIM WorkMonth%
 DIM WorkYear%
 DIM Days%(42)
 DIM WorkLine$
 DIM Index%
 DIM Work%
 DIM Key$
 DIM OldSecond%
 WorkDay% = DayValue%
 WorkMonth% = MonthValue%
 WorkYear% = YearValue%
 IF WorkYear% < 0 THEN WorkYear% = 0
 IF WorkMonth% < 1 THEN WorkMonth% = 1
 IF WorkMonth% > 12 THEN WorkMonth% = 12
 IF WorkDay% < 1 THEN WorkDay% = 1
 IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
 CALL MakeWindow(7, 3, 64, 18, True%, Title$, True%, Message$, True%, "ESC=Quit.")
 COLOR 4, 7
 LOCATE 11, 30, 0
 PRINT "Mo Tu We Th Fr Sa Su";
 COLOR 0, 7
 LOCATE 18, 7, 0
 PRINT CHR$(204) + STRING$(64, CHR$(205)) + CHR$(185);
 OldSecond% = NOT VAL(MID$(TIME$, 7, 2))
 GOSUB OutPutCalendar
 DO
  Key$ = ""
  WHILE Key$ = ""
   IF OldSecond% <> VAL(MID$(TIME$, 7, 2)) THEN
    OldSecond% = VAL(MID$(TIME$, 7, 2))
    GOSUB OutPutCalendar
   END IF
   Key$ = INKEY$
  WEND
  SELECT CASE LEN(Key$)
  CASE 1
    IF Key$ = CHR$(27) THEN EXIT DO
  CASE 2
    SELECT CASE RIGHT$(Key$, 1)
    CASE CHR$(72)
      WorkDay% = WorkDay% - 1
      IF WorkDay% < 1 THEN
       WorkMonth% = WorkMonth% - 1
       IF WorkMonth% < 1 THEN
        IF WorkYear% = 0 THEN
         WorkMonth% = 1
         WorkDay% = 1
        ELSE
         WorkYear% = WorkYear% - 1
         WorkMonth% = 12
         WorkDay% = 31
        END IF
       ELSE
        WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
       END IF
      END IF
      GOSUB OutPutCalendar
    CASE CHR$(80)
      WorkDay% = WorkDay% + 1
      IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN
       WorkMonth% = WorkMonth% + 1
       IF WorkMonth% > 12 THEN
        IF WorkYear% = 32767 THEN
         WorkMonth% = 12
         WorkDay% = 31
        ELSE
         WorkYear% = WorkYear% + 1
         WorkMonth% = 1
         WorkDay% = 1
        END IF
       ELSE
        WorkDay% = 1
       END IF
      END IF
      GOSUB OutPutCalendar
    CASE CHR$(75)
      WorkDay% = WorkDay% - 1
      IF WorkDay% < 1 THEN
       WorkMonth% = WorkMonth% - 1
       IF WorkMonth% < 1 THEN
        IF WorkYear% = 0 THEN
         WorkMonth% = 1
         WorkDay% = 1
        ELSE
         WorkYear% = WorkYear% - 1
         WorkMonth% = 12
         WorkDay% = 31
        END IF
       ELSE
        WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
       END IF
      END IF
      GOSUB OutPutCalendar
    CASE CHR$(77)
      WorkDay% = WorkDay% + 1
      IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN
       WorkMonth% = WorkMonth% + 1
       IF WorkMonth% > 12 THEN
        IF WorkYear% = 32767 THEN
         WorkMonth% = 12
         WorkDay% = 31
        ELSE
         WorkYear% = WorkYear% + 1
         WorkMonth% = 1
         WorkDay% = 1
        END IF
       ELSE
        WorkDay% = 1
       END IF
      END IF
      GOSUB OutPutCalendar
    CASE CHR$(73)
      WorkMonth% = WorkMonth% - 1
      IF WorkMonth% < 1 THEN
       IF WorkYear% = 0 THEN
        WorkMonth% = 1
       ELSE
        WorkYear% = WorkYear% - 1
        WorkMonth% = 12
       END IF
      ELSE
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutPutCalendar
    CASE CHR$(81)
      WorkMonth% = WorkMonth% + 1
      IF WorkMonth% > 12 THEN
       IF WorkYear% = 32767 THEN
        WorkMonth% = 12
       ELSE
        WorkYear% = WorkYear% + 1
        WorkMonth% = 1
       END IF
      ELSE
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutPutCalendar
    CASE CHR$(71)
      IF WorkYear% > 0 THEN
       WorkYear% = WorkYear% - 1
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutPutCalendar
    CASE CHR$(79)
      IF WorkYear% < 32767 THEN
       WorkYear% = WorkYear% + 1
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutPutCalendar
    END SELECT
  END SELECT
 LOOP
 LOCATE 6, 8, 0
 COLOR 0, 7
 EXIT SUB
OutPutCalendar:
 LOCATE 10, 8, 0
 COLOR 7, 7
 PRINT STRING$(64, CHR$(0));
 LOCATE 10, 8, 0
 COLOR 2, 7
 PRINT STRING$(INT((64 - LEN(MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + ".")) / 2), CHR$(0)) + MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + ".";
 COLOR 1, 7
 FOR Index% = 1 TO 42
  Days%(Index%) = 0
 NEXT Index%
 Work% = 1
 FOR Index% = DayOfWeek%(1, WorkMonth%, WorkYear%) TO 42
  Days%(Index%) = Work%
  Work% = Work% + 1
  IF Work% = MonthDaysCount%(WorkMonth%, WorkYear%) + 1 THEN EXIT FOR
 NEXT Index%
 WorkLine$ = ""
 Work% = 1
 FOR Index% = 1 TO 42
  IF Days%(Index%) = 0 THEN
   WorkLine$ = WorkLine$ + SPACE$(3)
  ELSE
   IF Days%(Index%) = WorkDay% THEN WorkLine$ = WorkLine$ + "*" + STRING$(2 - LEN(LTRIM$(STR$(Days%(Index%)))), ASC(SPACE$(1))) + LTRIM$(STR$(Days%(Index%))) ELSE WorkLine$ = WorkLine$ + SPACE$(1) + STRING$(2 - LEN(LTRIM$(STR$(Days%(Index%)))), ASC(SPACE$(1))) + LTRIM$(STR$(Days%(Index%)))
  END IF
  IF LEN(WorkLine$) = 21 THEN
   LOCATE 11 + Work%, 29, 0
   COLOR 7, 7
   PRINT STRING$(21, CHR$(0));
   COLOR 1, 7
   LOCATE 11 + Work%, 29, 0
   WHILE WorkLine$ <> ""
    SELECT CASE LEFT$(WorkLine$, 1)
    CASE "*"
      COLOR 14, 6
      PRINT SPACE$(1) + MID$(WorkLine$, 2, 3);
      COLOR 1, 7
      WorkLine$ = MID$(WorkLine$, 5)
    CASE ELSE
      PRINT LEFT$(WorkLine$, 1);
      WorkLine$ = MID$(WorkLine$, 2)
    END SELECT
   WEND
   PRINT WorkLine$;
   WorkLine$ = ""
   Work% = Work% + 1
  END IF
 NEXT Index%
 LOCATE 19, 8, 0
 COLOR 7, 7
 PRINT STRING$(64, CHR$(0));
 LOCATE 19, 8, 0
 COLOR 4, 7
 PRINT "Current date: " + DayName$(DayOfWeek%(VAL(MID$(DATE$, 4, 2)), VAL(LEFT$(DATE$, 2)), VAL(MID$(DATE$, 7, 4)))) + ", " + LTRIM$(STR$(VAL(MID$(DATE$, 4, 2)))) + SPACE$(1) + MonthName$(VAL(LEFT$(DATE$, 2))) + SPACE$(1) + LTRIM$(STR$(VAL(MID$(DATE$, 7, 4)))) + " year, time: " + TIME$ + ".";
 RETURN
END SUB

FUNCTION CalendarBox% (DayValue%, MonthValue%, YearValue%, Title$, Message$)
 DIM WorkDay%
 DIM WorkMonth%
 DIM WorkYear%
 DIM Days%(42)
 DIM WorkLine$
 DIM Index%
 DIM Work%
 DIM Key$
 DIM OldSecond%
 WorkDay% = DayValue%
 WorkMonth% = MonthValue%
 WorkYear% = YearValue%
 IF WorkYear% < 0 THEN WorkYear% = 0
 IF WorkMonth% < 1 THEN WorkMonth% = 1
 IF WorkMonth% > 12 THEN WorkMonth% = 12
 IF WorkDay% < 1 THEN WorkDay% = 1
 IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
 CALL MakeWindow(7, 3, 64, 18, True%, Title$, True%, Message$, True%, "ENTER=Yes, ESC=No.")
 COLOR 4, 7
 LOCATE 11, 30, 0
 PRINT "Mo Tu We Th Fr Sa Su";
 COLOR 0, 7
 LOCATE 18, 7, 0
 PRINT CHR$(204) + STRING$(64, CHR$(205)) + CHR$(185);
 OldSecond% = NOT VAL(MID$(TIME$, 7, 2))
 GOSUB OutCalendar
 DO
  Key$ = ""
  WHILE Key$ = ""
   IF OldSecond% <> VAL(MID$(TIME$, 7, 2)) THEN
    OldSecond% = VAL(MID$(TIME$, 7, 2))
    GOSUB OutCalendar
   END IF
   Key$ = INKEY$
  WEND
  SELECT CASE LEN(Key$)
  CASE 1
    SELECT CASE Key$
    CASE CHR$(13)
      DayValue% = WorkDay%
      MonthValue% = WorkMonth%
      YearValue% = WorkYear%
      CalendarBox% = True%
      EXIT DO
    CASE CHR$(27)
      CalendarBox% = False%
      EXIT DO
    END SELECT
  CASE 2
    SELECT CASE RIGHT$(Key$, 1)
    CASE CHR$(72)
      WorkDay% = WorkDay% - 1
      IF WorkDay% < 1 THEN
       WorkMonth% = WorkMonth% - 1
       IF WorkMonth% < 1 THEN
        IF WorkYear% = 0 THEN
         WorkMonth% = 1
         WorkDay% = 1
        ELSE
         WorkYear% = WorkYear% - 1
         WorkMonth% = 12
         WorkDay% = 31
        END IF
       ELSE
        WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(80)
      WorkDay% = WorkDay% + 1
      IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN
       WorkMonth% = WorkMonth% + 1
       IF WorkMonth% > 12 THEN
        IF WorkYear% = 32767 THEN
         WorkMonth% = 12
         WorkDay% = 31
        ELSE
         WorkYear% = WorkYear% + 1
         WorkMonth% = 1
         WorkDay% = 1
        END IF
       ELSE
        WorkDay% = 1
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(75)
      WorkDay% = WorkDay% - 1
      IF WorkDay% < 1 THEN
       WorkMonth% = WorkMonth% - 1
       IF WorkMonth% < 1 THEN
        IF WorkYear% = 0 THEN
         WorkMonth% = 1
         WorkDay% = 1
        ELSE
         WorkYear% = WorkYear% - 1
         WorkMonth% = 12
         WorkDay% = 31
        END IF
       ELSE
        WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(77)
      WorkDay% = WorkDay% + 1
      IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN
       WorkMonth% = WorkMonth% + 1
       IF WorkMonth% > 12 THEN
        IF WorkYear% = 32767 THEN
         WorkMonth% = 12
         WorkDay% = 31
        ELSE
         WorkYear% = WorkYear% + 1
         WorkMonth% = 1
         WorkDay% = 1
        END IF
       ELSE
        WorkDay% = 1
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(73)
      WorkMonth% = WorkMonth% - 1
      IF WorkMonth% < 1 THEN
       IF WorkYear% = 0 THEN
        WorkMonth% = 1
       ELSE
        WorkYear% = WorkYear% - 1
        WorkMonth% = 12
       END IF
      ELSE
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutCalendar
    CASE CHR$(81)
      WorkMonth% = WorkMonth% + 1
      IF WorkMonth% > 12 THEN
       IF WorkYear% = 32767 THEN
        WorkMonth% = 12
       ELSE
        WorkYear% = WorkYear% + 1
        WorkMonth% = 1
       END IF
      ELSE
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutCalendar
    CASE CHR$(71)
      IF WorkYear% > 0 THEN
       WorkYear% = WorkYear% - 1
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutCalendar
    CASE CHR$(79)
      IF WorkYear% < 32767 THEN
       WorkYear% = WorkYear% + 1
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutCalendar
    END SELECT
  END SELECT
 LOOP
 LOCATE 6, 8, 0
 COLOR 0, 7
 EXIT FUNCTION
OutCalendar:
 LOCATE 10, 8, 0
 COLOR 7, 7
 PRINT STRING$(64, CHR$(0));
 LOCATE 10, 8, 0
 COLOR 2, 7
 PRINT STRING$(INT((64 - LEN(MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + ".")) / 2), CHR$(0)) + MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + ".";
 COLOR 1, 7
 FOR Index% = 1 TO 42
  Days%(Index%) = 0
 NEXT Index%
 Work% = 1
 FOR Index% = DayOfWeek%(1, WorkMonth%, WorkYear%) TO 42
  Days%(Index%) = Work%
  Work% = Work% + 1
  IF Work% = MonthDaysCount%(WorkMonth%, WorkYear%) + 1 THEN EXIT FOR
 NEXT Index%
 WorkLine$ = ""
 Work% = 1
 FOR Index% = 1 TO 42
  IF Days%(Index%) = 0 THEN
   WorkLine$ = WorkLine$ + SPACE$(3)
  ELSE
   IF Days%(Index%) = WorkDay% THEN WorkLine$ = WorkLine$ + "*" + STRING$(2 - LEN(LTRIM$(STR$(Days%(Index%)))), ASC(SPACE$(1))) + LTRIM$(STR$(Days%(Index%))) ELSE WorkLine$ = WorkLine$ + SPACE$(1) + STRING$(2 - LEN(LTRIM$(STR$(Days%(Index%)))), ASC(SPACE$(1))) + LTRIM$(STR$(Days%(Index%)))
  END IF
  IF LEN(WorkLine$) = 21 THEN
   LOCATE 11 + Work%, 29, 0
   COLOR 7, 7
   PRINT STRING$(21, CHR$(0));
   COLOR 1, 7
   LOCATE 11 + Work%, 29, 0
   WHILE WorkLine$ <> ""
    SELECT CASE LEFT$(WorkLine$, 1)
    CASE "*"
      COLOR 14, 6
      PRINT SPACE$(1) + MID$(WorkLine$, 2, 3);
      COLOR 1, 7
      WorkLine$ = MID$(WorkLine$, 5)
    CASE ELSE
      PRINT LEFT$(WorkLine$, 1);
      WorkLine$ = MID$(WorkLine$, 2)
    END SELECT
   WEND
   PRINT WorkLine$;
   WorkLine$ = ""
   Work% = Work% + 1
  END IF
 NEXT Index%
 LOCATE 19, 8, 0
 COLOR 7, 7
 PRINT STRING$(64, CHR$(0));
 LOCATE 19, 8, 0
 COLOR 4, 7
 PRINT "Current date: " + DayName$(DayOfWeek%(VAL(MID$(DATE$, 4, 2)), VAL(LEFT$(DATE$, 2)), VAL(MID$(DATE$, 7, 4)))) + ", " + LTRIM$(STR$(VAL(MID$(DATE$, 4, 2)))) + SPACE$(1) + MonthName$(VAL(LEFT$(DATE$, 2))) + SPACE$(1) + LTRIM$(STR$(VAL(MID$(DATE$, 7, 4)))) + " year, time: " + TIME$ + ".";
 RETURN
END FUNCTION

SUB Control
 IF TextPosition% < 1 THEN TextPosition% = 1
 IF PagePosition% < 1 THEN PagePosition% = 1
 IF LinePosition% < 1 THEN LinePosition% = 1
 IF CursorPosition% < 1 THEN CursorPosition% = 1
 IF TextPosition% > TextLines% THEN TextPosition% = TextLines%
 IF PagePosition% > 20 THEN PagePosition% = 20
 IF LinePosition% > LEN(Text$(TextPosition%)) + 1 THEN LinePosition% = LEN(Text$(TextPosition%)) + 1
 IF LEN(Text$(TextPosition%)) < 78 THEN IF CursorPosition% > LEN(Text$(TextPosition%)) + 1 THEN CursorPosition% = LEN(Text$(TextPosition%)) + 1
 IF LEN(Text$(TextPosition%)) > 76 THEN IF CursorPosition% > 77 THEN CursorPosition% = 77
 CALL ScratchScreen
END SUB

SUB CursorDown
 TextPosition% = TextPosition% + 1
 PagePosition% = PagePosition% + 1
 CALL Control
END SUB

SUB CursorEnd
 LinePosition% = LEN(Text$(TextPosition%)) + 1
 CursorPosition% = LEN(Text$(TextPosition%)) + 1
 CALL Control
END SUB

SUB CursorHome
 LinePosition% = 1
 CursorPosition% = 1
 CALL ScratchScreen
END SUB

SUB CursorLeft
 IF LinePosition% = 1 THEN
  IF TextPosition% = 1 THEN EXIT SUB
  TextPosition% = TextPosition% - 1
  PagePosition% = PagePosition% - 1
  LinePosition% = LEN(Text$(TextPosition%)) + 1
  CursorPosition% = LEN(Text$(TextPosition%)) + 1
 ELSE
  LinePosition% = LinePosition% - 1
  CursorPosition% = CursorPosition% - 1
 END IF
 CALL Control
END SUB

SUB CursorRight
 IF LinePosition% = LEN(Text$(TextPosition%)) + 1 THEN
  IF TextPosition% > TextLines% - 1 THEN EXIT SUB
  TextPosition% = TextPosition% + 1
  PagePosition% = PagePosition% + 1
  LinePosition% = 1
  CursorPosition% = 1
 ELSE
  LinePosition% = LinePosition% + 1
  CursorPosition% = CursorPosition% + 1
 END IF
 CALL Control
END SUB

SUB CursorUp
 TextPosition% = TextPosition% - 1
 PagePosition% = PagePosition% - 1
 CALL Control
END SUB

FUNCTION DayName$ (DayNumber%)
 SELECT CASE DayNumber%
 CASE 1
   DayName$ = "Monday"
 CASE 2
   DayName$ = "Tuesday"
 CASE 3
   DayName$ = "Wednesday"
 CASE 4
   DayName$ = "Thursday"
 CASE 5
   DayName$ = "Friday"
 CASE 6
   DayName$ = "Saturday"
 CASE 7
   DayName$ = "Sunday"
 END SELECT
END FUNCTION

FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
 SELECT CASE DaysCount#(DayValue%, MonthValue%, YearValue%) - (INT(DaysCount#(DayValue%, MonthValue%, YearValue%) / 7) * 7)
 CASE 0
   DayOfWeek% = 6
 CASE 1
   DayOfWeek% = 7
 CASE 2
   DayOfWeek% = 1
 CASE 3
   DayOfWeek% = 2
 CASE 4
   DayOfWeek% = 3
 CASE 5
   DayOfWeek% = 4
 CASE 6
   DayOfWeek% = 5
 END SELECT
END FUNCTION

FUNCTION DaysCount# (DayValue%, MonthValue%, YearValue%)
 DaysCount# = MonthDays%(MonthValue%, YearValue%) + (YearValue% * 365!) + INT(YearValue% / 4) + INT(YearValue% / 100) + DayValue%
END FUNCTION

SUB DeleteBackSymbol
 DIM Length%
 DIM Index%
 IF LinePosition% = 1 THEN
  IF TextPosition% = 1 THEN EXIT SUB
  IF LEN(Text$(TextPosition%)) = LineLength% THEN EXIT SUB
  Length% = LEN(Text$(TextPosition% - 1))
  Text$(TextPosition% - 1) = Text$(TextPosition% - 1) + LEFT$(Text$(TextPosition%), LineLength% - LEN(Text$(TextPosition% - 1)))
  Text$(TextPosition%) = MID$(Text$(TextPosition%), LineLength% - Length%)
  IF Text$(TextPosition%) = "" THEN
   FOR Index% = TextPosition% TO TextLines% - 1
    Text$(Index%) = Text$(Index% + 1)
    Text$(Index% + 1) = ""
   NEXT Index%
  END IF
  TextPosition% = TextPosition% - 1
  PagePosition% = PagePosition% - 1
  LinePosition% = Length% + 1
  CursorPosition% = Length% + 1
  CALL Control
 ELSE
  LinePosition% = LinePosition% - 1
  CursorPosition% = CursorPosition% - 1
  Text$(TextPosition%) = MID$(Text$(TextPosition%), 1, LinePosition% - 1) + MID$(Text$(TextPosition%), LinePosition% + 1)
  CALL ScratchScreen
 END IF
END SUB

SUB DeleteCurrentSymbol
 DIM Length%
 DIM Index%
 IF LinePosition% = LEN(Text$(TextPosition%)) + 1 THEN
  IF TextPosition% > TextLines% - 1 THEN EXIT SUB
  IF LEN(Text$(TextPosition%)) = LineLength% THEN EXIT SUB
  Length% = LEN(Text$(TextPosition%))
  Text$(TextPosition%) = Text$(TextPosition%) + LEFT$(Text$(TextPosition% + 1), LineLength% - LEN(Text$(TextPosition%)))
  Text$(TextPosition% + 1) = MID$(Text$(TextPosition% + 1), LineLength% - Length%)
  IF Text$(TextPosition% + 1) = "" THEN
   FOR Index% = TextPosition% + 1 TO TextLines% - 1
    Text$(Index%) = Text$(Index% + 1)
    Text$(Index% + 1) = ""
   NEXT Index%
  END IF
 ELSE
  Text$(TextPosition%) = MID$(Text$(TextPosition%), 1, LinePosition% - 1) + MID$(Text$(TextPosition%), LinePosition% + 1)
 END IF
 CALL ScratchScreen
END SUB

FUNCTION InputBox% (Title$, Message$, InputLine$)
 DIM Key$
 DIM WorkLine$
 DIM InputLinePosition%
 DIM InputCursorPosition%
 CALL MakeWindow(7, 7, 64, 9, True%, Title$, True%, Message$, True%, "ENTER=Yes, ESC=No.")
 InputLinePosition% = 1
 InputCursorPosition% = 1
 WorkLine$ = LEFT$(InputLine$, 256)
 GOSUB OutInputLine
 DO
  Key$ = INKEY$
  SELECT CASE LEN(Key$)
  CASE 1
    SELECT CASE Key$
    CASE CHR$(8)
      IF InputLinePosition% > 1 THEN
       InputLinePosition% = InputLinePosition% - 1
       InputCursorPosition% = InputCursorPosition% - 1
       IF InputLinePosition% < 1 THEN InputLinePosition% = 1
       IF InputCursorPosition% < 1 THEN InputCursorPosition% = 1
       WorkLine$ = MID$(WorkLine$, 1, InputLinePosition% - 1) + MID$(WorkLine$, InputLinePosition% + 1)
       GOSUB OutInputLine
      END IF
    CASE CHR$(13)
      InputBox% = True%
      InputLine$ = WorkLine$
      EXIT DO
    CASE CHR$(27)
      InputBox% = False%
      EXIT DO
    CASE ELSE
      IF LEN(WorkLine$) < 256 THEN
       WorkLine$ = MID$(WorkLine$, 1, InputLinePosition% - 1) + Key$ + MID$(WorkLine$, InputLinePosition%)
       InputLinePosition% = InputLinePosition% + 1
       InputCursorPosition% = InputCursorPosition% + 1
       IF InputLinePosition% > LEN(WorkLine$) + 1 THEN InputLinePosition% = LEN(WorkLine$) + 1
       IF LEN(WorkLine$) < 65 THEN IF InputCursorPosition% > LEN(WorkLine$) + 1 THEN InputCursorPosition% = LEN(WorkLine$) + 1
       IF LEN(WorkLine$) > 63 THEN IF InputCursorPosition% > 64 THEN InputCursorPosition% = 64
       GOSUB OutInputLine
      END IF
    END SELECT
  CASE 2
    SELECT CASE RIGHT$(Key$, 1)
    CASE CHR$(75)
      IF InputLinePosition% <> 1 THEN
       InputLinePosition% = InputLinePosition% - 1
       InputCursorPosition% = InputCursorPosition% - 1
       IF InputLinePosition% < 1 THEN InputLinePosition% = 1
       IF InputCursorPosition% < 1 THEN InputCursorPosition% = 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(77)
      IF InputLinePosition% < LEN(WorkLine$) + 1 THEN
       InputLinePosition% = InputLinePosition% + 1
       InputCursorPosition% = InputCursorPosition% + 1
       IF InputLinePosition% > LEN(WorkLine$) + 1 THEN InputLinePosition% = LEN(WorkLine$) + 1
       IF LEN(WorkLine$) < 65 THEN IF InputCursorPosition% > LEN(WorkLine$) + 1 THEN InputCursorPosition% = LEN(WorkLine$) + 1
       IF LEN(WorkLine$) > 63 THEN IF InputCursorPosition% > 64 THEN InputCursorPosition% = 64
       GOSUB OutInputLine
      END IF
    CASE CHR$(71)
      IF InputLinePosition% <> 1 THEN
       InputLinePosition% = 1
       InputCursorPosition% = 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(79)
      IF InputLinePosition% < LEN(WorkLine$) + 1 THEN
       InputLinePosition% = LEN(WorkLine$) + 1
       InputCursorPosition% = LEN(WorkLine$) + 1
       IF LEN(WorkLine$) < 65 THEN IF InputCursorPosition% > LEN(WorkLine$) + 1 THEN InputCursorPosition% = LEN(WorkLine$) + 1
       IF LEN(WorkLine$) > 63 THEN IF InputCursorPosition% > 64 THEN InputCursorPosition% = 64
       GOSUB OutInputLine
      END IF
    CASE CHR$(83)
      IF WorkLine$ <> "" THEN
       WorkLine$ = MID$(WorkLine$, 1, InputLinePosition% - 1) + MID$(WorkLine$, InputLinePosition% + 1)
       GOSUB OutInputLine
      END IF
    END SELECT
  END SELECT
 LOOP
 COLOR 0, 7
 LOCATE 8, 8, 0
 EXIT FUNCTION
OutInputLine:
 LOCATE 14, 8, 0
 COLOR 15, 3
 PRINT STRING$(64, CHR$(0));
 LOCATE 14, 8, 0
 PRINT MID$(WorkLine$, (InputLinePosition% - InputCursorPosition%) + 1, 64);
 LOCATE 14, 8 + (InputCursorPosition% - 1), 1, 7, 8
 RETURN
END FUNCTION

SUB InsertLine
 DIM Index%
 IF (Text$(TextLines%) <> "") OR (TextPosition% > TextLines% - 1) THEN EXIT SUB
 FOR Index% = TextLines% - 1 TO TextPosition% + 1 STEP -1
  Text$(Index% + 1) = Text$(Index%)
  Text$(Index%) = ""
 NEXT Index%
 Text$(TextPosition% + 1) = MID$(Text$(TextPosition%), LinePosition%)
 Text$(TextPosition%) = MID$(Text$(TextPosition%), 1, LinePosition% - 1)
 LinePosition% = 1
 CursorPosition% = 1
 TextPosition% = TextPosition% + 1
 PagePosition% = PagePosition% + 1
 CALL ScratchScreen
END SUB

FUNCTION LeapYear% (YearValue%)
 LeapYear% = ABS((INT(YearValue% / 4) * 4) = YearValue%)
END FUNCTION

SUB MakeWindow (WindowColumn%, WindowRow%, WindowWidth%, WindowHeight%, Title%, Title$, Message%, Message$, Status%, Status$)
 DIM Index%
 DIM Msg$
 IF (WindowColumn% < 1) OR (WindowRow% < 1) OR (WindowWidth% < 1) OR (WindowHeight% < 1) OR (WindowWidth% > 77) OR (WindowHeight% > 22) OR (WindowWidth% + (WindowColumn% - 1) > 80) OR (WindowHeight% + (WindowRow% - 1) > 25) THEN EXIT SUB
 COLOR 0, 7
 LOCATE WindowRow%, WindowColumn%, 0
 PRINT CHR$(201) + STRING$(WindowWidth%, CHR$(205)) + CHR$(187);
 FOR Index% = 1 TO WindowHeight%
  LOCATE WindowRow% + Index%, WindowColumn%, 0
  PRINT CHR$(186) + STRING$(WindowWidth%, CHR$(0)) + CHR$(186);
  COLOR 0, 0
  PRINT CHR$(0);
  COLOR 0, 7
 NEXT Index%
 LOCATE WindowRow% + (WindowHeight% + 1), WindowColumn%, 0
 PRINT CHR$(200) + STRING$(WindowWidth%, CHR$(205)) + CHR$(188);
 COLOR 0, 0
 PRINT CHR$(0);
 COLOR 0, 7
 LOCATE WindowRow% + (WindowHeight% + 2), WindowColumn% + 1, 0
 COLOR 0, 0
 PRINT STRING$(WindowWidth% + 2, CHR$(0));
 IF Title% THEN
  COLOR 0, 7
  LOCATE WindowRow% + 1, WindowColumn% + 1, 0
  COLOR 4, 7
  PRINT STRING$(INT((WindowWidth% - LEN(LEFT$(Title$, WindowWidth%))) / 2), CHR$(0)) + LEFT$(Title$, WindowWidth%);
  LOCATE WindowRow% + 2, WindowColumn%, 0
  COLOR 0, 7
  PRINT CHR$(204) + STRING$(WindowWidth%, CHR$(205)) + CHR$(185);
 END IF
 IF Message% THEN
  IF Title% THEN Index% = WindowRow% + 3 ELSE Index% = WindowRow% + 1
  Msg$ = LEFT$(Message$, 256)
  COLOR 1, 7
  DO WHILE Msg$ <> ""
   LOCATE Index%, WindowColumn% + 1, 0
   PRINT LEFT$(Msg$, WindowWidth%);
   Msg$ = MID$(Msg$, WindowWidth% + 1)
   Index% = Index% + 1
  LOOP
 END IF
 IF Status% THEN
  COLOR 0, 7
  LOCATE WindowRow% + (WindowHeight% - 1), WindowColumn%, 0
  PRINT CHR$(204) + STRING$(WindowWidth%, CHR$(205)) + CHR$(185);
  LOCATE WindowRow% + WindowHeight%, WindowColumn% + 1, 0
  COLOR 2, 7
  PRINT STRING$(INT((WindowWidth% - LEN(LEFT$(Status$, WindowWidth%))) / 2), CHR$(0)) + LEFT$(Status$, WindowWidth%);
 END IF
 COLOR 0, 7
 LOCATE WindowRow% + 3, WindowColumn% + 1, 0
END SUB

FUNCTION MenuBox% (ItemsCount%, Items$())
 DIM Index%
 DIM Length%
 DIM CurrentItem%
 DIM Key$
 IF (ItemsCount% < 1) OR (ItemsCount% > UBOUND(Items$)) OR (ItemsCount% > 20) THEN
  MenuBox% = -1
  EXIT FUNCTION
 END IF
 Length% = 0
 FOR Index% = 1 TO ItemsCount%
  IF LEN(Items$(Index%)) > Length% THEN Length% = LEN(Items$(Index%))
 NEXT Index%
 IF Length% < 23 THEN Length% = 23
 IF Length% > 70 THEN Length% = 70
 CALL MakeWindow(INT((80 - (Length% + 10)) / 2) + 1, INT((25 - (ItemsCount% + 5)) / 2) + 1, Length% + 7, ItemsCount% + 2, False%, "", False%, "", True%, "ENTER=Select item, ESC=Cancel.")
 CurrentItem% = 1
 GOSUB OutMenu
 DO
  Key$ = INKEY$
  SELECT CASE LEN(Key$)
  CASE 1
    SELECT CASE UCASE$(Key$)
    CASE CHR$(13)
      MenuBox% = CurrentItem%
      EXIT DO
    CASE CHR$(27)
      MenuBox% = 0
      EXIT DO
    CASE "A" TO CHR$(ASC("A") + (ItemsCount% - 1))
      IF CurrentItem% <> (ASC(UCASE$(Key$)) - ASC("A")) + 1 THEN
       CurrentItem% = (ASC(UCASE$(Key$)) - ASC("A")) + 1
       GOSUB OutMenu
      END IF
    END SELECT
  CASE 2
    SELECT CASE RIGHT$(Key$, 1)
    CASE CHR$(72)
      IF CurrentItem% <> 1 THEN
       CurrentItem% = CurrentItem% - 1
       GOSUB OutMenu
      END IF
    CASE CHR$(80)
      IF CurrentItem% <> ItemsCount% THEN
       CurrentItem% = CurrentItem% + 1
       GOSUB OutMenu
      END IF
    END SELECT
  END SELECT
 LOOP
 LOCATE INT((25 - (ItemsCount% + 2)) / 2) + 1, INT((80 - (Length% + 7)) / 2) + 1, 0
 COLOR 0, 7
 EXIT FUNCTION
OutMenu:
 FOR Index% = 1 TO ItemsCount%
  LOCATE INT((25 - (ItemsCount% + 5)) / 2) + Index% + 1, INT((80 - (Length% + 10)) / 2) + 2, 0
  COLOR 4, 7
  PRINT STRING$(2 - LEN(LTRIM$(STR$(Index%))), "0") + LTRIM$(STR$(Index%));
  COLOR 14, 7
  PRINT "#";
  COLOR 1, 7
  PRINT "(";
  COLOR 15, 7
  PRINT CHR$(ASC("A") + (Index% - 1));
  COLOR 1, 7
  PRINT ")";
  COLOR 2, 7
  PRINT "=";
  IF Index% = CurrentItem% THEN COLOR 14, 1 ELSE COLOR 1, 7
  PRINT LEFT$(Items$(Index%), Length%) + STRING$(Length% - LEN(LEFT$(Items$(Index%), Length%)), CHR$(0));
 NEXT Index%
 RETURN
END FUNCTION

FUNCTION MessageBox% (Title$, Message$)
 DIM Key$
 CALL MakeWindow(7, 8, 64, 8, True%, Title$, True%, Message$, True%, "ENTER=Yes, ESC=No.")
 DO
  Key$ = INKEY$
 LOOP UNTIL (Key$ = CHR$(13)) OR (Key$ = CHR$(27))
 MessageBox% = Key$ = CHR$(13)
END FUNCTION

FUNCTION MonthDays% (MonthValue%, YearValue%)
 SELECT CASE MonthValue%
 CASE 1
   MonthDays% = 0
 CASE 2
   MonthDays% = 31
 CASE 3
   MonthDays% = 59 + LeapYear%(YearValue%)
 CASE 4
   MonthDays% = 90 + LeapYear%(YearValue%)
 CASE 5
   MonthDays% = 120 + LeapYear%(YearValue%)
 CASE 6
   MonthDays% = 151 + LeapYear%(YearValue%)
 CASE 7
   MonthDays% = 181 + LeapYear%(YearValue%)
 CASE 8
   MonthDays% = 212 + LeapYear%(YearValue%)
 CASE 9
   MonthDays% = 243 + LeapYear%(YearValue%)
 CASE 10
   MonthDays% = 273 + LeapYear%(YearValue%)
 CASE 11
   MonthDays% = 304 + LeapYear%(YearValue%)
 CASE 12
   MonthDays% = 334 + LeapYear%(YearValue%)
 END SELECT
END FUNCTION

FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
 SELECT CASE MonthValue%
 CASE 1
   MonthDaysCount% = 31
 CASE 2
   MonthDaysCount% = 28 + LeapYear%(YearValue%)
 CASE 3
   MonthDaysCount% = 31
 CASE 4
   MonthDaysCount% = 30
 CASE 5
   MonthDaysCount% = 31
 CASE 6
   MonthDaysCount% = 30
 CASE 7
   MonthDaysCount% = 31
 CASE 8
   MonthDaysCount% = 31
 CASE 9
   MonthDaysCount% = 30
 CASE 10
   MonthDaysCount% = 31
 CASE 11
   MonthDaysCount% = 30
 CASE 12
   MonthDaysCount% = 31
 END SELECT
END FUNCTION

FUNCTION MonthName$ (MonthNumber%)
 SELECT CASE MonthNumber%
 CASE 1
   MonthName$ = "January"
 CASE 2
   MonthName$ = "February"
 CASE 3
   MonthName$ = "March"
 CASE 4
   MonthName$ = "April"
 CASE 5
   MonthName$ = "May"
 CASE 6
   MonthName$ = "June"
 CASE 7
   MonthName$ = "July"
 CASE 8
   MonthName$ = "August"
 CASE 9
   MonthName$ = "September"
 CASE 10
   MonthName$ = "October"
 CASE 11
   MonthName$ = "November"
 CASE 12
   MonthName$ = "December"
 END SELECT
END FUNCTION

SUB OutBox (Title$, Message$)
 CALL MakeWindow(7, 8, 64, 8, True%, Title$, True%, Message$, True%, "Press the Enter key to quit.")
 WHILE INKEY$ <> CHR$(13)
 WEND
END SUB

SUB PageDown
 TextPosition% = TextPosition% + 20
 PagePosition% = PagePosition% + 20
 CALL Control
END SUB

SUB PageUp
 TextPosition% = TextPosition% - 20
 PagePosition% = PagePosition% - 20
 CALL Control
END SUB

SUB ScratchScreen
 DIM Index%
 COLOR 0, 2
 CLS
 COLOR 0, 7
 LOCATE 1, 1, 0
 PRINT CHR$(201) + STRING$(77, CHR$(205)) + CHR$(187);
 FOR Index% = 2 TO 21
  LOCATE Index%, 1, 0
  PRINT CHR$(186) + STRING$(77, CHR$(0)) + CHR$(186) + CHR$(219);
  COLOR 1, 7
  LOCATE Index%, 2, 0
  PRINT MID$(Text$((TextPosition% - PagePosition%) + (Index% - 1)), (LinePosition% - CursorPosition%) + 1, 77);
  COLOR 0, 7
 NEXT Index%
 LOCATE 22, 1, 0
 PRINT CHR$(200) + STRING$(77, CHR$(205)) + CHR$(188) + CHR$(219);
 LOCATE 23, 2, 0
 PRINT STRING$(79, CHR$(219));
 LOCATE 25, 2, 0
 COLOR 15, 4
 PRINT STRING$(78, CHR$(0));
 LOCATE 25, 2, 0
 PRINT LEFT$(StatusLine$, 78);
 COLOR 1, 7
 LOCATE PagePosition% + 1, CursorPosition% + 1, 1, 7, 8
END SUB

FUNCTION StandartStatus$
 DIM WorkLine$
 WorkLine$ = "ESC=Menu. Row=" + LTRIM$(STR$(TextPosition%)) + ". Column=" + LTRIM$(STR$(LinePosition%)) + ". Date: "
 SELECT CASE DayOfWeek%(VAL(MID$(DATE$, 4, 2)), VAL(LEFT$(DATE$, 2)), VAL(MID$(DATE$, 7, 4)))
 CASE 1
   WorkLine$ = WorkLine$ + "Mon"
 CASE 2
   WorkLine$ = WorkLine$ + "Tue"
 CASE 3
   WorkLine$ = WorkLine$ + "Wed"
 CASE 4
   WorkLine$ = WorkLine$ + "Thu"
 CASE 5
   WorkLine$ = WorkLine$ + "Fri"
 CASE 6
   WorkLine$ = WorkLine$ + "Sat"
 CASE 7
   WorkLine$ = WorkLine$ + "Sun"
 END SELECT
 WorkLine$ = WorkLine$ + ", " + LTRIM$(STR$(VAL(MID$(DATE$, 4, 2)))) + " "
 SELECT CASE VAL(LEFT$(DATE$, 2))
 CASE 1
   WorkLine$ = WorkLine$ + "Jan"
 CASE 2
   WorkLine$ = WorkLine$ + "Feb"
 CASE 3
   WorkLine$ = WorkLine$ + "Mar"
 CASE 4
   WorkLine$ = WorkLine$ + "Apr"
 CASE 5
   WorkLine$ = WorkLine$ + "May"
 CASE 6
   WorkLine$ = WorkLine$ + "Jun"
 CASE 7
   WorkLine$ = WorkLine$ + "Jul"
 CASE 8
   WorkLine$ = WorkLine$ + "Aug"
 CASE 9
   WorkLine$ = WorkLine$ + "Sep"
 CASE 10
   WorkLine$ = WorkLine$ + "Oct"
 CASE 11
   WorkLine$ = WorkLine$ + "Nov"
 CASE 12
   WorkLine$ = WorkLine$ + "Dec"
 END SELECT
 WorkLine$ = WorkLine$ + " " + LTRIM$(STR$(VAL(MID$(DATE$, 7, 4)))) + " year, time: " + TIME$ + "."
 IF Language% THEN StandartStatus$ = WorkLine$ + SPACE$(1) + "RU" ELSE StandartStatus$ = WorkLine$ + SPACE$(1) + "EN"
END FUNCTION

