VERSION 5.00
Object = "{9F3DA521-3D24-11D2-BB47-0060978DAE40}#1.2#0"; "cimage.dll"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmDiveLog 
   Caption         =   "Dive Log"
   ClientHeight    =   6780
   ClientLeft      =   60
   ClientTop       =   630
   ClientWidth     =   9840
   Icon            =   "frmDiveLog.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6780
   ScaleWidth      =   9840
   StartUpPosition =   2  'CenterScreen
   Begin VB.PictureBox Picture1 
      Height          =   495
      Left            =   7200
      ScaleHeight     =   435
      ScaleWidth      =   1155
      TabIndex        =   47
      Top             =   6120
      Visible         =   0   'False
      Width           =   1215
   End
   Begin VB.CommandButton cmdOpenMemo 
      Caption         =   "Open Memo"
      Height          =   375
      Left            =   7440
      TabIndex        =   44
      Top             =   570
      Width           =   1695
   End
   Begin VB.CommandButton cmdLinkToPictures 
      Caption         =   "Go"
      Height          =   375
      Left            =   9240
      TabIndex        =   43
      Top             =   120
      Width           =   495
   End
   Begin VB.TextBox txtLinkToPictures 
      DataField       =   "Link to Pictures"
      DataSource      =   "diveLogData"
      Height          =   315
      Left            =   7440
      TabIndex        =   41
      Top             =   180
      Width           =   1695
   End
   Begin MSComDlg.CommonDialog dlgCommonDialog 
      Left            =   5880
      Top             =   6000
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.TextBox txtDepth 
      DataField       =   "Depth"
      DataSource      =   "diveLogData"
      Height          =   315
      Left            =   4320
      TabIndex        =   12
      Top             =   180
      Width           =   1335
   End
   Begin VB.TextBox txtTime 
      DataField       =   "Time (TBT)"
      DataSource      =   "diveLogData"
      Height          =   315
      Left            =   4320
      TabIndex        =   13
      Top             =   600
      Width           =   1335
   End
   Begin VB.TextBox txtSurfaceInterval 
      DataField       =   "Surface interval"
      DataSource      =   "diveLogData"
      Height          =   315
      Left            =   4320
      TabIndex        =   14
      Top             =   1080
      Width           =   1335
   End
   Begin VB.CommandButton cmdDeleteRecord 
      Caption         =   "Del."
      Height          =   375
      Left            =   3240
      TabIndex        =   20
      ToolTipText     =   "Delete current record"
      Top             =   6120
      Width           =   495
   End
   Begin VB.CommandButton cmdMoveLast 
      Caption         =   ">>"
      Height          =   375
      Left            =   2280
      TabIndex        =   19
      ToolTipText     =   "Move to the last record"
      Top             =   6120
      Width           =   495
   End
   Begin VB.CommandButton cmdMoveForward 
      Caption         =   ">"
      Height          =   375
      Left            =   1680
      TabIndex        =   18
      ToolTipText     =   "Move to the next record"
      Top             =   6120
      Width           =   495
   End
   Begin VB.CommandButton cmdMoveBack 
      Caption         =   "<"
      Height          =   375
      Left            =   840
      TabIndex        =   17
      ToolTipText     =   "Move to previous record"
      Top             =   6120
      Width           =   495
   End
   Begin VB.CommandButton cmdMoveFirst 
      Caption         =   "<<"
      Height          =   375
      Left            =   240
      TabIndex        =   16
      ToolTipText     =   "Move to first record"
      Top             =   6120
      Width           =   495
   End
   Begin VB.ComboBox cmbCurrent 
      DataField       =   "Current"
      DataSource      =   "diveLogData"
      Height          =   315
      ItemData        =   "frmDiveLog.frx":030A
      Left            =   1320
      List            =   "frmDiveLog.frx":0314
      TabIndex        =   11
      Top             =   5160
      Width           =   1335
   End
   Begin VB.ComboBox cmbSurf 
      DataField       =   "Surf"
      DataSource      =   "diveLogData"
      Height          =   315
      ItemData        =   "frmDiveLog.frx":0324
      Left            =   1320
      List            =   "frmDiveLog.frx":0331
      TabIndex        =   10
      Top             =   4800
      Width           =   1335
   End
   Begin VB.ComboBox cmbSurface 
      DataField       =   "Surface"
      DataSource      =   "diveLogData"
      Height          =   315
      ItemData        =   "frmDiveLog.frx":034B
      Left            =   1320
      List            =   "frmDiveLog.frx":0358
      TabIndex        =   9
      Top             =   4440
      Width           =   1335
   End
   Begin VB.TextBox txtWaterTemperature 
      DataField       =   "Water Temperature"
      DataSource      =   "diveLogData"
      Height          =   315
      Left            =   1320
      TabIndex        =   8
      Top             =   4080
      Width           =   1335
   End
   Begin VB.ComboBox cmbWater 
      DataField       =   "Water"
      DataSource      =   "diveLogData"
      Height          =   315
      ItemData        =   "frmDiveLog.frx":0371
      Left            =   1320
      List            =   "frmDiveLog.frx":037B
      TabIndex        =   7
      Top             =   3720
      Width           =   1335
   End
   Begin VB.TextBox txtOutsideTemperature 
      DataField       =   "Outside Temperature"
      DataSource      =   "diveLogData"
      Height          =   315
      Left            =   1320
      TabIndex        =   6
      Top             =   3120
      Width           =   1335
   End
   Begin VB.ComboBox cmbWeather 
      DataField       =   "Weather"
      DataSource      =   "diveLogData"
      Height          =   315
      ItemData        =   "frmDiveLog.frx":038C
      Left            =   1320
      List            =   "frmDiveLog.frx":0399
      TabIndex        =   5
      Top             =   2760
      Width           =   1335
   End
   Begin VB.TextBox txtLocation 
      DataField       =   "Location"
      DataSource      =   "diveLogData"
      Height          =   315
      Left            =   1320
      TabIndex        =   4
      Top             =   2040
      Width           =   1335
   End
   Begin VB.TextBox txtSiteName 
      DataField       =   "Site Name"
      DataSource      =   "diveLogData"
      Height          =   315
      Left            =   1320
      TabIndex        =   3
      Top             =   1680
      Width           =   1335
   End
   Begin VB.TextBox txtDiveBuddy 
      DataField       =   "Dive Buddy"
      DataSource      =   "diveLogData"
      Height          =   315
      Left            =   1320
      TabIndex        =   2
      Top             =   1320
      Width           =   1335
   End
   Begin VB.TextBox txtDate 
      DataField       =   "Date"
      DataSource      =   "diveLogData"
      Height          =   315
      Left            =   1320
      TabIndex        =   1
      Top             =   600
      Width           =   1335
   End
   Begin VB.TextBox txtDiveNumber 
      DataField       =   "Dive Number"
      DataSource      =   "diveLogData"
      Height          =   315
      Left            =   1320
      TabIndex        =   0
      Top             =   180
      Width           =   1335
   End
   Begin VB.Data diveLogData 
      Caption         =   "Dive Log"
      Connect         =   "Access"
      DatabaseName    =   ""
      DefaultCursorType=   0  'DefaultCursor
      DefaultType     =   2  'UseODBC
      Exclusive       =   0   'False
      Height          =   345
      Left            =   4200
      Options         =   0
      ReadOnly        =   0   'False
      RecordsetType   =   1  'Dynaset
      RecordSource    =   "Dive Log Fields Table"
      Top             =   6000
      Visible         =   0   'False
      Width           =   1455
   End
   Begin CIMAGELibCtl.CopyImag CopyImag1 
      Left            =   6720
      OleObjectBlob   =   "frmDiveLog.frx":03B3
      Top             =   6120
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Dive Number"
      Height          =   255
      Index           =   0
      Left            =   120
      TabIndex        =   46
      Top             =   240
      Width           =   975
   End
   Begin VB.OLE OLE1 
      Class           =   "MSGraph.Chart.8"
      DataField       =   "Dive Proffile"
      DataSource      =   "diveLogData"
      Height          =   3675
      Left            =   3120
      SizeMode        =   1  'Stretch
      TabIndex        =   15
      Top             =   2160
      Width           =   6075
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Open Memo"
      Height          =   255
      Index           =   17
      Left            =   6240
      TabIndex        =   45
      Top             =   630
      Width           =   1095
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Link to Pictures"
      Height          =   255
      Index           =   16
      Left            =   6240
      TabIndex        =   42
      Top             =   240
      Width           =   1095
   End
   Begin VB.Label lblWaterTemp 
      BackStyle       =   0  'Transparent
      Caption         =   "C"
      Height          =   255
      Left            =   2760
      TabIndex        =   40
      Top             =   4110
      Width           =   255
   End
   Begin VB.Label lblOutsideTemp 
      BackStyle       =   0  'Transparent
      Caption         =   "C"
      Height          =   255
      Left            =   2760
      TabIndex        =   39
      Top             =   3150
      Width           =   255
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Min"
      Height          =   255
      Index           =   19
      Left            =   5760
      TabIndex        =   38
      Top             =   1110
      Width           =   255
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Min"
      Height          =   255
      Index           =   18
      Left            =   5760
      TabIndex        =   37
      Top             =   630
      Width           =   255
   End
   Begin VB.Label lblDepth 
      BackStyle       =   0  'Transparent
      Caption         =   "M"
      Height          =   255
      Left            =   5760
      TabIndex        =   36
      Top             =   240
      Width           =   255
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Depth"
      Height          =   255
      Index           =   12
      Left            =   3120
      TabIndex        =   35
      Top             =   240
      Width           =   975
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Time (TBT)"
      Height          =   255
      Index           =   13
      Left            =   3120
      TabIndex        =   34
      Top             =   600
      Width           =   975
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Surface Int. (before)"
      Height          =   495
      Index           =   14
      Left            =   3120
      TabIndex        =   33
      Top             =   990
      Width           =   1095
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Dive Profile"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Index           =   15
      Left            =   3120
      TabIndex        =   32
      Top             =   1800
      Width           =   1455
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Current"
      Height          =   255
      Index           =   11
      Left            =   120
      TabIndex        =   31
      Top             =   5190
      Width           =   975
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Surf"
      Height          =   255
      Index           =   10
      Left            =   120
      TabIndex        =   30
      Top             =   4830
      Width           =   975
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Surface"
      Height          =   255
      Index           =   9
      Left            =   120
      TabIndex        =   29
      Top             =   4470
      Width           =   975
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Water Temp."
      Height          =   255
      Index           =   8
      Left            =   120
      TabIndex        =   28
      Top             =   4110
      Width           =   1095
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Water"
      Height          =   255
      Index           =   7
      Left            =   120
      TabIndex        =   27
      Top             =   3750
      Width           =   975
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Outside Temp."
      Height          =   255
      Index           =   6
      Left            =   120
      TabIndex        =   26
      Top             =   3150
      Width           =   1095
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Weather"
      Height          =   255
      Index           =   5
      Left            =   120
      TabIndex        =   25
      Top             =   2790
      Width           =   975
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Location"
      Height          =   255
      Index           =   4
      Left            =   120
      TabIndex        =   24
      Top             =   2070
      Width           =   975
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Site Name"
      Height          =   255
      Index           =   3
      Left            =   120
      TabIndex        =   23
      Top             =   1710
      Width           =   975
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Dive Buddy"
      Height          =   255
      Index           =   2
      Left            =   120
      TabIndex        =   22
      Top             =   1350
      Width           =   975
   End
   Begin VB.Label Label 
      BackStyle       =   0  'Transparent
      Caption         =   "Date"
      DataSource      =   "diveLogData"
      Height          =   255
      Index           =   1
      Left            =   120
      TabIndex        =   21
      Top             =   600
      Width           =   615
   End
   Begin VB.Menu FieMenu 
      Caption         =   "&File"
      Index           =   1
      Begin VB.Menu mnuOpenFile 
         Caption         =   "&Open"
         Index           =   2
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuSaveFile 
         Caption         =   "&Save"
         Index           =   3
         Shortcut        =   ^S
      End
   End
   Begin VB.Menu mnuTools 
      Caption         =   "&Tools"
      Index           =   4
      Begin VB.Menu mnuGenerateHTML 
         Caption         =   "&Generate HTML"
         Index           =   5
      End
   End
   Begin VB.Menu SetupMenu 
      Caption         =   "Setu&p"
      Index           =   6
      Begin VB.Menu mnuSetupUnits 
         Caption         =   "&Units"
         Index           =   7
      End
      Begin VB.Menu mnuSetupBackground 
         Caption         =   "&Background"
         Index           =   8
      End
      Begin VB.Menu mnuSetupTextColor 
         Caption         =   "Text &color"
         Index           =   9
      End
      Begin VB.Menu mnuSetupHTMLPath 
         Caption         =   "&HTML Path"
         Index           =   10
      End
   End
   Begin VB.Menu mnuAbout 
      Caption         =   "&About"
      Index           =   10
   End
   Begin VB.Menu mnuExit 
      Caption         =   "E&xit"
      Index           =   11
   End
End
Attribute VB_Name = "frmDiveLog"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim DiveNumber As Integer
Dim DiveLogChart As Chart
Dim strDiveLogDatabase As String
Dim strBackgroundName As String
Const DefaultFileName = "\dive_log.mdb"
Dim metric As Boolean   'this is true if the units are metric
Public HTMLPath As String  'this is the path to the place where the HTML is generated

Private Sub cmdDeleteRecord_Click()
'    On Error Resume Next
    With diveLogData
        If Not (.Recordset.EOF Or .Recordset.BOF) Then .Recordset.Delete  'Delete current record
        .Recordset.MovePrevious
'        If .Recordset.BOF Then
'            MsgBox "EOF"
'            AddNewDive
'        End If
    End With
End Sub

Private Sub oldcmdDeleteRecord_Click()
    On Error Resume Next
    With diveLogData
        .Recordset.Delete 'Delete current record
        If Not .Recordset.EOF Then
            .Recordset.MoveNext
            If .Recordset.EOF Then .Recordset.MovePrevious
        ElseIf Not .Recordset.BOF Then
            .Recordset.MovePrevious
        Else
            MsgBox "EOF"
            AddNewDive
        End If
    End With
End Sub

Private Sub cmdLinkToPictures_Click()
    OpenFile ("http://" + txtLinkToPictures.Text)
End Sub

Private Sub cmdMoveBack_Click()
    On Error Resume Next
    With diveLogData
        .Recordset.MovePrevious
        If .Recordset.BOF Then .Recordset.MoveFirst
    End With
End Sub

Private Sub cmdMoveFirst_Click()
    On Error Resume Next
    diveLogData.Recordset.MoveFirst
End Sub

Private Sub cmdMoveForward_Click()
    With diveLogData
   If Not .Recordset.EOF Then .Recordset.MoveNext
        If .Recordset.EOF Then
            AddNewDive
        End If
    End With
End Sub
Sub AddNewDive()
    Dim mygraph As Object
  '  On Error Resume Next
    With diveLogData
        .Recordset.AddNew       'create a new record
        
        'auto number it
         txtDiveNumber.Text = .Recordset.RecordCount + 1
        'date it to the today date
        txtDate.Text = Date
        
        'fill the object with a real graph
        OLE1.Class = "MSGraph.Chart.8"    'this is set in bound frame's property
        OLE1.Action = CreateEmbed
        OLE1.Verb = vbOLEShow
        OLE1.Action = DoVerb
        
        'put an empty string in the memo field
        .Recordset.Fields("Memo") = ""
        .Recordset.Update
        .Recordset.MovePrevious
                        
    End With
End Sub

Private Sub cmdMoveLast_Click()
    diveLogData.Recordset.MoveLast
End Sub

Private Sub cmdOpenMemo_Click()
    If Len(diveLogData.Recordset.Fields("Memo")) <> 0 Then
        frmMemo.txtMemo.Text = diveLogData.Recordset.Fields("Memo")
    Else
        frmMemo.txtMemo.Text = ""
    End If
    frmMemo.Show vbModal
End Sub

Private Sub Form_Load()
Dim FileName As String

On Error GoTo Error
'read the default for the file name and open the database
RegReadValue "HKLM", "Software\DiveLog", "DiveLogFileName", "S", _
            App.Path + DefaultFileName, FileName
diveLogData.DatabaseName = FileName
diveLogData.Refresh

'read the metric variable to see if the units should be displayed in metric
RegReadValue "HKLM", "Software\DiveLog", "metric", "B", _
            True, metric
'see what to display on the form
If metric Then
    frmDiveLog.lblDepth.Caption = "M"
    frmDiveLog.lblOutsideTemp.Caption = "C"
    frmDiveLog.lblWaterTemp.Caption = "C"
Else
    frmDiveLog.lblDepth.Caption = "Ft"
    frmDiveLog.lblOutsideTemp.Caption = "F"
    frmDiveLog.lblWaterTemp.Caption = "F"
End If

'load the Background picture from disk.
RegReadValue "HKLM", "Software\DiveLog", "Background", "S", _
            App.Path + "\school of fish.jpg", strBackgroundName

frmDiveLog.Picture = LoadPicture(strBackgroundName)

'change the labels color to the registry savd color
RegReadValue "HKLM", "Software\DiveLog", "Color", "S", QBColor(0), Color
ChangeAllLabelColor (CLng(Color))

'restore the HTMLPath from the registry
RegReadValue "HKLM", "Software\DiveLog", "HTMLPath", "S", App.Path + "\Dive Log Web\", HTMLPath

Exit Sub

Error:
    If Err.Number = 3044 Then
        Call mnuOpenFile_Click(2)       'call open database menu
    ElseIf Err.Number = 76 Then
        Call mnuSetupBackground_Click(8)      'call the set background picture menu
    End If
        
End Sub



Private Sub mnuAbout_Click(Index As Integer)
frmAbout.txtAbout.Text = "Name of the application: Dive log " + vbCrLf + _
    "Date: July 2000" + vbCrLf + _
    "Version: 0.1" + vbCrLf + _
    "Author: Vlad Pambucol (vlad.pambucol@usa.net)" + vbCrLf + vbCrLf + _
    "Description: This program is an alternative to the old fashion way of " + _
    "recording your dives. The program save its inputs in an Access database " + _
    "so you can browse this database with the database browser of your choice" + _
    vbCrLf + vbCrLf + _
    "Usage: open your database from the File menu and put your dive data in. " + _
    "Double click on the Dive Profile box to manually enter your dive profile. " + _
    "Use the '<' '>' '<<' '>>' buttons to get to the previous/next/first/last " + _
    "record in the database. If you don't know to operate those buttons you " + _
    "don't deserve to use this program." + vbCrLf + vbCrLf + _
    "Copyrights: None of that crap. Take the program, use it, enjoy it, " + _
    "send me comments and suggestions. That's all." + vbCrLf + vbCrLf + _
    "Dive safe and have fun"
frmAbout.Show vbModal

End Sub

Private Sub mnuExit_Click(Index As Integer)
    'unload all forms and exit the program
    diveLogData.Refresh
    Unload frmDiveLog
End Sub

Private Sub mnuGenerateHTML_Click(Index As Integer)
    Dim sText As String
    Dim Result As String
    Dim DiveProfilePicture As Variant
    'first open the file dive_log_web_page.htm
    nfilenum = FreeFile
    Open App.Path + "\Dive Log Web\dive_log_web_page.htm" For Input As nfilenum
    sText = Input(LOF(nfilenum), nfilenum)
    Close
    With diveLogData.Recordset
        Result = SearchAndReplace(sText, "<!--DiveNumber-->", Str(.Fields("Dive Number")))
        Result = SearchAndReplace(Result, "<!--Date-->", Str(.Fields("Date")))
        Result = SearchAndReplace(Result, "<!--DiveBuddy-->", .Fields("Dive Buddy"))
        Result = SearchAndReplace(Result, "<!--SiteName-->", .Fields("Site Name"))
        Result = SearchAndReplace(Result, "<!--Location-->", .Fields("Location"))
        Result = SearchAndReplace(Result, "<!--Weather-->", .Fields("Weather"))
        Result = SearchAndReplace(Result, "<!--OutsideTemperature-->", Str(.Fields("Outside Temperature")))
        Result = SearchAndReplace(Result, "<!--Water-->", .Fields("Water"))
        Result = SearchAndReplace(Result, "<!--WaterTemperature-->", Str(.Fields("Water Temperature")))
        Result = SearchAndReplace(Result, "<!--Surface-->", .Fields("Surface"))
        Result = SearchAndReplace(Result, "<!--Surf-->", .Fields("Surf"))
        Result = SearchAndReplace(Result, "<!--Current-->", .Fields("Current"))
        Result = SearchAndReplace(Result, "<!--Depth-->", Str(.Fields("Depth")))
        Result = SearchAndReplace(Result, "<!--Time-->", Str(.Fields("Time (TBT)")))
        Result = SearchAndReplace(Result, "<!--SurfaceInterval-->", Str(.Fields("Surface Interval")))
        Result = SearchAndReplace(Result, "<!--LinkToPictures-->", _
                "<a HREF=""http://" + .Fields("Link To Pictures") + """>" _
                + .Fields("Link To Pictures") + "</a>")
        Result = SearchAndReplace(Result, "<!--Memo-->", .Fields("Memo"))
    End With
    
    'save the dive profile as a picture
    'activate the graph
    OLE1.DoVerb vbOLEShow
    OLE1.Copy
    'deactivate the graph
    OLE1.DoVerb vbOLEHide
    'set focus somwhere else
    txtDiveNumber.SetFocus
    Picture1.Picture = Clipboard.GetData
    'SavePicture Picture1.Picture, "d:\temp\graphdata.wmf"
    
    Picture1.ScaleMode = 3      'set scale to pixels
  
    CopyImag1.Type = 1          'set the type to GIF
    'create the image name
    ImageName = HTMLPath + "dive_profile_" + _
                Str(diveLogData.Recordset.Fields("Dive Number")) + ".gif"
    
    'if the file exist then kill it first
    If Dir(ImageName) <> "" Then
        Kill ImageName
    End If
        
    'write the file
    CopyImag1.CopyPicture Picture1.Picture, ImageName, 500, 400
    'replace the image coment with the image name
    Result = SearchAndReplace(Result, "<!--DiveProfile-->", _
    "<img src=""dive_profile_" _
        + Str(diveLogData.Recordset.Fields("Dive Number")) + ".gif"">")
         
    'Insert the date when the file was generated.
    Result = SearchAndReplace(Result, "<!--TodayDate-->", Str(Date))
    
    'Save the result of the replacement in a file
    nfilenum = FreeFile
    Open HTMLPath + "dive_log_web_page_" + _
                Str(diveLogData.Recordset.Fields("Dive Number")) + _
                ".htm" For Output As nfilenum
    
    Print #1, Result
    Close #1
        
    'now copy the aditional files needed for the HTML (background picture & title)
    If Dir(HTMLPath + "dive_log_web_background.gif") = "" Then
        FileCopy App.Path + "\Dive Log Web\dive_log_web_background.gif", _
            HTMLPath + "dive_log_web_background.gif"
        FileCopy App.Path + "\Dive Log Web\dive_log_web_title.gif", _
            HTMLPath + "dive_log_web_title.gif"
    End If
    
End Sub

Function SearchAndReplace(WhereToReplace, WhatToReplace, WithWhatToReplace) As String
    'this function search the string WhatToReplace in the string WhereToREplace and replace it with What to
    ' replace. The function return the new string with the replacement made
    Dim strReturn As String
    Dim Position As Integer
    
    If IsNull(WithWhatToReplace) Then
        WithWhatToReplace = " "
    End If
    
    Position = InStr(1, WhereToReplace, WhatToReplace, vbTextCompare)
    'put everything until the find string in the strReturn
    strReturn = Left(WhereToReplace, Position - 1)
    'now add WithWhatToReplace
    strReturn = strReturn + WithWhatToReplace
    'now add everything after the found string
    strReturn = strReturn + Mid(WhereToReplace, Position + Len(WhatToReplace))
    'now return the result
    SearchAndReplace = strReturn
End Function

Private Sub mnuOpenFile_Click(Index As Integer)
    dlgCommonDialog.DialogTitle = "Open Dive Log Database"
    dlgCommonDialog.Filter = "Database files (*.mdb)|*.mdb|All Files (*.*)|*.*"
    dlgCommonDialog.ShowOpen
    
    'get the name from the dialog
    diveLogData.DatabaseName = dlgCommonDialog.FileName
    'save the file name in the registry for future use
    RegWriteValue "HKLM", "Software\DiveLog", "DiveLogFileName", "S", diveLogData.DatabaseName
    'open the database
    diveLogData.Refresh
End Sub

Private Sub mnuSaveFile_Click(Index As Integer)
    
    'show the Save as dialog
    dlgCommonDialog.ShowSave
    
    'close the database to be able to save it
    diveLogData.Database.Close
    
    'copy the database in the new file
    FileCopy diveLogData.DatabaseName, dlgCommonDialog.FileName
    
    'continue to work in the database with the new name.
    diveLogData.DatabaseName = dlgCommonDialog.FileName
    
    'open the database
    diveLogData.Refresh
        
End Sub

Private Sub mnuSetupBackground_Click(Index As Integer)
    dlgCommonDialog.DialogTitle = "Open Background Picture"
    dlgCommonDialog.Filter = "Jpg files (*.jpg)|*.jpg|Bmp files (*.bmp)|*.bmp|Gif files (*.gif)|*.gif|All files (*.*)|*.*"
    dlgCommonDialog.ShowOpen
    'get the name from the dialog
    frmDiveLog.Picture = LoadPicture(dlgCommonDialog.FileName)
    'now save the file name in the registry
    strBackgroundName = dlgCommonDialog.FileName
    RegWriteValue "HKLM", "Software\DiveLog", "Background", "S", strBackgroundName
End Sub

Private Sub mnuSetupHTMLPath_Click(Index As Integer)
    frmGetPath.Visible = True
End Sub

Private Sub mnuSetupTextColor_Click(Index As Integer)
    dlgCommonDialog.DialogTitle = "Chose collor for the text"
    dlgCommonDialog.ShowColor
            
    'change the label colors
    ChangeAllLabelColor (dlgCommonDialog.Color)
    
    'set the value in the registry
    RegWriteValue "HKLM", "Software\DiveLog", "Color", "S", Str(dlgCommonDialog.Color)

End Sub

Private Sub ChangeAllLabelColor(Color As Long)
    'set the color for all the labels except the named one
    For i = 0 To 19
        Label(i).ForeColor = Color
    Next i
    
    'set the color for the named labels
    lblOutsideTemp.ForeColor = Color
    lblWaterTemp.ForeColor = Color
    lblDepth.ForeColor = Color
End Sub
Private Sub mnuSetupUnits_Click(Index As Integer)
    frmUnits.Show vbModal
End Sub
