// ------------------------------------------------------------------------
// System       : Win9X/NT
// Program      : mloc.c
// Description  : MLOC - "Thousands of Lines Of Code"
//                CommandLine Utility to Count Lines in Text Files
//                Report Files and Number of Lines to Screen
//                Handles long filenames under Win9x/NT.
// Written by   : Bill Buckels
// Date Written : March 2000
// Revision     : 1.1 First Release
// ------------------------------------------------------------------------

#include <stdlib.h>
#include <io.h>
#include <stdio.h>
#include <string.h>
#include <direct.h>
#include <malloc.h>
#include <dos.h>

long mloc(char *fname, char *sname, int *found)
{
  FILE *fp;
  int c;
  long total = 0L;

  fp = fopen(fname, "rb");            // open raw
  if (NULL != fp) {
    while ((c = fgetc(fp))!=EOF) {
      if (c == '\n')
        total++;
    }
    // if any lines at all report to stdio
    if (total > 0L) {
      // increment counter...
      c = found[0] + 1;
      found[0] = c;
      fclose(fp);
      if (found[0] == 1) {
        printf("%14s%-8s%s\n", "", "Lines", "FileName");
      }
      printf("%14s%-8ld%s\n", "", total, sname);
      return total;
    }
  }
  return 0L;
}


int main(int argc, unsigned char **argv)
{
  long findhandle, grandtotal = 0L;
  struct _finddata_t wild_card;
  
  unsigned char filename[_MAX_PATH],
    path_buffer[_MAX_PATH],
    drive[_MAX_DRIVE],
    dir[_MAX_DIR],
    rootname[_MAX_FNAME],
    ext[_MAX_EXT];

  int found = 0;
  
  puts("MLOC(C) \"Thousands of Lines Of Code\" v1.1");
  puts("CopyLeft Bill Buckels 2000. All Rights Reversed.");
  if(argc < 2) {
    puts("Usage is : \"MLOC [FileName*.*]\"");
    puts("Purpose  : Count Lines In Files. (especially source code files)\n");
    return 1;
  }
  
  strcpy(filename, argv[1]);
  strcpy(path_buffer, filename);       // allow pathing...
  
  _splitpath(path_buffer, drive, dir, rootname, ext);
  
  if((findhandle = _findfirst(filename, &wild_card)) < 1l)
    return 1;
  
  if(!(wild_card.attrib  &_A_SUBDIR)) 
  {
    sprintf(path_buffer, "%s%s%s", drive, dir, wild_card.name);
    grandtotal += mloc(path_buffer, wild_card.name, &found);
  }
  
  while(_findnext(findhandle, &wild_card) == 0)
  {
    if(!(wild_card.attrib  &_A_SUBDIR)) 
    {
      sprintf(path_buffer, "%s%s%s", drive, dir, wild_card.name);
      grandtotal += mloc(path_buffer, wild_card.name, &found);
    }
  }

  _findclose(findhandle);
  
  printf("%-12s= %ld\n", "Total Lines", grandtotal);
  printf("%-12s= %ld\n", "Total Files", found);
  if ( found)
    printf("%-12s= %ld\n", "Average", grandtotal / found);

  if(!found)
    return 1;
  
  return 0;
}
