// ------------------------------------------------------------------------
// System       : Win9X/NT
// Program      : wraptext.c
// Description  : Add word wrap (hard returns) to long text files prior
//                to processing in a programmers editor.
//                This is helpful if text is created in a windows editor
//                (i.e. msword) then re-editted in a programmers editor.
//                Handles long filenames under Win9X/NT
// Written by   : Bill Buckels
// Date Written : 1998
// Revision     : 2.0 Second Release - March 2000
//                General Clean-up
//                Added Support for Long FileNames
// Outstanding  : No checks are in place for leading and trailing
//                whitespace. No changes are planned for this,
//                and this should only occur when more than one whitepace
//                is grouped at a word wrap point.
// ------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <string.h>

char infile[_MAX_PATH], outfile[_MAX_PATH];

#define MAX_BUFSIZE 2048
#define MAX_BUFLEN  (MAX_BUFSIZE - 1)

char buffer[MAX_BUFSIZE],
     worker[MAX_BUFSIZE];

int main(int argc, char **argv)
{
  FILE *fp, *fp2;
  int len,                        /* string length */
      ctr,                        /* onscreen counter */
      c,                          /* character from file */
      limit = 72,                 /* line wrap length */
      lastspace,                  /* last space character */
      idx;                        /* work var. */

  puts("WrapText(C) v2.0 CopyLeft Bill Buckels 1998-2000.");
  puts("All Rights Reversed.");
  puts("=================================================");
  if(argc>1)strcpy(infile,argv[1]);
  if(argc>2)strcpy(outfile,argv[2]);
  if(argc>3) {
    limit = atoi(argv[3]);
    if (limit < 1 || limit > MAX_BUFLEN)
      limit = 72;
  }

  if(argc<3)
  {
    puts("This Utility Reformats and Adds Hard Returns to text files.");
    puts("Commandline Usage is : \"WrapText [infile.txt] [outfile.txt] {limit}\"");
    puts("                 But : You may manually enter filename(s) Now...");
    puts("                 Or  : Enter a \"BLANK\" filename to exit Now...");
    puts("================================================================");
    if(argc==1)
    {
      printf("Enter Input  Filename: ");gets(infile);
      if(infile[0]==0)return 1;
    }
    printf("Enter Output Filename: ");gets(outfile);
    if(outfile[0]==0)return 1;
    puts("================================================================");
  }

  if((fp2=fopen(outfile,"rb"))!=NULL)
  {
    fclose(fp2);
    printf("%cOutput File %s already exists! Overwrite? (Y/N) ",7,outfile);
    if((c=toupper(getch()))==0)getch();
    else printf("%c",c);
    puts("");
    if(c!='Y')return 1;
    puts("================================================================");
  }

  if((fp=fopen(infile,"rb"))==NULL)
  {
      perror(infile);
      return 1;
  }

  if((fp2=fopen(outfile,"wb"))==NULL)
  {
      perror(outfile);
      fclose(fp);
      return 1;
  }

  printf("Infile  : %s\n",infile);
  printf("Outfile : %s\n",outfile);
  printf("        < Line");

  ctr=0;
  len=0;
  buffer[0] = 0;
  lastspace = -1;
  while(EOF != (c = fgetc(fp)))
  {
      /* do not accumulate carriage returns... toss them away */
      if (c == '\r')
        continue;

      /* leave line alone if it starts with a pound sign */
      if (len == 0 && c == '#') {
        while(EOF != (c = fgetc(fp))) {
          if (c == '\n') {
            ctr++;
            printf("\r%d",ctr);
            fputc(13,fp2);
            fputc(10,fp2);
            break;
          }
          if (c != '\r')
            fputc(c, fp2);
        }
        continue;
      }

      /* if linefeed clear the line and continue */
      /* if space and limit is reached, flush and continue */
      /* if no spaces and limit is reached, flush and continue */
      /* if buffer length is exceeded, flush and continue  */

      if (c == '\n' || (c == ' ' && len >= limit) ||
          len >= MAX_BUFLEN || (len >= limit && lastspace<1)) {

        for (idx = 0; buffer[idx] != 0; idx++)
          fputc(buffer[idx],fp2);

        /* write straggler */
        if ((len >= MAX_BUFLEN || lastspace < 1) && c!= ' ' && c!= '\n')
          fputc(c, fp2);

        buffer[0] = 0;       /* reset values, increment counter */
        ctr++;
        printf("\r%d",ctr);
        len = 0;
        lastspace = -1;
        fputc(13,fp2);
        fputc(10,fp2);
        continue;
      }

      /* add the character to the buffer */
      if (c == ' ')lastspace = len;         /* keep track of last space */
      buffer[len] = c;
      len++;
      buffer[len] = 0;

      /* most common case for word wrap... */
      /* if we have gone beyond the limit, split the line at the */
      /* previous whitespace character... */
      /* hopefully this will not create "orphans" and other stupid effects */

      if (len > limit && lastspace > 0) {
        for (idx = 0; idx < lastspace; idx++)
          fputc(buffer[idx],fp2);
        fputc(13,fp2);
        fputc(10,fp2);
        buffer[lastspace] = 0;
        strcpy(worker, &buffer[lastspace+1]);
        strcpy(buffer, worker);
        lastspace = -1;
        ctr++;
        printf("\r%d",ctr);
        for (idx = 0; buffer[idx] != 0; idx++) {
          if (buffer[idx] == ' ')
            lastspace = idx;
        }
        len = strlen(buffer);
      }
  }

  /* write stragglers */
  if (strlen(buffer)) {
    for (idx = 0; buffer[idx] != 0; idx++)
      fputc(buffer[idx],fp2);
    ctr++;
    printf("\r%d",ctr);
    fputc(13,fp2);
    fputc(10,fp2);
  }
  fclose(fp);
  fclose(fp2);
  puts("\nDone!");

return 0;
}
