// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : basename.c
// Description  : Gets Basename from FileName
//
// Written by   : Bill Buckels
// Date Written : March 2000
// Revision     : 1.1
// ------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <direct.h>

unsigned char path_buffer[_MAX_PATH],
    drive[_MAX_DRIVE],
    dir[_MAX_DIR],
    rootname[_MAX_FNAME],
    ext[_MAX_EXT];

void main(int argc, char **argv)
{
    int c = 0, cnt = 0, idx;
    FILE *fp = NULL;

    if (argc > 1)
      fp = fopen(argv[1], "rb");

    for (;;) {
      if (NULL == fp)
        c = getchar();
      else
        c = fgetc(fp);

      if (c==EOF)break;

      if (c == '\n' && cnt > 0) {
        _splitpath(path_buffer, drive, dir, rootname, ext);
        for (idx = 0; rootname[idx] != 0; idx++)
          putchar(rootname[idx]);
        putchar('\n');
        path_buffer[0] = cnt = 0;
        continue;
      }

      if(c != '\r')  {
        path_buffer[cnt] = c;
        cnt++;
        path_buffer[cnt] = 0;
      }
    }

    if (NULL != fp) {
      fclose(fp);
      exit(0);
    }
}

