// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : lcase.c
// Description  : Uppercase to Lowercase filter.
//
//                This program is a filter that translates all uppercase
//                characters to lowercase.  It will optionally accept a
//                filename to read input from.  All output goes to the
//                standard output device unless redirected.
//
//                Examples:
//                  Lcase abc.txt
//                      read input from abc.txt,
//                      output goes to screen.
//                  Lcase abc.txt >abcnew.txt
//                      read input from abc.txt,
//                      output goes to abcnew.txt.
//                  Lcase <abc.txt >abcnew.txt
//                      same as previous example
//                  Lcase abc.txt | find "abc"
//                      translates abc.txt to lowercase
//                      and then searches the result
//                      for the string "abc".
//                      Output goes to screen.
//                  find "ABC" abc.txt | Lcase | sort
//                      Search abc.txt for all lines that
//                      contain "ABC".  Translate all lines
//                      selected and sort them, sending output
//                      to the screen.
//
// Written by   : Bill Buckels
// Based On     : lower.asm
//                used with permission
// Date Written : March 2000
// Revision     : 2.0 Second Release
// ------------------------------------------------------------------------
#include <stdio.h>

void main(int argc, char **argv)
{
    int c;
    FILE *fp = NULL;

    if (argc > 1)
      fp = fopen(argv[1], "r");

    for (;;) {
      if (NULL == fp)
        c = getchar();
      else
        c = fgetc(fp);

      if (c==EOF)break;

      if(c>64 && c<91)c+=32;

      putchar(c);
    }

    if (NULL != fp) {
      fclose(fp);
      exit(0);
    }
}
