/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBColumnAwareSupport;
import com.borland.dbswing.DBDataBinder;
import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBRuntimeSupport;
import com.borland.dbswing.DBUtilities;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.Designable;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.Variant;
import com.borland.dx.text.InvalidFormatException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.plaf.UIResource;

public class DBButtonDataBinder
implements ActionListener,
ItemListener,
PropertyChangeListener,
AccessListener,
DataChangeListener,
NavigationListener,
ColumnAware,
Designable,
DBDataBinder,
Serializable {
    private AbstractButton button;
    private AbstractButton oldButton;
    private ButtonModel buttonModel;
    private String selectedValue;
    private String unselectedValue;
    private int mode = 0;
    private DBColumnAwareSupport columnAwareSupport = new DBColumnAwareSupport(this);
    private boolean ignoreValueChange;
    private int defaultHorizontalAlignment = 2;
    private Variant compareVariant;
    private boolean rebindColumnProperties;
    private boolean dataSetEventsEnabled = true;

    public DBButtonDataBinder() {
    }

    public DBButtonDataBinder(AbstractButton button) {
        this.setAbstractButton(button);
    }

    public void setAbstractButton(AbstractButton button) {
        if (this.button != null && this.button != button) {
            this.button.removePropertyChangeListener(this);
        }
        this.button = button;
        if (button == null) {
            this.setButtonModel(null);
        } else {
            button.addPropertyChangeListener(this);
            this.setButtonModel(button.getModel());
            if (button instanceof JButton || button instanceof JToggleButton) {
                this.defaultHorizontalAlignment = 0;
            }
        }
    }

    public AbstractButton getAbstractButton() {
        return this.button;
    }

    public void setButtonModel(ButtonModel buttonModel) {
        if (this.buttonModel != null) {
            this.buttonModel.removeActionListener(this);
            this.buttonModel.removeItemListener(this);
        }
        this.buttonModel = buttonModel;
        if (buttonModel != null) {
            buttonModel.addActionListener(this);
            buttonModel.addItemListener(this);
        }
        this.bindColumnProperties();
    }

    public ButtonModel getButtonModel() {
        return this.buttonModel;
    }

    public void setSelectedDataValue(String selectedValue) {
        this.selectedValue = selectedValue;
    }

    public String getSelectedDataValue() {
        return this.selectedValue;
    }

    public void setUnselectedDataValue(String unselectedValue) {
        this.unselectedValue = unselectedValue;
    }

    public String getUnselectedDataValue() {
        return this.unselectedValue;
    }

    public void setUnknownDataValueMode(int mode) {
        this.mode = mode;
    }

    public int getUnknownDataValueMode() {
        return this.mode;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.columnAwareSupport.dataSet != null) {
            this.columnAwareSupport.dataSet.removeNavigationListener(this);
        }
        this.columnAwareSupport.setDataSet(dataSet);
        if (dataSet != null) {
            this.columnAwareSupport.dataSet.addNavigationListener(this);
        }
        this.bindColumnProperties();
    }

    public DataSet getDataSet() {
        return this.columnAwareSupport.dataSet;
    }

    public void setColumnName(String columnName) {
        this.columnAwareSupport.setColumnName(columnName);
        this.bindColumnProperties();
    }

    public String getColumnName() {
        return this.columnAwareSupport.columnName;
    }

    public void propertyChange(PropertyChangeEvent e2) {
        if (e2.getPropertyName().equals("ancestor")) {
            this.bindColumnProperties();
        }
        if (e2.getPropertyName().equals("model")) {
            this.setButtonModel((ButtonModel)e2.getNewValue());
        }
    }

    public void actionPerformed(ActionEvent e2) {
        this.columnAwareSupport.lazyOpen();
        if (this.columnAwareSupport.isValidDataSetState() && this.columnAwareSupport.getColumn().isEditable()) {
            if (this.buttonModel.isSelected()) {
                if (this.selectedValue != null) {
                    this.columnAwareSupport.setFromString(this.selectedValue, this.button);
                } else if (this.unselectedValue == null) {
                    Variant value = this.columnAwareSupport.getVariant();
                    switch (this.columnAwareSupport.getColumn().getDataType()) {
                        case 11: {
                            value.setBoolean(true);
                            break;
                        }
                        case 16: {
                            value.setString(String.valueOf(true));
                            break;
                        }
                        case 2: {
                            value.setByte((byte)1);
                            break;
                        }
                        case 3: {
                            value.setShort((short)1);
                            break;
                        }
                        case 4: {
                            value.setInt(1);
                            break;
                        }
                        case 5: {
                            value.setLong(1L);
                            break;
                        }
                        case 6: {
                            value.setFloat(1.0f);
                            break;
                        }
                        case 7: {
                            value.setDouble(1.0);
                            break;
                        }
                        case 10: {
                            value.setBigDecimal(new BigDecimal("1"));
                            break;
                        }
                        case 14: {
                            value.setTime(1L);
                            break;
                        }
                        case 13: {
                            value.setDate(1L);
                            break;
                        }
                        case 15: {
                            value.setTimestamp(1L);
                            break;
                        }
                        default: {
                            value.setUnassignedNull();
                        }
                    }
                    if (!value.isUnassignedNull()) {
                        this.columnAwareSupport.setVariant(value);
                    }
                }
            } else if (this.unselectedValue != null) {
                this.columnAwareSupport.setFromString(this.unselectedValue, this.button);
            } else if (this.selectedValue == null) {
                Variant value = this.columnAwareSupport.getVariant();
                switch (this.columnAwareSupport.getColumn().getDataType()) {
                    case 11: {
                        value.setBoolean(false);
                        break;
                    }
                    case 16: {
                        value.setString(String.valueOf(false));
                        break;
                    }
                    case 2: {
                        value.setByte((byte)0);
                        break;
                    }
                    case 3: {
                        value.setShort((short)0);
                        break;
                    }
                    case 4: {
                        value.setInt(0);
                        break;
                    }
                    case 5: {
                        value.setLong(0L);
                        break;
                    }
                    case 6: {
                        value.setFloat(0.0f);
                        break;
                    }
                    case 7: {
                        value.setDouble(0.0);
                        break;
                    }
                    case 10: {
                        value.setBigDecimal(new BigDecimal("0"));
                        break;
                    }
                    case 14: {
                        value.setTime(0L);
                        break;
                    }
                    case 13: {
                        value.setDate(0L);
                        break;
                    }
                    case 15: {
                        value.setTimestamp(0L);
                        break;
                    }
                    default: {
                        value.setUnassignedNull();
                    }
                }
                if (!value.isUnassignedNull()) {
                    this.columnAwareSupport.setVariant(value);
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent e2) {
        if (!this.ignoreValueChange) {
            this.columnAwareSupport.lazyOpen();
            if (e2.getStateChange() == 2 && this.columnAwareSupport.isValidDataSetState() && this.columnAwareSupport.getColumn().isEditable()) {
                if (this.unselectedValue != null) {
                    this.columnAwareSupport.setFromString(this.unselectedValue, this.button);
                } else if (this.selectedValue == null) {
                    Variant value = this.columnAwareSupport.getVariant();
                    switch (this.columnAwareSupport.getColumn().getDataType()) {
                        case 11: {
                            value.setBoolean(false);
                            break;
                        }
                        case 16: {
                            value.setString(String.valueOf(false));
                            break;
                        }
                        case 2: {
                            value.setByte((byte)0);
                            break;
                        }
                        case 3: {
                            value.setShort((short)0);
                            break;
                        }
                        case 4: {
                            value.setInt(0);
                            break;
                        }
                        case 5: {
                            value.setLong(0L);
                            break;
                        }
                        case 6: {
                            value.setFloat(0.0f);
                            break;
                        }
                        case 7: {
                            value.setDouble(0.0);
                            break;
                        }
                        case 10: {
                            value.setBigDecimal(new BigDecimal("0"));
                            break;
                        }
                        case 14: {
                            value.setTime(0L);
                            break;
                        }
                        case 13: {
                            value.setDate(0L);
                            break;
                        }
                        case 15: {
                            value.setTimestamp(0L);
                            break;
                        }
                        default: {
                            value.setUnassignedNull();
                        }
                    }
                    if (!value.isUnassignedNull()) {
                        this.columnAwareSupport.setVariant(value);
                    }
                }
            }
        }
    }

    protected void updateButtonState() {
        this.ignoreValueChange = true;
        if (this.columnAwareSupport.isValidDataSetState()) {
            Variant columnValue = this.columnAwareSupport.getVariant();
            if (this.selectedValue == null && this.unselectedValue == null) {
                this.buttonModel.setSelected(columnValue.getAsBoolean());
            } else {
                if (this.compareVariant == null || this.compareVariant.getType() != this.columnAwareSupport.getColumn().getDataType()) {
                    this.compareVariant = new Variant();
                }
                if (this.selectedValue != null) {
                    try {
                        this.columnAwareSupport.getColumn().getFormatter().parse(this.selectedValue, this.compareVariant);
                        if (columnValue.equals(this.compareVariant)) {
                            if (this.mode == 1 && !this.buttonModel.isEnabled()) {
                                this.buttonModel.setEnabled(true);
                            }
                            this.buttonModel.setSelected(true);
                            return;
                        }
                    }
                    catch (InvalidFormatException e2) {
                        DBExceptionHandler.handleException(this.columnAwareSupport.dataSet, this.button, e2);
                    }
                }
                if (this.unselectedValue != null) {
                    try {
                        this.columnAwareSupport.getColumn().getFormatter().parse(this.unselectedValue, this.compareVariant);
                        if (columnValue.equals(this.compareVariant)) {
                            if (this.mode == 1 && !this.buttonModel.isEnabled()) {
                                this.buttonModel.setEnabled(true);
                            }
                            this.buttonModel.setSelected(false);
                            return;
                        }
                    }
                    catch (InvalidFormatException e3) {
                        DBExceptionHandler.handleException(this.columnAwareSupport.dataSet, this.button, e3);
                    }
                }
                this.buttonModel.setSelected(false);
                if (this.mode == 1) {
                    if (columnValue.isUnassignedNull()) {
                        this.buttonModel.setEnabled(true);
                    } else {
                        this.buttonModel.setEnabled(false);
                    }
                } else if (this.mode == 2 && !this.columnAwareSupport.isNull()) {
                    this.columnAwareSupport.resetValue();
                }
            }
        } else if (this.buttonModel != null) {
            this.buttonModel.setEnabled(true);
            this.buttonModel.setSelected(false);
        }
        this.ignoreValueChange = false;
    }

    public void navigated(NavigationEvent event) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        this.updateButtonState();
    }

    public void dataChanged(DataChangeEvent event) {
        boolean affectedOurRow;
        if (!this.dataSetEventsEnabled) {
            return;
        }
        int affectedRow = event.getRowAffected();
        boolean bl = affectedOurRow = affectedRow == this.columnAwareSupport.dataSet.getRow() || affectedRow == -1;
        if (affectedOurRow) {
            this.updateButtonState();
        }
    }

    public void postRow(DataChangeEvent event) throws Exception {
    }

    private boolean useCaptionFromColumn() {
        return this.button.getText() == null || this.button.getText().length() == 0;
    }

    private boolean isDefaultProperty(Object property) {
        return property == null || property instanceof UIResource;
    }

    private void bindColumnProperties() {
        if (this.oldButton != null) {
            DBRuntimeSupport.getInstance().removeComponent(this.oldButton);
            this.oldButton = null;
        }
        if (this.button != null && this.button.isDisplayable()) {
            this.rebindColumnProperties = false;
            this.columnAwareSupport.lazyOpen();
            this.updateButtonState();
            if (this.columnAwareSupport.isValidDataSetState()) {
                DBRuntimeSupport.getInstance().addComponent(this.button, this);
                this.oldButton = this.button;
                Column column = this.columnAwareSupport.getColumn();
                if (this.useCaptionFromColumn()) {
                    this.button.setText(column.getCaption());
                }
                if (this.button.getHorizontalAlignment() == this.defaultHorizontalAlignment) {
                    this.button.setHorizontalAlignment(DBUtilities.convertJBCLToSwingAlignment(column.getAlignment(), true));
                }
                if (this.button.getVerticalAlignment() == 0) {
                    this.button.setVerticalAlignment(DBUtilities.convertJBCLToSwingAlignment(column.getAlignment(), false));
                }
                if (this.isDefaultProperty(this.button.getBackground()) && column.getBackground() != null) {
                    this.button.setBackground(column.getBackground());
                }
                if (this.isDefaultProperty(this.button.getForeground()) && column.getForeground() != null) {
                    this.button.setForeground(column.getForeground());
                }
                if (this.isDefaultProperty(this.button.getFont()) && column.getFont() != null) {
                    this.button.setFont(column.getFont());
                }
                if (this.buttonModel.isEnabled() && !column.isEditable()) {
                    this.buttonModel.setEnabled(false);
                }
            }
        }
    }

    public void accessChange(AccessEvent event) {
        if (event.getID() == 2) {
            if (event.getReason() == 8) {
                this.dataSetEventsEnabled = false;
                return;
            }
            if (this.mode == 1) {
                this.buttonModel.setEnabled(false);
            }
            if (event.getReason() == 9) {
                this.rebindColumnProperties = true;
            }
        } else {
            if (event.getReason() == 2) {
                this.dataSetEventsEnabled = true;
            }
            if (event.getReason() == 1 || this.rebindColumnProperties || event.getReason() == 2) {
                this.bindColumnProperties();
            }
        }
    }
}

