/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBColumnAwareSupport;
import com.borland.dbswing.DBExceptionHandler;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Designable;
import com.borland.dx.dataset.Variant;
import javax.swing.AbstractListModel;

public class DBListModel
extends AbstractListModel
implements AccessListener,
DataChangeListener,
ColumnAware,
Designable {
    private Variant value = new Variant();
    DBColumnAwareSupport columnAwareSupport = new DBColumnAwareSupport(this);
    private boolean dataSetEventsEnabled = true;

    public DBListModel() {
    }

    public DBListModel(DataSet dataSet, String columnName) {
        this.setDataSet(dataSet);
        this.setColumnName(columnName);
    }

    public void setDataSet(DataSet dataSet) {
        this.columnAwareSupport.setDataSet(dataSet);
    }

    public DataSet getDataSet() {
        return this.columnAwareSupport.getDataSet();
    }

    public void setColumnName(String columnName) {
        this.columnAwareSupport.setColumnName(columnName);
    }

    public String getColumnName() {
        return this.columnAwareSupport.getColumnName();
    }

    public int getSize() {
        if (this.columnAwareSupport.dataSet != null && this.columnAwareSupport.dataSet.isOpen()) {
            this.columnAwareSupport.lazyOpen();
        }
        if (this.columnAwareSupport.isValidDataSetState()) {
            try {
                int n2 = this.columnAwareSupport.dataSet.getRowCount();
                return n2;
            }
            catch (DataSetException e2) {
                DBExceptionHandler.handleException(this.columnAwareSupport.dataSet, e2);
            }
        }
        return 0;
    }

    public Object getElementAt(int index) {
        Variant value = this.getVariantElementAt(index);
        if (value == null) {
            return null;
        }
        return value.getAsObject();
    }

    Variant getVariantElementAt(int index) {
        if (this.columnAwareSupport.dataSet != null && this.columnAwareSupport.dataSet.isOpen()) {
            this.columnAwareSupport.lazyOpen();
        }
        if (this.columnAwareSupport.isValidDataSetState()) {
            try {
                this.columnAwareSupport.dataSet.getDisplayVariant(this.columnAwareSupport.columnOrdinal, index, this.value);
                Variant variant = this.value;
                return variant;
            }
            catch (DataSetException e2) {
                DBExceptionHandler.handleException(this.columnAwareSupport.dataSet, e2);
            }
        }
        return null;
    }

    public void accessChange(AccessEvent event) {
        if (event.getID() == 1) {
            if (event.getReason() == 2) {
                this.dataSetEventsEnabled = true;
            }
            this.columnAwareSupport.lazyOpen();
            if (this.columnAwareSupport.isValidDataSetState()) {
                this.fireContentsChanged(this, 0, this.getSize());
            }
        } else {
            if (event.getReason() == 8) {
                this.dataSetEventsEnabled = false;
                return;
            }
            this.fireIntervalRemoved(this, 0, this.getSize());
        }
    }

    public void dataChanged(DataChangeEvent event) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        if (event.multiRowChange()) {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
            return;
        }
        int affectedRow = event.getRowAffected();
        switch (event.getID()) {
            case 1: {
                this.fireIntervalAdded(this, affectedRow, affectedRow);
                break;
            }
            case 2: {
                this.fireIntervalRemoved(this, affectedRow, affectedRow);
                break;
            }
            case 3: 
            case 4: {
                this.fireContentsChanged(this, affectedRow, affectedRow);
                break;
            }
            default: {
                this.fireContentsChanged(this, 0, this.getSize() - 1);
            }
        }
    }

    public void postRow(DataChangeEvent event) throws Exception {
    }
}

