/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.FontChooserDialog;
import com.borland.dbswing.Res;
import java.awt.Font;
import java.awt.Frame;
import java.io.Serializable;

public class FontChooser
implements Serializable {
    private Frame frame;
    private String title;
    private boolean modal;
    private String sampleText;
    private boolean allowAnyFontSize = true;
    private Font[] availableFonts;
    private Font selectedFont;
    private String[] availableFontSizes;
    private boolean okPressed = false;

    public FontChooser() {
        this(null, "", true);
    }

    public FontChooser(Frame frame, String title) {
        this(frame, title, true);
    }

    public FontChooser(Frame frame, String title, boolean modal) {
        this.setFrame(frame);
        this.setTitle(title);
        this.setModal(modal);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setSampleText(String sampleText) {
        this.sampleText = sampleText;
    }

    public String getSampleText() {
        return this.sampleText;
    }

    public void setAvailableFonts(Font[] availableFonts) {
        this.availableFonts = availableFonts;
    }

    public Font[] getAvailableFonts() {
        return this.availableFonts;
    }

    public void setSelectedFont(Font selectedFont) {
        this.selectedFont = selectedFont;
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void setAvailableFontSizes(String[] availableFontSizes) {
        this.availableFontSizes = availableFontSizes;
    }

    public String[] getAvailableFontSizes() {
        return this.availableFontSizes;
    }

    public void setAllowAnyFontSize(boolean allowAnyFontSize) {
        this.allowAnyFontSize = allowAnyFontSize;
    }

    public boolean isAllowAnyFontSize() {
        return this.allowAnyFontSize;
    }

    public void show() {
        this.showDialog();
    }

    public boolean showDialog() {
        if (this.frame == null) {
            throw new IllegalStateException(Res.bundle.getString(33));
        }
        FontChooserDialog dialog = new FontChooserDialog(this.frame, this.title == null ? Res.bundle.getString(42) : this.title, this.modal);
        dialog.setLocationRelativeTo(this.frame);
        dialog.setAllowAnyFontSize(this.allowAnyFontSize);
        if (this.sampleText != null) {
            dialog.setSampleText(this.sampleText);
        }
        if (this.availableFonts != null) {
            dialog.setAvailableFonts(this.availableFonts);
        }
        if (this.availableFontSizes != null) {
            dialog.setFontSizes(this.availableFontSizes);
        }
        if (this.selectedFont != null) {
            dialog.setSelectedFont(this.selectedFont);
        }
        dialog.pack();
        dialog.show();
        if (dialog.isOKPressed()) {
            this.selectedFont = dialog.getSelectedFont();
            this.okPressed = true;
        }
        dialog.dispose();
        return this.okPressed;
    }
}

