/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class ToolBarLayout
extends FlowLayout {
    int orientation = 0;

    public ToolBarLayout() {
    }

    public ToolBarLayout(int orientation) {
        this.orientation = orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public Dimension preferredLayoutSize(Container target) {
        if (this.orientation == 0) {
            Dimension d2 = super.preferredLayoutSize(target);
            return d2;
        }
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            for (int i2 = 0; i2 < nmembers; ++i2) {
                Component m2 = target.getComponent(i2);
                if (!m2.isVisible()) continue;
                Dimension d3 = m2.getPreferredSize();
                dim.width = Math.max(dim.width, d3.width);
                if (i2 > 0) {
                    dim.height += this.getVgap();
                }
                dim.height += d3.height;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.getHgap() * 2;
            dim.height += insets.top + insets.bottom + this.getVgap() * 2;
            Dimension dimension = dim;
            return dimension;
        }
    }

    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            int maxwidth = target.getWidth() - (insets.left + insets.right + hgap * 2);
            int maxheight = target.getHeight() - (insets.top + insets.bottom + vgap * 2);
            int nmembers = target.getComponentCount();
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            if (this.orientation == 0) {
                int x2 = 0;
                int y2 = insets.top + vgap;
                int rowh = 0;
                int start = 0;
                for (int i2 = 0; i2 < nmembers; ++i2) {
                    Component m2 = target.getComponent(i2);
                    if (!m2.isVisible()) continue;
                    Dimension d2 = m2.getPreferredSize();
                    m2.setSize(d2.width, d2.height);
                    if (x2 == 0 || x2 + d2.width <= maxwidth) {
                        if (x2 > 0) {
                            x2 += hgap;
                        }
                        x2 += d2.width;
                        rowh = Math.max(rowh, d2.height);
                        continue;
                    }
                    this.doGridLayout(target);
                    return;
                }
                this.moveComponentsX(target, insets.left + hgap, y2, maxwidth - x2, rowh, start, nmembers, ltr);
            } else {
                int y3 = 0;
                int x3 = insets.left + hgap;
                int colw = 0;
                int start = 0;
                for (int i3 = 0; i3 < nmembers; ++i3) {
                    Component m3 = target.getComponent(i3);
                    if (!m3.isVisible()) continue;
                    Dimension d3 = m3.getPreferredSize();
                    m3.setSize(d3.width, d3.height);
                    if (y3 == 0 || y3 + d3.height <= maxheight) {
                        if (y3 > 0) {
                            y3 += vgap;
                        }
                        y3 += d3.height;
                        colw = Math.max(colw, d3.width);
                        continue;
                    }
                    this.doGridLayout(target);
                    return;
                }
                this.moveComponentsY(target, x3, insets.top + vgap, colw, maxheight - y3, start, nmembers, ltr);
            }
        }
    }

    private void doGridLayout(Container target) {
        int ncols;
        int nrows;
        int visibleComponents = 0;
        int ncomponents = target.getComponentCount();
        Insets insets = target.getInsets();
        int hgap = this.getHgap();
        int vgap = this.getVgap();
        for (int i2 = 0; i2 < ncomponents; ++i2) {
            if (!target.getComponent(i2).isVisible()) continue;
            ++visibleComponents;
        }
        if (visibleComponents == 0) {
            return;
        }
        if (this.orientation == 0) {
            nrows = 1;
            ncols = visibleComponents;
        } else {
            nrows = visibleComponents;
            ncols = 1;
        }
        int w2 = target.getWidth() - (insets.left + insets.right);
        int h2 = target.getHeight() - (insets.top + insets.bottom);
        w2 = (w2 - (ncols - 1) * hgap) / ncols;
        h2 = (h2 - (nrows - 1) * vgap) / nrows;
        if (this.orientation == 0) {
            int y2 = insets.top + vgap;
            int x2 = insets.left;
            int i3 = 0;
            block1: for (int c2 = 0; c2 < ncols; ++c2) {
                while (i3 < ncomponents) {
                    Component comp;
                    if ((comp = target.getComponent(i3++)).isVisible()) {
                        comp.setBounds(x2, y2, w2, comp.getPreferredSize().height);
                        x2 += w2 + hgap;
                        continue block1;
                    }
                    comp.setBounds(-1, -1, 0, 0);
                }
            }
        } else {
            int x3 = insets.left + hgap;
            int y3 = insets.top;
            int i4 = 0;
            block3: for (int c3 = 0; c3 < nrows; ++c3) {
                while (i4 < ncomponents) {
                    Component comp;
                    if ((comp = target.getComponent(i4++)).isVisible()) {
                        comp.setBounds(x3, y3, comp.getPreferredSize().width, h2);
                        y3 += h2 + vgap;
                        continue block3;
                    }
                    comp.setBounds(-1, -1, 0, 0);
                }
            }
        }
    }

    private void moveComponentsX(Container target, int x2, int y2, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        int hgap = this.getHgap();
        int vgap = this.getVgap();
        int align = this.getAlignment();
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (align) {
                case 0: {
                    x2 += ltr ? 0 : width;
                    break;
                }
                case 1: {
                    x2 += width / 2;
                    break;
                }
                case 2: {
                    x2 += ltr ? width : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    x2 += width;
                }
            }
            for (int i2 = rowStart; i2 < rowEnd; ++i2) {
                Component m2 = target.getComponent(i2);
                if (!m2.isVisible()) continue;
                if (ltr) {
                    m2.setLocation(x2, y2 + (height - m2.getSize().height) / 2);
                } else {
                    m2.setLocation(target.getWidth() - x2 - m2.getSize().width, y2 + (height - m2.getSize().height) / 2);
                }
                x2 += m2.getSize().width + hgap;
            }
        }
    }

    private void moveComponentsY(Container target, int x2, int y2, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        int hgap = this.getHgap();
        int vgap = this.getVgap();
        int align = this.getAlignment();
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (align) {
                case 0: {
                    y2 = 0;
                    break;
                }
                case 1: {
                    y2 += height / 2;
                    break;
                }
                case 2: {
                    y2 = height;
                }
            }
            for (int i2 = rowStart; i2 < rowEnd; ++i2) {
                Component m2 = target.getComponent(i2);
                if (!m2.isVisible()) continue;
                m2.setLocation(x2 + (width - m2.getSize().width) / 2, y2);
                y2 += m2.getSize().height + vgap;
            }
        }
    }
}

