VERSION 5.00
Begin VB.Form frmSample 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "CT INIFile ActiveX Library Sample"
   ClientHeight    =   3465
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   5925
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   ScaleHeight     =   3465
   ScaleWidth      =   5925
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame fraSample 
      Height          =   3225
      Left            =   150
      TabIndex        =   0
      Top             =   90
      Width           =   5625
      Begin VB.TextBox txtFile 
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   238
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         Left            =   600
         Locked          =   -1  'True
         TabIndex        =   9
         Top             =   2670
         Width           =   4755
      End
      Begin VB.CommandButton cmdStep 
         Caption         =   "Delete Section"
         Enabled         =   0   'False
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   238
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   2
         Left            =   510
         TabIndex        =   6
         Top             =   1710
         Width           =   1365
      End
      Begin VB.CommandButton cmdStep 
         Caption         =   "Delete Key"
         Enabled         =   0   'False
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   238
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   1
         Left            =   510
         TabIndex        =   4
         Top             =   1050
         Width           =   1365
      End
      Begin VB.ListBox lstSettings 
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   238
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   1815
         ItemData        =   "SAMPLE.frx":0000
         Left            =   2700
         List            =   "SAMPLE.frx":0002
         TabIndex        =   7
         Top             =   330
         Width           =   2655
      End
      Begin VB.CommandButton cmdStep 
         Caption         =   "Create File"
         Default         =   -1  'True
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   238
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Index           =   0
         Left            =   510
         TabIndex        =   2
         Top             =   390
         Width           =   1365
      End
      Begin VB.Label lblFile 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "File:"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   238
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Left            =   270
         TabIndex        =   8
         Top             =   2730
         Width           =   300
      End
      Begin VB.Line linSeparator 
         X1              =   270
         X2              =   5340
         Y1              =   2400
         Y2              =   2400
      End
      Begin VB.Label lblStep 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "3."
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   238
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Index           =   2
         Left            =   270
         TabIndex        =   5
         Top             =   1800
         Width           =   150
      End
      Begin VB.Line linStep 
         Index           =   2
         Visible         =   0   'False
         X1              =   2010
         X2              =   2580
         Y1              =   1890
         Y2              =   1890
      End
      Begin VB.Label lblStep 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "2."
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   238
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Index           =   1
         Left            =   270
         TabIndex        =   3
         Top             =   1140
         Width           =   150
      End
      Begin VB.Line linStep 
         Index           =   1
         Visible         =   0   'False
         X1              =   2010
         X2              =   2580
         Y1              =   1230
         Y2              =   1230
      End
      Begin VB.Line linStep 
         Index           =   0
         X1              =   2010
         X2              =   2580
         Y1              =   570
         Y2              =   570
      End
      Begin VB.Label lblStep 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "1."
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   238
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Index           =   0
         Left            =   270
         TabIndex        =   1
         Top             =   480
         Width           =   150
      End
   End
End
Attribute VB_Name = "frmSample"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'**********************************************************
'
'This is an example of how to use properties and methods
'exposed by CT INIFile ActiveX Library file.
'
'Properties and methods can be invoked as if they were
'simply global functions. Its not necessary to explicitly
'create an instance of the class first, because one will
'automatically be created.
'
'Properties and methods
'that has been used in this example
'   Methods
'       INIQuerySettingNames
'       INIQuerySetting
'       INIWriteSetting
'       INIClearSection
'       INIClearSetting
'
'**********************************************************
'
'CT INIFile ActiveX Library allows you to read from
'and write to initialization/INI files from Visual
'Basic applications.
'
'This library file is specifically designed for Visual
'Basic, but may work in any environment that supports
'ActiveX technology.
'
'CT INIFile ActiveX Library
'Copyright  1999-2000, Cezar Botez
'All rights reserved
'
'CT INIFile ActiveX Library is freeware and may be
'distributed and used freely, in any commercial purpose
'or not, as long as it is distributed in its entirety.
'
'The author will not be responsible for any kind of loss
'occuring due to the use of this software.
'
'Reference for further information
'http://softrunner.homestead.com
'
'Comments, suggestions or bugs reports
'cbotez@homestead.com
'
'**********************************************************

Private Sub SaveSettings()
    INIWriteSetting "Section", "Key_1", "Value_1", txtFile.Text
    INIWriteSetting "Section", "Key_2", "Value_2", txtFile.Text
    INIWriteSetting "Section", "Key_3", "Value_3", txtFile.Text
End Sub

Private Sub LoadSettings()
    Dim keynames() As String
    Dim arrcount As Long
    Dim nkeyname As Long
    Dim skeyname As String
    Dim strvalue As String

    arrcount = INIQuerySettingNames("Section", keynames, , txtFile.Text)

    lstSettings.Clear
    For nkeyname = 0 To arrcount - 1
        skeyname = keynames(nkeyname)
        INIQuerySetting "Section", skeyname, strvalue, , txtFile.Text
        lstSettings.AddItem skeyname & "=" & strvalue
    Next

    Erase keynames
End Sub

Private Sub DeleteKeyName()
    INIClearSetting "Section", "Key_1", txtFile.Text
End Sub

Private Sub DeleteSection()
    INIClearSection "Section", txtFile.Text
End Sub

Private Sub cmdStep_Click(Index As Integer)
    cmdStep(Index).Enabled = False
    linStep(Index).Visible = False

    Select Case Index
        Case 0: SaveSettings:  LoadSettings
        Case 1: DeleteKeyName: LoadSettings
        Case 2: DeleteSection: LoadSettings
    End Select

    If Index < cmdStep.Count - 1 Then
        cmdStep(Index + 1).Enabled = True
        cmdStep(Index + 1).Default = True
        linStep(Index + 1).Visible = True
    Else
        cmdStep(0).Enabled = True
        cmdStep(0).Default = True
        linStep(0).Visible = True
    End If
End Sub

Private Sub Form_Load()
    If Right(App.Path, 1) = "\" Then
        txtFile.Text = App.Path & App.EXEName & ".ini"
    Else
        txtFile.Text = App.Path & "\" & App.EXEName & ".ini"
    End If
    txtFile.Locked = True
End Sub

Private Sub Form_Unload(Cancel As Integer)
    On Error Resume Next
    Kill txtFile.Text
End Sub
