VERSION 5.00
Begin VB.Form fmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Variable Space Demo"
   ClientHeight    =   3630
   ClientLeft      =   2235
   ClientTop       =   1995
   ClientWidth     =   6540
   Icon            =   "fmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3630
   ScaleWidth      =   6540
   Begin VB.Frame frStack 
      Caption         =   "Stack Management"
      Height          =   750
      Left            =   210
      TabIndex        =   11
      Top             =   2415
      Width           =   6210
      Begin VB.CommandButton cmdPop 
         Caption         =   "Pop"
         Height          =   330
         Left            =   5145
         TabIndex        =   13
         Top             =   315
         Width           =   855
      End
      Begin VB.CommandButton cmdPush 
         Caption         =   "Push"
         Height          =   330
         Left            =   4200
         TabIndex        =   12
         Top             =   315
         Width           =   855
      End
      Begin VB.Label lblLevel 
         Caption         =   "0"
         Height          =   225
         Left            =   1155
         TabIndex        =   15
         Top             =   315
         Width           =   645
      End
      Begin VB.Label lblStackLevel 
         Alignment       =   1  'Right Justify
         Caption         =   "Stack Level:"
         Height          =   225
         Left            =   105
         TabIndex        =   14
         Top             =   315
         Width           =   960
      End
   End
   Begin VB.Frame frVariables 
      Caption         =   "Variable Info"
      Height          =   1275
      Left            =   210
      TabIndex        =   4
      Top             =   1050
      Width           =   6210
      Begin VB.CommandButton cmdGet 
         Caption         =   "Get"
         Height          =   330
         Left            =   5145
         TabIndex        =   10
         Top             =   735
         Width           =   855
      End
      Begin VB.CommandButton cmdSet 
         Caption         =   "Set"
         Height          =   330
         Left            =   5145
         TabIndex        =   9
         Top             =   315
         Width           =   855
      End
      Begin VB.TextBox txtValue 
         Height          =   330
         Left            =   1155
         TabIndex        =   8
         Top             =   735
         Width           =   3690
      End
      Begin VB.TextBox txtName 
         Height          =   330
         Left            =   1155
         TabIndex        =   7
         Top             =   315
         Width           =   3690
      End
      Begin VB.Label lblVValue 
         Alignment       =   1  'Right Justify
         Caption         =   "Value"
         Height          =   225
         Left            =   105
         TabIndex        =   6
         Top             =   840
         Width           =   855
      End
      Begin VB.Label lnlVName 
         Alignment       =   1  'Right Justify
         Caption         =   "Name"
         Height          =   225
         Left            =   105
         TabIndex        =   5
         Top             =   420
         Width           =   855
      End
   End
   Begin VB.Frame frValues 
      Caption         =   "Operating Scope"
      Height          =   855
      Left            =   210
      TabIndex        =   1
      Top             =   105
      Width           =   6210
      Begin VB.OptionButton optGlobal 
         Caption         =   "Get and Set variables globally"
         Height          =   225
         Left            =   3360
         TabIndex        =   3
         Top             =   420
         Value           =   -1  'True
         Width           =   2640
      End
      Begin VB.OptionButton optLocal 
         Caption         =   "Get and Set variables locally only"
         Height          =   225
         Left            =   210
         TabIndex        =   2
         Top             =   420
         Width           =   2745
      End
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   330
      Left            =   5355
      TabIndex        =   0
      Top             =   3255
      Width           =   855
   End
End
Attribute VB_Name = "fmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'**
' This form is a small demo of the VarSpace Runtime Stack
' @author Andrew Friedl
'*
Option Explicit

Dim vs As VarStack

Dim WithEvents vtCaption As VarTrace
Attribute vtCaption.VB_VarHelpID = -1
Dim WithEvents vtAutoInc As VarTrace
Attribute vtAutoInc.VB_VarHelpID = -1

Private Sub cmdExit_Click()
    Unload Me
End Sub

Private Sub cmdGet_Click()
    Dim v As Variant
    v = ""
    If vs.GetValue(txtName.Text, v, optLocal.Value) Then
        txtValue.Text = CStr(v)
    Else
        txtValue = "Variable not found!"
    End If
End Sub

Private Sub cmdPop_Click()
    Err.Clear
    On Error Resume Next
    vs.Pop
    If Err.Number <> 0 Then
        MsgBox Err.Description, vbCritical, "Stack Error"
        Err.Clear
    End If
    lblLevel.Caption = CStr(vs.Count)
End Sub

Private Sub cmdPush_Click()
    vs.Push
    lblLevel.Caption = CStr(vs.Count)
End Sub

Private Sub cmdSet_Click()
    Call vs.SetValue(txtName.Text, txtValue, , optLocal)
End Sub

Private Sub Form_Load()
    Set vs = New VarStack
    Call vs.SetValue("Caption", Me.Caption)
    Call vs.SetValue("AutoInc", -1, True)
    Set vtCaption = vs.Peek(0).SetTrace("Caption")
    Set vtAutoInc = vs.Peek(0).SetTrace("AutoInc")
End Sub

Private Sub vtAutoInc_TraceRead(Value As Variant)
    Value = CLng(Value) + 1
End Sub

Private Sub vtCaption_TraceRead(Value As Variant)
    Value = Me.Caption
End Sub

Private Sub vtCaption_TraceWrite(OldValue As Variant, NewValue As Variant)
    Me.Caption = CStr(NewValue)
End Sub
