VERSION 5.00
Object = "{23F895D7-45A6-4886-931B-89D88C2857ED}#2.0#0"; "iGrid250_75B4A91C.ocx"
Begin VB.Form frmScrlBars 
   Caption         =   "Playing with Scroll Bars"
   ClientHeight    =   4950
   ClientLeft      =   660
   ClientTop       =   1050
   ClientWidth     =   9390
   Icon            =   "ScrlBars.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   4950
   ScaleWidth      =   9390
   Begin VB.PictureBox picInfo 
      Height          =   4035
      Left            =   4260
      ScaleHeight     =   3975
      ScaleWidth      =   4815
      TabIndex        =   2
      Top             =   780
      Width           =   4875
      Begin VB.CommandButton cmbShowHSBInfo 
         Caption         =   "Show HScrollBar Info"
         Height          =   315
         Left            =   1980
         TabIndex        =   13
         Top             =   1140
         Width           =   1755
      End
      Begin VB.CommandButton cmdShowVSBInfo 
         Caption         =   "Show VScrollBar Info"
         Height          =   315
         Left            =   120
         TabIndex        =   12
         Top             =   1140
         Width           =   1755
      End
      Begin VB.CommandButton cmdChangeHSBValue 
         Caption         =   "Change"
         Height          =   315
         Left            =   3000
         TabIndex        =   11
         Top             =   720
         Width           =   1155
      End
      Begin VB.TextBox txtHSBValue 
         Height          =   285
         Left            =   2100
         TabIndex        =   10
         Text            =   "0"
         Top             =   720
         Width           =   795
      End
      Begin VB.CommandButton cmdChangeVSBValue 
         Caption         =   "Change"
         Height          =   315
         Left            =   3000
         TabIndex        =   8
         Top             =   360
         Width           =   1155
      End
      Begin VB.TextBox txtVSBValue 
         Height          =   285
         Left            =   2100
         TabIndex        =   7
         Text            =   "0"
         Top             =   360
         Width           =   795
      End
      Begin VB.ListBox lstEvents 
         Height          =   2010
         Left            =   60
         TabIndex        =   3
         Top             =   1860
         Width           =   4695
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         Caption         =   "Horizontal Scroll Bar Value:"
         Height          =   195
         Index           =   1
         Left            =   120
         TabIndex        =   9
         Top             =   750
         Width           =   1920
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         Caption         =   "Vertical Scroll Bar Value:"
         Height          =   195
         Index           =   0
         Left            =   120
         TabIndex        =   6
         Top             =   390
         Width           =   1740
      End
      Begin VB.Label Label2 
         Alignment       =   2  'Center
         BackColor       =   &H80000010&
         Caption         =   "Scroll Bar Events:"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H8000000E&
         Height          =   195
         Index           =   2
         Left            =   60
         TabIndex        =   5
         Top             =   1560
         Width           =   4665
      End
      Begin VB.Label Label2 
         Alignment       =   2  'Center
         BackColor       =   &H80000010&
         Caption         =   "Change Scroll Bar Properties:"
         BeginProperty Font 
            Name            =   "Tahoma"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H8000000E&
         Height          =   195
         Index           =   1
         Left            =   60
         TabIndex        =   4
         Top             =   60
         Width           =   4665
      End
   End
   Begin iGrid250_75B4A91C.iGrid iGrid1 
      Height          =   4035
      Left            =   120
      TabIndex        =   1
      Top             =   780
      Width           =   3975
      _ExtentX        =   7011
      _ExtentY        =   7117
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Label Label1 
      Caption         =   $"ScrlBars.frx":0442
      Height          =   495
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   9135
   End
End
Attribute VB_Name = "frmScrlBars"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function SendMessageByLong Lib "user32" Alias "SendMessageA" _
   (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Const WM_VSCROLL = &H115
Private Const SB_BOTTOM = 7

Private m_bShowToolTip As Boolean

Private Sub cmdChangeHSBValue_Click()
   iGrid1.HScrollBar.Value = CLng(txtHSBValue)
End Sub

Private Sub cmdChangeVSBValue_Click()
   iGrid1.VScrollBar.Value = CLng(txtVSBValue)
End Sub

Private Sub cmdShowVSBInfo_Click()
   With iGrid1.VScrollBar
      MsgBox _
         "Value: " & .Value & vbCrLf & _
         "Min. value: " & .Min & vbCrLf & _
         "Max. value: " & .Max & vbCrLf & _
         "Large change: " & .LargeChange & vbCrLf & _
         "Small change: " & .SmallChange & vbCrLf & _
         "Visible: " & .Visible & vbCrLf & _
         "Width: " & .Thickness _
         , , "Vertical Scroll Bar Info"
   End With
End Sub

Private Sub cmbShowHSBInfo_Click()
   With iGrid1.HScrollBar
      MsgBox _
         "Value: " & .Value & vbCrLf & _
         "Min. value: " & .Min & vbCrLf & _
         "Max. value: " & .Max & vbCrLf & _
         "Large change: " & .LargeChange & vbCrLf & _
         "Small change: " & .SmallChange & vbCrLf & _
         "Visible: " & .Visible & vbCrLf & _
         "Height: " & .Thickness _
         , , "Horizontal Scroll Bar Info"
   End With
End Sub

Private Sub Form_Load()
   Dim iRow As Long
   Dim iCol As Long
   
   With iGrid1
      .Redraw = False
      
      For iCol = 1 To 5
         .AddCol sHeader:="Column " & iCol, lWidth:=92
      Next
      
      .RowCount = 30
      
      For iRow = 1 To .RowCount
         For iCol = 1 To .ColCount
            .CellValue(iRow, iCol) = "Row " & iRow & ", Col " & iCol
         Next
      Next
      
      .Redraw = True
   End With
   
   gpTextBoxNumOnly txtHSBValue
   gpTextBoxNumOnly txtVSBValue
End Sub

Private Sub Form_Resize()
   On Error Resume Next
   With picInfo
      .Move Me.ScaleWidth - .Width - 120, .Top, .Width, Me.ScaleHeight - .Top - 120
   End With
   With iGrid1
      .Move 120, .Top, picInfo.Left - 240, Me.ScaleHeight - .Top - 120
   End With
End Sub

Private Sub pAddEvent(psEvent As String)
   Static s_lEventsCount As Long
   
   s_lEventsCount = s_lEventsCount + 1
   
   With lstEvents
      If .ListCount = 1000 Then
         .RemoveItem 0
      End If
      .AddItem s_lEventsCount & ". " & psEvent
      SendMessageByLong .hWnd, WM_VSCROLL, SB_BOTTOM, 0
   End With
End Sub

Private Sub iGrid1_ScrollBarEndScroll(ByVal eBar As iGrid250_75B4A91C.EScrollBar)
   pAddEvent "ScrollBarEndScroll" & _
         ", Scrollbar: " & IIf(eBar = igScrollBarH, "H", "V")
   Unload frmScrlBarTollTip
   m_bShowToolTip = False
End Sub

Private Sub iGrid1_ScrollBarPosChanged(ByVal eBar As iGrid250_75B4A91C.EScrollBar, ByVal lValue As Long)
   pAddEvent "ScrollBarPosChanged" & _
         ", Scrollbar: " & IIf(eBar = igScrollBarH, "H", "V") & _
         ", Value: " & lValue
   If eBar = igScrollBarH Then
      txtHSBValue.Text = lValue
   Else
      txtVSBValue.Text = lValue
   End If
End Sub

Private Sub iGrid1_ScrollBarThicknessChanged(ByVal eBar As iGrid250_75B4A91C.EScrollBar, ByVal lValue As Long)
   pAddEvent "ScrollBarThicknessChanged" & _
         ", Scrollbar: " & IIf(eBar = igScrollBarH, "H", "V") & _
         ", Value: " & lValue
End Sub

Private Sub iGrid1_ScrollBarThumbTrack(ByVal eBar As iGrid250_75B4A91C.EScrollBar, ByVal lValue As Long)
   pAddEvent "ScrollBarThumbTrack" & _
         ", Scrollbar: " & IIf(eBar = igScrollBarH, "H", "V") & _
         ", Value: " & lValue
         
   With frmScrlBarTollTip
      If Not m_bShowToolTip Then
         If eBar = igScrollBarV Then
            .Move Me.Left + iGrid1.Left + iGrid1.Width - .Width - iGrid1.VScrollBar.Thickness * Screen.TwipsPerPixelX, _
                  Me.Top + iGrid1.Top + iGrid1.Height / 2 - .Height / 2
         Else
            .Move Me.Left + iGrid1.Left + iGrid1.Width / 2 - .Width / 2, _
                  Me.Top + iGrid1.Top + iGrid1.Height + 500
         End If
         .Show
         m_bShowToolTip = True
      End If
      .LabelPos = lValue
      DoEvents ' this statement allows to instantly redraw the label that shows the current position
   End With
End Sub

Private Sub iGrid1_ScrollBarVisibilityChanged(ByVal eBar As iGrid250_75B4A91C.EScrollBar, ByVal bVisible As Boolean)
   pAddEvent "ScrollBarVisibilityChanged" & _
         ", Scrollbar: " & IIf(eBar = igScrollBarH, "H", "V") & _
         ", Visible: " & bVisible
End Sub

Private Sub picInfo_Resize()
   On Error Resume Next
   With lstEvents
      .Move .Left, .Top, .Width, picInfo.Height - .Top - 60
   End With
End Sub
