#include "stdafx.h"
#include "sgRegExp.h"  
#include "Substrings.h"
#include "Substring.h"
#include "clsRegExp.h"


HRESULT Substrings::Init(const class Regexp& re)
{
	delete [] m_Items;
	m_Items = 0;
	m_Count = (short)(re.SubStrings() + 1);
	if (m_Count != 0)
	{
		m_Items = new CComVariant[m_Count];
		for (short i = 0; i < m_Count; i++)
		{
			CComObject<Substring>* substr = new CComObject<Substring>;
			if (substr == 0)
				return E_OUTOFMEMORY;
			substr->m_Value  = re[i].c_str();
			substr->m_Start  = re.SubStart(i);
			substr->m_Length = re.SubLength(i);

			IDispatch* pDisp;
			HRESULT hr = substr->QueryInterface(IID_IDispatch, reinterpret_cast<void**>(&pDisp));
			if (FAILED(hr))
			{
				delete substr;
				return hr;
			}
			m_Items[i] = pDisp;
			pDisp->Release();
		}
	}
	return S_OK;
}

STDMETHODIMP Substrings::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] =  
	{
		&IID_ISubstrings,
	};
	for (int i=0;i<sizeof(arr)/sizeof(arr[0]);i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}


STDMETHODIMP Substrings::get__NewEnum(/*[out, retval]*/ IUnknown** retval)
{
	if (retval == 0)
		return E_POINTER;
	if (m_Items == 0)
		return E_FAIL;

	*retval = 0;
	typedef CComEnum<IEnumVARIANT, &IID_IEnumVARIANT, VARIANT, _Copy<VARIANT> > EnumVar;
	CComObject<EnumVar>* ev = new CComObject<EnumVar>;
	HRESULT hr = ev->Init(m_Items, m_Items + m_Count, NULL, AtlFlagNoCopy);
	if (SUCCEEDED(hr))
	{
		//hr = ev->QueryInterface(IID_IEnumVARIANT, reinterpret_cast<void**>(retval));
		hr = ev->QueryInterface(IID_IUnknown, reinterpret_cast<void**>(retval));
	}
	if (FAILED(hr))
		delete ev;

	return hr;
}

STDMETHODIMP Substrings::get_Item(/*[in]*/ short index, /*[out, retval]*/ ISubstring** retval)
{
	if (retval == 0)
		return E_POINTER;
	if ((index < 0) || (index >= m_Count))
		return E_INVALIDARG;

	HRESULT hr = m_Items[index].punkVal->QueryInterface(IID_ISubstring, reinterpret_cast<void**>(retval));
	if (FAILED(hr))
		return AtlReportError(CLSID_Substrings, IDS_ERR_NOSUBSTRING, GUID_NULL, hr);
	return hr;
}

STDMETHODIMP Substrings::get_Count(/*[out, retval]*/ short* retval)
{
	if (retval == 0)
		return E_POINTER;

	*retval = m_Count;
	return S_OK;
}
