//******************************************************
// SPRINT - Print & Preview engine for Delphi
// WWW.SMART.CO.YU
//******************************************************

unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, Buttons, ShellAPI,
  Report1,Report2,Report3,Report4,Report5,Report6,Report7, SPrint;

type
  TForm1 = class(TForm)
    ExitBtn: TBitBtn;
    TCaption: TLabel;
    TDetail: TLabel;
    SPrint1: TSPrint;
    Image2: TImage;
    Label1: TLabel;
    Rep1: TLabel;
    Rep3: TLabel;
    Rep4: TLabel;
    Rep5: TLabel;
    Rep6: TLabel;
    Rep7: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Preview: TLabel;
    Print: TLabel;
    Rep2: TLabel;
    Image1: TImage;
    procedure ExitBtnClick(Sender: TObject);
    procedure SelectReport(Sender: TObject);
    procedure Text(i:integer);
    procedure FormShow(Sender: TObject);
    procedure HelpClick(Sender: TObject);
    procedure wwwClick(Sender: TObject);
    procedure RegistrationClick(Sender: TObject);
    procedure PreviewClick(Sender: TObject);
    procedure PrintClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ExitBtnClick(Sender: TObject);
begin
   Application.Terminate;
end;

procedure TForm1.Text(i:integer);
begin
   tag:=i;
   if i=-1 then begin
      TCaption.Caption:='How to register?';
      TDetail.Caption:=
         'All registering and pricing related questions are'#13+
         'answered in the REGISTERING chapter of user'+chr(39)+'s manual.';
   end;
   if i=0 then begin
      TCaption.Caption:='Welcome to SPRINT Demo';
      TDetail.Caption:=
         'This demo software will demonstrate how SPRINT engine can be used to print various reports with Delphi.'#13#13+
         'With SPRINT any printing can be done with ease.'#13#13+
         'Choose report type (left), and then click preview or print to see results.'#13#13+
         'HAVE A NICE PRINT';
   end;
   if i=1 then begin
      TCaption.Caption:='Low level drawing demo report';
      TDetail.Caption:=
         'In this demo report you can see:'#13#13+
         '* how to work with margins'#13+
         '* how to draw lines'#13+
         '* how to draw areas'#13+
         '* how to print text with low level functions'#13+
         '* how to print bitmap or vector pictures'#13+
         '* how to draw on SPrintCanvas'#13+
         '* how to color your reports'#13#13+
         'Source: Report1.pas';
   end;
   if i=2 then begin
      TCaption.Caption:='Simple multi-column report';
      TDetail.Caption:=
         'In this demo report you can see:'#13#13+
         '* how to define styles'#13+
         '* how to define report fields'#13+
         '* how to use high level functions'#13+
         '* how easy report creating can be'#13#13+
         'Source: Report2.pas'#13#13+
         '(BDE + DBDEMOS required)';
   end;
   if i=3 then begin
      TCaption.Caption:='Simple multi-column, grouped report';
      TDetail.Caption:=
         'In this demo report you can see:'#13#13+
         '* how to define styles'#13+
         '* how to define report fields'#13+
         '* how to use high level functions'#13#13+
         '+ how to combine styles'#13#13+
         'Source: Report3.pas'#13#13+
         '(BDE + DBDEMOS required)';
   end;
   if i=4 then begin
      TCaption.Caption:='Multi-column, multi-group report';
      TDetail.Caption:=
         'In this demo report you can see:'#13#13+
         '* how to define styles'#13+
         '* how to define report fields'#13+
         '* how to use high level functions'#13+
         '* how to combine styles'#13#13+
         '+ how to create unlimited grouping depth'#13#13+
         'Source: Report4.pas'#13#13+
         '(BDE + DBDEMOS required)';
   end;
   if i=5 then begin
      TCaption.Caption:='We really made this one complicated';
      TDetail.Caption:=
         'In this demo report you can see:'#13#13+
         '* how to define styles'#13+
         '* how to define report fields'#13+
         '* how to use high level functions'#13+
         '* how to combine styles'#13+
         '* how to create unlimited grouping depth'#13#13+
         '+ how to think creative in order to create good-looking documents'#13#13+
         'Source: Report5.pas'#13#13+
         '(BDE + DBDEMOS required)';
   end;
   if i=6 then begin
      TCaption.Caption:='Let'+chr(39)+'s print our own documentation';
      TDetail.Caption:=
         'In this demo report you can see:'#13#13+
         '* how to envelop SPRINT engine with even more'#13+
         'sophisticated functions'#13+
         '* how to print formated (RTF) documents'#13#13+
         'Source: Report6.pas';
   end;
   if i=7 then begin
      TCaption.Caption:='Unleashed SPRINT power!';
      TDetail.Caption:=
         'NO LIMITS... EXCEPT YOUR IMAGINATION'#13#13+
         'Source: Report7.pas';
   end;
   if i<=0 then begin
   end;
   Preview.Visible:=(i>0);
   Print.Visible:=(i>0);
end;

procedure TForm1.SelectReport(Sender: TObject);
begin
   if TLabel(Sender).Name='Rep1' then text(1);
   if TLabel(Sender).Name='Rep2' then text(2);
   if TLabel(Sender).Name='Rep3' then text(3);
   if TLabel(Sender).Name='Rep4' then text(4);
   if TLabel(Sender).Name='Rep5' then text(5);
   if TLabel(Sender).Name='Rep6' then text(6);
   if TLabel(Sender).Name='Rep7' then text(7);
end;

procedure TForm1.FormShow(Sender: TObject);
begin
   Text(0);
end;

procedure TForm1.HelpClick(Sender: TObject);
begin
   Text(0);
end;

procedure TForm1.wwwClick(Sender: TObject);
var WWWPATH:string;
begin
   WWWPATH:='http://www.smart.co.yu/sprint.html';
   if ShellExecute(  Application.Handle,
                     PChar('open'),
                     PChar(WWWPATH),
                     PChar(''),nil,SW_NORMAL) < 33 then
   if ShellExecute(  Application.Handle,PChar('open'),
                     PChar('netscape.exe'),
                     PChar(WWWPATH),
                     nil,SW_NORMAL) < 32 then
   if ShellExecute(  Application.Handle,PChar('open'),
                     PChar('iexplore.exe'),
                     PChar(WWWPATH),
                     nil,SW_NORMAL) < 32 then
   showmessage ('Error: starting internet browser. Go to WWW.SMART.CO.YU manually.');
end;

procedure TForm1.RegistrationClick(Sender: TObject);
begin
   Text(-1);
end;

procedure TForm1.PreviewClick(Sender: TObject);
begin
   if tag=1 then Report_1(True);
   if tag=2 then Report_2(True);
   if tag=3 then Report_3(True);
   if tag=4 then Report_4(True);
   if tag=5 then Report_5(True);
   if tag=6 then Report_6(True);
   if tag=7 then Report_7(True);
end;

procedure TForm1.PrintClick(Sender: TObject);
begin
   if tag=1 then Report_1(False);
   if tag=2 then Report_2(False);
   if tag=3 then Report_3(False);
   if tag=4 then Report_4(False);
   if tag=5 then Report_5(False);
   if tag=6 then Report_6(False);
   if tag=7 then Report_7(False);
end;

end.
       