VERSION 5.00
Begin VB.UserControl LiteBtnCtrl 
   CanGetFocus     =   0   'False
   ClientHeight    =   390
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   1500
   MouseIcon       =   "LiteBtn.ctx":0000
   MousePointer    =   99  'Custom
   ScaleHeight     =   26
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   100
   ToolboxBitmap   =   "LiteBtn.ctx":030A
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   10
      Left            =   300
      Top             =   60
   End
   Begin VB.Line lineRight 
      BorderColor     =   &H80000010&
      X1              =   80
      X2              =   80
      Y1              =   0
      Y2              =   48
   End
   Begin VB.Line lineLeft 
      BorderColor     =   &H80000014&
      X1              =   0
      X2              =   0
      Y1              =   0
      Y2              =   48
   End
   Begin VB.Line lineBottom 
      BorderColor     =   &H80000010&
      X1              =   0
      X2              =   156
      Y1              =   20
      Y2              =   20
   End
   Begin VB.Line lineTop 
      BorderColor     =   &H80000014&
      X1              =   0
      X2              =   156
      Y1              =   0
      Y2              =   0
   End
End
Attribute VB_Name = "LiteBtnCtrl"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const BUTTON_HIGHLIGHT = &H80000014
Private Const BUTTON_SHADOW = &H80000010
Private Const TOOLTIP = &H80000018
Private Const BUTTON_FACE = &H8000000F

Private Const MIN_SHIFT = 1
Private Const CAPTION_MARGIN = 8

Private Type POINTAPI
    X As Long
    y As Long
End Type

Private Declare Function GetCursorPos Lib "user32" (lpPoint As POINTAPI) As Long
Private Declare Function WindowFromPoint Lib "user32" (ByVal xPoint As Long, ByVal yPoint As Long) As Long

Private Type RECT
    Left As Long
    Top As Long
    Right As Long
    Bottom As Long
End Type

Private Declare Function GetClientRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Private Declare Function DrawText Lib "user32" Alias "DrawTextA" (ByVal hdc As Long, ByVal lpStr As String, ByVal nCount As Long, lpRect As RECT, ByVal wFormat As Long) As Long

Private Const DT_LEFT = &H0
Private Const DT_CENTER = &H1
Private Const DT_RIGHT = &H2
Private Const DT_VCENTER = &H4
Private Const DT_BOTTOM = &H8
Private Const DT_WORDBREAK = &H10
Private Const DT_SINGLELINE = &H20
Private Const DT_CALCRECT = &H400

Private Declare Function OffsetRect Lib "user32" (lpRect As RECT, ByVal X As Long, ByVal y As Long) As Long

Dim mblnHighl As Boolean
Dim mCaption As String, mHotKeyCaption As String
Dim mCaptionStyle As ECaptionStyle

Public Event Click()
Public Event MouseOver()
Public Event MouseLeave()

Public Enum ECaptionStyle
    csSingleLineLeft
    csSingleLineCenter
    csMultiLine
End Enum

Private Sub Timer1_Timer()
   If Not MouseIsInControl(hwnd) Then
      Timer1.Enabled = False
      mblnHighl = False
      BackColor = BUTTON_FACE
      PaintAllCaptions
        
      RaiseEvent MouseLeave
   End If
End Sub

Private Sub UserControl_InitProperties()
   Caption = Extender.Name
   CaptionStyle = csSingleLineCenter
End Sub

Private Sub UserControl_MouseDown(Button As Integer, Shift As Integer, X As Single, y As Single)
   lineTop.BorderColor = BUTTON_SHADOW
   lineLeft.BorderColor = BUTTON_SHADOW
   lineRight.BorderColor = BUTTON_HIGHLIGHT
   lineBottom.BorderColor = BUTTON_HIGHLIGHT
    
   PaintAllCaptions True
End Sub

Private Sub UserControl_MouseMove(Button As Integer, Shift As Integer, X As Single, y As Single)
   If Not mblnHighl Then
      BackColor = TOOLTIP
      PaintAllCaptions
      mblnHighl = True
      Timer1.Enabled = True
        
      RaiseEvent MouseOver
   End If
End Sub

Private Sub UserControl_MouseUp(Button As Integer, Shift As Integer, X As Single, y As Single)
   lineTop.BorderColor = BUTTON_HIGHLIGHT
   lineLeft.BorderColor = BUTTON_HIGHLIGHT
   lineRight.BorderColor = BUTTON_SHADOW
   lineBottom.BorderColor = BUTTON_SHADOW
    
   PaintAllCaptions
    
   RaiseEvent Click
End Sub

Private Sub UserControl_Paint()
   PaintAllCaptions
End Sub

Private Sub UserControl_Resize()
   lineTop.X2 = ScaleWidth - MIN_SHIFT
    
   lineLeft.Y2 = ScaleHeight - MIN_SHIFT
    
   lineRight.X1 = ScaleWidth - MIN_SHIFT
   lineRight.X2 = ScaleWidth - MIN_SHIFT
   lineRight.Y2 = ScaleHeight
    
   lineBottom.X2 = ScaleWidth
   lineBottom.Y1 = ScaleHeight - MIN_SHIFT
   lineBottom.Y2 = ScaleHeight - MIN_SHIFT
End Sub

Public Property Get CaptionStyle() As ECaptionStyle
   CaptionStyle = mCaptionStyle
End Property

Public Property Let CaptionStyle(ByVal NewValue As ECaptionStyle)
   mCaptionStyle = NewValue
   PaintAllCaptions
   PropertyChanged "CaptionStyle"
End Property

Public Property Get Caption() As String
   Caption = mCaption
End Property

Public Property Let Caption(ByVal NewValue As String)
   mCaption = NewValue
   PaintAllCaptions
   PropertyChanged "Caption"
End Property

Public Property Get HotKeyCaption() As String
   HotKeyCaption = mHotKeyCaption
End Property

Public Property Let HotKeyCaption(ByVal NewValue As String)
   mHotKeyCaption = NewValue
   PaintAllCaptions
   PropertyChanged "HotKeyCaption"
End Property

Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
   PropBag.WriteProperty "Caption", mCaption, Extender.Name
   PropBag.WriteProperty "HotKeyCaption", mHotKeyCaption, ""
   PropBag.WriteProperty "CaptionStyle", mCaptionStyle, ECaptionStyle.csMultiLine
End Sub

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
   Caption = PropBag.ReadProperty("Caption", Extender.Name)
   HotKeyCaption = PropBag.ReadProperty("HotKeyCaption", "")
   CaptionStyle = PropBag.ReadProperty("CaptionStyle", ECaptionStyle.csMultiLine)
End Sub

Private Function MouseIsInControl(ByVal hwnd As Long) As Boolean
   Dim P As POINTAPI
   GetCursorPos P
   MouseIsInControl = (hwnd = WindowFromPoint(P.X, P.y))
End Function

Private Sub PaintAllCaptions(Optional pShift As Boolean = False)
   Dim Box As RECT, CalcBox As RECT
    
   GetClientRect hwnd, Box
    
   Box.Left = CAPTION_MARGIN
   Box.Right = Box.Right - CAPTION_MARGIN
   
   If mCaptionStyle = csMultiLine Then
      LSet CalcBox = Box
      DrawText UserControl.hdc, mCaption, Len(mCaption), CalcBox, _
         DT_WORDBREAK + DT_CENTER + DT_CALCRECT
      Box.Top = (Box.Bottom - CalcBox.Bottom) \ 2
      Box.Bottom = Box.Bottom - Box.Top
   Else
      Box.Top = CAPTION_MARGIN
      Box.Bottom = Box.Bottom - CAPTION_MARGIN
   End If
   
   If pShift Then OffsetRect Box, 1, 1
    
   Cls
    
   Select Case mCaptionStyle
   Case csSingleLineLeft
      DrawText UserControl.hdc, mCaption, Len(mCaption), Box, _
         DT_LEFT + DT_VCENTER + DT_SINGLELINE
      DrawText UserControl.hdc, mHotKeyCaption, Len(mHotKeyCaption), _
         Box, DT_RIGHT + DT_VCENTER + DT_SINGLELINE
   Case csSingleLineCenter
      DrawText UserControl.hdc, mCaption, Len(mCaption), Box, _
         DT_CENTER + DT_VCENTER + DT_SINGLELINE
      DrawText UserControl.hdc, mHotKeyCaption, Len(mHotKeyCaption), _
         Box, DT_RIGHT + DT_VCENTER + DT_SINGLELINE
   Case csMultiLine
      DrawText UserControl.hdc, mCaption, Len(mCaption), Box, _
         DT_WORDBREAK + DT_CENTER
      DrawText UserControl.hdc, mHotKeyCaption, Len(mHotKeyCaption), _
         Box, DT_RIGHT + DT_BOTTOM + DT_SINGLELINE
   End Select
End Sub

