#ifdef WINDOWS
#include <windows.h>
#endif
#include "chup.hh"
#include "psock.hh"
#include "conf.h"
#include "h.h"
#include <stdio.h>
#include <string.h>
#ifdef WINDOWS
#include <process.h>
#include "win/h2.h"
#else
#include <pthread.h>
#endif
#include "compat.hh"

void UpdateErr()
{
    MessageBox(hwnd, "Invalid update return format. Please contact author.",
	       "Ad Buster update", MB_OK | MB_ICONERROR);
}

void CheckUpdate2(LPVOID par);

void CheckUpdate(bool batch)
{
#ifdef WINDOWS
  HANDLE h = (HANDLE) _beginthread((void (*)(void *)) CheckUpdate2,
				   0, (void *) batch);
  if (h != INVALID_HANDLE_VALUE)
    CloseHandle(h);
#else
  pthread_t t;
  pthread_create(&t, 0, (void * (*)(void *)) CheckUpdate2, (void *) batch);
#endif
}

void CheckUpdate2(LPVOID par)
{
  bool batch = (bool) par;
  PSock *p = new PSock;
//  printf("c1 %d\n", listen_port);
  p->Connect("localhost", listen_port);
//  printf("c2\n");
  p->SendStr("GET http://lide.punknet.cz/miri/adbuster.update?v=" ADB_VERSION " HTTP/1.0\r\nHost: lide.punknet.cz\r\n\r\n");  
//  p->SendStr("GET http://www.kolej.mff.cuni.cz/~miri/adbuster.update?v=" ADB_VERSION " HTTP/1.0\r\nHost: www.kolej.mff.cuni.cz\r\n\r\n");
//  printf("c3\n");  
  const int bsize = 60000;
  char *buf = new char[bsize];
  int ret, r;
  for(ret = 0, r = 1; r > 0 && ret < bsize; ) {
    r = p->Recv(buf+ret, bsize-ret);
//    printf("%d %d\n", ret, r);
    if (r > 0)
      ret += r;
  }
//  printf("%s\n", buf);
  if (r < 0)
    MessageBox(hwnd, "Error while checking for Ad Buster update",
	       "Ad Buster update", MB_ABORTRETRYIGNORE | MB_ICONERROR);
  else {
    char *bufe = buf+ret;
    *bufe = 0;
    char *b = strstr(buf, "adbstart\n");
    if (!b) {
      UpdateErr();
    } else {
      b += 9;
      int v1, v2;
      if (sscanf(b, "last: %d.%d\n", &v1, &v2) != 2) {
	UpdateErr();
      } else if (v1 == adb_version_major && v2 == adb_version_minor) {
	if (!batch)
	  MessageBox(hwnd, "You have already lastest version.",
		     "Ad Buster update", MB_OK | MB_ICONINFORMATION);
      } else if (v1 < adb_version_major || (v1 == adb_version_major && v2 < adb_version_minor)) {
	MessageBox(hwnd, "You have newer version of Ad Buster than author! Please send me your patches!",
		   "Ad Buster update", MB_OK | MB_ICONERROR);
      } else {
	MessageBox(hwnd, "Updated version of Ad Buster is available. Please check Ad Buster homepage for more information.",
		   "Ad Buster update", MB_OK | MB_ICONEXCLAMATION);
	OpenHomepage();
      }
    }
  }
  delete buf;
  delete p;
#ifdef WINDOWS
#ifdef __MINGW32__
   _endthread();
#else
   ExitThread(0);
#endif
#else
  pthread_exit(0);
#endif
}

void OpenHomepage()
{
#ifdef WINDOWS
  ShellExecute(hwnd, "open", "http://lide.punknet.cz/miri/adbuster.html?v=" ADB_VERSION, NULL, NULL, 0);
#endif
}
