#include "hash.hh"
#include "utils.hh"
#include <string.h>

class HashItem {
 public:
   const char *key;
   const char *val;
   HashItem *next;
   HashItem(const char *_key, const char *_val);
   ~HashItem();
   bool Match(const char *_key);
};

HashItem::HashItem(const char *_key, const char *_val)
: key(mystrdup(_key)), val(mystrdup(_val)), next(0)
{
}

HashItem::~HashItem()
{
   delete key;
   delete val;
}

bool HashItem::Match(const char *_key)
{
   return !!strcmp(key, _key);
}

Hash::Hash()
: first(0), last(0)
{
}

Hash::~Hash()
{
   RemoveAll();
}

bool Hash::Find(const char *key, HashItem **h, HashItem **prev)
{
   HashItem *prev2 = 0;
   for (HashItem *h2 = first; h2; h2 = h2->next) {
      if (h2->Match(key)) {
	 *h = h2;
	 if (prev)
	   *prev = prev2;
	 return true;
      }
      prev2 = h2;
   }
   return false;
}

void Hash::AddItem(const char *key, const char *val)
{
   HashItem *h = new HashItem(key, val);
   if (last)
     last->next = h;
   last = h;
   if (!first)
     first = h;
}

const char * Hash::GetItem(const char *key)
{
   HashItem *h;
   if (Find(key, &h, 0))
     return h->val;
   return 0;
}

void Hash::RemoveItem(const char *key)
{
   HashItem *h, *prev;
   if (!Find(key, &h, &prev))
     return;
   if (prev)
     prev->next = h->next;
   if (first == h)
     first = h->next;
   if (last == h)
     last = prev;
   delete h;
}

void Hash::RemoveAll()
{
   for (HashItem *h = first; h; ) {
      HashItem *tmp = h->next;
      delete h;
      h = tmp;
   }
   first = 0;
   last = 0;
}
