#include <windows.h>
#ifndef __MINGW32__
#include <commctrl.h>
#endif
#include "win\rsc.h"
#include "win\status.h"
#include <stdio.h>
#include <string.h>
#include "parse.h"
#include "block.h"
#include "adb.h"
#include "h.h"
#include "utils.hh"
#include "win\errlist.hh"
#include "blist.hh"
#include "conf.h"
#include "chup.hh"
#include "hcom.hh"
#include "about.hh"

HINSTANCE hInstance;
HWND hwnd, hlst;
HMENU hmenu;
HWND hdlg = 0;
HWND hstatus;
HWND herrlst;

BOOL CALLBACK AddEntryDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
void WindowResize(int x, int y);

SECURITY_ATTRIBUTES secattr = { sizeof(SECURITY_ATTRIBUTES), NULL, TRUE };

HANDLE print_mutex = INVALID_HANDLE_VALUE;

void PrintStatus(const char *host, int port, const char *path)
{
   WaitForSingleObject(print_mutex, INFINITE);
   char *s = new char[mystrlen(host)+mystrlen(path)+100];
   if (port != 80)
     sprintf(s, "http://%s:%i/%s", host, port, path);
   else
     sprintf(s, "http://%s/%s", host, path); /* should be snprintf */
   SendMessage(hstatus, SB_SETTEXT, 1, (LPARAM) s);
   SendMessage(hstatus, WM_PAINT, 0, 0);
   delete s;
   ReleaseMutex(print_mutex);
}

void PrintThreads(int threads)
{
   WaitForSingleObject(print_mutex, INFINITE);
   char s[100], *s2 = s;
   if (threads)
     sprintf(s, "Threads: %i", threads);
   else {
      s2 = "Idle";
      sprintf(s, "Total: %i", blist.total);
      SendMessage(hstatus, SB_SETTEXT, 1, (LPARAM) s);
   }
   SendMessage(hstatus, SB_SETTEXT, 0, (LPARAM) s2);
   SendMessage(hstatus, WM_PAINT, 0, 0);
   ReleaseMutex(print_mutex);   
}

void PrintError(const char *host, int port, const char *path, const char *title, const char *text)
{
   WaitForSingleObject(print_mutex, INFINITE);   
   char *url;
   if (host) {
      url = new char[mystrlen(host)+mystrlen(path)+100];
      if (port != 80)
	sprintf(url, "http://%s:%i/%s", host, port, path);
      else
	sprintf(url, "http://%s/%s", host, path);
   } else
     url = "";
   SendMessage(hstatus, SB_SETTEXT, 2 | SBT_POPOUT, (LPARAM) title);
   SendMessage(hstatus, WM_PAINT, 0, 0);
   ErrListAddItem(title, text, url);
   if (show_log)
     ErrListResize();
   if (host)
      delete url;
   ReleaseMutex(print_mutex);
}

void UpdateEntry(int idx)
{
   PostMessage(hwnd, WM_LIST_CHANGED, 0, (LPARAM) idx);
}

void SetAutoSave(bool inverse, bool set)
{
   if (inverse) {
      auto_save = !CheckMenuItem(hmenu, ID_BLOCK_AUTO, MF_BYCOMMAND);
   } else
     auto_save = set;
   CheckMenuItem(hmenu, ID_BLOCK_AUTO, MF_BYCOMMAND | (auto_save ? MF_CHECKED : MF_UNCHECKED));
   SaveConf();
}

void SetShowLog(bool inverse, bool set)
{
   if (inverse) {
      show_log = !CheckMenuItem(hmenu, ID_LOG_SHOW, MF_BYCOMMAND);
   } else
     show_log = set;
   CheckMenuItem(hmenu, ID_LOG_SHOW, MF_BYCOMMAND | (show_log ? MF_CHECKED : MF_UNCHECKED));
   SaveConf();
   RECT r;
   GetClientRect(hwnd, &r);
   WindowResize(r.right - r.left, r.bottom - r.top);
}

void SetShowAll()
{
   show_all = !CheckMenuItem(hmenu, ID_LOG_ALL, MF_BYCOMMAND);
   CheckMenuItem(hmenu, ID_LOG_ALL, MF_BYCOMMAND | (show_all ? MF_CHECKED : MF_UNCHECKED));   
}

int status_widths[3] = { 90, 300, -1 };

void InitializeStatus()
{
   hstatus = CreateStatusWindow(WS_VISIBLE | WS_CHILD, "",
				hwnd, WM_STATUS_CALL);
   PostMessage(hstatus, SB_SETPARTS, 3, (LPARAM) status_widths);
   PostMessage(hstatus, SB_SIMPLE, FALSE, 0); 
}
   
void SetDisable()
{
   blist.disabled = !CheckMenuItem(hmenu, ID_BLOCK_DISABLE, MF_BYCOMMAND);
   CheckMenuItem(hmenu, ID_BLOCK_DISABLE, MF_BYCOMMAND | (blist.disabled ? MF_CHECKED : MF_UNCHECKED));   
}

void EntryAdd()
{
   hdlg = CreateDialog(hInstance, "addEntry", hwnd, (DLGPROC) AddEntryDlgProc);
   if (OpenClipboard(0)) {
      HANDLE h = GetClipboardData(CF_TEXT);
      if (h) {
	 char *s = new char[strlen((char *) h)+1];
	 strcpy(s, (char *) h);
	 char *host, *path, *dummy;
	 int port, ofs;
	 ParseURI(dummy, s, false, host, port, path, ofs);
	 //	       printf("h: %s, host: %s, port: %i, path: %s\n", (char *) h, host, port, path);
	 if (!host)
	   host = "";
	 if (!path)
	   path = "";
	 SendMessage(GetDlgItem(hdlg, ID_ENTRY_ADD_FULL), WM_SETTEXT, 0, (LPARAM) ((char *) h + ofs));
	 SendMessage(GetDlgItem(hdlg, ID_ENTRY_ADD_HOST), WM_SETTEXT, 0, (LPARAM) host);
	 SendMessage(GetDlgItem(hdlg, ID_ENTRY_ADD_PATH), WM_SETTEXT, 0, (LPARAM) path);
	 SendMessage(GetDlgItem(hdlg, ID_ENTRY_ADD_ANYPATH), WM_SETTEXT, 0, (LPARAM) path);	
	 /* remove filename from path */
	 for(char *s3 = path+strlen(path); s3 >= path; s3--)
	   if (*s3 == '/') {
	      *(s3+1) = 0;
	      break;
	   }
	 char *s2 = new char[strlen((char *) h)+100];
	 if (port != 80)
	   sprintf(s2, "http://%s:%i/%s", host, port, path);
	 else
	   sprintf(s2, "http://%s/%s", host, path);
	 SendMessage(GetDlgItem(hdlg, ID_ENTRY_ADD_DIR), WM_SETTEXT, 0, (LPARAM) s2);
	 delete s;
	 delete s2;
      }
      CloseClipboard();
   }
   ShowWindow(hdlg, SW_NORMAL);
   UpdateWindow(hdlg);
   EnableWindow(hwnd, false);
}

void EntryDel()
{
   if (!ListView_GetSelectedCount(hlst))
     return;
   int r = ListView_GetNextItem(hlst, -1, LVNI_SELECTED);
   if (r == -1 || r < 0 || r >= blist.GetLast())
     return;
   blist.remove_entry(r);
   ResetList();
}

void BlockFlush()
{
   blist.Free();
   ResetList();
}

void BlockFile(WPARAM wParam)
{
   if (LOWORD(wParam) == ID_BLOCK_SAVE && block_filename_used) {
      blist.Save(block_filename);
      return;
   }
   OPENFILENAME of;
   memset(&of, 0, sizeof(of));
   of.lStructSize = sizeof(of);
   of.hwndOwner = hwnd;
   of.hInstance = hInstance;
   of.lpstrFile = block_filename;
   of.nMaxFile = sizeof(block_filename);
   if (LOWORD(wParam) == ID_BLOCK_OPEN || LOWORD(wParam) == ID_BLOCK_ADD) {
      of.Flags = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST;
      if (GetOpenFileName(&of)) {
	 block_filename_used = true;
	 SaveConf();
	 if (LOWORD(wParam) == ID_BLOCK_OPEN)
	   blist.Free();
	 blist.Load(block_filename);
	 ResetList();
      }
   } else {
      of.Flags = OFN_PATHMUSTEXIST;
      if (GetSaveFileName(&of)) {
	 block_filename_used = true;
	 SaveConf();
	 blist.Save(block_filename);
      }
   }
}

void WindowResize(int x, int y)
{
   int y2 = y - 20, y3 = y2 > 200 ? y2 - 100 : y2;
   if (show_log) {
      MoveWindow(hlst, 0, 0, x, y3, TRUE);
      ShowWindow(herrlst, SW_SHOW);      
      MoveWindow(herrlst, 0, y3, x, y2 - y3, TRUE);
   } else {
      MoveWindow(hlst, 0, 0, x, y2, TRUE);
      ShowWindow(herrlst, SW_HIDE);
   }
   MoveWindow(hstatus, 0, y2, x, y - y2, TRUE);
}

BOOL CALLBACK AddEntryDlgProc(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM)
{
   if (uMsg == WM_COMMAND) {
      if (LOWORD(wParam) == IDCANCEL)
	;
      else if (LOWORD(wParam) >= ID_ENTRY_ADD_BSTART && LOWORD(wParam) <= ID_ENTRY_ADD_BEND) {
	 char buf[256];
	 SendMessage(GetDlgItem(hDlg, LOWORD(wParam)-10), WM_GETTEXT, 255, (LPARAM) buf);
	 char *host, *path;
	 int port, ofs, idx;
	 if (LOWORD(wParam) == ID_ENTRY_ADD_BPATH) {
	    host = 0;
	    port = 0;
	    path = buf;
	 } else {
	    char *dummy;
	    ParseURI(dummy, buf, false, host, port, path, ofs);
	 }
	 bool bodyblock = SendMessage(GetDlgItem(hDlg, ID_ENTRY_ADD_ISBODY), BM_GETCHECK, 0, 0);
	 char body[256];
	 SendMessage(GetDlgItem(hDlg, ID_ENTRY_ADD_BODY), WM_GETTEXT, 255, (LPARAM) body);
//	 printf("h: %s, host: %s, port: %i, path: %s\n", buf, host, port, path);
	 switch (LOWORD(wParam)) {
	  case ID_ENTRY_ADD_BFULL:
	    idx = blist.add_full(host, port, path, body, bodyblock);
	    break;
	  case ID_ENTRY_ADD_BDIR:
	    idx = blist.add_dir(host, port, path, body, bodyblock);
	    break;
	  case ID_ENTRY_ADD_BHOST:
	    idx = blist.add_host(host, port, body, bodyblock);
	    break;
	  case ID_ENTRY_ADD_BPATH:
	    idx = blist.add_path(path, body, bodyblock);
	    break;
	  case ID_ENTRY_ADD_BANYPATH:
	    idx = blist.add_anypath(path, body, bodyblock);
	    break;
	 }
//	 printf("add done: %i\n", idx);
	 if (idx >= 0) {
	    ListChanged(idx);
	    ListResize();
	 }
      } else
	return false;
      EnableWindow(hwnd, true);
      DestroyWindow(hDlg);
      hdlg = 0;
      return false;
   }
   return false;
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT uMsg,
                         WPARAM wParam, LPARAM lParam)
{
   switch(uMsg) {
    case WM_SYSTRAY_CALL:
      if (lParam == WM_LBUTTONDOWN && IsWindowEnabled(hwnd)) {
	 ShowWindow(hwnd, SW_RESTORE);
      }
      break;
    case WM_LIST_CHANGED:
      ListChanged(lParam);
      break;
    case WM_SIZE:
      if (wParam == SIZE_MINIMIZED)
	ShowWindow(hwnd, SW_HIDE);
      else
	WindowResize(LOWORD(lParam), HIWORD(lParam));
      break;
    case WM_COMMAND:
      switch (LOWORD(wParam)) {
       case ID_FILE_EXIT:
	 PostMessage(hwnd, WM_CLOSE, 0, 0);
	 break;
       case ID_FILE_CONF:
	 ShowConfDlg();
	 break;
       case ID_ENTRY_ADD:
	 EntryAdd();
	 break;
       case ID_ENTRY_DEL:
	 EntryDel();
	 break;
       case ID_BLOCK_FLUSH:
	 BlockFlush();
	 break;
       case ID_BLOCK_SAVE:
       case ID_BLOCK_OPEN:
       case ID_BLOCK_ADD:
       case ID_BLOCK_SAVEAS:
	 BlockFile(wParam);
	 break;
       case ID_BLOCK_AUTO:
	 SetAutoSave(true, false);
	 break;
       case ID_BLOCK_DISABLE:
	 SetDisable();
	 break;
       case ID_LOG_SHOW:
	 SetShowLog(true, false);
	 break;
       case ID_LOG_ALL:
	 SetShowAll();
	 break;
       case ID_LOG_FLUSH:
	 ErrListFlush();
	 break;
       case ID_HELP_HOMEPAGE:
	 OpenHomepage();
	 break;
       case ID_HELP_CHKUPDATE:
	 CheckUpdate(false);
	 break;
       case ID_HELP_ABOUT:
	 about_box();
	 break;
       default:
	 return DefWindowProc(hwnd, uMsg, wParam, lParam);
      }
      break;
    case WM_DESTROY:
      PostQuitMessage(0);
      break;
    default:
      return DefWindowProc(hwnd, uMsg, wParam, lParam);
   }
   return 0;
}

DWORD WINAPI CallServer(LPVOID)
{
   adbmain();
   PostMessage(hwnd, WM_COMMAND, ID_FILE_EXIT, 0);
   do_wnd_abort = true;
   return 0;
}

int WINAPI WinMain(HINSTANCE hThisInstance, HINSTANCE hPrevInstance,
		   LPSTR, int nCmdShow)
{
   DWORD dwThreadId;
   print_mutex = CreateMutex(&secattr, FALSE, NULL);
   
   CreateThread(0, 0, CallServer, 0, 0, &dwThreadId);
   LoadConf();
   if (auto_save)
     blist.Load(block_filename);
   hInstance = hThisInstance;
   if (!hPrevInstance) {
      WNDCLASS wndClass;      
      memset(&wndClass, 0, sizeof(wndClass));
      wndClass.style = 0;
      wndClass.lpfnWndProc = WndProc;
      wndClass.hInstance = hInstance;
      wndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
      wndClass.hIcon = LoadIcon(NULL, IDI_HAND);
      wndClass.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
      wndClass.lpszClassName = "adbMAINW";
      wndClass.lpszMenuName = "adbMenu";
      if (!RegisterClass(&wndClass))
	return false;
   }
   hwnd = CreateWindowEx(WS_EX_STATICEDGE /* | WS_EX_TOPMOST */, "adbMAINW", "Ad buster",
		       WS_OVERLAPPED | WS_MAXIMIZEBOX | WS_MINIMIZEBOX | WS_SIZEBOX | WS_SYSMENU,
		       CW_USEDEFAULT, 0, 450, 100,
		       NULL, NULL, hInstance, NULL);
   InitCommonControls();
   InitializeStatus();
   ErrListInitialize();
   PrintThreads(0);
   hmenu = GetMenu(hwnd);
   SetAutoSave(false, auto_save);
   ListInitialize();   
   ResetList();
   SetShowLog(false, show_log);
   ErrListResize();
   RECT r;
   GetWindowRect(hwnd, &r);
   MoveWindow(hwnd, r.left, r.top, 450, 200, TRUE);
   ShowWindow(hwnd, nCmdShow);
   EnableWindow(hwnd, true);
   UpdateWindow(hwnd);
   HICON hIcon = LoadIcon(0, IDI_HAND);
   register_icon(hwnd, false, "Ad Buster", hIcon);
   if (auto_update == 1)
     CheckUpdate(true);
   MSG msg;
   while (!do_wnd_abort && GetMessage(&msg, NULL, 0, 0)) {
      if (!hdlg || !IsDialogMessage(hdlg, &msg)) {
	 TranslateMessage(&msg);
	 DispatchMessage(&msg);
      }
   }
   if (auto_save)
     blist.Save(block_filename);
   remove_icon(hwnd); 
   return msg.wParam;
}
