###########################################################################
# Copyright (c) 1998, Jeffrey Glen Rennie
# All rights reserved.
###########################################################################
namespace eval struct {
    set makeTemplate { 
	proc %name%Make { } {
	    set result [list %values%]
	}
    }
    set memberTemplate { 
	proc %name%Set%member% { varStruct value } {
	    upvar $varStruct struct
	    set struct [lreplace $struct %index% %index% $value]
	}
	proc %name%Get%member% { varStruct } {
	    upvar $varStruct struct
	    lindex $struct %index%
	}
    }
}

proc struct::Declare { name args } {
    variable makeTemplate
    variable memberTemplate

    set values [list ]
    set members [list ]
    foreach member $args {
	lappend members [lindex $member 0]
	if { [llength $member] == 2 } {
	    lappend values [lindex $member 1]
	} else {
	    lappend values {}
	}
    }
    #declare the make proc
    regsub %values% $makeTemplate $values makeProc
    regsub %name% $makeProc $name makeProc
    uplevel #0 $makeProc
    
    #now declare the accessors
    set index 0
    foreach member $members {
	regsub -all %member% $memberTemplate $member memberProc
	regsub -all %name% $memberProc $name memberProc
	regsub -all %index% $memberProc $index memberProc
	incr index
	uplevel #0 $memberProc
    }
}
	
###########################################################################
# Copyright (c) 1998, Jeffrey Glen Rennie
# All rights reserved.
###########################################################################
