#include "h.h"
#include "blist.hh"

const int LIST_BLOCKED = 1;
const int LIST_HOST = 2;
const int LIST_PORT = 3;
const int LIST_PATH = 4;
const int LIST_BODY = 5;
const int LIST_MAX = 5;

GtkWidget *clist;

int clicked_row = -1;

void selection_made( GtkWidget *clist, gint row, gint column,
		    GdkEventButton *event, gpointer data)
{
  clicked_row = row;
}

void ListInitialize(GtkWidget *parent)
{
  gchar *titles[5] = {"Blocked", "Hostname", "Port", "Path", "Body"};
  int wd[5] = {50, 140, 50, 140, 120 };
  clist = gtk_clist_new_with_titles(5, titles);
  for(int i=0; i<5; i++)
    gtk_clist_set_column_width(GTK_CLIST(clist), i, wd[i]);
  gtk_clist_set_column_justification(GTK_CLIST(clist), 0, GTK_JUSTIFY_RIGHT);
  for(int i=1; i<5; i++)
    gtk_clist_set_column_justification(GTK_CLIST(clist), i, GTK_JUSTIFY_LEFT);
//  gtk_clist_set_policy(GTK_CLIST(clist), GTK_POLICY_AUTOMATIC,
//		       GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start(GTK_BOX(parent), clist, TRUE, TRUE, 0);
  gtk_signal_connect(GTK_OBJECT(clist), "select_row",
		     GTK_SIGNAL_FUNC(selection_made),
		     NULL);
  gtk_widget_show(clist);
}

void ListResize()
{
#ifdef WINDOWS
   for (int i = 0; i <= LIST_MAX; i++) {
      ListView_SetColumnWidth(hlst, i, LVSCW_AUTOSIZE);
      int c1 = ListView_GetColumnWidth(hlst, i);
      ListView_SetColumnWidth(hlst, i, LVSCW_AUTOSIZE_USEHEADER);
      int c2 = ListView_GetColumnWidth(hlst, i);
      if (c2 < c1)
	 ListView_SetColumnWidth(hlst, i, c1);
   }
#endif
}

void ListSetItem(int idx, int access, const char *host, const char *path, int port, const char *body)
{
  gtk_clist_freeze(GTK_CLIST(clist));
  
  gtk_clist_remove(GTK_CLIST(clist), idx);
  char s[100];
  g_snprintf(s, 100, "%i", access);
  char pr[20];
  if (!port || port == 80)
    pr[0] = 0;
  else
    g_snprintf(pr, 20, "%i", port);
  const char *t[5] = {s, host, pr, path, body};
  gtk_clist_insert(GTK_CLIST(clist), idx, (gchar **) t);
  
  gtk_clist_thaw(GTK_CLIST(clist));  
}

void ListClear()
{
  gtk_clist_clear(GTK_CLIST(clist));  
}
