###########################################################################
# Copyright (c) 1998, Jeffrey Glen Rennie
# All rights reserved.
###########################################################################
###########################################################################
# regwrap.tcl
# these functions wrap the new registry API, so that the old calls still 
#   work

package require registry 1.0

proc reg_openkey { root path args } {
    regsub -all / $path \\ path
    set result "H[string toupper $root]\\$path"
}

proc reg_closekey { args } {
}

proc reg_getvalue { key valueName } {
    list [registry type $key $valueName] [registry get $key $valueName]
}

proc reg_setvalue { key valueName type value } {
    registry set $key $valueName $value $type
}

global registryDllLoaded
set registryDllLoaded 1
###########################################################################
# Copyright (c) 1998, Jeffrey Glen Rennie
# All rights reserved.
###########################################################################
