/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.ConstantValueAttr;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.Location;
import java.io.DataOutputStream;
import java.io.IOException;

public class Field
extends Location
implements AttrContainer {
    int flags;
    Field next;
    Attribute attributes;
    ClassType owner;
    String sourceName;
    java.lang.reflect.Field rfield;

    public final Attribute getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Attribute attribute) {
        this.attributes = attribute;
    }

    public Field(ClassType classType) {
        if (classType.last_field == null) {
            classType.fields = this;
        } else {
            classType.last_field.next = this;
        }
        classType.last_field = this;
        ++classType.fields_count;
        this.owner = classType;
    }

    public final ClassType getDeclaringClass() {
        return this.owner;
    }

    public final void setStaticFlag(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags ^= 0xFFFFFFF7);
    }

    public final boolean getStaticFlag() {
        return (this.flags & 8) != 0;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final int getModifiers() {
        return this.flags;
    }

    void write(DataOutputStream dataOutputStream, ClassType classType) throws IOException {
        dataOutputStream.writeShort(this.flags);
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.signature_index);
        Attribute.writeAll(this, dataOutputStream);
    }

    void assign_constants(ClassType classType) {
        ConstantPool constantPool = classType.constants;
        if (this.name_index == 0 && this.name != null) {
            this.name_index = constantPool.addUtf8((String)this.name).index;
        }
        if (this.signature_index == 0 && this.type != null) {
            this.signature_index = constantPool.addUtf8((String)this.type.signature).index;
        }
        Attribute.assignConstants(this, classType);
    }

    public java.lang.reflect.Field getReflectField() throws NoSuchFieldException {
        if (this.rfield == null) {
            this.rfield = this.owner.getReflectClass().getDeclaredField(this.getName());
        }
        return this.rfield;
    }

    public void setSourceName(String string) {
        this.sourceName = string;
    }

    public String getSourceName() {
        if (this.sourceName == null) {
            this.sourceName = this.getName().intern();
        }
        return this.sourceName;
    }

    public static Field searchField(Field field, String string) {
        while (field != null) {
            if (field.getSourceName() == string) {
                return field;
            }
            field = field.next;
        }
        return null;
    }

    public final Field getNext() {
        return this.next;
    }

    public final void setConstantValue(Object object, ClassType classType) {
        CpoolEntry cpoolEntry;
        ConstantPool constantPool = classType.getConstants();
        char c = this.getType().getSignature().charAt(0);
        switch (c) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                cpoolEntry = constantPool.addInt(((Number)object).intValue());
                break;
            }
            case 'J': {
                cpoolEntry = constantPool.addLong(((Number)object).longValue());
                break;
            }
            case 'F': {
                cpoolEntry = constantPool.addFloat(((Number)object).floatValue());
                break;
            }
            case 'D': {
                cpoolEntry = constantPool.addDouble(((Number)object).doubleValue());
                break;
            }
            default: {
                cpoolEntry = constantPool.addString(object.toString());
            }
        }
        ConstantValueAttr constantValueAttr = new ConstantValueAttr(cpoolEntry.getIndex());
        constantValueAttr.addToFrontOf(this);
    }
}

