/*
 * Decompiled with CFR 0.152.
 */
package uk.co.visualisationsystems.QuickFire.Editor;

import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringBufferInputStream;
import uk.co.visualisationsystems.QuickFire.Applet.QuickFireAppletRuntime;
import uk.co.visualisationsystems.QuickFire.Applet.QuickFireIO;
import uk.co.visualisationsystems.QuickFire.Compiler.Backend;
import uk.co.visualisationsystems.QuickFire.Compiler.CompilerCallback;
import uk.co.visualisationsystems.QuickFire.Compiler.ParserTab;
import uk.co.visualisationsystems.QuickFire.Compiler.QuickFireRuntimeError;
import uk.co.visualisationsystems.QuickFire.Editor.AboutDialog;
import uk.co.visualisationsystems.QuickFire.Editor.EditorApplet;
import uk.co.visualisationsystems.QuickFire.Editor.EditorFrame;
import uk.co.visualisationsystems.QuickFire.Editor.GeneralDialog;
import uk.co.visualisationsystems.QuickFire.Editor.InterpreterApplet;
import uk.co.visualisationsystems.QuickFire.Editor.LicenseInfoDialog;
import uk.co.visualisationsystems.QuickFire.Editor.LoadFileDialog;
import uk.co.visualisationsystems.QuickFire.Editor.QuickFireEditorRuntime;
import uk.co.visualisationsystems.QuickFire.Editor.SaveFileDialog;
import uk.co.visualisationsystems.QuickFire.Editor.SplashScreen;
import uk.co.visualisationsystems.QuickFire.Editor.WindowSizeDialog;
import uk.co.visualisationsystems.QuickFire.LicenseManager.LicenseManager;

public class EditorPanel
extends Panel
implements ActionListener,
ItemListener,
CompilerCallback {
    Class interpreterBackendClass;
    Class jvmBackendClass;
    String editorRuntimeClassName = "uk.co.visualisationsystems.QuickFire.Editor.QuickFireEditorRuntime";
    String appletRuntimeClassName = "uk.co.visualisationsystems.QuickFire.Applet.QuickFireAppletRuntime";
    MenuBar menuBar;
    Menu fileMenu;
    MenuItem newMenuItem;
    MenuItem loadMenuItem;
    MenuItem saveMenuItem;
    MenuItem saveVirtualDiskMenuItem;
    MenuItem exitMenuItem;
    Menu editMenu;
    MenuItem selectAllMenuItem;
    MenuItem copyMenuItem;
    MenuItem cutMenuItem;
    MenuItem pasteMenuItem;
    MenuItem deleteMenuItem;
    Menu runMenu;
    MenuItem compileMenuItem;
    MenuItem runMenuItem;
    MenuItem stopMenuItem;
    MenuItem firstErrorMenuItem;
    MenuItem nextErrorMenuItem;
    MenuItem prevErrorMenuItem;
    MenuItem lastErrorMenuItem;
    CheckboxMenuItem useCompilerMenuItem;
    CheckboxMenuItem useInterpreterMenuItem;
    CheckboxMenuItem createHTMLMenuItem;
    Menu windowMenu;
    CheckboxMenuItem windowSize160x120MenuItem;
    CheckboxMenuItem windowSize320x240MenuItem;
    CheckboxMenuItem windowSize640x480MenuItem;
    CheckboxMenuItem customWindowSizeMenuItem;
    Menu debugMenu;
    MenuItem showThreadsMenuItem;
    MenuItem showMemoryMenuItem;
    MenuItem garbageCollectionMenuItem;
    MenuItem runFinalizationMenuItem;
    Menu helpMenu;
    MenuItem viewLicenseMenuItem;
    MenuItem locateLicenseMenuItem;
    MenuItem aboutMenuItem;
    private EditorFrame editorFrame;
    private EditorApplet editorApplet;
    private Frame interpreterFrame = null;
    private InterpreterApplet interpreterApplet = null;
    private boolean enableDebugMenu = false;
    private WindowSizeDialog windowSizeDialog;
    String pasteBuffer = null;
    final int MAXERRORS = 100;
    int nerrors = 0;
    int currentError;
    String[] errorMessage = new String[100];
    int[] startOffset = new int[100];
    int[] finishOffset = new int[100];
    ParserTab parser;
    private String releaseID = "2.0.0";
    Font font;
    TextArea inputTextArea;
    TextArea outputTextArea;
    static final String OUTPUTCANVAS = "Output Canvas";
    static final String SOURCE = "Source Code";
    LoadFileDialog loadFileDialog = null;
    SaveFileDialog saveFileDialog = null;
    GeneralDialog generalDialog = null;
    AboutDialog aboutDialog = null;
    private String currentDirectory = null;
    private String currentFilename = null;
    private String programName = null;
    private boolean useCompilerBackend;

    EditorPanel(EditorFrame editorFrame, EditorApplet editorApplet, boolean bl) {
        this.editorFrame = editorFrame;
        this.editorApplet = editorApplet;
        this.enableDebugMenu = bl;
        MenuBar menuBar = new MenuBar();
        this.fileMenu = new Menu("File");
        menuBar.add(this.fileMenu);
        this.newMenuItem = new MenuItem("New");
        this.newMenuItem.addActionListener(this);
        this.fileMenu.add(this.newMenuItem);
        this.loadMenuItem = new MenuItem("Load");
        this.loadMenuItem.addActionListener(this);
        this.fileMenu.add(this.loadMenuItem);
        this.saveMenuItem = new MenuItem("Save");
        this.saveMenuItem.addActionListener(this);
        this.fileMenu.add(this.saveMenuItem);
        if (this.isApplet() && editorApplet.isUsingVirtualDisk()) {
            this.saveVirtualDiskMenuItem = new MenuItem("Save Virtual Disk");
            this.saveVirtualDiskMenuItem.addActionListener(this);
            this.fileMenu.add(this.saveVirtualDiskMenuItem);
        } else {
            this.saveVirtualDiskMenuItem = null;
        }
        this.exitMenuItem = new MenuItem("Exit");
        this.exitMenuItem.addActionListener(this);
        this.fileMenu.add(this.exitMenuItem);
        this.editMenu = new Menu("Edit");
        menuBar.add(this.editMenu);
        this.selectAllMenuItem = new MenuItem("Select all");
        this.selectAllMenuItem.addActionListener(this);
        this.editMenu.add(this.selectAllMenuItem);
        this.copyMenuItem = new MenuItem("Copy");
        this.copyMenuItem.addActionListener(this);
        this.editMenu.add(this.copyMenuItem);
        this.cutMenuItem = new MenuItem("Cut");
        this.cutMenuItem.addActionListener(this);
        this.editMenu.add(this.cutMenuItem);
        this.pasteMenuItem = new MenuItem("Paste");
        this.pasteMenuItem.addActionListener(this);
        this.editMenu.add(this.pasteMenuItem);
        this.deleteMenuItem = new MenuItem("Delete");
        this.deleteMenuItem.addActionListener(this);
        this.editMenu.add(this.deleteMenuItem);
        this.runMenu = new Menu("Run");
        menuBar.add(this.runMenu);
        this.compileMenuItem = new MenuItem("Compile");
        this.compileMenuItem.addActionListener(this);
        this.runMenu.add(this.compileMenuItem);
        this.runMenuItem = new MenuItem("Run");
        this.runMenuItem.addActionListener(this);
        this.runMenu.add(this.runMenuItem);
        this.stopMenuItem = new MenuItem("Stop");
        this.stopMenuItem.addActionListener(this);
        this.runMenu.add(this.stopMenuItem);
        this.runMenu.addSeparator();
        this.firstErrorMenuItem = new MenuItem("First Error");
        this.firstErrorMenuItem.addActionListener(this);
        this.runMenu.add(this.firstErrorMenuItem);
        this.nextErrorMenuItem = new MenuItem("Next Error");
        this.nextErrorMenuItem.addActionListener(this);
        this.runMenu.add(this.nextErrorMenuItem);
        this.prevErrorMenuItem = new MenuItem("Previous Error");
        this.prevErrorMenuItem.addActionListener(this);
        this.runMenu.add(this.prevErrorMenuItem);
        this.lastErrorMenuItem = new MenuItem("Last Error");
        this.lastErrorMenuItem.addActionListener(this);
        this.runMenu.add(this.lastErrorMenuItem);
        this.runMenu.addSeparator();
        this.useCompilerMenuItem = new CheckboxMenuItem("Use Compiler");
        this.useCompilerMenuItem.addItemListener(this);
        this.runMenu.add(this.useCompilerMenuItem);
        this.useInterpreterMenuItem = new CheckboxMenuItem("Use Interpreter");
        this.useInterpreterMenuItem.addItemListener(this);
        this.runMenu.add(this.useInterpreterMenuItem);
        this.runMenu.addSeparator();
        this.createHTMLMenuItem = new CheckboxMenuItem("Create HTML");
        this.createHTMLMenuItem.addItemListener(this);
        this.runMenu.add(this.createHTMLMenuItem);
        this.windowMenu = new Menu("Window");
        menuBar.add(this.windowMenu);
        this.windowSize160x120MenuItem = new CheckboxMenuItem("160x120");
        this.windowSize160x120MenuItem.addItemListener(this);
        this.windowMenu.add(this.windowSize160x120MenuItem);
        this.windowSize320x240MenuItem = new CheckboxMenuItem("320x240");
        this.windowSize320x240MenuItem.addItemListener(this);
        this.windowMenu.add(this.windowSize320x240MenuItem);
        this.windowSize640x480MenuItem = new CheckboxMenuItem("640x480");
        this.windowSize640x480MenuItem.addItemListener(this);
        this.windowMenu.add(this.windowSize640x480MenuItem);
        this.customWindowSizeMenuItem = new CheckboxMenuItem("Custom size");
        this.customWindowSizeMenuItem.addItemListener(this);
        this.windowMenu.add(this.customWindowSizeMenuItem);
        this.windowSize160x120MenuItem.setState(false);
        this.windowSize320x240MenuItem.setState(true);
        this.windowSize640x480MenuItem.setState(false);
        this.customWindowSizeMenuItem.setState(false);
        if (bl) {
            this.debugMenu = new Menu("Debug");
            menuBar.add(this.debugMenu);
            this.showThreadsMenuItem = new MenuItem("Show Threads");
            this.showThreadsMenuItem.addActionListener(this);
            this.debugMenu.add(this.showThreadsMenuItem);
            this.showMemoryMenuItem = new MenuItem("Show Memory");
            this.showMemoryMenuItem.addActionListener(this);
            this.debugMenu.add(this.showMemoryMenuItem);
            this.garbageCollectionMenuItem = new MenuItem("Garbage Collection");
            this.garbageCollectionMenuItem.addActionListener(this);
            this.debugMenu.add(this.garbageCollectionMenuItem);
            this.runFinalizationMenuItem = new MenuItem("Run Finalization");
            this.runFinalizationMenuItem.addActionListener(this);
            this.debugMenu.add(this.runFinalizationMenuItem);
        }
        this.helpMenu = new Menu("Help");
        menuBar.setHelpMenu(this.helpMenu);
        this.viewLicenseMenuItem = new MenuItem("View License");
        this.viewLicenseMenuItem.addActionListener(this);
        this.helpMenu.add(this.viewLicenseMenuItem);
        this.locateLicenseMenuItem = new MenuItem("Locate License");
        this.locateLicenseMenuItem.addActionListener(this);
        this.helpMenu.add(this.locateLicenseMenuItem);
        this.helpMenu.addSeparator();
        this.aboutMenuItem = new MenuItem("About");
        this.aboutMenuItem.addActionListener(this);
        this.helpMenu.add(this.aboutMenuItem);
        editorFrame.setMenuBar(menuBar);
        this.setBackground(Color.lightGray);
        this.font = new Font("Monospaced", 0, 12);
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.font);
        Dimension dimension = new Dimension(600, 400);
        int n = dimension.height;
        int n2 = fontMetrics.getHeight();
        int n3 = n * 3 / 4;
        int n4 = n - n3;
        int n5 = n3 / n2;
        int n6 = n4 / n2;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        this.inputTextArea = new TextArea("", n5, 80, 0);
        this.inputTextArea.setFont(this.font);
        gridBagLayout.setConstraints(this.inputTextArea, gridBagConstraints);
        this.add(this.inputTextArea);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridheight = 1;
        this.outputTextArea = new TextArea("", n6, 80, 0);
        this.outputTextArea.setFont(this.font);
        this.outputTextArea.setEditable(false);
        gridBagLayout.setConstraints(this.outputTextArea, gridBagConstraints);
        this.add(this.outputTextArea);
        this.windowSizeDialog = new WindowSizeDialog(editorFrame);
        if (this.isApplication() && !LicenseManager.isLicensed()) {
            SplashScreen splashScreen = new SplashScreen(editorFrame);
            splashScreen.show();
            if (splashScreen.locateLicenseFile()) {
                this.doLocateLicense();
            }
        }
        try {
            this.interpreterBackendClass = Class.forName("uk.co.visualisationsystems.QuickFire.Compiler.InterpreterBackend");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFoundException: " + classNotFoundException.getMessage());
            this.interpreterBackendClass = null;
        }
        try {
            this.jvmBackendClass = Class.forName("uk.co.visualisationsystems.QuickFire.Compiler.JvmBackend");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFoundException: " + classNotFoundException.getMessage());
            this.jvmBackendClass = null;
        }
        this.useCompilerBackend = this.isApplication() && this.jvmBackendClass != null && LicenseManager.isLicensed();
        this.useCompilerMenuItem.setState(this.useCompilerBackend);
        this.useInterpreterMenuItem.setState(!this.useCompilerBackend);
        this.ConfigMenuItems();
        this.validate();
    }

    boolean isApplication() {
        return this.editorApplet == null;
    }

    boolean isApplet() {
        return this.editorApplet != null;
    }

    void Print(String string) {
        this.outputTextArea.appendText(string + "\n");
    }

    public void RuntimeError(QuickFireRuntimeError quickFireRuntimeError) {
        String string = quickFireRuntimeError.getMessage();
        int n = quickFireRuntimeError.getOffset();
        this.outputTextArea.appendText(string + "\n");
        this.inputTextArea.select(n, n);
    }

    void SetBusy(boolean bl) {
        Cursor cursor = bl ? new Cursor(3) : new Cursor(0);
        this.setCursor(cursor);
        this.inputTextArea.enable(!bl);
        this.outputTextArea.enable(!bl);
    }

    void Output(String string) {
        this.outputTextArea.appendText(string);
    }

    void SetErrorDetails(String string, int n, int n2) {
        this.outputTextArea.setText(string);
        this.inputTextArea.select(n, n2);
    }

    public void CompilerWarning(String string, int n, int n2) {
        this.errorMessage[this.nerrors] = string;
        this.startOffset[this.nerrors] = n;
        this.finishOffset[this.nerrors] = n2;
        this.Output("Warning: " + string + "\n");
        ++this.nerrors;
    }

    public void CompilerError(String string, int n, int n2) {
        this.errorMessage[this.nerrors] = string;
        this.startOffset[this.nerrors] = n;
        this.finishOffset[this.nerrors] = n2;
        this.Output("Error: " + string + "\n");
        ++this.nerrors;
    }

    void HighlightError(int n) {
        this.SetErrorDetails(this.errorMessage[n], this.startOffset[n], this.finishOffset[n]);
        this.currentError = n;
    }

    int Compile(String string, Backend backend) {
        boolean bl = false;
        this.nerrors = 0;
        this.Output("Compiling Program\n");
        this.parser = new ParserTab(new StringBufferInputStream(string));
        try {
            backend.InstallSystemCalls(this.parser, this.appletRuntimeClassName);
            this.parser.Parse(this);
            if (this.parser.ErrorCount() == 0) {
                bl = true;
            }
            if (bl) {
                backend.GenerateProgram(this.programName, this.parser);
                this.Output("Program compiled successfully\n");
                backend.SaveAs(this.programName);
            } else {
                this.Output("Program compiled with errors\n");
                this.currentError = -1;
            }
        }
        catch (Exception exception) {
            this.CompilerError("Exception: " + exception.getMessage(), 0, 0);
            this.currentError = -1;
        }
        return this.nerrors;
    }

    public void ProgramFinished() {
        this.ConfigMenuItems();
        this.outputTextArea.appendText("Program completed\n");
        this.inputTextArea.requestFocus();
        if (this.interpreterApplet != null) {
            this.interpreterApplet.destroy();
            this.interpreterApplet = null;
            this.interpreterFrame.dispose();
            this.interpreterFrame = null;
        }
    }

    public void SaveState() {
        QuickFireIO quickFireIO;
        if (this.isApplet() && (quickFireIO = this.editorApplet.getQuickFireIO()) != null) {
            String string = this.inputTextArea.getText();
            int n = quickFireIO.WriteObject(".quickfire", string);
        }
    }

    public void RestoreState() {
        Object object;
        QuickFireIO quickFireIO;
        if (this.isApplet() && (quickFireIO = this.editorApplet.getQuickFireIO()) != null && (object = quickFireIO.ReadObject(".quickfire")) instanceof String) {
            this.inputTextArea.setText((String)object);
        }
    }

    private boolean useLocalFileSystem() {
        boolean bl = true;
        if (this.editorApplet != null && this.editorApplet.isAppletMode()) {
            bl = false;
        }
        return bl;
    }

    private boolean isRunning() {
        boolean bl = false;
        if (this.interpreterApplet != null) {
            bl = this.interpreterApplet.isRunning();
        }
        if (this.editorApplet != null) {
            bl = this.editorApplet.isRunning();
        }
        return bl;
    }

    private void ConfigMenuItems() {
        boolean bl = LicenseManager.isLicensed();
        boolean bl2 = this.isRunning();
        this.newMenuItem.enable(!bl2);
        this.loadMenuItem.enable(!bl2);
        this.saveMenuItem.enable(!bl2);
        if (this.saveVirtualDiskMenuItem != null) {
            this.saveVirtualDiskMenuItem.enable(!bl2);
        }
        this.exitMenuItem.enable(true);
        this.selectAllMenuItem.enable(!bl2);
        this.copyMenuItem.enable(!bl2);
        this.cutMenuItem.enable(!bl2);
        this.pasteMenuItem.enable(!bl2 && this.pasteBuffer != null);
        this.deleteMenuItem.enable(!bl2);
        this.compileMenuItem.enable(!bl2);
        this.runMenuItem.enable(!bl2);
        this.stopMenuItem.enable(bl2);
        this.firstErrorMenuItem.enable(!bl2 && this.nerrors > 0);
        this.nextErrorMenuItem.enable(!bl2 && this.nerrors > 0 && this.currentError < this.nerrors - 1);
        this.prevErrorMenuItem.enable(!bl2 && this.nerrors > 0 && this.currentError > 0);
        this.lastErrorMenuItem.enable(!bl2 && this.nerrors > 0);
        this.useCompilerMenuItem.enable(this.isApplication() && this.jvmBackendClass != null && bl && !bl2);
        this.useInterpreterMenuItem.enable(!bl2);
        this.createHTMLMenuItem.enable(this.isApplication() && this.jvmBackendClass != null && bl && !bl2);
        boolean bl3 = this.isApplet() ? false : !bl2;
        this.windowSize160x120MenuItem.enable(bl3);
        this.windowSize320x240MenuItem.enable(bl3);
        this.windowSize640x480MenuItem.enable(bl3);
        this.customWindowSizeMenuItem.enable(bl3);
        this.viewLicenseMenuItem.enable(this.isApplication() && LicenseManager.licenseInstalled());
        this.locateLicenseMenuItem.enable(this.isApplication());
        this.aboutMenuItem.enable(true);
    }

    private void doLocateLicense() {
        this.SetBusy(true);
        FileDialog fileDialog = new FileDialog((Frame)this.editorFrame, "Select QuickFire License File", 0);
        if (this.currentDirectory != null) {
            fileDialog.setDirectory(this.currentDirectory);
        }
        fileDialog.show();
        this.currentDirectory = fileDialog.getDirectory();
        String string = fileDialog.getFile();
        if (this.currentDirectory != null && string != null) {
            String string2 = this.currentDirectory + string;
            LicenseManager.setLicenseFile(string2);
        }
        this.SetBusy(false);
    }

    private void doNew() {
        this.inputTextArea.setText("");
        this.programName = "unnamed";
    }

    private void doLoad() {
        this.SetBusy(true);
        if (!this.useLocalFileSystem()) {
            QuickFireIO quickFireIO = this.editorApplet.getQuickFireIO();
            if (this.loadFileDialog == null) {
                this.loadFileDialog = new LoadFileDialog((Frame)this.editorFrame, quickFireIO);
            }
            this.loadFileDialog.show();
            String string = this.loadFileDialog.GetFilename();
            if (string != null) {
                Object object = quickFireIO.ReadObject(string);
                if (object instanceof String) {
                    this.inputTextArea.setText((String)object);
                } else {
                    this.generalDialog = new GeneralDialog((Frame)this.editorFrame, "Error", "\"" + string + "\" does not contain QuickFire Source Code.");
                    this.generalDialog.show();
                }
            }
        } else {
            FileDialog fileDialog = new FileDialog((Frame)this.editorFrame, "Select QuickFire File to Load", 0);
            if (this.currentDirectory != null) {
                fileDialog.setDirectory(this.currentDirectory);
            }
            fileDialog.show();
            this.currentDirectory = fileDialog.getDirectory();
            this.currentFilename = fileDialog.getFile();
            if (this.currentDirectory != null && this.currentFilename != null) {
                String string = this.currentDirectory + this.currentFilename;
                int n = this.currentFilename.indexOf(".");
                this.programName = n == -1 ? this.currentFilename : this.currentFilename.substring(0, n);
                try {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    int n2 = fileInputStream.available();
                    if (n2 > 0) {
                        byte[] byArray = new byte[n2];
                        fileInputStream.read(byArray);
                        this.inputTextArea.setText(new String(byArray, 0));
                    } else {
                        this.inputTextArea.setText(string);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("FileNotFoundException: " + fileNotFoundException.getMessage());
                    this.inputTextArea.setText("");
                }
                catch (IOException iOException) {
                    System.out.println("IOException: " + iOException.getMessage());
                    this.inputTextArea.setText("");
                }
            }
        }
        this.SetBusy(false);
    }

    private void doSave() {
        this.SetBusy(true);
        if (!this.useLocalFileSystem()) {
            QuickFireIO quickFireIO = this.editorApplet.getQuickFireIO();
            if (this.saveFileDialog == null) {
                this.saveFileDialog = new SaveFileDialog((Frame)this.editorFrame, quickFireIO);
            }
            this.saveFileDialog.show();
            String string = this.saveFileDialog.GetFilename();
            if (string != null) {
                String string2 = this.inputTextArea.getText();
                int n = quickFireIO.WriteObject(string, string2);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        this.generalDialog = new GeneralDialog((Frame)this.editorFrame, "Warning", "File saved OK but your storage quota has been exceeded. You cannot save anything again until your quota is within its allowed range");
                        this.generalDialog.show();
                        break;
                    }
                    case 3: {
                        this.generalDialog = new GeneralDialog((Frame)this.editorFrame, "Error", "File not saved because your storage quota has been exceeded. You cannot save anything again until your quota is within its allowed range");
                        this.generalDialog.show();
                        break;
                    }
                    default: {
                        this.generalDialog = new GeneralDialog((Frame)this.editorFrame, "Error", "File not saved due to an unexpected error.");
                        this.generalDialog.show();
                        break;
                    }
                }
            }
        } else {
            FileDialog fileDialog = new FileDialog((Frame)this.editorFrame, "Save QuickFire File As", 1);
            if (this.currentDirectory != null) {
                fileDialog.setDirectory(this.currentDirectory);
            }
            fileDialog.show();
            this.currentDirectory = fileDialog.getDirectory();
            this.currentFilename = fileDialog.getFile();
            if (this.currentDirectory != null && this.currentFilename != null) {
                String string = this.currentDirectory + this.currentFilename;
                int n = this.currentFilename.indexOf(".");
                this.programName = n == -1 ? this.currentFilename : this.currentFilename.substring(0, n);
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string);
                    String string3 = this.inputTextArea.getText();
                    int n2 = string3.length();
                    if (n2 > 0) {
                        byte[] byArray = new byte[n2];
                        string3.getBytes(0, n2, byArray, 0);
                        fileOutputStream.write(byArray);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("FileNotFoundException: " + fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.out.println("IOException: " + iOException.getMessage());
                }
            }
        }
        this.SetBusy(false);
    }

    private void doExit() {
        this.SaveState();
        try {
            System.exit(0);
        }
        catch (SecurityException securityException) {
            GeneralDialog generalDialog = new GeneralDialog((Frame)this.editorFrame, "Unable to exit", "Terminate Browser or navigate to a different page to exit");
            generalDialog.show();
        }
    }

    private void doSaveVirtualDisk() {
        this.SetBusy(true);
        boolean bl = false;
        if (this.editorApplet != null) {
            bl = this.editorApplet.SaveVirtualDisk();
        }
        if (!bl) {
            this.generalDialog = new GeneralDialog((Frame)this.editorFrame, "Error", "Failed to save Virtual Disk - Read Only Image / Server Down / Bad Poster URL.");
            this.generalDialog.show();
        }
        this.SetBusy(false);
    }

    private void doCompile() {
        int n;
        String string = this.inputTextArea.getText();
        this.outputTextArea.setText("");
        Backend backend = null;
        try {
            Class clazz = this.useCompilerBackend ? this.jvmBackendClass : this.interpreterBackendClass;
            backend = (Backend)clazz.newInstance();
            String[] stringArray = null;
            if (this.createHTMLMenuItem.getState()) {
                stringArray = new String[]{"-html"};
            }
            backend.parseArgs(stringArray);
        }
        catch (InstantiationException instantiationException) {
            this.Output("InstantiationException: " + instantiationException.getMessage());
            backend = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.Output("IllegalAccessException: " + illegalAccessException.getMessage());
            backend = null;
        }
        if (backend != null && (n = this.Compile(string, backend)) != 0) {
            this.HighlightError(0);
        }
    }

    private void doRun() {
        Object object;
        String string = this.inputTextArea.getText();
        this.outputTextArea.setText("");
        Backend backend = null;
        try {
            Class clazz = this.useCompilerBackend ? this.jvmBackendClass : this.interpreterBackendClass;
            backend = (Backend)clazz.newInstance();
            object = null;
            if (this.createHTMLMenuItem.getState()) {
                object = new String[]{"-html"};
            }
            backend.parseArgs((String[])object);
        }
        catch (InstantiationException instantiationException) {
            this.Output("InstantiationException: " + instantiationException.getMessage());
            backend = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.Output("IllegalAccessException: " + illegalAccessException.getMessage());
            backend = null;
        }
        if (backend != null) {
            int n = this.Compile(string, backend);
            if (n == 0) {
                object = new QuickFireEditorRuntime();
                object.editorPanel = this;
                if (this.editorApplet != null) {
                    if (!this.editorApplet.isRunning()) {
                        this.Output("Starting Program\n");
                        this.editorApplet.StartProgram(this.programName, backend, (QuickFireAppletRuntime)object);
                        boolean bl = true;
                    } else {
                        this.Output("Another program is already running\n");
                    }
                } else {
                    this.interpreterFrame = new Frame("QuickFire Applet");
                    this.interpreterApplet = new InterpreterApplet(this);
                    this.interpreterFrame.add("Center", this.interpreterApplet);
                    this.interpreterFrame.resize(this.windowSizeDialog.getWidth(), this.windowSizeDialog.getHeight());
                    this.interpreterFrame.show();
                    this.interpreterApplet.init();
                    this.interpreterApplet.start();
                    this.interpreterApplet.StartProgram(this.programName, backend, (QuickFireAppletRuntime)object);
                    boolean bl = true;
                }
            } else {
                this.HighlightError(0);
            }
        }
    }

    private void doStop() {
        if (this.interpreterApplet != null) {
            this.interpreterApplet.StopProgram();
        }
        if (this.editorApplet != null) {
            this.editorApplet.StopProgram();
        }
    }

    private void doShowThreads() {
        int n = Thread.activeCount();
        Thread[] threadArray = new Thread[n];
        n = Thread.enumerate(threadArray);
        int n2 = 0;
        while (n2 < n) {
            this.Output("Thread " + n2 + ": " + threadArray[n2] + ")\n");
            ++n2;
        }
    }

    private void doShowMemory() {
        Runtime runtime = Runtime.getRuntime();
        this.Output("Total Memory: " + runtime.totalMemory() / 1024L + "K\n");
        this.Output("Free Memory: " + runtime.freeMemory() / 1024L + "K\n");
    }

    private void doGarbageCollection() {
        System.gc();
    }

    private void doRunFinalization() {
        System.runFinalization();
    }

    private void doFirstError() {
        this.HighlightError(0);
    }

    private void doLastError() {
        this.HighlightError(this.nerrors - 1);
    }

    private void doNextError() {
        this.HighlightError(this.currentError + 1);
    }

    private void doPrevError() {
        this.HighlightError(this.currentError - 1);
    }

    private void doViewLicense() {
        this.SetBusy(true);
        LicenseInfoDialog licenseInfoDialog = new LicenseInfoDialog(this.editorFrame);
        licenseInfoDialog.show();
        this.SetBusy(false);
    }

    private void doAbout() {
        this.SetBusy(true);
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog((Frame)this.editorFrame, this.releaseID);
        }
        this.aboutDialog.show();
        this.SetBusy(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        Object object = actionEvent.getSource();
        if (object == this.newMenuItem) {
            this.doNew();
        } else if (object == this.loadMenuItem) {
            this.doLoad();
        } else if (object == this.saveMenuItem) {
            this.doSave();
        } else if (object == this.exitMenuItem) {
            this.doExit();
        } else if (object == this.selectAllMenuItem) {
            this.inputTextArea.selectAll();
        } else if (object == this.copyMenuItem) {
            this.pasteBuffer = this.inputTextArea.getSelectedText();
        } else if (object == this.cutMenuItem) {
            this.pasteBuffer = this.inputTextArea.getSelectedText();
            int n = this.inputTextArea.getSelectionStart();
            int n2 = this.inputTextArea.getSelectionEnd();
            this.inputTextArea.replaceText("", n, n2);
        } else if (object == this.pasteMenuItem) {
            if (this.pasteBuffer != null) {
                int n;
                int n3 = this.inputTextArea.getSelectionStart();
                if (n3 == (n = this.inputTextArea.getSelectionEnd())) {
                    this.inputTextArea.insertText(this.pasteBuffer, n3);
                } else {
                    this.inputTextArea.replaceText(this.pasteBuffer, n3, n);
                }
            }
        } else if (object == this.deleteMenuItem) {
            int n = this.inputTextArea.getSelectionStart();
            int n4 = this.inputTextArea.getSelectionEnd();
            this.inputTextArea.replaceText("", n, n4);
        } else if (object == this.compileMenuItem) {
            this.doCompile();
        } else if (object == this.runMenuItem) {
            this.doRun();
        } else if (object == this.stopMenuItem) {
            this.doStop();
        } else if (object == this.firstErrorMenuItem) {
            this.doFirstError();
        } else if (object == this.nextErrorMenuItem) {
            this.doNextError();
        } else if (object == this.prevErrorMenuItem) {
            this.doPrevError();
        } else if (object == this.lastErrorMenuItem) {
            this.doLastError();
        } else if (object == this.aboutMenuItem) {
            this.doAbout();
        } else if (object == this.viewLicenseMenuItem) {
            this.doViewLicense();
        } else if (object == this.locateLicenseMenuItem) {
            this.doLocateLicense();
        } else {
            bl = false;
        }
        if (!bl && this.editorApplet != null && object == this.saveVirtualDiskMenuItem) {
            this.doSaveVirtualDisk();
            bl = true;
        }
        if (!bl && this.enableDebugMenu) {
            if (object == this.showThreadsMenuItem) {
                this.doShowThreads();
            } else if (object == this.showMemoryMenuItem) {
                this.doShowMemory();
            } else if (object == this.garbageCollectionMenuItem) {
                this.doGarbageCollection();
            } else if (object == this.runFinalizationMenuItem) {
                this.doRunFinalization();
            }
        }
        this.ConfigMenuItems();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = true;
        Object object = itemEvent.getSource();
        if (object == this.windowSize160x120MenuItem) {
            this.windowSizeDialog.setWidth(160);
            this.windowSizeDialog.setHeight(120);
            this.windowSize160x120MenuItem.setState(true);
            this.windowSize320x240MenuItem.setState(false);
            this.windowSize640x480MenuItem.setState(false);
            this.customWindowSizeMenuItem.setState(false);
        } else if (object == this.windowSize320x240MenuItem) {
            this.windowSizeDialog.setWidth(320);
            this.windowSizeDialog.setHeight(240);
            this.windowSize160x120MenuItem.setState(false);
            this.windowSize320x240MenuItem.setState(true);
            this.windowSize640x480MenuItem.setState(false);
            this.customWindowSizeMenuItem.setState(false);
        } else if (object == this.windowSize640x480MenuItem) {
            this.windowSizeDialog.setWidth(640);
            this.windowSizeDialog.setHeight(480);
            this.windowSize160x120MenuItem.setState(false);
            this.windowSize320x240MenuItem.setState(false);
            this.windowSize640x480MenuItem.setState(true);
            this.customWindowSizeMenuItem.setState(false);
        } else if (object == this.customWindowSizeMenuItem) {
            boolean bl2 = !this.customWindowSizeMenuItem.getState();
            this.windowSizeDialog.show();
            if (this.windowSizeDialog.getOkButtonPressedFlag()) {
                this.windowSize160x120MenuItem.setState(false);
                this.windowSize320x240MenuItem.setState(false);
                this.windowSize640x480MenuItem.setState(false);
                this.customWindowSizeMenuItem.setState(true);
            } else {
                this.customWindowSizeMenuItem.setState(bl2);
            }
        } else if (object == this.useCompilerMenuItem) {
            this.useCompilerMenuItem.setState(true);
            this.useInterpreterMenuItem.setState(false);
            this.useCompilerBackend = true;
        } else if (object == this.useInterpreterMenuItem) {
            this.useCompilerMenuItem.setState(false);
            this.useInterpreterMenuItem.setState(true);
            this.useCompilerBackend = false;
        }
    }
}

