/*
 * Decompiled with CFR 0.152.
 */
package uk.co.visualisationsystems.QuickFire.ImageProducer;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.PixelGrabber;
import uk.co.visualisationsystems.QuickFire.ImageProducer.QuickFireImageProducerException;

class QuickFireSprite {
    private int[] rawSpriteArray;
    private int rawSpriteArraySize;
    private int rawSpriteX;
    private int rawSpriteY;
    private int rawSpriteWidth;
    private int rawSpriteHeight;
    private boolean transformRequired;
    private double angle;
    private double scaleX;
    private double scaleY;
    private int[] tempSpriteArray;
    private int tempSpriteArraySize;
    private int[] spriteArray;
    private int spriteArraySize;
    private int spriteX;
    private int spriteY;
    private int spriteWidth;
    private int spriteHeight;
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private int numFrames;
    private int[][] spriteFrameArray;
    private int currentFrame;
    private int rgb;
    private int lastX;
    private int lastY;
    static int npoints = 0;
    public static int[] xp1 = null;
    public static int[] c1 = null;
    public static int[] xp2 = null;
    public static int[] c2 = null;
    int firstPolyX;
    int firstPolyY;
    int firstPolyRGB;
    int lastPolyX;
    int lastPolyY;
    int lastPolyRGB;
    private static double DEGRAD = Math.PI / 180;

    QuickFireSprite(int n, int n2, int n3, boolean bl) {
        this.numFrames = n;
        this.spriteFrameArray = new int[this.numFrames][];
        this.rawSpriteX = 0;
        this.rawSpriteY = 0;
        this.rawSpriteWidth = n2;
        this.rawSpriteHeight = n3;
        this.rawSpriteArraySize = this.rawSpriteWidth * this.rawSpriteHeight;
        this.tempSpriteArray = null;
        this.tempSpriteArraySize = 0;
        int n4 = bl ? -1 : 0;
        int n5 = 0;
        while (n5 < this.numFrames) {
            this.rawSpriteArray = new int[this.rawSpriteArraySize];
            int n6 = 0;
            while (n6 < this.rawSpriteArraySize) {
                this.rawSpriteArray[n6] = n4;
                ++n6;
            }
            this.spriteFrameArray[n5] = this.rawSpriteArray;
            ++n5;
        }
        this.rawSpriteArray = this.spriteFrameArray[0];
        this.currentFrame = 0;
        this.minX = 0;
        this.minY = 0;
        this.maxX = n2 - 1;
        this.maxY = n3 - 1;
        this.angle = 0.0;
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        this.transformRequired = true;
    }

    int getNumFrames() {
        return this.numFrames;
    }

    int getWidth() {
        return this.rawSpriteWidth;
    }

    int getHeight() {
        return this.rawSpriteHeight;
    }

    int getPixelAt(int n, int n2) {
        int n3 = -1;
        if (n >= this.minX && n <= this.maxX && n2 >= this.minY && n2 <= this.maxY) {
            int n4 = n2 * this.rawSpriteWidth + n;
            n3 = this.rawSpriteArray[n4];
        }
        return n3;
    }

    public void SelectFrame(int n) throws QuickFireImageProducerException {
        if (n >= 0 && n < this.numFrames) {
            if (n != this.currentFrame) {
                this.rawSpriteArray = this.spriteFrameArray[n];
                this.currentFrame = n;
                this.transformRequired = true;
            }
        } else {
            throw new QuickFireImageProducerException("Invalid frameNumber " + n + "  for Sprite");
        }
    }

    public void MoveTo(int n, int n2) {
        this.rawSpriteX = n;
        this.rawSpriteY = n2;
        this.transformRequired = true;
    }

    public void Scale(double d, double d2) {
        if (this.scaleX != d) {
            this.scaleX = d;
            this.transformRequired = true;
        }
        if (this.scaleY != d2) {
            this.scaleY = d2;
            this.transformRequired = true;
        }
    }

    public void Rotate(double d) {
        if (d != this.angle) {
            this.angle = d;
            this.transformRequired = true;
        }
    }

    public void SetColour(int n) {
        this.rgb = n;
    }

    void Plot(int n, int n2) {
        if (n >= this.minX && n <= this.maxX && n2 >= this.minY && n2 <= this.maxY) {
            int n3 = n2 * this.rawSpriteWidth + n;
            this.rawSpriteArray[n3] = this.rgb;
            this.transformRequired = true;
        }
        this.lastX = n;
        this.lastY = n2;
    }

    void DrawTo(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = this.lastX;
        int n13 = n;
        int n14 = this.lastY;
        int n15 = n2;
        if (n13 < n12) {
            n11 = n12;
            n12 = n13;
            n13 = n11;
            n11 = n14;
            n14 = n15;
            n15 = n11;
        }
        n11 = n13 - n12;
        if (n15 > n14) {
            n10 = 1;
            n9 = n15 - n14;
        } else {
            n10 = -1;
            n9 = n14 - n15;
        }
        if (n11 > n9) {
            n8 = 1;
            n7 = 0;
            n6 = 1;
            n5 = n10;
            n4 = n11;
            n3 = n9;
        } else {
            n8 = 0;
            n7 = n10;
            n6 = 1;
            n5 = n10;
            n4 = n9;
            n3 = n11;
        }
        int n16 = n4 / 2;
        int n17 = 0;
        while (n17 < n4 + 1) {
            if (n12 >= this.minX && n12 <= this.maxX && n14 >= this.minY && n14 <= this.maxY) {
                this.rawSpriteArray[n14 * this.rawSpriteWidth + n12] = this.rgb;
            }
            if ((n16 += n3) >= n4) {
                n12 += n6;
                n14 += n5;
                n16 -= n4;
            } else {
                n12 += n8;
                n14 += n7;
            }
            ++n17;
        }
        this.lastX = n;
        this.lastY = n2;
        this.transformRequired = true;
    }

    void SetText(Image image, int n, int n2, int n3, int n4) {
        int[] nArray = new int[n3 * n4];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n3, n4, nArray, 0, n3);
        try {
            pixelGrabber.grabPixels();
            int n5 = 0;
            while (n5 < n4) {
                int n6 = n2 + n5;
                if (n6 < this.rawSpriteHeight) {
                    int n7 = n6 * this.rawSpriteWidth;
                    int n8 = 0;
                    while (n8 < n3) {
                        int n9;
                        int n10 = n + n8;
                        if (n10 < this.rawSpriteWidth && (n9 = nArray[n5 * n3 + n8] & 0xFFFFFF) == 0xFFFFFF) {
                            this.rawSpriteArray[n7 + n10] = this.rgb;
                        }
                        ++n8;
                    }
                }
                ++n5;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.transformRequired = true;
    }

    void PutImage(Image image, int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[n4 * n5];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n4, n5, nArray, 0, n4);
        try {
            pixelGrabber.grabPixels();
            int n6 = 0;
            while (n6 < n5) {
                int n7 = n3 + n6;
                if (n7 < this.rawSpriteHeight) {
                    int n8 = n7 * this.rawSpriteWidth;
                    int n9 = 0;
                    while (n9 < n4) {
                        int n10;
                        int n11 = n2 + n9;
                        if (n11 < this.rawSpriteWidth && (n10 = nArray[n6 * n4 + n9] & 0xFFFFFF) != n) {
                            this.rawSpriteArray[n8 + n11] = n10;
                        }
                        ++n9;
                    }
                }
                ++n6;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.transformRequired = true;
    }

    void ClearArea(int n, int n2, int n3, int n4) {
        if (n < this.minX) {
            n = this.minX;
        }
        if (n3 >= this.maxX) {
            n3 = this.maxX;
        }
        if (n2 < this.minY) {
            n2 = this.minY;
        }
        if (n4 >= this.maxY) {
            n4 = this.maxY;
        }
        int n5 = n2 * this.rawSpriteWidth;
        int n6 = n2;
        while (n6 <= n4) {
            int n7 = n;
            while (n7 <= n3) {
                this.rawSpriteArray[n5 + n7] = 0;
                ++n7;
            }
            n5 += this.rawSpriteWidth;
            ++n6;
        }
        this.transformRequired = true;
    }

    void FillArea(int n, int n2, int n3, int n4) {
        if (n < this.minX) {
            n = this.minX;
        }
        if (n3 >= this.maxX) {
            n3 = this.maxX;
        }
        if (n2 < this.minY) {
            n2 = this.minY;
        }
        if (n4 >= this.maxY) {
            n4 = this.maxY;
        }
        int n5 = n2 * this.rawSpriteWidth;
        int n6 = n2;
        while (n6 <= n4) {
            int n7 = n;
            while (n7 <= n3) {
                this.rawSpriteArray[n5 + n7] = this.rgb;
                ++n7;
            }
            n5 += this.rawSpriteWidth;
            ++n6;
        }
        this.transformRequired = true;
    }

    void DrawSegment(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 >> 24 & 0xFF;
        int n7 = n3 >> 16 & 0xFF;
        int n8 = n3 >> 8 & 0xFF;
        int n9 = n3 & 0xFF;
        int n10 = n5 >> 24 & 0xFF;
        int n11 = n5 >> 16 & 0xFF;
        int n12 = n5 >> 8 & 0xFF;
        int n13 = n5 & 0xFF;
        int n14 = n4 - n2 + 1;
        double d = (double)(n10 - n6) / (double)n14;
        double d2 = (double)(n11 - n7) / (double)n14;
        double d3 = (double)(n12 - n8) / (double)n14;
        double d4 = (double)(n13 - n9) / (double)n14;
        double d5 = n6;
        double d6 = n7;
        double d7 = n8;
        double d8 = n9;
        int n15 = n2;
        while (n15 <= n4) {
            if (n15 >= 0 && n15 < this.rawSpriteWidth) {
                int n16;
                int n17 = (int)d5;
                int n18 = (int)d6;
                int n19 = (int)d7;
                int n20 = (int)d8;
                this.rawSpriteArray[n + n15] = n16 = n17 << 24 | n18 << 16 | n19 << 8 | n20;
            }
            d5 += d;
            d6 += d2;
            d7 += d3;
            d8 += d4;
            ++n15;
        }
    }

    private void CalculatePolyLine(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8 = n3 >> 24 & 0xFF;
        int n9 = n3 >> 16 & 0xFF;
        int n10 = n3 >> 8 & 0xFF;
        int n11 = n3 & 0xFF;
        int n12 = n6 >> 24 & 0xFF;
        int n13 = n6 >> 16 & 0xFF;
        int n14 = n6 >> 8 & 0xFF;
        int n15 = n6 & 0xFF;
        int n16 = Math.abs(n5 - n2) + 1;
        int n17 = n16 >= (n7 = Math.abs(n4 - n) + 1) ? n16 : n7;
        double d = (double)(n12 - n8) / (double)n17;
        double d2 = (double)(n13 - n9) / (double)n17;
        double d3 = (double)(n14 - n10) / (double)n17;
        double d4 = (double)(n15 - n11) / (double)n17;
        double d5 = n8;
        double d6 = n9;
        double d7 = n10;
        double d8 = n11;
        double d9 = n;
        double d10 = (double)(n4 - n) / (double)n17;
        double d11 = n2;
        double d12 = (double)(n5 - n2) / (double)n17;
        int n18 = 0;
        while (n18 < n17) {
            int n19 = (int)d11;
            if (n19 >= 0 && n19 < this.rawSpriteHeight) {
                int n20 = (int)d5;
                int n21 = (int)d6;
                int n22 = (int)d7;
                int n23 = (int)d8;
                int n24 = n20 << 24 | n21 << 16 | n22 << 8 | n23;
                if (d9 < (double)xp1[n19]) {
                    QuickFireSprite.xp1[n19] = (int)d9;
                    QuickFireSprite.c1[n19] = n24;
                }
                if (d9 > (double)xp2[n19]) {
                    QuickFireSprite.xp2[n19] = (int)d9;
                    QuickFireSprite.c2[n19] = n24;
                }
            }
            d5 += d;
            d6 += d2;
            d7 += d3;
            d8 += d4;
            d9 += d10;
            d11 += d12;
            ++n18;
        }
    }

    void PolyBegin(int n, int n2) {
        if (npoints < this.rawSpriteHeight) {
            npoints = this.rawSpriteHeight;
            xp1 = new int[npoints];
            c1 = new int[npoints];
            xp2 = new int[npoints];
            c2 = new int[npoints];
        }
        int n3 = 0;
        while (n3 < npoints) {
            QuickFireSprite.xp1[n3] = Integer.MAX_VALUE;
            QuickFireSprite.xp2[n3] = Integer.MIN_VALUE;
            ++n3;
        }
        this.firstPolyX = this.lastPolyX = n;
        this.firstPolyY = this.lastPolyY = n2;
        this.firstPolyRGB = this.lastPolyRGB = this.rgb;
    }

    void PolyDrawTo(int n, int n2) {
        this.CalculatePolyLine(this.lastPolyX, this.lastPolyY, this.lastPolyRGB, n, n2, this.rgb);
        this.lastPolyX = n;
        this.lastPolyY = n2;
        this.lastPolyRGB = this.rgb;
    }

    void PolyEnd() {
        this.CalculatePolyLine(this.lastPolyX, this.lastPolyY, this.lastPolyRGB, this.firstPolyX, this.firstPolyY, this.firstPolyRGB);
        int n = 0;
        int n2 = 0;
        while (n2 < npoints) {
            if (xp1[n2] != Integer.MAX_VALUE) {
                this.DrawSegment(this.rawSpriteArray, n, xp1[n2], c1[n2], xp2[n2], c2[n2]);
            }
            n += this.rawSpriteWidth;
            ++n2;
        }
        this.transformRequired = true;
    }

    void CopyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 > n && n4 > n2) {
            int n7 = n5 + (n3 - n);
            int n8 = n6 + (n4 - n2);
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            if (n < this.minX) {
                n9 += this.minX - n;
            }
            if (n2 < this.minY) {
                n10 += this.minY - n2;
            }
            if (n3 > this.maxX) {
                n11 += this.maxX - n3;
            }
            if (n4 > this.maxY) {
                n12 += this.maxY - n4;
            }
            int n13 = n5 + n9;
            int n14 = n6 + n10;
            int n15 = n7 + n11;
            int n16 = n8 + n12;
            if (n13 < this.minX) {
                n9 += this.minX - n13;
            }
            if (n14 < this.minY) {
                n10 += this.minY - n14;
            }
            if (n15 > this.maxX) {
                n11 += this.maxX - n15;
            }
            if (n16 > this.maxY) {
                n12 += this.maxY - n16;
            }
            int n17 = n + n9;
            int n18 = n2 + n10;
            int n19 = n3 + n11;
            int n20 = n4 + n12;
            n13 = n5 + n9;
            n14 = n6 + n10;
            n15 = n7 + n11;
            n16 = n8 + n12;
            int n21 = n14 * this.rawSpriteWidth + n13;
            int n22 = n18 * this.rawSpriteWidth + n17;
            if (n21 < n22) {
                int n23 = n18;
                while (n23 <= n20) {
                    int n24 = 0;
                    int n25 = n17;
                    while (n25 <= n19) {
                        int n26;
                        this.rawSpriteArray[n21 + n24] = n26 = this.rawSpriteArray[n22 + n24];
                        ++n25;
                        ++n24;
                    }
                    n22 += this.rawSpriteWidth;
                    n21 += this.rawSpriteWidth;
                    ++n23;
                }
            } else if (n21 > n22) {
                n22 = n20 * this.rawSpriteWidth + n19;
                n21 = n16 * this.rawSpriteWidth + n15;
                int n27 = n20;
                while (n27 >= n18) {
                    int n28 = 0;
                    int n29 = n19;
                    while (n29 >= n17) {
                        this.rawSpriteArray[n21 - n28] = this.rawSpriteArray[n22 - n28];
                        --n29;
                        ++n28;
                    }
                    n22 -= this.rawSpriteWidth;
                    n21 -= this.rawSpriteWidth;
                    --n27;
                }
            }
            if (n < n17) {
                this.ClearArea(n5, n14, n13 - 1, n16);
            }
            if (n3 > n19) {
                this.ClearArea(n15 + 1, n14, n7, n16);
            }
            if (n2 < n18) {
                this.ClearArea(n5, n6, n7, n14 - 1);
            }
            if (n4 > n20) {
                this.ClearArea(n5, n16 + 1, n7, n8);
            }
        }
        this.transformRequired = true;
    }

    private synchronized void DoSpriteTransform() {
        if (this.angle == 0.0 && this.scaleX == 1.0 && this.scaleY == 1.0) {
            this.spriteX = this.rawSpriteX;
            this.spriteY = this.rawSpriteY;
            this.spriteWidth = this.rawSpriteWidth;
            this.spriteHeight = this.rawSpriteHeight;
            this.spriteArraySize = this.rawSpriteArraySize;
            this.spriteArray = this.rawSpriteArray;
        } else {
            double d;
            double d2;
            double d3;
            int n;
            double d4 = Math.sin(this.angle * DEGRAD);
            double d5 = Math.cos(this.angle * DEGRAD);
            double d6 = Double.POSITIVE_INFINITY;
            double d7 = Double.POSITIVE_INFINITY;
            double d8 = Double.NEGATIVE_INFINITY;
            double d9 = Double.NEGATIVE_INFINITY;
            double d10 = (double)this.rawSpriteHeight * this.scaleY;
            double d11 = (double)this.rawSpriteWidth * this.scaleX;
            int n2 = 0;
            while (n2 <= 1) {
                double d12 = (double)n2 * d10;
                n = 0;
                while (n <= 1) {
                    d3 = (double)n * d11;
                    d2 = d5 * d3 + d4 * d12;
                    d = d5 * d12 - d4 * d3;
                    if (d2 > d8) {
                        d8 = d2;
                    }
                    if (d2 < d6) {
                        d6 = d2;
                    }
                    if (d > d9) {
                        d9 = d;
                    }
                    if (d < d7) {
                        d7 = d;
                    }
                    ++n;
                }
                ++n2;
            }
            d6 = Math.floor(d6);
            d7 = Math.floor(d7);
            d8 = Math.ceil(d8);
            d9 = Math.ceil(d9);
            int n3 = -((int)d6);
            int n4 = -((int)d7);
            this.spriteWidth = (int)(d8 - d6) + 1;
            this.spriteHeight = (int)(d9 - d7) + 1;
            int n5 = this.spriteWidth - (int)d11;
            int n6 = this.spriteHeight - (int)d10;
            this.spriteX = this.rawSpriteX - n5 / 2;
            this.spriteY = this.rawSpriteY - n6 / 2;
            this.spriteArraySize = this.spriteWidth * this.spriteHeight;
            if (this.spriteArraySize > this.tempSpriteArraySize) {
                this.tempSpriteArraySize = this.spriteArraySize;
                this.tempSpriteArray = new int[this.tempSpriteArraySize];
            }
            this.spriteArray = this.tempSpriteArray;
            d3 = (d5 * (double)(0 - n3) - d4 * (double)(0 - n4)) / this.scaleX;
            d2 = (d5 * (double)(0 - n4) + d4 * (double)(0 - n3)) / this.scaleY;
            d = (d5 * (double)(this.spriteWidth - n3) - d4 * (double)(0 - n4)) / this.scaleX;
            double d13 = (d5 * (double)(0 - n4) + d4 * (double)(this.spriteWidth - n3)) / this.scaleY;
            double d14 = (d - d3) / (double)this.spriteWidth;
            double d15 = (d13 - d2) / (double)this.spriteWidth;
            n2 = 0;
            while (n2 < this.spriteHeight) {
                d3 = (d5 * (double)(0 - n3) - d4 * (double)(n2 - n4)) / this.scaleX;
                d2 = (d5 * (double)(n2 - n4) + d4 * (double)(0 - n3)) / this.scaleY;
                int n7 = n2 * this.spriteWidth;
                n = 0;
                while (n < this.spriteWidth) {
                    int n8 = (int)Math.round(d3);
                    int n9 = (int)Math.round(d2);
                    int n10 = n8 < 0 || n8 >= this.rawSpriteWidth || n9 < 0 || n9 >= this.rawSpriteHeight ? -1 : this.rawSpriteArray[n9 * this.rawSpriteWidth + n8];
                    this.spriteArray[n7++] = n10;
                    d3 += d14;
                    d2 += d15;
                    ++n;
                }
                ++n2;
            }
        }
        this.transformRequired = false;
    }

    synchronized void Merge(QuickFireSprite quickFireSprite, int n, int n2) {
        int n3;
        int n4;
        if (this.transformRequired) {
            this.DoSpriteTransform();
        }
        int[] nArray = quickFireSprite.rawSpriteArray;
        int n5 = quickFireSprite.rawSpriteWidth;
        int n6 = quickFireSprite.rawSpriteHeight;
        int n7 = 0;
        int n8 = this.spriteWidth;
        int n9 = 0;
        int n10 = this.spriteHeight;
        if (n2 < 0) {
            n9 += -n2;
        }
        if ((n4 = n2 + this.spriteHeight) > n6) {
            n10 -= n4 - n6;
        }
        if (n < 0) {
            n7 += -n;
        }
        if ((n3 = n + this.spriteWidth) > n5) {
            n8 -= n3 - n5;
        }
        int n11 = n9 * this.spriteWidth;
        int n12 = (n2 + n9) * n5 + n;
        int n13 = n9;
        while (n13 < n10) {
            int n14 = n7;
            while (n14 < n8) {
                int n15 = this.spriteArray[n11 + n14];
                if (n15 != -1) {
                    nArray[n12 + n14] = n15;
                }
                ++n14;
            }
            n12 += n5;
            n11 += this.spriteWidth;
            ++n13;
        }
    }

    synchronized void DrawSprite(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        if (this.transformRequired) {
            this.DoSpriteTransform();
        }
        int n5 = 0;
        int n6 = this.spriteWidth;
        int n7 = 0;
        int n8 = this.spriteHeight;
        if (this.spriteY < 0) {
            n7 += -this.spriteY;
        }
        if ((n4 = this.spriteY + this.spriteHeight) > n2) {
            n8 -= n4 - n2;
        }
        if (this.spriteX < 0) {
            n5 += -this.spriteX;
        }
        if ((n3 = this.spriteX + this.spriteWidth) > n) {
            n6 -= n3 - n;
        }
        int n9 = n7 * this.spriteWidth;
        int n10 = (this.spriteY + n7) * n + this.spriteX;
        int n11 = -1;
        int n12 = -1;
        n12 = n7;
        while (n12 < n8) {
            n11 = n5;
            while (n11 < n6) {
                int n13 = this.spriteArray[n9 + n11];
                if (n13 != -1) {
                    nArray[n10 + n11] = n13;
                }
                ++n11;
            }
            n10 += n;
            n9 += this.spriteWidth;
            ++n12;
        }
    }

    synchronized boolean Hit(QuickFireSprite quickFireSprite) {
        Rectangle rectangle;
        Rectangle rectangle2;
        if (this.transformRequired) {
            this.DoSpriteTransform();
        }
        if (quickFireSprite.transformRequired) {
            quickFireSprite.DoSpriteTransform();
        }
        if ((rectangle2 = new Rectangle(this.spriteX, this.spriteY, this.spriteWidth, this.spriteHeight)).intersects(rectangle = new Rectangle(quickFireSprite.spriteX, quickFireSprite.spriteY, quickFireSprite.spriteWidth, quickFireSprite.spriteHeight))) {
            Rectangle rectangle3 = rectangle2.intersection(rectangle);
            int n = rectangle3.x - rectangle2.x;
            int n2 = rectangle3.y - rectangle2.y;
            int n3 = rectangle3.x - rectangle.x;
            int n4 = rectangle3.y - rectangle.y;
            int n5 = rectangle3.width;
            int n6 = rectangle3.height;
            int n7 = n2 * this.spriteWidth + n;
            int n8 = n4 * quickFireSprite.spriteWidth + n3;
            int n9 = 0;
            while (n9 < n6) {
                int n10 = 0;
                while (n10 < n5) {
                    if (this.spriteArray[n7 + n10] >= 0 && quickFireSprite.spriteArray[n8 + n10] >= 0) {
                        return true;
                    }
                    ++n10;
                }
                n7 += this.spriteWidth;
                n8 += quickFireSprite.spriteWidth;
                ++n9;
            }
        }
        return false;
    }
}

