/*
 * Decompiled with CFR 0.152.
 */
package uk.co.visualisationsystems.QuickFire.VirtualDisk;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.StringTokenizer;
import uk.co.visualisationsystems.QuickFire.VirtualDisk.VirtualDisk;

class VirtualDiskManager {
    VirtualDiskManager() {
    }

    static VirtualDisk LoadVirtualDisk(String string) {
        VirtualDisk virtualDisk = null;
        try {
            ObjectInputStream objectInputStream;
            FileInputStream fileInputStream = new FileInputStream(string);
            if (fileInputStream != null && (objectInputStream = new ObjectInputStream(fileInputStream)) != null) {
                Object object = objectInputStream.readObject();
                if (object instanceof VirtualDisk) {
                    virtualDisk = (VirtualDisk)object;
                } else {
                    System.out.println("object = " + object);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("FileNotFoundException: " + fileNotFoundException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ClassNotFoundException: " + classNotFoundException.getMessage());
        }
        catch (OptionalDataException optionalDataException) {
            System.out.println("OptionalDataException: " + optionalDataException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
        }
        return virtualDisk;
    }

    static void SaveVirtualDisk(String string, VirtualDisk virtualDisk) {
        try {
            ObjectOutputStream objectOutputStream;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            if (fileOutputStream != null && (objectOutputStream = new ObjectOutputStream(fileOutputStream)) != null) {
                objectOutputStream.writeObject(virtualDisk);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("FileNotFoundException: " + fileNotFoundException.getMessage());
        }
        catch (OptionalDataException optionalDataException) {
            System.out.println("OptionalDataException: " + optionalDataException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
        }
    }

    static byte[] LoadByteArray(String string) {
        byte[] byArray = null;
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(string);
            if (fileInputStream != null && (n = fileInputStream.available()) > 0) {
                byArray = new byte[n];
                fileInputStream.read(byArray);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("FileNotFoundException: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
        }
        return byArray;
    }

    static void SaveByteArray(String string, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            if (fileOutputStream != null) {
                fileOutputStream.write(byArray);
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException: " + iOException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        VirtualDisk virtualDisk = null;
        boolean bl = false;
        System.out.println("Virtual Disk Manger");
        System.out.println("-------------------");
        DataInputStream dataInputStream = new DataInputStream(System.in);
        boolean bl2 = false;
        do {
            try {
                String string2;
                Object object;
                StringTokenizer stringTokenizer;
                System.out.print("> ");
                String string3 = dataInputStream.readLine();
                if (string3 == null || !(stringTokenizer = new StringTokenizer(string3)).hasMoreTokens()) continue;
                String string4 = stringTokenizer.nextToken();
                if (string4.compareTo("create") == 0) {
                    while (stringTokenizer.hasMoreTokens()) {
                        if (bl) {
                            System.out.println("Saving current virtual disk: " + string);
                            VirtualDiskManager.SaveVirtualDisk(string, virtualDisk);
                        }
                        string = stringTokenizer.nextToken();
                        System.out.println("Creating new disk: " + string);
                        virtualDisk = new VirtualDisk();
                        bl = true;
                    }
                    continue;
                }
                if (string4.compareTo("load") == 0) {
                    while (stringTokenizer.hasMoreTokens()) {
                        if (bl) {
                            System.out.println("Saving current virtual disk: " + string);
                            VirtualDiskManager.SaveVirtualDisk(string, virtualDisk);
                            bl = false;
                        }
                        string = stringTokenizer.nextToken();
                        System.out.println("Loading virtual disk: " + string);
                        virtualDisk = VirtualDiskManager.LoadVirtualDisk(string);
                        if (virtualDisk != null) continue;
                        System.out.println("Virtual disk not found: " + string);
                    }
                    continue;
                }
                if (string4.compareTo("save") == 0) {
                    if (virtualDisk != null) {
                        if (!bl) continue;
                        VirtualDiskManager.SaveVirtualDisk(string, virtualDisk);
                        continue;
                    }
                    System.out.println("No virtual disks loaded!");
                    continue;
                }
                if (string4.compareTo("dir") == 0) {
                    if (virtualDisk != null) {
                        object = virtualDisk.GetDirectory();
                        if (object != null) {
                            int n = 0;
                            while (n < ((String[])object).length) {
                                System.out.println(object[n]);
                                ++n;
                            }
                            continue;
                        }
                        System.out.println("Empty disk");
                        continue;
                    }
                    System.out.println("No virtual disks loaded!");
                    continue;
                }
                if (string4.compareTo("delete") == 0) {
                    if (virtualDisk != null) {
                        while (stringTokenizer.hasMoreTokens()) {
                            object = stringTokenizer.nextToken();
                            virtualDisk.DeleteObject((String)object);
                            bl = true;
                        }
                        continue;
                    }
                    System.out.println("No virtual disks loaded!");
                    continue;
                }
                if (string4.compareTo("rename") == 0) {
                    if (virtualDisk != null) {
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        object = stringTokenizer.nextToken();
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        String string5 = stringTokenizer.nextToken();
                        virtualDisk.RenameObject((String)object, string5);
                        bl = true;
                        continue;
                    }
                    System.out.println("No virtual disks loaded!");
                    continue;
                }
                if (string4.compareTo("import") == 0) {
                    if (virtualDisk != null) {
                        while (stringTokenizer.hasMoreTokens()) {
                            object = stringTokenizer.nextToken();
                            byte[] byArray = VirtualDiskManager.LoadByteArray((String)object);
                            if (byArray == null || (string2 = new String(byArray, 0)) == null) continue;
                            virtualDisk.WriteObject((String)object, string2);
                            bl = true;
                        }
                        continue;
                    }
                    System.out.println("No virtual disks loaded!");
                    continue;
                }
                if (string4.compareTo("export") == 0) {
                    if (virtualDisk != null) {
                        while (stringTokenizer.hasMoreTokens()) {
                            int n;
                            object = stringTokenizer.nextToken();
                            Object object2 = virtualDisk.ReadObject((String)object);
                            if (object2 == null || !(object2 instanceof String) || (n = (string2 = (String)object2).length()) <= 0) continue;
                            byte[] byArray = new byte[n];
                            string2.getBytes(0, n, byArray, 0);
                            VirtualDiskManager.SaveByteArray((String)object, byArray);
                        }
                        continue;
                    }
                    System.out.println("No virtual disks loaded!");
                    continue;
                }
                if (string4.compareTo("quit") == 0) {
                    bl2 = true;
                    continue;
                }
                System.out.println("create virtualDisk             - Create new virtual disk");
                System.out.println("load virtualDisk               - Load specified virtual disk");
                System.out.println("save                           - Save virtual disk");
                System.out.println("dir                            - Get directory listing");
                System.out.println("delete filename [filename...]  - Delete specified files");
                System.out.println("rename fromFilename toFilename - Rename specified file");
                System.out.println("import filename [filename...]  - Import specified files");
                System.out.println("export filename [filename...]  - Export specified files");
                System.out.println("quit                           - Leave Program");
            }
            catch (IOException iOException) {
                System.out.println("IOException: " + iOException.getMessage());
                bl2 = true;
            }
        } while (!bl2);
        if (bl) {
            System.out.println("Saving current virtual disk: " + string);
            VirtualDiskManager.SaveVirtualDisk(string, virtualDisk);
        }
    }
}

