/*
 * Decompiled with CFR 0.152.
 */
package uk.co.visualisationsystems.QuickFire.Compiler;

import java.io.PrintStream;
import uk.co.visualisationsystems.QuickFire.Compiler.FunctionFrame;
import uk.co.visualisationsystems.QuickFire.Compiler.Operand;
import uk.co.visualisationsystems.QuickFire.Compiler.QuickFireRuntimeError;
import uk.co.visualisationsystems.QuickFire.Compiler.Symbol;

class SymbolOperand
extends Operand {
    Symbol symbol;
    Operand index;
    FunctionFrame symbolFunctionFrame = null;
    int symbolClass;
    int symbolType;
    String symbolName;

    SymbolOperand() {
    }

    SymbolOperand(Symbol symbol, int n) {
        super(n);
        this.symbol = symbol;
        this.index = null;
        this.symbolClass = symbol.GetSymbolClass();
        this.symbolType = symbol.GetSymbolType();
        this.symbolName = symbol.GetSymbolName();
    }

    void Print(PrintStream printStream) {
        if (this.symbolName == null) {
            printStream.print("symbolName==null");
        } else {
            printStream.print(this.symbolName);
        }
        if (this.index != null) {
            printStream.print("[");
            this.index.Print(printStream);
            printStream.print("]");
        }
    }

    boolean isArrayAccess() {
        return this.index != null;
    }

    boolean isNumericOperand() {
        boolean bl;
        switch (this.symbolType) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    boolean isStringOperand() {
        boolean bl;
        switch (this.symbolType) {
            case 7: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    boolean isFunctionCallOperand() {
        return this.symbolClass == 5;
    }

    boolean isSystemCallOperand() {
        return this.symbolClass == 7;
    }

    int GetType() {
        int n = this.symbolType;
        if (this.index != null) {
            switch (this.symbolType) {
                case 8: {
                    n = 3;
                    break;
                }
                case 9: {
                    n = 4;
                    break;
                }
                case 10: {
                    n = 5;
                    break;
                }
                case 11: {
                    n = 6;
                    break;
                }
                case 12: {
                    n = 7;
                    break;
                }
                default: {
                    System.out.println("Attempt to access non-array using array index: symbolName=" + this.symbolName + " symbolType=" + this.symbolType);
                }
            }
        }
        return n;
    }

    Symbol GetSymbol() {
        return this.symbol;
    }

    Operand GetIndex() {
        return this.index;
    }

    String GetSymbolName() {
        return this.symbolName;
    }

    FunctionFrame GetFunctionFrame() {
        return this.symbol.GetFunctionFrame();
    }

    void SetFunctionFrame(FunctionFrame functionFrame) {
        this.symbolFunctionFrame = functionFrame;
    }

    void SetIndexOperand(Operand operand) {
        this.index = operand;
    }

    void ThrowArrayOutOfBounds(int n) {
        String string = this.symbolName + ": Array out of bounds, index=" + n + ", valid=[0 ... " + (this.symbol.array.length - 1) + "]";
        throw new QuickFireRuntimeError(string, this.sourceOffset);
    }

    void ThrowVariableNotInitialised() {
        throw new QuickFireRuntimeError(this.symbolName + ": Not initialised", this.sourceOffset);
    }

    public void PutObject(Object object) {
        if (this.index != null) {
            int n = this.index.GetInteger();
            if (n < 0 || n >= this.symbol.array.length) {
                this.ThrowArrayOutOfBounds(n);
            }
            this.symbol.array[n] = object;
        } else {
            this.symbol.valObject = object;
        }
    }

    public void PutObjectArray(Object[] objectArray) {
        if (this.symbol.isArray()) {
            this.symbol.array = objectArray;
        } else {
            System.out.println("SymbolOperand: PutObjectArray() to non array");
        }
    }

    public void PutInteger(int n) {
        if (this.index != null) {
            int n2 = this.index.GetInteger();
            if (n2 < 0 || n2 >= this.symbol.array.length) {
                this.ThrowArrayOutOfBounds(n2);
            }
            this.symbol.array[n2] = new Integer(n);
        } else {
            this.symbol.valObject = new Integer(n);
        }
    }

    public void PutLong(long l) {
        if (this.index != null) {
            int n = this.index.GetInteger();
            if (n < 0 || n >= this.symbol.array.length) {
                this.ThrowArrayOutOfBounds(n);
            }
            this.symbol.array[n] = new Long(l);
        } else {
            this.symbol.valObject = new Long(l);
        }
    }

    public void PutFloat(float f) {
        if (this.index != null) {
            int n = this.index.GetInteger();
            if (n < 0 || n >= this.symbol.array.length) {
                this.ThrowArrayOutOfBounds(n);
            }
            this.symbol.array[n] = new Float(f);
        } else {
            this.symbol.valObject = new Float(f);
        }
    }

    public void PutDouble(double d) {
        if (this.index != null) {
            int n = this.index.GetInteger();
            if (n < 0 || n >= this.symbol.array.length) {
                this.ThrowArrayOutOfBounds(n);
            }
            this.symbol.array[n] = new Double(d);
        } else {
            this.symbol.valObject = new Double(d);
        }
    }

    public void PutString(String string) {
        if (this.index != null) {
            int n = this.index.GetInteger();
            if (n < 0 || n >= this.symbol.array.length) {
                this.ThrowArrayOutOfBounds(n);
            }
            this.symbol.array[n] = string;
        } else {
            this.symbol.valObject = string;
        }
    }

    public Object GetObject() {
        Object object;
        if (this.index != null) {
            int n = this.index.GetInteger();
            if (n < 0 || n >= this.symbol.array.length) {
                this.ThrowArrayOutOfBounds(n);
            }
            object = this.symbol.array[n];
        } else {
            object = this.symbol.valObject;
        }
        return object;
    }

    public Object[] GetObjectArray() {
        Object[] objectArray = this.symbol.isArray() ? this.symbol.array : null;
        return objectArray;
    }

    public int GetInteger() {
        Object object;
        int n = 0;
        if (this.index != null) {
            int n2 = this.index.GetInteger();
            if (n2 < 0 || n2 >= this.symbol.array.length) {
                this.ThrowArrayOutOfBounds(n2);
            }
            object = this.symbol.array[n2];
        } else {
            object = this.symbol.valObject;
        }
        if (object instanceof Number) {
            n = ((Number)object).intValue();
        } else if (object == null) {
            this.ThrowVariableNotInitialised();
        } else {
            this.ThrowBadOperand();
        }
        return n;
    }

    public long GetLong() {
        Object object;
        long l = 0L;
        if (this.index != null) {
            int n = this.index.GetInteger();
            if (n < 0 || n >= this.symbol.array.length) {
                this.ThrowArrayOutOfBounds(n);
            }
            object = this.symbol.array[n];
        } else {
            object = this.symbol.valObject;
        }
        if (object instanceof Number) {
            l = ((Number)object).longValue();
        } else if (object == null) {
            this.ThrowVariableNotInitialised();
        } else {
            this.ThrowBadOperand();
        }
        return l;
    }

    public float GetFloat() {
        Object object;
        float f = 0.0f;
        if (this.index != null) {
            int n = this.index.GetInteger();
            if (n < 0 || n >= this.symbol.array.length) {
                this.ThrowArrayOutOfBounds(n);
            }
            object = this.symbol.array[n];
        } else {
            object = this.symbol.valObject;
        }
        if (object instanceof Number) {
            f = ((Number)object).floatValue();
        } else if (object == null) {
            this.ThrowVariableNotInitialised();
        } else {
            this.ThrowBadOperand();
        }
        return f;
    }

    public double GetDouble() {
        Object object;
        double d = 0.0;
        if (this.index != null) {
            int n = this.index.GetInteger();
            if (n < 0 || n >= this.symbol.array.length) {
                this.ThrowArrayOutOfBounds(n);
            }
            object = this.symbol.array[n];
        } else {
            object = this.symbol.valObject;
        }
        if (object instanceof Number) {
            d = ((Number)object).doubleValue();
        } else if (object == null) {
            this.ThrowVariableNotInitialised();
        } else {
            this.ThrowBadOperand();
        }
        return d;
    }

    public String GetString() {
        Object object;
        String string = null;
        if (this.index != null) {
            int n = this.index.GetInteger();
            if (n < 0 || n >= this.symbol.array.length) {
                this.ThrowArrayOutOfBounds(n);
            }
            object = this.symbol.array[n];
        } else {
            object = this.symbol.valObject;
        }
        if (object instanceof String) {
            string = (String)object;
        } else if (object == null) {
            this.ThrowVariableNotInitialised();
        } else {
            this.ThrowBadOperand();
        }
        return string;
    }
}

