/*
 * Decompiled with CFR 0.152.
 */
package uk.co.visualisationsystems.QuickFire.Editor;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class WindowSizeDialog
extends Dialog
implements ActionListener,
WindowListener {
    private Label widthLabel;
    private TextField widthField;
    private Label heightLabel;
    private TextField heightField;
    private Button okButton;
    private Button cancelButton;
    private int width = 320;
    private int height = 240;
    private boolean okButtonPressedFlag;

    WindowSizeDialog(Frame frame) {
        super(frame, "Window Size", true);
        GridLayout gridLayout = new GridLayout(3, 2);
        this.setLayout(gridLayout);
        this.widthLabel = new Label("Width");
        this.add(this.widthLabel);
        this.widthField = new TextField(Integer.toString(this.width), 4);
        this.add(this.widthField);
        this.heightLabel = new Label("Height");
        this.add(this.heightLabel);
        this.heightField = new TextField(Integer.toString(this.height), 4);
        this.add(this.heightField);
        this.okButton = new Button("OK");
        this.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new Button("Cancel");
        this.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.addWindowListener(this);
        ((Component)this).setBackground(Color.lightGray);
        this.pack();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.widthField.setText(Integer.toString(this.width));
        this.heightField.setText(Integer.toString(this.height));
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            this.width = Integer.parseInt(this.widthField.getText());
            this.height = Integer.parseInt(this.heightField.getText());
            this.okButtonPressedFlag = true;
        } else {
            this.okButtonPressedFlag = false;
        }
        this.hide();
    }

    public boolean getOkButtonPressedFlag() {
        return this.okButtonPressedFlag;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int n) {
        this.width = n;
        this.widthField.setText(Integer.toString(n));
    }

    public void setHeight(int n) {
        this.height = n;
        this.heightField.setText(Integer.toString(n));
    }
}

