package com.softviewtech.jbillboard;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;

/** Very simplistic "Web browser" using Swing. Supply a URL on the
 *  command line to see it initially, and to set the destination
 *  of the "home" button.
 *  1998 Marty Hall, http://www.apl.jhu.edu/~hall/java/
 */

public class HelpBrowser extends JFrame implements HyperlinkListener {

  private JEditorPane htmlPane;
  private String initialURL;

  public HelpBrowser(String initialURL) {
    super("Help of JBillboard");
    this.initialURL = initialURL;
    addWindowListener(new ExitListener());

    JPanel topPanel = new JPanel();
    topPanel.setBackground(Color.lightGray);
    getContentPane().add(topPanel, BorderLayout.NORTH);

    try {
        URL url=new URL(initialURL);
        htmlPane = new JEditorPane(url);
//        htmlPane = new JEditorPane(initialURL);

        htmlPane.setEditable(false);
        htmlPane.addHyperlinkListener(this);
        JScrollPane scrollPane = new JScrollPane(htmlPane);
        getContentPane().add(scrollPane, BorderLayout.CENTER);
    } catch(IOException ioe) {
       warnUser("Can't build HTML pane for " + initialURL + ": " + ioe);
       dispose();
    }

    Dimension screenSize = getToolkit().getScreenSize();
    int width = screenSize.width * 8 / 10;
    int height = screenSize.height * 8 / 10;
    setBounds(width/8, height/8, width, height);
    setVisible(true);
  }

  public void hyperlinkUpdate(HyperlinkEvent event) {
    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
      try {
        htmlPane.setPage(event.getURL());
      } catch(IOException ioe) {
        warnUser("Can't follow link to "
                 + event.getURL().toExternalForm() + ": " + ioe);
      }
    }
  }

  private void warnUser(String message) {
    JOptionPane.showMessageDialog(this, message, "Error",
                                  JOptionPane.ERROR_MESSAGE);
    dispose();
  }

  class ExitListener extends WindowAdapter {
    public void windowClosing(WindowEvent event) {
      dispose();
    }
  }
}


