/*
 * Decompiled with CFR 0.152.
 */
package jfr.pagesucker;

import java.awt.Frame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import jfr.awt.AWTUtil;
import jfr.awt.MessageDialog;
import jfr.html.Parser;
import jfr.pagesucker.Constants;
import jfr.pagesucker.PageSucker;
import jfr.pagesucker.RegistrationDialog;
import jfr.pagesucker.RegistrationException;
import jfr.util.Alphabet;
import jfr.util.StringUtils;

public class Registration {
    private static final int CHECKSUM_START_VALUE = 5916;
    private static final int[] secret_key_table;
    private static final int REG_FILE_KEY = 8253;

    public static void showRegistrationDialog() {
        StringBuffer name = new StringBuffer();
        StringBuffer number = new StringBuffer();
        while (true) {
            RegistrationDialog dialog;
            if (!(dialog = new RegistrationDialog((Frame)Main.sucker.frame_control, PageSucker.registration_name, PageSucker.registration_number)).handle(name, number)) {
                if (PageSucker.registration_name == null) {
                    new MessageDialog((Frame)Main.sucker.frame_control, "You have chosen to use the demo version of PageSucker. You'll find that certain functions are disabled in that version, but simple Web sites can still be downloaded.\n\nYou can unlock the whole power of PageSucker at any time by registering. The shareware fee is USD 10.- for a single user license. See the ReadMe file for more details.", 2).handle();
                }
                return;
            }
            String name_string = name.toString();
            String number_string = number.toString();
            name_string = Parser.alphabet_control_characters.clean(name_string);
            number_string = Parser.alphabet_control_characters.clean(number_string);
            name_string = Parser.alphabet_whitespace.trim(name_string);
            number_string = Parser.alphabet_whitespace.trim(number_string);
            String old_reg_name = PageSucker.registration_name;
            String old_reg_number = PageSucker.registration_number;
            int old_reg_checksum1 = PageSucker.registration_checksum1;
            int old_reg_checksum2 = PageSucker.registration_checksum2;
            try {
                Registration.verifyRegistrationData(name_string, number_string);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (RegistrationException registrationException) {
                PageSucker.registration_name = name_string;
                PageSucker.registration_number = number_string;
                AWTUtil.updateLabelText(Main.sucker.frame_control.label_reg_name, "Registered To: " + name_string);
                Registration.saveRegistrationFile(name_string, number_string);
                new MessageDialog((Frame)Main.sucker.frame_control, "Thank you for supporting the concept of shareware!\nPageSucker has been unlocked.", 1).handle();
                return;
            }
            new MessageDialog((Frame)Main.sucker.frame_control, "Sorry, but that is not a valid registration number!\nPlease try again.", 3).handle();
            if (old_reg_name == null) continue;
            PageSucker.registration_name = old_reg_name;
            PageSucker.registration_number = old_reg_number;
            PageSucker.registration_checksum1 = old_reg_checksum1;
            PageSucker.registration_checksum2 = old_reg_checksum2;
        }
    }

    private static void verifyRegistrationData(String name, String number) throws RegistrationException {
        int name_length = name.length();
        if (name_length == 0 || number.length() == 0) {
            throw new StringIndexOutOfBoundsException();
        }
        name = Constants.alphabet_non_ASCII_or_control_characters.clean(name, 'x');
        PageSucker.registration_checksum1 = 5916;
        PageSucker.registration_checksum2 = (PageSucker.registration_checksum1 - 23) * 3 + name_length;
        PageSucker.registration_name = null;
        PageSucker.registration_number = null;
        int checksum = 5916;
        int previous_int = name.charAt(0);
        int i = 0;
        while (i < name_length) {
            int j = i * 2;
            char name_data = name.charAt(i);
            int number_data = Integer.parseInt(number.substring(j, j + 2), 16);
            previous_int = (number_data + (secret_key_table[number_data] ^ previous_int) + name_data) % 256;
            checksum += previous_int;
            ++i;
        }
        PageSucker.registration_checksum1 = checksum - 485;
        PageSucker.registration_checksum2 = Integer.parseInt(number.substring(name_length * 2), 16);
        if (PageSucker.registration_checksum1 - (PageSucker.registration_checksum1 + 485 - PageSucker.registration_checksum2) == PageSucker.registration_checksum1) {
            throw new RegistrationException();
        }
        PageSucker.registration_checksum1 *= 2;
    }

    private static void saveRegistrationFile(String name_string, String number_string) {
        FileOutputStream fos = null;
        FilterOutputStream out_stream = null;
        String fspec = System.getProperty("user.home", "");
        if (fspec.length() > 0 && !fspec.endsWith(File.separator)) {
            fspec = String.valueOf(fspec) + File.separator;
        }
        fspec = String.valueOf(fspec) + "PageSuckerRegistration.dat";
        try {
            try {
                File file = new File(fspec);
                fos = new FileOutputStream(file);
                out_stream = new DataOutputStream(fos);
                String encrypted_string = StringUtils.cryptString(String.valueOf(name_string) + '\n' + number_string, 8253);
                ((DataOutputStream)out_stream).writeUTF(encrypted_string);
                ((DataOutputStream)out_stream).flush();
            }
            catch (IOException e) {
                new MessageDialog((Frame)Main.sucker.frame_control, "Couldn't write the registration file.\n" + e.toString(), 2).handle();
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {
                if (out_stream != null) {
                    out_stream.close();
                }
            }
            catch (IOException e) {
                new MessageDialog((Frame)Main.sucker.frame_control, "Couldn't close the registration file.\n" + e.toString(), 2).handle();
            }
            throw throwable;
        }
        try {
            if (out_stream != null) {
                out_stream.close();
            }
        }
        catch (IOException e) {
            new MessageDialog((Frame)Main.sucker.frame_control, "Couldn't close the registration file.\n" + e.toString(), 2).handle();
        }
    }

    public static boolean loadRegistrationFile() {
        FileInputStream fis = null;
        FilterInputStream in_stream = null;
        boolean result = false;
        PageSucker.registration_checksum1 = 0;
        PageSucker.registration_checksum2 = 0;
        PageSucker.registration_name = null;
        PageSucker.registration_number = null;
        String fspec = System.getProperty("user.home", "");
        if (fspec.length() > 0 && !fspec.endsWith(File.separator)) {
            fspec = String.valueOf(fspec) + File.separator;
        }
        fspec = String.valueOf(fspec) + "PageSuckerRegistration.dat";
        try {
            try {
                File file = new File(fspec);
                fis = new FileInputStream(file);
                in_stream = new DataInputStream(fis);
                String data = ((DataInputStream)in_stream).readUTF();
                StringBuffer data_buffer = new StringBuffer(StringUtils.cryptString(data, 8253));
                data_buffer.reverse();
                String name = Parser.alphabet_not_eol.spanBackAndRemove(data_buffer);
                Alphabet.readFromEnd(data_buffer);
                data_buffer.reverse();
                String number = data_buffer.toString();
                try {
                    Registration.verifyRegistrationData(name, number);
                }
                catch (RegistrationException registrationException) {
                    PageSucker.registration_name = name;
                    PageSucker.registration_number = number;
                    result = true;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                if (in_stream != null) {
                    in_stream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (in_stream != null) {
                in_stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    static {
        int[] nArray = new int[256];
        nArray[0] = 186;
        nArray[1] = 202;
        nArray[2] = 27;
        nArray[3] = 107;
        nArray[4] = 233;
        nArray[5] = 78;
        nArray[6] = 39;
        nArray[7] = 19;
        nArray[8] = 171;
        nArray[10] = 188;
        nArray[11] = 38;
        nArray[12] = 191;
        nArray[13] = 160;
        nArray[14] = 125;
        nArray[15] = 68;
        nArray[16] = 229;
        nArray[17] = 153;
        nArray[18] = 158;
        nArray[19] = 236;
        nArray[20] = 136;
        nArray[21] = 18;
        nArray[22] = 196;
        nArray[23] = 1;
        nArray[24] = 86;
        nArray[25] = 126;
        nArray[26] = 206;
        nArray[27] = 214;
        nArray[28] = 212;
        nArray[29] = 201;
        nArray[30] = 54;
        nArray[31] = 239;
        nArray[32] = 121;
        nArray[33] = 132;
        nArray[34] = 13;
        nArray[35] = 182;
        nArray[36] = 198;
        nArray[37] = 231;
        nArray[38] = 17;
        nArray[39] = 252;
        nArray[40] = 96;
        nArray[41] = 151;
        nArray[42] = 144;
        nArray[43] = 108;
        nArray[44] = 142;
        nArray[45] = 2;
        nArray[46] = 44;
        nArray[47] = 8;
        nArray[48] = 146;
        nArray[49] = 255;
        nArray[50] = 222;
        nArray[51] = 10;
        nArray[52] = 6;
        nArray[53] = 77;
        nArray[54] = 247;
        nArray[55] = 224;
        nArray[56] = 193;
        nArray[57] = 84;
        nArray[58] = 230;
        nArray[59] = 185;
        nArray[60] = 137;
        nArray[61] = 55;
        nArray[62] = 28;
        nArray[63] = 243;
        nArray[64] = 60;
        nArray[65] = 204;
        nArray[66] = 37;
        nArray[67] = 9;
        nArray[68] = 232;
        nArray[69] = 99;
        nArray[70] = 169;
        nArray[71] = 207;
        nArray[72] = 161;
        nArray[73] = 87;
        nArray[74] = 52;
        nArray[75] = 176;
        nArray[76] = 56;
        nArray[77] = 195;
        nArray[78] = 65;
        nArray[79] = 238;
        nArray[80] = 29;
        nArray[81] = 26;
        nArray[82] = 4;
        nArray[83] = 130;
        nArray[84] = 181;
        nArray[85] = 187;
        nArray[86] = 97;
        nArray[87] = 154;
        nArray[88] = 115;
        nArray[89] = 194;
        nArray[90] = 150;
        nArray[91] = 192;
        nArray[92] = 34;
        nArray[93] = 179;
        nArray[94] = 216;
        nArray[95] = 24;
        nArray[96] = 246;
        nArray[97] = 145;
        nArray[98] = 138;
        nArray[99] = 227;
        nArray[100] = 190;
        nArray[101] = 71;
        nArray[102] = 180;
        nArray[103] = 25;
        nArray[104] = 23;
        nArray[105] = 20;
        nArray[106] = 139;
        nArray[107] = 253;
        nArray[108] = 35;
        nArray[109] = 40;
        nArray[110] = 199;
        nArray[111] = 22;
        nArray[112] = 170;
        nArray[113] = 163;
        nArray[114] = 155;
        nArray[115] = 102;
        nArray[116] = 242;
        nArray[117] = 134;
        nArray[118] = 117;
        nArray[119] = 197;
        nArray[120] = 213;
        nArray[121] = 32;
        nArray[122] = 149;
        nArray[123] = 61;
        nArray[124] = 112;
        nArray[125] = 64;
        nArray[126] = 210;
        nArray[127] = 109;
        nArray[128] = 128;
        nArray[129] = 100;
        nArray[130] = 122;
        nArray[131] = 11;
        nArray[132] = 21;
        nArray[133] = 51;
        nArray[134] = 215;
        nArray[135] = 235;
        nArray[136] = 208;
        nArray[137] = 92;
        nArray[138] = 30;
        nArray[139] = 70;
        nArray[140] = 147;
        nArray[141] = 83;
        nArray[142] = 79;
        nArray[143] = 175;
        nArray[144] = 177;
        nArray[145] = 141;
        nArray[146] = 15;
        nArray[147] = 50;
        nArray[148] = 223;
        nArray[149] = 166;
        nArray[150] = 12;
        nArray[151] = 33;
        nArray[152] = 41;
        nArray[153] = 189;
        nArray[154] = 250;
        nArray[155] = 152;
        nArray[156] = 157;
        nArray[157] = 211;
        nArray[158] = 200;
        nArray[159] = 95;
        nArray[160] = 74;
        nArray[161] = 219;
        nArray[162] = 249;
        nArray[163] = 165;
        nArray[164] = 111;
        nArray[165] = 91;
        nArray[166] = 203;
        nArray[167] = 124;
        nArray[168] = 49;
        nArray[169] = 220;
        nArray[170] = 75;
        nArray[171] = 183;
        nArray[172] = 174;
        nArray[173] = 148;
        nArray[174] = 3;
        nArray[175] = 135;
        nArray[176] = 5;
        nArray[177] = 119;
        nArray[178] = 58;
        nArray[179] = 67;
        nArray[180] = 244;
        nArray[181] = 178;
        nArray[182] = 221;
        nArray[183] = 159;
        nArray[184] = 73;
        nArray[185] = 106;
        nArray[186] = 88;
        nArray[187] = 140;
        nArray[188] = 72;
        nArray[189] = 162;
        nArray[190] = 94;
        nArray[191] = 104;
        nArray[192] = 205;
        nArray[193] = 118;
        nArray[194] = 226;
        nArray[195] = 31;
        nArray[196] = 168;
        nArray[197] = 43;
        nArray[198] = 45;
        nArray[199] = 167;
        nArray[200] = 46;
        nArray[201] = 120;
        nArray[202] = 127;
        nArray[203] = 48;
        nArray[204] = 143;
        nArray[205] = 228;
        nArray[206] = 173;
        nArray[207] = 66;
        nArray[208] = 113;
        nArray[209] = 103;
        nArray[210] = 82;
        nArray[211] = 129;
        nArray[212] = 53;
        nArray[213] = 254;
        nArray[214] = 14;
        nArray[215] = 218;
        nArray[216] = 131;
        nArray[217] = 47;
        nArray[218] = 114;
        nArray[219] = 217;
        nArray[220] = 89;
        nArray[221] = 69;
        nArray[222] = 234;
        nArray[223] = 36;
        nArray[224] = 110;
        nArray[225] = 251;
        nArray[226] = 16;
        nArray[227] = 57;
        nArray[228] = 240;
        nArray[229] = 101;
        nArray[230] = 209;
        nArray[231] = 42;
        nArray[232] = 172;
        nArray[233] = 248;
        nArray[234] = 76;
        nArray[235] = 105;
        nArray[236] = 85;
        nArray[237] = 90;
        nArray[238] = 59;
        nArray[239] = 225;
        nArray[240] = 184;
        nArray[241] = 116;
        nArray[242] = 98;
        nArray[243] = 245;
        nArray[244] = 7;
        nArray[245] = 164;
        nArray[246] = 156;
        nArray[247] = 62;
        nArray[248] = 93;
        nArray[249] = 81;
        nArray[250] = 133;
        nArray[251] = 237;
        nArray[252] = 123;
        nArray[253] = 80;
        nArray[254] = 241;
        nArray[255] = 63;
        secret_key_table = nArray;
    }
}

