/*
 * Decompiled with CFR 0.152.
 */
package jfr.pagesucker;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.Perl5Pattern;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import jfr.awt.MessageDialog;
import jfr.pagesucker.Constants;
import jfr.pagesucker.InvalidSettingsFileError;
import jfr.pagesucker.PageSucker;
import jfr.pagesucker.SettingsFileVersionError;
import jfr.util.FileAccessor;
import jfr.util.StringUtils;

public class Settings {
    private static final int SETTINGS_FILE_VERSION = 1;
    private static final int RECOGNIZED_SETTINGS_FILE_VERSION = 1;
    private static final int LOGIN_CRYPT_KEY = 149;
    public String base_url_string;
    public String logfilespec;
    public boolean log_history;
    public boolean beep_when_finished;
    public boolean remember_window_positions;
    public String http_proxy_host;
    public int http_proxy_port;
    public String ftp_proxy_host;
    public int ftp_proxy_port;
    public boolean treat_urls_case_insensitive;
    public String[] default_page_names;
    public String save_types_string;
    public String[] save_types;
    public String[] html_types;
    public String[] authentications;
    public boolean save_untyped_non_html;
    public boolean save_html_pages;
    public boolean parse_html_pages_not_in_hierarchy;
    public boolean parse_remote_html_pages;
    public boolean consider_frames_on_same_level_as_page;
    public boolean save_embedded_images;
    public boolean save_images_not_in_hierarchy;
    public boolean save_remote_images;
    public boolean consider_images_on_same_level_as_page;
    public boolean save_non_html_objects;
    public boolean save_non_html_objects_not_in_hierarchy;
    public boolean save_remote_non_html_objects;
    public boolean dont_allow_gt_in_strings;
    public boolean accept_single_line_comments;
    public boolean guess_urls_in_javascript;
    public boolean guess_urls_in_select;
    public boolean recognize_javascript_in_tags;
    public boolean parse_ram_files;
    public boolean accept_ram_files_not_in_hierarchy;
    public boolean accept_remote_ram_files;
    public boolean consider_ram_files_on_same_level_as_page;
    public boolean use_absolute_paths_in_ram_files;
    public byte ram_file_action;
    public boolean parse_m3u_files;
    public boolean accept_m3u_files_not_in_hierarchy;
    public boolean accept_remote_m3u_files;
    public boolean consider_m3u_files_on_same_level_as_page;
    public boolean use_absolute_paths_in_m3u_files;
    public byte m3u_file_action;
    public int max_recursion_depth;
    public int max_remote_recursion_depth;
    public int max_threads;
    public int max_parsing_threads;
    public int existing_file_strategy;
    public boolean alphanumeric_filenames;
    public int untyped_object_mode;
    public Perl5Pattern pattern_regexp_filter;
    public String string_regexp_filter;

    Settings() {
        this.setDefaultValues();
    }

    Settings(boolean in_initialize) {
        if (in_initialize) {
            this.setDefaultValues();
        }
    }

    public void setDefaultValues() {
        this.base_url_string = "http://www.crpht.lu/";
        this.logfilespec = "PageSuckerLog.txt";
        this.log_history = false;
        this.beep_when_finished = true;
        this.remember_window_positions = true;
        this.http_proxy_host = "";
        this.http_proxy_port = 80;
        this.ftp_proxy_host = "";
        this.ftp_proxy_port = 80;
        this.treat_urls_case_insensitive = false;
        this.default_page_names = null;
        this.save_types_string = "gif, jpg, ra, rm, mp3";
        this.buildSaveTypesArrayFromSaveTypesString();
        this.buildHTMLTypesArrayFromString("html, htm, shtml, htmlx");
        this.authentications = null;
        this.save_untyped_non_html = true;
        this.save_html_pages = true;
        this.parse_html_pages_not_in_hierarchy = true;
        this.parse_remote_html_pages = false;
        this.consider_frames_on_same_level_as_page = true;
        this.save_embedded_images = true;
        this.save_images_not_in_hierarchy = true;
        this.save_remote_images = false;
        this.consider_images_on_same_level_as_page = true;
        this.save_non_html_objects = true;
        this.save_non_html_objects_not_in_hierarchy = true;
        this.save_remote_non_html_objects = false;
        this.dont_allow_gt_in_strings = false;
        this.accept_single_line_comments = true;
        this.guess_urls_in_javascript = false;
        this.guess_urls_in_select = false;
        this.recognize_javascript_in_tags = false;
        this.parse_ram_files = false;
        this.accept_ram_files_not_in_hierarchy = true;
        this.accept_remote_ram_files = true;
        this.consider_ram_files_on_same_level_as_page = true;
        this.use_absolute_paths_in_ram_files = true;
        this.ram_file_action = (byte)23;
        this.parse_m3u_files = false;
        this.accept_m3u_files_not_in_hierarchy = true;
        this.accept_remote_m3u_files = true;
        this.consider_m3u_files_on_same_level_as_page = true;
        this.use_absolute_paths_in_m3u_files = true;
        this.m3u_file_action = (byte)33;
        this.max_recursion_depth = -1;
        this.max_remote_recursion_depth = 0;
        this.max_threads = 10;
        this.max_parsing_threads = 10;
        this.existing_file_strategy = 4;
        this.alphanumeric_filenames = true;
        this.untyped_object_mode = 11;
        this.pattern_regexp_filter = null;
        this.string_regexp_filter = "http://.+/h[^/]*";
        if (PageSucker.registration_checksum1 + 485 != PageSucker.registration_checksum2) {
            this.parse_html_pages_not_in_hierarchy = false;
        }
    }

    public Settings makeClone() {
        Settings result = new Settings(false);
        result.base_url_string = this.base_url_string;
        result.logfilespec = this.logfilespec;
        result.log_history = this.log_history;
        result.beep_when_finished = this.beep_when_finished;
        result.remember_window_positions = this.remember_window_positions;
        result.http_proxy_host = this.http_proxy_host;
        result.http_proxy_port = this.http_proxy_port;
        result.ftp_proxy_host = this.ftp_proxy_host;
        result.ftp_proxy_port = this.ftp_proxy_port;
        result.treat_urls_case_insensitive = this.treat_urls_case_insensitive;
        result.default_page_names = this.default_page_names;
        result.save_types_string = this.save_types_string;
        result.save_types = this.save_types;
        result.html_types = this.html_types;
        result.authentications = this.authentications;
        result.pattern_regexp_filter = this.pattern_regexp_filter;
        result.string_regexp_filter = this.string_regexp_filter;
        result.save_untyped_non_html = this.save_untyped_non_html;
        result.save_html_pages = this.save_html_pages;
        result.parse_html_pages_not_in_hierarchy = this.parse_html_pages_not_in_hierarchy;
        result.parse_remote_html_pages = this.parse_remote_html_pages;
        result.consider_frames_on_same_level_as_page = this.consider_frames_on_same_level_as_page;
        result.save_embedded_images = this.save_embedded_images;
        result.save_images_not_in_hierarchy = this.save_images_not_in_hierarchy;
        result.save_remote_images = this.save_remote_images;
        result.consider_images_on_same_level_as_page = this.consider_images_on_same_level_as_page;
        result.save_non_html_objects = this.save_non_html_objects;
        result.save_non_html_objects_not_in_hierarchy = this.save_non_html_objects_not_in_hierarchy;
        result.save_remote_non_html_objects = this.save_remote_non_html_objects;
        result.dont_allow_gt_in_strings = this.dont_allow_gt_in_strings;
        result.accept_single_line_comments = this.accept_single_line_comments;
        result.guess_urls_in_javascript = this.guess_urls_in_javascript;
        result.guess_urls_in_select = this.guess_urls_in_select;
        result.recognize_javascript_in_tags = this.recognize_javascript_in_tags;
        result.parse_ram_files = this.parse_ram_files;
        result.accept_ram_files_not_in_hierarchy = this.accept_ram_files_not_in_hierarchy;
        result.accept_remote_ram_files = this.accept_remote_ram_files;
        result.consider_ram_files_on_same_level_as_page = this.consider_ram_files_on_same_level_as_page;
        result.use_absolute_paths_in_ram_files = this.use_absolute_paths_in_ram_files;
        result.ram_file_action = this.ram_file_action;
        result.parse_m3u_files = this.parse_m3u_files;
        result.accept_m3u_files_not_in_hierarchy = this.accept_m3u_files_not_in_hierarchy;
        result.accept_remote_m3u_files = this.accept_remote_m3u_files;
        result.consider_m3u_files_on_same_level_as_page = this.consider_m3u_files_on_same_level_as_page;
        result.use_absolute_paths_in_m3u_files = this.use_absolute_paths_in_m3u_files;
        result.m3u_file_action = this.m3u_file_action;
        result.max_recursion_depth = this.max_recursion_depth;
        result.max_remote_recursion_depth = this.max_remote_recursion_depth;
        result.max_threads = this.max_threads;
        result.max_parsing_threads = this.max_parsing_threads;
        result.existing_file_strategy = this.existing_file_strategy;
        result.alphanumeric_filenames = this.alphanumeric_filenames;
        result.untyped_object_mode = this.untyped_object_mode;
        if (PageSucker.registration_checksum1 + 485 != PageSucker.registration_checksum2) {
            result.parse_html_pages_not_in_hierarchy = false;
            result.parse_remote_html_pages = false;
            result.parse_ram_files = false;
            result.parse_m3u_files = false;
            result.guess_urls_in_javascript = false;
            result.guess_urls_in_select = false;
            result.recognize_javascript_in_tags = false;
            if (this.max_threads > 3) {
                result.max_threads = 3;
            }
            if (this.max_parsing_threads > 3) {
                result.max_parsing_threads = 3;
            }
            result.pattern_regexp_filter = null;
            result.authentications = null;
        }
        return result;
    }

    void writeLog(DataOutputStream in_log_stream) throws IOException {
        int i;
        String s;
        in_log_stream.writeBytes("-- Base URL: \"" + this.base_url_string + '\"' + Constants.endl);
        if (this.default_page_names == null) {
            s = "<none>";
        } else {
            s = "\"" + this.default_page_names[0] + "\"";
            i = 1;
            while (i < this.default_page_names.length) {
                s = String.valueOf(s) + ", \"" + this.default_page_names[i] + "\"";
                ++i;
            }
        }
        in_log_stream.writeBytes("-- Default Page Names: " + s + Constants.endl);
        s = this.max_recursion_depth == -1 ? "INF" : String.valueOf(this.max_recursion_depth);
        in_log_stream.writeBytes("-- Max Recursion Depth: " + s + Constants.endl);
        in_log_stream.writeBytes("-- Max Concurrent Threads: " + this.max_threads + Constants.endl);
        in_log_stream.writeBytes("-- Max Threads Parsing HTML: " + this.max_parsing_threads + Constants.endl);
        s = this.existing_file_strategy == 1 ? "overwrite existing file" : (this.existing_file_strategy == 2 ? "reuse existing file, unless empty" : (this.existing_file_strategy == 3 ? "keep the original URL" : (this.existing_file_strategy == 4 ? "modify the filename by prefixing a number" : (this.existing_file_strategy == 5 ? "modify the filename by suffixing a number" : "???"))));
        in_log_stream.writeBytes("-- Existing File Strategy: " + s + Constants.endl);
        s = this.untyped_object_mode == 11 ? "directories" : (this.untyped_object_mode == 12 ? "non html files" : (this.untyped_object_mode == 13 ? "html files" : "???"));
        in_log_stream.writeBytes("-- Object names without extensions denote " + s + Constants.endl);
        in_log_stream.writeBytes("-- Don't allow '>' in HTML Strings Option: " + (this.dont_allow_gt_in_strings ? "ON" : "OFF") + Constants.endl);
        in_log_stream.writeBytes("-- Unterminated HTML Comments Are Single Line Comments Option: " + (this.accept_single_line_comments ? "ON" : "OFF") + Constants.endl);
        in_log_stream.writeBytes("-- Guess URLs in JavaScript Blocks Option: " + (this.guess_urls_in_javascript ? "ON" : "OFF") + Constants.endl);
        in_log_stream.writeBytes("-- Guess URLs in Selectors Option: " + (this.guess_urls_in_select ? "ON" : "OFF") + Constants.endl);
        in_log_stream.writeBytes("-- Recognize JavaScript in Tags Option: " + (this.recognize_javascript_in_tags ? "ON" : "OFF") + Constants.endl);
        in_log_stream.writeBytes("-- Treat URLs As Case Insensitive Option: " + (this.treat_urls_case_insensitive ? "ON" : "OFF") + Constants.endl);
        in_log_stream.writeBytes("-- Log Download History Option: " + (this.log_history ? "ON" : "OFF") + Constants.endl);
        in_log_stream.writeBytes("-- Beep When Finished Option: " + (this.beep_when_finished ? "ON" : "OFF") + Constants.endl);
        in_log_stream.writeBytes("-- Remember Window Positions Option: " + (this.remember_window_positions ? "ON" : "OFF") + Constants.endl);
        in_log_stream.writeBytes("-- HTTP Proxy Host:  " + (this.http_proxy_host.length() == 0 ? "<none>" : this.http_proxy_host) + Constants.endl);
        in_log_stream.writeBytes("-- HTTP Proxy Port:  " + String.valueOf(this.http_proxy_port) + Constants.endl);
        in_log_stream.writeBytes("-- FTP Proxy Host:  " + (this.ftp_proxy_host.length() == 0 ? "<none>" : this.ftp_proxy_host) + Constants.endl);
        in_log_stream.writeBytes("-- FTP Proxy Port:  " + String.valueOf(this.ftp_proxy_port) + Constants.endl);
        s = "-- Authentications for: ";
        if (this.authentications != null) {
            s = String.valueOf(s) + "\"" + Settings.getAuthenticationHost(this.authentications[0]) + "\"";
            i = 1;
            while (i < this.authentications.length) {
                s = String.valueOf(s) + ", \"" + Settings.getAuthenticationHost(this.authentications[i]) + "\"";
                ++i;
            }
        } else {
            s = String.valueOf(s) + "<none>";
        }
        in_log_stream.writeBytes(String.valueOf(s) + Constants.endl);
        s = "";
        if (this.save_html_pages) {
            s = String.valueOf(s) + Constants.endl + "---- Save HTML Pages";
        }
        if (this.parse_html_pages_not_in_hierarchy) {
            s = String.valueOf(s) + Constants.endl + "---- Parse HTML Pages Not In Hierarchy";
        }
        if (this.parse_remote_html_pages) {
            s = String.valueOf(s) + Constants.endl + "---- Parse HTML Pages On Remote Server, Up To Recursion Depth ";
            s = this.max_remote_recursion_depth == -1 ? String.valueOf(s) + "INF" : String.valueOf(s) + String.valueOf(this.max_remote_recursion_depth);
        }
        s = String.valueOf(s) + Constants.endl + "---- HTML Types: ";
        if (this.html_types != null) {
            s = String.valueOf(s) + "\"" + this.html_types[0] + "\"";
            i = 1;
            while (i < this.html_types.length) {
                s = String.valueOf(s) + ", \"" + this.html_types[i] + "\"";
                ++i;
            }
        } else {
            s = String.valueOf(s) + "<none>";
        }
        if (this.save_embedded_images) {
            s = String.valueOf(s) + Constants.endl + "---- Save Embedded Images";
        }
        if (this.save_images_not_in_hierarchy) {
            s = String.valueOf(s) + Constants.endl + "---- Save Embedded Images Not In Hierarchy";
        }
        if (this.save_remote_images) {
            s = String.valueOf(s) + Constants.endl + "---- Save Embedded Images On Remote Server";
        }
        if (this.save_non_html_objects) {
            s = String.valueOf(s) + Constants.endl + "---- Save Non HTML Objects";
        }
        if (this.save_non_html_objects_not_in_hierarchy) {
            s = String.valueOf(s) + Constants.endl + "---- Save Non HTML Objects Not In Hierarchy";
        }
        if (this.save_remote_non_html_objects) {
            s = String.valueOf(s) + Constants.endl + "---- Save Non HTML Objects On Remote Server";
        }
        if (this.save_untyped_non_html) {
            s = String.valueOf(s) + Constants.endl + "---- Save Untyped Non HTML Objects";
        }
        if (this.consider_images_on_same_level_as_page) {
            s = String.valueOf(s) + Constants.endl + "---- Consider Images To Be On Same Recursion Level As Their Host Page";
        }
        if (this.consider_frames_on_same_level_as_page) {
            s = String.valueOf(s) + Constants.endl + "---- Consider Frames To Be On Same Recursion Level As Main Page";
        }
        if (this.parse_ram_files) {
            s = String.valueOf(s) + Constants.endl + "---- Recognize RAM Files";
            if (this.accept_ram_files_not_in_hierarchy) {
                s = String.valueOf(s) + Constants.endl + "---- Accept RAM Files Not In Hierarchy";
            }
            if (this.accept_remote_ram_files) {
                s = String.valueOf(s) + Constants.endl + "---- Accept RAM Files On Remote Server";
            }
            if (this.consider_ram_files_on_same_level_as_page) {
                s = String.valueOf(s) + Constants.endl + "---- Consider RAM Files To Be On Same Recursion Level As Their Host Page";
            }
            if (this.use_absolute_paths_in_ram_files) {
                s = String.valueOf(s) + Constants.endl + "---- Use Absolute Paths In Saved RAM Files";
            }
            s = String.valueOf(s) + Constants.endl + "---- RAM File Action: ";
            switch (this.ram_file_action) {
                case 21: {
                    s = String.valueOf(s) + "Don't Save";
                    break;
                }
                case 22: {
                    s = String.valueOf(s) + "Save";
                    break;
                }
                case 23: {
                    s = String.valueOf(s) + "Shortcircuit";
                    break;
                }
            }
        }
        if (this.parse_m3u_files) {
            s = String.valueOf(s) + Constants.endl + "---- Recognize M3U Files";
            if (this.accept_m3u_files_not_in_hierarchy) {
                s = String.valueOf(s) + Constants.endl + "---- Accept M3U Files Not In Hierarchy";
            }
            if (this.accept_remote_m3u_files) {
                s = String.valueOf(s) + Constants.endl + "---- Accept M3U Files On Remote Server";
            }
            if (this.consider_m3u_files_on_same_level_as_page) {
                s = String.valueOf(s) + Constants.endl + "---- Consider M3U Files To Be On Same Recursion Level As Their Host Page";
            }
            if (this.use_absolute_paths_in_m3u_files) {
                s = String.valueOf(s) + Constants.endl + "---- Use Absolute Paths In Saved M3U Files";
            }
            s = String.valueOf(s) + Constants.endl + "---- M3U File Action: ";
            switch (this.m3u_file_action) {
                case 31: {
                    s = String.valueOf(s) + "Don't Save";
                    break;
                }
                case 32: {
                    s = String.valueOf(s) + "Save";
                    break;
                }
                case 33: {
                    s = String.valueOf(s) + "Shortcircuit";
                    break;
                }
            }
        }
        if (this.save_types != null) {
            s = String.valueOf(s) + Constants.endl + "---- Save Types: \"" + this.save_types[0] + "\"";
            i = 1;
            while (i < this.save_types.length) {
                s = String.valueOf(s) + ", \"" + this.save_types[i] + "\"";
                ++i;
            }
        }
        if (this.pattern_regexp_filter != null) {
            s = String.valueOf(s) + Constants.endl + "---- Regexp Filter: \"" + this.pattern_regexp_filter.getPattern() + "\"";
        }
        if (this.alphanumeric_filenames) {
            s = String.valueOf(s) + Constants.endl + "---- Use Alphanumeric Local Filenames";
        }
        in_log_stream.writeBytes("-- Enabled Filters:" + (s.length() == 0 ? " <none>" : s) + Constants.endl + Constants.endl);
    }

    void saveToFile(boolean save_as_default) {
        String fspec;
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        FilterOutputStream out_stream = null;
        if (save_as_default) {
            fspec = System.getProperty("user.home", "");
            if (fspec.length() > 0 && !fspec.endsWith(File.separator)) {
                fspec = String.valueOf(fspec) + File.separator;
            }
            fspec = String.valueOf(fspec) + "PageSuckerDefaultSettings.prf";
        } else {
            fspec = this.askForSettingsFilespec("Save settings as:", 1);
            if (fspec == null) {
                return;
            }
        }
        try {
            try {
                File file = new File(fspec);
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                out_stream = new DataOutputStream(bos);
                ((DataOutputStream)out_stream).writeBytes("PageSucker Settings File Version " + String.valueOf(1) + '\n');
                Settings.saveValue((DataOutputStream)out_stream, "BaseURL", this.base_url_string);
                Settings.saveValue((DataOutputStream)out_stream, "LogFileSpec", this.logfilespec);
                Settings.saveValue((DataOutputStream)out_stream, "LogHistory", this.log_history);
                Settings.saveValue((DataOutputStream)out_stream, "BeepWhenFinished", this.beep_when_finished);
                Settings.saveValue((DataOutputStream)out_stream, "RememberWindowPositions", this.remember_window_positions);
                Settings.saveValue((DataOutputStream)out_stream, "HttpProxyHost", this.http_proxy_host);
                Settings.saveValue((DataOutputStream)out_stream, "HttpProxyPort", this.http_proxy_port);
                Settings.saveValue((DataOutputStream)out_stream, "FtpProxyHost", this.ftp_proxy_host);
                Settings.saveValue((DataOutputStream)out_stream, "FtpProxyPort", this.ftp_proxy_port);
                Settings.saveValue((DataOutputStream)out_stream, "TreatURLsCaseInsensitive", this.treat_urls_case_insensitive);
                Settings.saveValue((DataOutputStream)out_stream, "DefaultPageNames", this.default_page_names);
                Settings.saveValue((DataOutputStream)out_stream, "SaveTypesString", this.save_types_string);
                Settings.saveValue((DataOutputStream)out_stream, "SaveTypesEnabled", this.save_types != null);
                Settings.saveValue((DataOutputStream)out_stream, "SaveUntypedNonHTML", this.save_untyped_non_html);
                Settings.saveValue((DataOutputStream)out_stream, "SaveHTML", this.save_html_pages);
                Settings.saveValue((DataOutputStream)out_stream, "ParseHTMLNotInHierarchy", this.parse_html_pages_not_in_hierarchy);
                Settings.saveValue((DataOutputStream)out_stream, "ParseRemoteHTML", this.parse_remote_html_pages);
                Settings.saveValue((DataOutputStream)out_stream, "HTMLTypes", this.html_types);
                Settings.saveValue((DataOutputStream)out_stream, "ConsiderFramesOnSameLevelAsPage", this.consider_frames_on_same_level_as_page);
                Settings.saveValue((DataOutputStream)out_stream, "SaveEmbeddedImages", this.save_embedded_images);
                Settings.saveValue((DataOutputStream)out_stream, "SaveImagesNotInHierarchy", this.save_images_not_in_hierarchy);
                Settings.saveValue((DataOutputStream)out_stream, "SaveRemoteImages", this.save_remote_images);
                Settings.saveValue((DataOutputStream)out_stream, "ConsiderImagesOnSameLevelAsPage", this.consider_images_on_same_level_as_page);
                Settings.saveValue((DataOutputStream)out_stream, "SaveNonHTML", this.save_non_html_objects);
                Settings.saveValue((DataOutputStream)out_stream, "SaveNonHTMLNotInHierarchy", this.save_non_html_objects_not_in_hierarchy);
                Settings.saveValue((DataOutputStream)out_stream, "SaveRemoteNonHTML", this.save_remote_non_html_objects);
                Settings.saveValue((DataOutputStream)out_stream, "DontAllowGTInStrings", this.dont_allow_gt_in_strings);
                Settings.saveValue((DataOutputStream)out_stream, "AcceptSingleLineComments", this.accept_single_line_comments);
                Settings.saveValue((DataOutputStream)out_stream, "GuessURLsInJavaScript", this.guess_urls_in_javascript);
                Settings.saveValue((DataOutputStream)out_stream, "GuessURLsInSelect", this.guess_urls_in_select);
                Settings.saveValue((DataOutputStream)out_stream, "RecognizeJavaScriptInTags", this.recognize_javascript_in_tags);
                Settings.saveValue((DataOutputStream)out_stream, "ParseRAMFiles", this.parse_ram_files);
                Settings.saveValue((DataOutputStream)out_stream, "AcceptRAMFilesNotInHierarchy", this.accept_ram_files_not_in_hierarchy);
                Settings.saveValue((DataOutputStream)out_stream, "AcceptRemoteRAMFiles", this.accept_remote_ram_files);
                Settings.saveValue((DataOutputStream)out_stream, "ConsiderRAMFilesOnSameLevelAsPage", this.consider_ram_files_on_same_level_as_page);
                Settings.saveValue((DataOutputStream)out_stream, "UseAbsolutePathsInRAMFiles", this.use_absolute_paths_in_ram_files);
                Settings.saveValue((DataOutputStream)out_stream, "RAMFileAction", this.ram_file_action);
                Settings.saveValue((DataOutputStream)out_stream, "ParseM3UFiles", this.parse_m3u_files);
                Settings.saveValue((DataOutputStream)out_stream, "AcceptM3UFilesNotInHierarchy", this.accept_m3u_files_not_in_hierarchy);
                Settings.saveValue((DataOutputStream)out_stream, "AcceptRemoteM3UFiles", this.accept_remote_m3u_files);
                Settings.saveValue((DataOutputStream)out_stream, "ConsiderM3UFilesOnSameLevelAsPage", this.consider_m3u_files_on_same_level_as_page);
                Settings.saveValue((DataOutputStream)out_stream, "UseAbsolutePathsInM3UFiles", this.use_absolute_paths_in_m3u_files);
                Settings.saveValue((DataOutputStream)out_stream, "M3UFileAction", this.m3u_file_action);
                Settings.saveValue((DataOutputStream)out_stream, "MaxRecursionDepth", this.max_recursion_depth);
                Settings.saveValue((DataOutputStream)out_stream, "MaxRemoteRecursionDepth", this.max_remote_recursion_depth);
                Settings.saveValue((DataOutputStream)out_stream, "MaxThreads", this.max_threads);
                Settings.saveValue((DataOutputStream)out_stream, "MaxParsingThreads", this.max_parsing_threads);
                Settings.saveValue((DataOutputStream)out_stream, "ExistingFileStrategy", this.existing_file_strategy);
                Settings.saveValue((DataOutputStream)out_stream, "AlphanumericFilenames", this.alphanumeric_filenames);
                Settings.saveValue((DataOutputStream)out_stream, "UntypedObjectMode", this.untyped_object_mode);
                Settings.saveValue((DataOutputStream)out_stream, "StringRegexpFilter", this.string_regexp_filter);
                Settings.saveValue((DataOutputStream)out_stream, "RegexpFilterEnabled", this.pattern_regexp_filter != null);
                Settings.saveValue((DataOutputStream)out_stream, "Authentications", this.authentications);
                ((DataOutputStream)out_stream).flush();
            }
            catch (IOException e) {
                new MessageDialog((Frame)Main.sucker.frame_control, "Couldn't write the settings file.\n" + e.toString(), 2).handle();
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {
                if (out_stream != null) {
                    out_stream.close();
                }
            }
            catch (IOException e) {
                new MessageDialog((Frame)Main.sucker.frame_control, "Couldn't close the settings file.\n" + e.toString(), 2).handle();
            }
            throw throwable;
        }
        try {
            if (out_stream != null) {
                out_stream.close();
            }
        }
        catch (IOException e) {
            new MessageDialog((Frame)Main.sucker.frame_control, "Couldn't close the settings file.\n" + e.toString(), 2).handle();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void loadFromFile(boolean load_as_default) {
        boolean regexp_filter_enabled;
        boolean save_types_enabled;
        BufferedReader buffered_reader;
        block149: {
            block148: {
                String fspec;
                FileReader reader = null;
                buffered_reader = null;
                int version = 0;
                String header_string = "PageSucker Settings File Version ";
                if (load_as_default) {
                    fspec = System.getProperty("user.home", "");
                    if (fspec.length() > 0 && !fspec.endsWith(File.separator)) {
                        fspec = String.valueOf(fspec) + File.separator;
                    }
                    fspec = String.valueOf(fspec) + "PageSuckerDefaultSettings.prf";
                } else {
                    fspec = this.askForSettingsFilespec("Load settings from:", 0);
                    if (fspec == null) {
                        return;
                    }
                }
                File file = new File(fspec);
                this.setDefaultValues();
                save_types_enabled = this.save_types != null;
                regexp_filter_enabled = this.pattern_regexp_filter != null;
                try {
                    try {
                        reader = new FileReader(file);
                        buffered_reader = new BufferedReader(reader);
                        String line = buffered_reader.readLine();
                        if (line == null) {
                            new MessageDialog((Frame)Main.sucker.frame_control, "Empty settings file: \"" + file.getName() + '\"', 2).handle();
                            Object var14_11 = null;
                            break block148;
                        }
                        if (line.length() <= "PageSucker Settings File Version ".length()) throw new InvalidSettingsFileError();
                        if (!line.startsWith("PageSucker Settings File Version ")) {
                            throw new InvalidSettingsFileError();
                        }
                        line = line.substring("PageSucker Settings File Version ".length());
                        try {
                            version = Integer.parseInt(line);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new InvalidSettingsFileError();
                        }
                        if (version > 1) {
                            throw new SettingsFileVersionError();
                        }
                        line = buffered_reader.readLine();
                        while (true) {
                            if (line == null) {
                                if (this.max_parsing_threads > this.max_threads) {
                                    this.max_parsing_threads = this.max_threads;
                                }
                                if (!FileAccessor.alphabet_platform_illegal_filename_characters.disjointed(fspec = StringUtils.decodeEncodedCharacters(this.logfilespec, true))) {
                                    this.logfilespec = "PageSuckerLog.txt";
                                }
                                if (PageSucker.registration_checksum1 + 485 != PageSucker.registration_checksum2) {
                                    this.parse_html_pages_not_in_hierarchy = false;
                                    this.parse_remote_html_pages = false;
                                    this.parse_ram_files = false;
                                    this.parse_m3u_files = false;
                                    this.guess_urls_in_javascript = false;
                                    this.guess_urls_in_select = false;
                                    this.recognize_javascript_in_tags = false;
                                    regexp_filter_enabled = false;
                                }
                                break block149;
                            }
                            String name = Constants.alphabet_not_control_or_equals.span(line);
                            line = Constants.alphabet_not_control_or_equals.trimLeft(line);
                            if (name.length() == 0) throw new InvalidSettingsFileError();
                            if (!line.startsWith("=")) {
                                throw new InvalidSettingsFileError();
                            }
                            String value = line.substring(1);
                            if (name.equals("BaseURL")) {
                                this.base_url_string = Settings.loadStringValue(value);
                            } else if (name.equals("LogFileSpec")) {
                                this.logfilespec = Settings.loadStringValue(value);
                            } else if (name.equals("LogHistory")) {
                                this.log_history = Settings.loadBooleanValue(value);
                            } else if (name.equals("BeepWhenFinished")) {
                                this.beep_when_finished = Settings.loadBooleanValue(value);
                            } else if (name.equals("RememberWindowPositions")) {
                                this.remember_window_positions = Settings.loadBooleanValue(value);
                            } else if (name.equals("HttpProxyHost")) {
                                this.http_proxy_host = Settings.loadStringValue(value);
                            } else if (name.equals("HttpProxyPort")) {
                                this.http_proxy_port = Settings.loadIntValue(value);
                            } else if (name.equals("FtpProxyHost")) {
                                this.ftp_proxy_host = Settings.loadStringValue(value);
                            } else if (name.equals("FtpProxyPort")) {
                                this.ftp_proxy_port = Settings.loadIntValue(value);
                            } else if (name.equals("TreatURLsCaseInsensitive")) {
                                this.treat_urls_case_insensitive = Settings.loadBooleanValue(value);
                            } else if (name.equals("DefaultPageNames")) {
                                this.default_page_names = Settings.loadStringArrayValue(value);
                            } else if (name.equals("SaveTypesString")) {
                                this.save_types_string = Settings.loadStringValue(value);
                            } else if (name.equals("SaveTypesEnabled")) {
                                save_types_enabled = Settings.loadBooleanValue(value);
                            } else if (name.equals("SaveUntypedNonHTML")) {
                                this.save_untyped_non_html = Settings.loadBooleanValue(value);
                            } else if (name.equals("SaveHTML")) {
                                this.save_html_pages = Settings.loadBooleanValue(value);
                            } else if (name.equals("ParseHTMLNotInHierarchy")) {
                                this.parse_html_pages_not_in_hierarchy = Settings.loadBooleanValue(value);
                            } else if (name.equals("ParseRemoteHTML")) {
                                this.parse_remote_html_pages = Settings.loadBooleanValue(value);
                            } else if (name.equals("HTMLTypes")) {
                                this.html_types = Settings.loadStringArrayValue(value);
                            } else if (name.equals("ConsiderFramesOnSameLevelAsPage")) {
                                this.consider_frames_on_same_level_as_page = Settings.loadBooleanValue(value);
                            } else if (name.equals("SaveEmbeddedImages")) {
                                this.save_embedded_images = Settings.loadBooleanValue(value);
                            } else if (name.equals("SaveImagesNotInHierarchy")) {
                                this.save_images_not_in_hierarchy = Settings.loadBooleanValue(value);
                            } else if (name.equals("SaveRemoteImages")) {
                                this.save_remote_images = Settings.loadBooleanValue(value);
                            } else if (name.equals("ConsiderImagesOnSameLevelAsPage")) {
                                this.consider_images_on_same_level_as_page = Settings.loadBooleanValue(value);
                            } else if (name.equals("SaveNonHTML")) {
                                this.save_non_html_objects = Settings.loadBooleanValue(value);
                            } else if (name.equals("SaveNonHTMLNotInHierarchy")) {
                                this.save_non_html_objects_not_in_hierarchy = Settings.loadBooleanValue(value);
                            } else if (name.equals("SaveRemoteNonHTML")) {
                                this.save_remote_non_html_objects = Settings.loadBooleanValue(value);
                            } else if (name.equals("DontAllowGTInStrings")) {
                                this.dont_allow_gt_in_strings = Settings.loadBooleanValue(value);
                            } else if (name.equals("AcceptSingleLineComments")) {
                                this.accept_single_line_comments = Settings.loadBooleanValue(value);
                            } else if (name.equals("GuessURLsInJavaScript")) {
                                this.guess_urls_in_javascript = Settings.loadBooleanValue(value);
                            } else if (name.equals("GuessURLsInSelect")) {
                                this.guess_urls_in_select = Settings.loadBooleanValue(value);
                            } else if (name.equals("RecognizeJavaScriptInTags")) {
                                this.recognize_javascript_in_tags = Settings.loadBooleanValue(value);
                            } else if (name.equals("ParseRAMFiles")) {
                                this.parse_ram_files = Settings.loadBooleanValue(value);
                            } else if (name.equals("AcceptRAMFilesNotInHierarchy")) {
                                this.accept_ram_files_not_in_hierarchy = Settings.loadBooleanValue(value);
                            } else if (name.equals("AcceptRemoteRAMFiles")) {
                                this.accept_remote_ram_files = Settings.loadBooleanValue(value);
                            } else if (name.equals("ConsiderRAMFilesOnSameLevelAsPage")) {
                                this.consider_ram_files_on_same_level_as_page = Settings.loadBooleanValue(value);
                            } else if (name.equals("UseAbsolutePathsInRAMFiles")) {
                                this.use_absolute_paths_in_ram_files = Settings.loadBooleanValue(value);
                            } else if (name.equals("RAMFileAction")) {
                                this.ram_file_action = Settings.loadByteValue(value);
                            } else if (name.equals("ParseM3UFiles")) {
                                this.parse_m3u_files = Settings.loadBooleanValue(value);
                            } else if (name.equals("AcceptM3UFilesNotInHierarchy")) {
                                this.accept_m3u_files_not_in_hierarchy = Settings.loadBooleanValue(value);
                            } else if (name.equals("AcceptRemoteM3UFiles")) {
                                this.accept_remote_m3u_files = Settings.loadBooleanValue(value);
                            } else if (name.equals("ConsiderM3UFilesOnSameLevelAsPage")) {
                                this.consider_m3u_files_on_same_level_as_page = Settings.loadBooleanValue(value);
                            } else if (name.equals("UseAbsolutePathsInM3UFiles")) {
                                this.use_absolute_paths_in_m3u_files = Settings.loadBooleanValue(value);
                            } else if (name.equals("M3UFileAction")) {
                                this.m3u_file_action = Settings.loadByteValue(value);
                            } else if (name.equals("MaxRecursionDepth")) {
                                this.max_recursion_depth = Settings.loadIntValue(value);
                            } else if (name.equals("MaxRemoteRecursionDepth")) {
                                this.max_remote_recursion_depth = Settings.loadIntValue(value);
                            } else if (name.equals("MaxThreads")) {
                                this.max_threads = Settings.loadIntValue(value);
                            } else if (name.equals("MaxParsingThreads")) {
                                this.max_parsing_threads = Settings.loadIntValue(value);
                            } else if (name.equals("ExistingFileStrategy")) {
                                this.existing_file_strategy = Settings.loadIntValue(value);
                            } else if (name.equals("AlphanumericFilenames")) {
                                this.alphanumeric_filenames = Settings.loadBooleanValue(value);
                            } else if (name.equals("UntypedObjectMode")) {
                                this.untyped_object_mode = Settings.loadIntValue(value);
                            } else if (name.equals("StringRegexpFilter")) {
                                this.string_regexp_filter = Settings.loadStringValue(value);
                            } else if (name.equals("RegexpFilterEnabled")) {
                                regexp_filter_enabled = Settings.loadBooleanValue(value);
                            } else if (name.equals("Authentications")) {
                                this.authentications = Settings.loadStringArrayValue(value);
                            }
                            line = buffered_reader.readLine();
                        }
                    }
                    catch (InvalidSettingsFileError invalidSettingsFileError) {
                        new MessageDialog((Frame)Main.sucker.frame_control, "Not a valid PageSucker settings file: \"" + file.getName() + '\"', 3).handle();
                        break block149;
                    }
                    catch (SettingsFileVersionError settingsFileVersionError) {
                        new MessageDialog((Frame)Main.sucker.frame_control, "PageSucker settings file too new; this version is not supported: \"" + file.getName() + "\". You might want to upgrade to a newer version of PageSucker.", 3).handle();
                        break block149;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (!load_as_default) {
                            new MessageDialog((Frame)Main.sucker.frame_control, "Couldn't find settings file: \"" + file.getName() + '\"', 3).handle();
                        }
                        break block149;
                    }
                    catch (IOException e) {
                        new MessageDialog((Frame)Main.sucker.frame_control, "Couldn't read settings file: \"" + file.getName() + "\"\n" + e.toString(), 3).handle();
                        break block149;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_13 = null;
                    try {
                        if (buffered_reader != null) {
                            buffered_reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    if (save_types_enabled) {
                        this.buildSaveTypesArrayFromSaveTypesString();
                    } else {
                        this.save_types = null;
                    }
                    if (regexp_filter_enabled && this.string_regexp_filter.length() > 0) {
                        try {
                            this.pattern_regexp_filter = (Perl5Pattern)Main.sucker.compiler_regexp_filter.compile(this.string_regexp_filter);
                            throw throwable;
                        }
                        catch (MalformedPatternException malformedPatternException) {
                            this.pattern_regexp_filter = null;
                            throw throwable;
                        }
                    }
                    this.pattern_regexp_filter = null;
                    throw throwable;
                }
            }
            try {}
            catch (IOException iOException) {}
            if (buffered_reader != null) {
                buffered_reader.close();
            }
            if (save_types_enabled) {
                this.buildSaveTypesArrayFromSaveTypesString();
            } else {
                this.save_types = null;
            }
            if (regexp_filter_enabled && this.string_regexp_filter.length() > 0) {
                try {}
                catch (MalformedPatternException malformedPatternException) {
                    this.pattern_regexp_filter = null;
                    return;
                }
                this.pattern_regexp_filter = (Perl5Pattern)Main.sucker.compiler_regexp_filter.compile(this.string_regexp_filter);
                return;
            }
            this.pattern_regexp_filter = null;
            return;
        }
        Object var14_12 = null;
        try {}
        catch (IOException iOException) {}
        if (buffered_reader != null) {
            buffered_reader.close();
        }
        if (save_types_enabled) {
            this.buildSaveTypesArrayFromSaveTypesString();
        } else {
            this.save_types = null;
        }
        if (regexp_filter_enabled && this.string_regexp_filter.length() > 0) {
            try {}
            catch (MalformedPatternException malformedPatternException) {
                this.pattern_regexp_filter = null;
                return;
            }
            this.pattern_regexp_filter = (Perl5Pattern)Main.sucker.compiler_regexp_filter.compile(this.string_regexp_filter);
            return;
        }
        this.pattern_regexp_filter = null;
    }

    public static void saveValue(DataOutputStream stream, String name, String value) throws IOException {
        String encoded_value = value == null ? "%null" : StringUtils.encodeString(value, Constants.alphabet_non_ASCII_or_control_characters, false);
        stream.writeBytes(String.valueOf(name) + '=' + encoded_value + '\n');
    }

    public static void saveValue(DataOutputStream stream, String name, String[] value) throws IOException {
        String encoded_value = value == null ? "%null" : StringUtils.arrayToString(value, ",", true, Constants.alphabet_non_ASCII_or_control_characters);
        stream.writeBytes(String.valueOf(name) + '=' + encoded_value + '\n');
    }

    public static void saveValue(DataOutputStream stream, String name, boolean value) throws IOException {
        stream.writeBytes(String.valueOf(name) + '=' + String.valueOf(value) + '\n');
    }

    public static void saveValue(DataOutputStream stream, String name, int value) throws IOException {
        stream.writeBytes(String.valueOf(name) + '=' + String.valueOf(value) + '\n');
    }

    public static void saveValue(DataOutputStream stream, String name, Dimension value) throws IOException {
        String value_string = value == null ? "%null" : String.valueOf(String.valueOf(value.width)) + ',' + String.valueOf(value.height);
        stream.writeBytes(String.valueOf(name) + '=' + value_string + '\n');
    }

    public static void saveValue(DataOutputStream stream, String name, Point value) throws IOException {
        String value_string = value == null ? "%null" : String.valueOf(String.valueOf(value.x)) + ',' + String.valueOf(value.y);
        stream.writeBytes(String.valueOf(name) + '=' + value_string + '\n');
    }

    public static String loadStringValue(String value_string) {
        if (value_string.equals("%null")) {
            return null;
        }
        return StringUtils.decodeEncodedCharacters(value_string, true);
    }

    public static String[] loadStringArrayValue(String value_string) {
        if (value_string.equals("%null")) {
            return null;
        }
        if (value_string.equals(",")) {
            return new String[0];
        }
        return StringUtils.tokenizeString(value_string, ',', true, null, true);
    }

    public static boolean loadBooleanValue(String value_string) {
        return value_string.equals("true");
    }

    public static int loadIntValue(String value_string) {
        int result;
        try {
            result = Integer.parseInt(value_string);
        }
        catch (NumberFormatException numberFormatException) {
            result = -1;
        }
        return result;
    }

    public static byte loadByteValue(String value_string) {
        return (byte)Settings.loadIntValue(value_string);
    }

    public static Point loadPointValue(String value_string) {
        int y;
        int x;
        if (value_string.equals("%null")) {
            return null;
        }
        String[] coords = StringUtils.tokenizeString(value_string, ',');
        if (coords == null || coords.length < 2) {
            return null;
        }
        try {
            x = Integer.parseInt(coords[0]);
            y = Integer.parseInt(coords[1]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Point(x, y);
    }

    public static Dimension loadDimensionValue(String value_string) {
        int height;
        int width;
        if (value_string.equals("%null")) {
            return null;
        }
        String[] coords = StringUtils.tokenizeString(value_string, ',');
        if (coords == null || coords.length < 2) {
            return null;
        }
        try {
            width = Integer.parseInt(coords[0]);
            height = Integer.parseInt(coords[1]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Dimension(width, height);
    }

    private String askForSettingsFilespec(String title, int mode) {
        FileDialog dialog = new FileDialog((Frame)Main.sucker.frame_control, title, mode);
        dialog.setFile("PageSuckerSettings.prf");
        ((Component)dialog).setVisible(true);
        String dir = dialog.getDirectory();
        String file = dialog.getFile();
        if (dir == null || file == null) {
            return null;
        }
        return String.valueOf(dir) + file;
    }

    public void buildSaveTypesArrayFromSaveTypesString() {
        if (this.save_types_string.length() != 0) {
            String[] st = StringUtils.tokenizeString(this.save_types_string, ',', false, Constants.alphabet_whitespace, false);
            int i = 0;
            int j = 0;
            while (i < st.length) {
                String type = st[i].toLowerCase();
                if (type.length() > 0) {
                    if (!type.startsWith(".")) {
                        type = "." + type;
                    }
                    st[j++] = type;
                }
                ++i;
            }
            if (j > 0) {
                if (j == i) {
                    this.save_types = st;
                } else {
                    this.save_types = new String[j];
                    System.arraycopy(st, 0, this.save_types, 0, j);
                }
            } else {
                this.save_types = null;
            }
        } else {
            this.save_types = null;
        }
    }

    public static String[] getHTMLTypesArrayFromString(String types_string) {
        String[] result;
        if (types_string != null && types_string.length() != 0) {
            String[] st = StringUtils.tokenizeString(types_string, ',', false, Constants.alphabet_whitespace, false);
            int i = 0;
            int j = 0;
            while (i < st.length) {
                String type = st[i].toLowerCase();
                if (type.length() > 0) {
                    if (!type.startsWith(".")) {
                        type = "." + type;
                    }
                    st[j++] = type;
                }
                ++i;
            }
            if (j > 0) {
                if (j == i) {
                    result = st;
                } else {
                    result = new String[j];
                    System.arraycopy(st, 0, result, 0, j);
                }
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    public void buildHTMLTypesArrayFromString(String types_string) {
        this.html_types = Settings.getHTMLTypesArrayFromString(types_string);
    }

    public static String buildAuthenticationString(String host, String login) {
        String encrypted_login = StringUtils.cryptString(login, 149);
        StringBuffer encoded_login = new StringBuffer();
        int i = 0;
        while (i < encrypted_login.length()) {
            String hex_string = Integer.toHexString(encrypted_login.charAt(i));
            if (hex_string.length() == 1) {
                hex_string = "0" + hex_string;
            }
            encoded_login.append(hex_string);
            ++i;
        }
        return String.valueOf(host) + "#" + encoded_login.toString();
    }

    public static String getAuthenticationHost(String authentication_string) {
        int sharp_index = authentication_string.indexOf(35);
        return sharp_index <= 0 ? "" : authentication_string.substring(0, sharp_index);
    }

    public static String getAuthenticationLogin(String authentication_string) {
        int sharp_index = authentication_string.indexOf(35);
        String login_string = authentication_string.substring(sharp_index + 1);
        StringBuffer encrypted_login = new StringBuffer();
        int i = 0;
        while (i < login_string.length()) {
            String hex_number = login_string.substring(i, i + 2);
            try {
                encrypted_login.append((char)Integer.parseInt(hex_number, 16));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            i += 2;
        }
        return StringUtils.cryptString(encrypted_login.toString(), 149);
    }

    public static String getAuthenticationUsername(String authentication_string) {
        String login = Settings.getAuthenticationLogin(authentication_string);
        int colon_index = login.indexOf(58);
        if (colon_index < 0) {
            return login;
        }
        return login.substring(0, colon_index);
    }

    public static String getAuthenticationPassword(String authentication_string) {
        String login = Settings.getAuthenticationLogin(authentication_string);
        int colon_index = login.indexOf(58);
        if (colon_index < 0 || colon_index >= login.length() - 1) {
            return "";
        }
        return login.substring(colon_index + 1);
    }

    public void addAuthentication(String domain, String username, String password) {
        String auth = Settings.buildAuthenticationString(domain, String.valueOf(username) + ':' + password);
        int existing_authentication_count = this.authentications != null ? this.authentications.length : 0;
        String[] new_authentications = new String[existing_authentication_count + 1];
        if (this.authentications != null) {
            System.arraycopy(this.authentications, 0, new_authentications, 0, existing_authentication_count);
        }
        new_authentications[existing_authentication_count] = auth;
        this.authentications = new_authentications;
    }

    public void removeAuthentications(int[] indexes) {
        if (indexes == null || indexes.length == 0 || this.authentications == null) {
            return;
        }
        if (this.authentications.length == indexes.length) {
            this.authentications = null;
            return;
        }
        int i = 0;
        while (i < indexes.length) {
            this.authentications[indexes[i]] = null;
            ++i;
        }
        String[] new_authentications = new String[this.authentications.length - indexes.length];
        i = 0;
        int j = 0;
        while (i < this.authentications.length) {
            if (this.authentications[i] != null) {
                new_authentications[j++] = this.authentications[i];
            }
            ++i;
        }
        this.authentications = new_authentications;
    }
}

