/*
 * Decompiled with CFR 0.152.
 */
package jfr.pagesucker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jfr.awt.MessageDialog;
import jfr.pagesucker.AboutBox;
import jfr.pagesucker.ControlFrame;
import jfr.pagesucker.PageSucker;
import jfr.pagesucker.Registration;
import jfr.pagesucker.ReleaseCheckerThread;
import jfr.pagesucker.SuckerFrameOwner;

public abstract class SuckerFrame
extends Frame
implements ActionListener,
ItemListener {
    private static GridBagConstraints grid_bag_constraints = new GridBagConstraints();
    private static Color macos8_background = new Color(0xDEDEDE);
    private SuckerFrameOwner owner;

    public SuckerFrame(SuckerFrameOwner in_owner, String title) {
        super(title);
        this.owner = in_owner;
        if (Main.sucker.settings_options.isRememberWindowPositions()) {
            this.setup(this.owner.getSavedFrameLocation(), this.owner.getSavedFrameSize());
        } else {
            this.setup(null, null);
        }
    }

    public SuckerFrame(String title, Point location, Dimension size) {
        super(title);
        this.owner = null;
        this.setup(location, size);
    }

    protected void setup(Point in_frame_location, Dimension in_frame_size) {
        if (PageSucker.os_type == 1) {
            ((Component)this).setFont(new Font("Geneva", 0, 10));
        }
        ((Component)this).setBackground(macos8_background);
        this.setLayout(new GridBagLayout());
        this.setUpFrameMenu();
        this.setUpFrameContents();
        this.addWindowListener(new SuckerFrameAdapter());
        this.setFrameLocationAndSize(in_frame_location, in_frame_size);
    }

    protected void setFrameLocationAndSize(Point in_frame_location, Dimension in_frame_size) {
        boolean use_default_frame_location;
        boolean bl = use_default_frame_location = in_frame_location == null;
        if (in_frame_size != null) {
            ((Component)this).setSize(in_frame_size);
        } else {
            this.pack();
        }
        if (in_frame_location != null) {
            Rectangle absolute_frame_bounds = new Rectangle(in_frame_location, this.getSize());
            Rectangle screen_bounds = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
            if (screen_bounds.intersects(absolute_frame_bounds)) {
                ((Component)this).setLocation(in_frame_location);
            } else {
                use_default_frame_location = true;
            }
        }
        if (use_default_frame_location) {
            if (this instanceof ControlFrame) {
                int y;
                int x;
                if (PageSucker.os_type == 1) {
                    x = 5;
                    y = 5;
                } else {
                    Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
                    Dimension frame_size = this.getSize();
                    x = (screen_size.width - frame_size.width) / 2;
                    y = (screen_size.height - frame_size.height) / 2;
                }
                ((Component)this).setLocation(x, y);
            } else {
                Point location = Main.sucker.frame_control.getLocation();
                location.translate(20, 20);
                ((Component)this).setLocation(location);
            }
        }
        ((Component)this).setVisible(true);
    }

    public abstract boolean saveContentsValues();

    public abstract void updateFromEditingSettings();

    protected abstract void setUpFrameContents();

    public Insets getInsets() {
        Insets r = (Insets)super.getInsets().clone();
        r.top += 15;
        r.bottom += 15;
        r.left += 15;
        r.right += 15;
        return r;
    }

    public void setUpFrameMenu() {
        if (PageSucker.os_type == 1 || this instanceof ControlFrame) {
            Menu menu_file = new Menu("File");
            if (PageSucker.os_type == 1) {
                menu_file.add(new MenuItem("Close", new MenuShortcut(87)));
                menu_file.add("-");
            }
            if (PageSucker.beta_expiration_date == null) {
                menu_file.add("Register...");
            }
            if (PageSucker.os_type == 1 || PageSucker.os_type == 2) {
                menu_file.add("Check For New Release...");
            }
            menu_file.add("-");
            menu_file.add(new MenuItem("Quit", new MenuShortcut(81)));
            menu_file.addActionListener(this);
            Menu menu_settings = new Menu("Settings", true);
            menu_settings.add("HTML Files");
            menu_settings.add("Data Files");
            menu_settings.add("RealAudio Files");
            menu_settings.add("MPEG Layer 3 Files");
            menu_settings.add("JavaScript");
            menu_settings.add("Options");
            menu_settings.add("Expert");
            menu_settings.add("Proxies & Firewalls");
            menu_settings.add("Authentication");
            menu_settings.add("-");
            menu_settings.add("Save Settings As...");
            menu_settings.add("Restore Settings...");
            menu_settings.add("-");
            menu_settings.add("Save Default Settings");
            menu_settings.add("Factory Settings");
            menu_settings.addActionListener(this);
            MenuBar menubar = new MenuBar();
            menubar.add(menu_file);
            menubar.add(menu_settings);
            if (PageSucker.os_type == 2) {
                Menu menu_help = new Menu("Help");
                menu_help.add("About ...");
                menu_help.addActionListener(this);
                menubar.add(menu_help);
            }
            this.setMenuBar(menubar);
        }
    }

    protected void addToGridBag(Container container, Component component, int y, int width, int anchor, int fill) {
        GridBagLayout the_layout = (GridBagLayout)container.getLayout();
        if (the_layout != null) {
            SuckerFrame.grid_bag_constraints.gridx = -1;
            SuckerFrame.grid_bag_constraints.gridy = y;
            SuckerFrame.grid_bag_constraints.anchor = anchor;
            SuckerFrame.grid_bag_constraints.gridwidth = width;
            SuckerFrame.grid_bag_constraints.fill = fill;
            the_layout.setConstraints(component, grid_bag_constraints);
            container.add(component);
        }
    }

    protected void addToGridBag(Container container, Component component, int y, int width, int anchor) {
        this.addToGridBag(container, component, y, width, anchor, 0);
    }

    protected void addToGridBag(Component component, int y, int width, int anchor, int fill) {
        this.addToGridBag(this, component, y, width, anchor, fill);
    }

    protected void addToGridBag(Component component, int y, int width, int anchor) {
        this.addToGridBag(this, component, y, width, anchor, 0);
    }

    protected int addVerticalSpace(int row) {
        this.addToGridBag(new Label(), row, 0, 10);
        return row + 1;
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        String command = evt.getActionCommand();
        if (source instanceof Menu) {
            if (command.equals("Close")) {
                if (this instanceof ControlFrame) {
                    Main.sucker.quitApplication();
                } else if (this.owner != null && this.saveContentsValues()) {
                    this.owner.disposeFrame();
                }
            } else if (command.equals("Register...")) {
                Registration.showRegistrationDialog();
            } else if (command.equals("Check For New Release...")) {
                if (ReleaseCheckerThread.getThreadInstance() == null) {
                    new ReleaseCheckerThread(false).start();
                } else {
                    new MessageDialog((Frame)Main.sucker.frame_control, "There is already a new release check running (maybe in the background). Please wait until it is finished before starting a new check.", 3).handle();
                }
            } else if (command.equals("Quit")) {
                Main.sucker.quitApplication();
            } else if (command.equals("HTML Files")) {
                Main.sucker.settings_html.showFrame();
            } else if (command.equals("Data Files")) {
                Main.sucker.settings_data.showFrame();
            } else if (command.equals("RealAudio Files")) {
                Main.sucker.settings_ram_files.showFrame();
            } else if (command.equals("MPEG Layer 3 Files")) {
                Main.sucker.settings_m3u_files.showFrame();
            } else if (command.equals("JavaScript")) {
                Main.sucker.settings_script.showFrame();
            } else if (command.equals("Options")) {
                Main.sucker.settings_options.showFrame();
            } else if (command.equals("Expert")) {
                Main.sucker.settings_expert.showFrame();
            } else if (command.equals("Proxies & Firewalls")) {
                Main.sucker.settings_proxy.showFrame();
            } else if (command.equals("Authentication")) {
                Main.sucker.settings_authentication.showFrame();
            } else if (command.equals("Save Settings As...")) {
                if (Main.sucker.gatherEditingSettings()) {
                    Main.sucker.editing_settings.saveToFile(false);
                }
            } else if (command.equals("Save Default Settings")) {
                if (Main.sucker.gatherEditingSettings()) {
                    Main.sucker.editing_settings.saveToFile(true);
                    new MessageDialog((Frame)Main.sucker.frame_control, "Your current settings have been saved as default settings. From now on, they will be used whenever PageSucker is launched.", 1).handle();
                }
            } else if (command.equals("Restore Settings...")) {
                Main.sucker.editing_settings.loadFromFile(false);
                Main.sucker.updateFramesFromEditingSettings();
            } else if (command.equals("Factory Settings")) {
                Main.sucker.editing_settings.setDefaultValues();
                Main.sucker.updateFramesFromEditingSettings();
                new MessageDialog((Frame)Main.sucker.frame_control, "Factory settings have been restored. To use them as default settings when PageSucker starts up, choose \"Save Default Settings\" from the \"Settings\" menu.", 1).handle();
            } else if (command.equals("About ...")) {
                AboutBox.show();
            }
        }
    }

    public void itemStateChanged(ItemEvent evt) {
    }

    class SuckerFrameAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent evt) {
            if (evt.getWindow() == Main.sucker.frame_control) {
                Main.sucker.quitApplication();
            } else if (SuckerFrame.this.owner != null && SuckerFrame.this.saveContentsValues()) {
                SuckerFrame.this.owner.disposeFrame();
            }
        }

        SuckerFrameAdapter() {
        }
    }
}

