/*
 * Decompiled with CFR 0.152.
 */
package jfr.pagesucker;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import jfr.pagesucker.SuckerFrame;

public abstract class SuckerFrameOwner {
    protected SuckerFrame frame = null;
    protected boolean frame_destroyed = false;
    protected Point frame_location = null;
    protected Dimension frame_size = null;

    protected abstract void createFrame();

    public void disposeFrame() {
        if (this.frame != null) {
            if (Main.sucker.settings_options.isRememberWindowPositions()) {
                this.frame_location = this.frame.getLocationOnScreen();
                this.frame_size = this.frame.getSize();
            }
            this.frame.dispose();
            this.frame = null;
            this.frame_destroyed = true;
        }
    }

    public boolean isFrameOpen() {
        return this.frame != null;
    }

    public Point getSavedFrameLocation() {
        return this.frame_location;
    }

    public Dimension getSavedFrameSize() {
        return this.frame_size;
    }

    public Point getFrameLocationOnScreen() {
        return this.frame != null ? this.frame.getLocationOnScreen() : this.frame_location;
    }

    public Dimension getFrameSize() {
        return this.frame != null ? this.frame.getSize() : this.frame_size;
    }

    public void setFrameSize(Dimension size) {
        if (this.frame != null) {
            ((Component)this.frame).setSize(size);
        } else {
            this.frame_size = size;
        }
    }

    public void setFrameLocation(Point location) {
        if (this.frame != null) {
            ((Component)this.frame).setLocation(location);
        } else {
            this.frame_location = location;
        }
    }

    public void showFrame() {
        if (this.frame == null) {
            this.createFrame();
        } else {
            if (this.frame_destroyed) {
                this.frame_destroyed = false;
                this.frame.setUpFrameMenu();
            }
            ((Component)this.frame).setVisible(true);
        }
    }

    public boolean saveContentsValues() {
        if (this.frame != null) {
            return this.frame.saveContentsValues();
        }
        return true;
    }

    public void updateFromEditingSettings() {
        if (this.frame != null) {
            this.frame.updateFromEditingSettings();
        }
    }
}

