/*
 * Decompiled with CFR 0.152.
 */
package jfr.pagesucker;

import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.PatternMatcherInput;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import com.oroinc.text.regex.Perl5Pattern;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import jfr.html.Parser;
import jfr.html.parser.AuthorizationErr;
import jfr.html.parser.HostNotFoundException;
import jfr.html.parser.Keyword;
import jfr.html.parser.PageNotFoundException;
import jfr.html.parser.Problem;
import jfr.util.Aborter;
import jfr.util.Alphabet;
import jfr.util.AlphabetException;
import jfr.util.FileSet;
import jfr.util.ModifiableInteger;
import jfr.util.StackInputStream;
import jfr.util.UserAbortException;

public class SuckerParser
extends Parser {
    protected static Alphabet alphabet_not_javascript_special;
    protected static Alphabet alphabet_js_tag;
    protected static Alphabet alphabet_single_quoted_string;
    protected static Alphabet alphabet_url_characters;
    protected static Alphabet alphabet_not_star;
    protected static Alphabet alphabet_not_single_quote;
    protected static Pattern pattern_javascript_close_tag;

    public SuckerParser(URL url, String ref_url_string, String[] default_names, String save_dir, byte in_file_kind, boolean in_use_absolute_paths_in_ram_files, boolean in_use_absolute_paths_in_m3u_files, ModifiableInteger existing_file_strategy, FileSet files_in_use, Aborter the_aborter, int in_recursion_level, boolean in_dont_allow_gt_in_strings, boolean in_accept_single_line_comments) throws IOException, Problem {
        super(url, ref_url_string, default_names, save_dir, in_file_kind, in_use_absolute_paths_in_ram_files, in_use_absolute_paths_in_m3u_files, existing_file_strategy, files_in_use, the_aborter, in_recursion_level, in_dont_allow_gt_in_strings, in_accept_single_line_comments);
    }

    protected void tagAction(Keyword kw) throws IOException, UserAbortException {
        switch (kw.getKind()) {
            case 1: 
            case 6: {
                int kw_kind;
                int[] keyword_pairs = new int[]{2, 60, 13, 60, 14, 60, 15, 60};
                while ((kw_kind = this.findKeywordPairsInTag(true, keyword_pairs)) != -1) {
                    if (kw_kind == 2) {
                        this.handleLink(null, false);
                        continue;
                    }
                    if (!Main.sucker.working_settings.recognize_javascript_in_tags) continue;
                    this.handleSingleLineJavaScript();
                }
                break;
            }
            case 17: {
                if (this.findKeywordPairsInTag(true, 15, 60) == -1) break;
                if (Main.sucker.working_settings.recognize_javascript_in_tags) {
                    this.handleSingleLineJavaScript();
                }
                this.skipToEndOfTag(true);
                break;
            }
            case 19: {
                if (this.findKeywordPairsInTag(true, 20, 60) == -1) break;
                if (Main.sucker.working_settings.guess_urls_in_select) {
                    String str = this.getString();
                    this.evaluateJavaScriptString(str, '\"');
                }
                this.skipToEndOfTag(true);
                break;
            }
            case 9: {
                if (this.findKeywordPairsInTag(true, 5, 60) == -1) break;
                this.handleLink(null, true);
                this.skipToEndOfTag(true);
                break;
            }
            case 4: {
                if (this.findKeywordPairsInTag(true, 5, 60) == -1) break;
                this.handleImage();
                this.skipToEndOfTag(true);
                break;
            }
            case 7: {
                if (this.findKeywordPairsInTag(true, 8, 60) == -1) break;
                this.handleImage();
                this.skipToEndOfTag(true);
                break;
            }
            case 10: {
                if (this.findKeywordPairsInTag(true, 2, 60, false) == -1) break;
                String base_string = Parser.alphabet_control_characters.clean(this.getString());
                try {
                    this.base_url = new URL(base_string);
                }
                catch (MalformedURLException malformedURLException) {}
                this.skipToEndOfTag(true);
                break;
            }
            case 11: {
                int kw_kind;
                boolean javascript_found = false;
                String include_url_string = null;
                URL include_url = null;
                int[] keyword_pairs = new int[]{12, 60, 5, 60};
                while ((kw_kind = this.findKeywordPairsInTag(true, keyword_pairs, false)) != -1) {
                    if (kw_kind == 12) {
                        String script_name;
                        if (this.out_stream != null) {
                            this.out_stream.writeBytes("LANGUAGE=");
                        }
                        if (!(script_name = this.getString().toLowerCase()).startsWith("javascript")) continue;
                        if (this.out_stream != null) {
                            this.out_stream.writeBytes(String.valueOf('\"') + script_name + '\"');
                        }
                        javascript_found = true;
                        continue;
                    }
                    if (Main.sucker.working_settings.guess_urls_in_javascript) {
                        include_url_string = Parser.alphabet_control_characters.clean(this.getString());
                        try {
                            include_url = Parser.buildNormalizedURL(this.getBaseURL(), include_url_string, Main.sucker.working_settings.untyped_object_mode != 11);
                        }
                        catch (MalformedURLException malformedURLException) {
                            Main.sucker.logError("Malformed URL: \"" + include_url_string + "\" (referenced from \"" + this.getPageURL().toString() + "\")");
                            if (this.out_stream != null) {
                                this.out_stream.writeBytes("SRC=");
                            }
                            this.writeURL(include_url_string);
                            include_url = null;
                        }
                        continue;
                    }
                    if (this.out_stream != null) {
                        this.out_stream.writeBytes("SRC=");
                    }
                    this.handleLink(null, false, true, false, '\"', true);
                }
                if (include_url != null) {
                    try {
                        this.includeSourceFile(include_url, javascript_found);
                    }
                    catch (IOException iOException) {
                        Main.sucker.logError("Error while opening downloading \"" + include_url.toString() + "\" (referenced from \"" + this.page_url.toString() + "\")");
                    }
                }
                if (!javascript_found) break;
                this.handleJavaScript();
                break;
            }
            default: {
                this.skipToEndOfTag(true);
            }
        }
    }

    protected void handleLink(String url_string, boolean is_frame) throws IOException {
        this.handleLink(url_string, is_frame, false, false, '\"', true);
    }

    protected void handleLink(String url_string, boolean is_frame, boolean is_javascript_include, boolean deep_check_url_validity, char quote_char, boolean close_string) throws IOException {
        String normalized_url_string = null;
        boolean url_replaced = false;
        if (url_string == null) {
            url_string = Parser.alphabet_control_characters.clean(this.getString());
        }
        String lower_url_protocol = this.getLowerURLProtocol(url_string);
        if (url_string.length() > 0 && !url_string.startsWith("#") && (lower_url_protocol == null || lower_url_protocol.equals("http") || lower_url_protocol.equals("ftp") || lower_url_protocol.equals("file") || lower_url_protocol.equals("javascript") || lower_url_protocol.equals("gopher"))) {
            String lower_url_string_wo_ref;
            String url_string_wo_ref;
            URL url;
            if (lower_url_protocol != null && lower_url_protocol.equals("javascript")) {
                if (!Main.sucker.working_settings.recognize_javascript_in_tags || url_string.length() <= 11) {
                    this.writeURL(url_string, quote_char, close_string);
                    return;
                }
                String js_line = url_string.substring(11);
                this.handleSingleLineJavaScript(js_line, true);
                return;
            }
            try {
                url = Parser.buildNormalizedURL(this.getBaseURL(), url_string, Main.sucker.working_settings.untyped_object_mode != 11);
                url_string_wo_ref = Parser.getURLString(url, true, true, false, false);
                lower_url_string_wo_ref = url_string_wo_ref.toLowerCase();
                normalized_url_string = Parser.getURLString(url, true, true, true, true);
                if (deep_check_url_validity && !this.isURLValid(url, url_string_wo_ref)) {
                    this.writeURL(url_string, quote_char, close_string);
                    return;
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (!deep_check_url_validity) {
                    Main.sucker.logError("Malformed URL: \"" + url_string + "\" (referenced from \"" + this.getPageURL().toString() + "\")");
                }
                this.writeURL(url_string, quote_char, close_string);
                return;
            }
            boolean download_page = this.m_recursion_level != 0 || is_javascript_include || is_frame && Main.sucker.working_settings.consider_frames_on_same_level_as_page;
            boolean is_html = false;
            boolean is_ram = false;
            boolean is_m3u = false;
            boolean in_hierarchy = false;
            boolean same_host = false;
            if (download_page) {
                if (!is_javascript_include) {
                    is_html = Main.sucker.isHTML(lower_url_string_wo_ref);
                    is_ram = Main.sucker.isRAM(lower_url_string_wo_ref);
                    is_m3u = Main.sucker.isM3U(lower_url_string_wo_ref);
                }
                in_hierarchy = url_string_wo_ref.startsWith(Main.sucker.base_url_path_string);
                boolean bl = same_host = url.getHost().equals(Main.sucker.base_url_host) && url.getPort() == Main.sucker.base_url_port;
                if (is_html) {
                    download_page = same_host ? in_hierarchy || Main.sucker.working_settings.parse_html_pages_not_in_hierarchy : Main.sucker.working_settings.parse_remote_html_pages;
                    if (download_page && this.m_recursion_level == 1 && !Main.sucker.working_settings.save_html_pages && !Main.sucker.working_settings.consider_images_on_same_level_as_page && !Main.sucker.working_settings.consider_frames_on_same_level_as_page) {
                        download_page = false;
                    }
                } else if (is_javascript_include) {
                    if (!Main.sucker.working_settings.save_html_pages) {
                        download_page = false;
                    }
                } else if (is_ram) {
                    download_page = same_host ? in_hierarchy || Main.sucker.working_settings.accept_ram_files_not_in_hierarchy : Main.sucker.working_settings.accept_remote_ram_files;
                    if (download_page && this.m_recursion_level == 1 && Main.sucker.working_settings.ram_file_action != 22 && !Main.sucker.working_settings.consider_ram_files_on_same_level_as_page) {
                        download_page = false;
                    }
                } else if (is_m3u) {
                    download_page = same_host ? in_hierarchy || Main.sucker.working_settings.accept_m3u_files_not_in_hierarchy : Main.sucker.working_settings.accept_remote_m3u_files;
                    if (download_page && this.m_recursion_level == 1 && Main.sucker.working_settings.m3u_file_action != 32 && !Main.sucker.working_settings.consider_m3u_files_on_same_level_as_page) {
                        download_page = false;
                    }
                } else if (Main.sucker.working_settings.save_non_html_objects) {
                    download_page = same_host ? in_hierarchy || Main.sucker.working_settings.save_non_html_objects_not_in_hierarchy : Main.sucker.working_settings.save_remote_non_html_objects;
                    if (download_page) {
                        download_page = Main.sucker.matchesRegexpFilter(normalized_url_string);
                    }
                    if (download_page) {
                        download_page = Main.sucker.matchesSaveTypesFilter(lower_url_string_wo_ref);
                    }
                } else {
                    download_page = false;
                }
            }
            if (download_page) {
                if (is_ram && Main.sucker.working_settings.ram_file_action == 23 || is_m3u && Main.sucker.working_settings.m3u_file_action == 33) {
                    String query_url_string_wo_ref = Parser.getURLString(url, true, true, false, true);
                    if (!Main.sucker.isURLKnown(query_url_string_wo_ref)) {
                        String new_url_string = null;
                        Main.sucker.inscribeSaveFile(query_url_string_wo_ref, null);
                        try {
                            new_url_string = Parser.getFirstURLInListFile(url);
                        }
                        catch (PageNotFoundException e) {
                            Main.sucker.logError("Remote file not found: \"" + e.getMessage() + "\" (referenced from \"" + this.page_url.toString() + "\")");
                        }
                        catch (HostNotFoundException e) {
                            Main.sucker.logError("Unknown Host: \"" + e.getMessage() + "\" (referenced from \"" + this.page_url.toString() + "\")");
                        }
                        catch (AuthorizationErr e) {
                            Main.sucker.logError("Unauthorized Access: \"" + e.getMessage() + "\" (referenced from \"" + this.page_url.toString() + "\")");
                        }
                        catch (ThreadDeath e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            Main.sucker.doUnexpectedError(e);
                        }
                        if (new_url_string != null) {
                            this.handleLink(new_url_string, false);
                            return;
                        }
                    }
                } else {
                    if (Main.sucker.working_settings.default_page_names != null && url_string_wo_ref.endsWith("/")) {
                        url = Parser.addDefaultNameToURL(url, Main.sucker.working_settings.default_page_names);
                        url_string_wo_ref = Parser.getURLString(url, true, true, false, false);
                        normalized_url_string = Parser.getURLString(url, true, true, true, true);
                    }
                    try {
                        int new_recursion_level;
                        int n = new_recursion_level = is_javascript_include || is_frame && Main.sucker.working_settings.consider_frames_on_same_level_as_page || is_ram && Main.sucker.working_settings.consider_ram_files_on_same_level_as_page || is_m3u && Main.sucker.working_settings.consider_m3u_files_on_same_level_as_page ? this.m_recursion_level : this.m_recursion_level - 1;
                        if (is_html && !same_host && Main.sucker.working_settings.max_remote_recursion_depth >= 0 && (new_recursion_level < 0 || Main.sucker.working_settings.max_remote_recursion_depth < new_recursion_level)) {
                            new_recursion_level = Main.sucker.working_settings.max_remote_recursion_depth;
                        }
                        byte file_kind = is_html ? (byte)1 : (is_javascript_include ? (byte)4 : (is_ram ? (byte)2 : (is_m3u ? (byte)3 : 4)));
                        url_replaced = Main.sucker.createParserForPage(url, this.getPageURL().toString(), normalized_url_string, file_kind, this, new_recursion_level, quote_char);
                    }
                    catch (Problem e) {
                        Main.sucker.logError("A Parser Error has occurred: " + e.getMessage());
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        Main.sucker.doUnexpectedError(e);
                    }
                }
            }
        }
        if (!url_replaced) {
            if (normalized_url_string != null) {
                this.writeURL(normalized_url_string, quote_char, close_string);
            } else {
                this.writeURL(url_string, quote_char, close_string);
            }
        }
    }

    private void handleImage() throws IOException {
        String url_string;
        boolean url_replaced;
        String normalized_url_string;
        block15: {
            normalized_url_string = null;
            url_replaced = false;
            url_string = Parser.alphabet_control_characters.clean(this.getString());
            String lower_url_protocol = this.getLowerURLProtocol(url_string);
            if (url_string.length() > 0 && (lower_url_protocol == null || lower_url_protocol.equals("http") || lower_url_protocol.equals("ftp") || lower_url_protocol.equals("file") || lower_url_protocol.equals("javascript") || lower_url_protocol.equals("gopher"))) {
                if (lower_url_protocol != null && lower_url_protocol.equals("javascript")) {
                    if (!Main.sucker.working_settings.recognize_javascript_in_tags || url_string.length() <= 11) {
                        this.writeURL(url_string, '\"', true);
                        return;
                    }
                    String js_line = url_string.substring(11);
                    this.handleSingleLineJavaScript(js_line, true);
                    return;
                }
                try {
                    boolean download_image;
                    URL url = Parser.buildNormalizedURL(this.getBaseURL(), url_string, Main.sucker.working_settings.untyped_object_mode != 11);
                    String url_string_wo_ref = Parser.getURLString(url, true, true, false, false);
                    String lower_url_string_wo_ref = url_string_wo_ref.toLowerCase();
                    normalized_url_string = Parser.getURLString(url, true, true, true, true);
                    boolean bl = download_image = Main.sucker.working_settings.save_embedded_images && (Main.sucker.working_settings.max_recursion_depth == -1 || this.m_recursion_level > 0 || this.m_recursion_level == 0 && Main.sucker.working_settings.consider_images_on_same_level_as_page);
                    if (download_image) {
                        download_image = Main.sucker.matchesRegexpFilter(normalized_url_string);
                    }
                    if (download_image) {
                        download_image = url.getHost().equals(Main.sucker.base_url_host) && url.getPort() == Main.sucker.base_url_port ? Main.sucker.working_settings.save_images_not_in_hierarchy || url_string_wo_ref.startsWith(Main.sucker.base_url_path_string) : Main.sucker.working_settings.save_remote_images;
                    }
                    if (download_image) {
                        download_image = Main.sucker.matchesSaveTypesFilter(lower_url_string_wo_ref);
                    }
                    if (!download_image) break block15;
                    try {
                        url_replaced = Main.sucker.createParserForPage(url, this.getPageURL().toString(), normalized_url_string, (byte)4, this, this.m_recursion_level, '\"');
                    }
                    catch (Problem e) {
                        Main.sucker.logError("A Parser Error has occurred: " + e.getMessage());
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        Main.sucker.doUnexpectedError(e);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Main.sucker.logError("Malformed URL: \"" + url_string + "\" (referenced from \"" + this.getPageURL().toString() + "\")");
                    this.writeURL(url_string);
                    return;
                }
            }
        }
        if (!url_replaced) {
            if (normalized_url_string != null) {
                this.writeURL(normalized_url_string);
            } else {
                this.writeURL(url_string);
            }
        }
    }

    protected void handleJavaScript() throws IOException, UserAbortException {
        this.handleJavaScript(this.in_stream, true);
    }

    protected void handleJavaScript(StackInputStream stream, boolean recognize_script_end_tag) throws IOException, UserAbortException {
        if (!Main.sucker.working_settings.guess_urls_in_javascript) {
            return;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        do {
            String str;
            int v;
            if ((v = alphabet_not_javascript_special.skip(stream, this.out_stream)) == -1) {
                return;
            }
            char current_char = (char)v;
            if (current_char == '/') {
                stream.read();
                if (this.out_stream != null) {
                    this.out_stream.writeByte(47);
                }
                if ((v = stream.peek()) == -1) {
                    return;
                }
                char next_char = (char)v;
                if (next_char == '/') {
                    PatternMatcherInput matcher_input;
                    String comment_line = Parser.alphabet_not_eol.span(stream);
                    if (recognize_script_end_tag && matcher.contains(matcher_input = new PatternMatcherInput(comment_line), pattern_javascript_close_tag)) {
                        String pre_match = matcher_input.preMatch();
                        String match = matcher_input.match();
                        String post_match = matcher_input.postMatch();
                        if (this.out_stream != null) {
                            this.out_stream.writeBytes(pre_match);
                            this.out_stream.writeBytes(match);
                        }
                        stream.pushBack(post_match);
                        return;
                    }
                    if (this.out_stream == null) continue;
                    this.out_stream.writeBytes(comment_line);
                    continue;
                }
                if (next_char != '*') continue;
                stream.read();
                if (this.out_stream != null) {
                    this.out_stream.writeByte(42);
                }
                boolean end_of_comment_found = false;
                do {
                    if (alphabet_not_star.skip(stream, this.out_stream) == -1) {
                        return;
                    }
                    stream.read();
                    if (this.out_stream != null) {
                        this.out_stream.writeByte(42);
                    }
                    if (stream.peek() != 47) continue;
                    stream.read();
                    if (this.out_stream != null) {
                        this.out_stream.writeByte(47);
                    }
                    end_of_comment_found = true;
                } while (!end_of_comment_found);
                continue;
            }
            if (current_char == '<') {
                String tag_name;
                stream.read();
                if (this.out_stream != null) {
                    this.out_stream.writeByte(60);
                }
                if (!recognize_script_end_tag || !(tag_name = alphabet_js_tag.span(stream, this.out_stream)).toLowerCase().equals("/script")) continue;
                this.skipToEndOfTag(true);
                return;
            }
            if (current_char == '\"') {
                stream.read();
                str = Parser.alphabet_string.span(stream);
                stream.read();
                this.evaluateJavaScriptString(str, '\"');
                continue;
            }
            if (current_char != '\'') continue;
            stream.read();
            str = alphabet_single_quoted_string.span(stream);
            stream.read();
            this.evaluateJavaScriptString(str, '\'');
        } while (this.aborter == null || !this.aborter.abortRequested());
        throw new UserAbortException();
    }

    protected void handleSingleLineJavaScript() throws IOException {
        this.handleSingleLineJavaScript(null, false);
    }

    protected void handleSingleLineJavaScript(String line_string, boolean prefix_js_protocol) throws IOException {
        if (line_string == null) {
            line_string = this.getString();
        }
        StringBuffer js_line = new StringBuffer(line_string);
        js_line.reverse();
        if (this.out_stream != null) {
            this.out_stream.writeByte(34);
            if (prefix_js_protocol) {
                this.out_stream.writeBytes("javascript:");
            }
        }
        while (alphabet_not_single_quote.skipBack(js_line, this.out_stream) != -1) {
            Alphabet.readFromEnd(js_line);
            String str = alphabet_single_quoted_string.spanBackAndRemove(js_line);
            Alphabet.readFromEnd(js_line);
            this.evaluateJavaScriptString(str, '\'');
        }
        if (this.out_stream != null) {
            this.out_stream.writeByte(34);
        }
    }

    private void evaluateJavaScriptString(String str, char quote_char) throws IOException {
        if (str.length() > 0 && alphabet_url_characters.contains(str)) {
            this.handleLink(str, false, false, true, quote_char, true);
        } else if (quote_char != '\"') {
            StringBuffer js_line = new StringBuffer(str);
            js_line.reverse();
            if (this.out_stream != null) {
                this.out_stream.writeByte(quote_char);
            }
            while (Parser.alphabet_string.skipBack(js_line, this.out_stream) != -1) {
                boolean string_closed;
                Alphabet.readFromEnd(js_line);
                String encased_string = Parser.alphabet_string.spanBackAndRemove(js_line);
                boolean bl = string_closed = Alphabet.readFromEnd(js_line) != -1;
                if (encased_string.length() > 0 && alphabet_url_characters.contains(encased_string)) {
                    this.handleLink(encased_string, false, false, true, '\"', string_closed);
                    continue;
                }
                this.writeURL(encased_string, '\"', string_closed);
            }
            if (this.out_stream != null) {
                this.out_stream.writeByte(quote_char);
            }
        } else {
            this.writeURL(str, quote_char, true);
        }
    }

    protected void includeSourceFile(URL url, boolean is_javascript) throws UserAbortException, IOException {
        BufferedInputStream stream;
        Object result = null;
        if (!(this.out_stream != null || is_javascript && Main.sucker.working_settings.guess_urls_in_javascript)) {
            return;
        }
        try {
            stream = new BufferedInputStream(url.openStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            Main.sucker.logError("Remote file not found: \"" + url.toString() + "\" (referenced from \"" + this.page_url.toString() + "\")");
            return;
        }
        catch (UnknownHostException unknownHostException) {
            Main.sucker.logError("Unknown Host: \"" + url.toString() + "\" (referenced from \"" + this.page_url.toString() + "\")");
            return;
        }
        if (is_javascript && Main.sucker.working_settings.guess_urls_in_javascript) {
            this.handleJavaScript(new StackInputStream(stream), false);
        } else if (this.out_stream != null) {
            int size;
            byte[] buffer = new byte[this.input_buffer_size];
            while ((size = stream.read(buffer)) != -1) {
                this.out_stream.write(buffer, 0, size);
                if (this.aborter == null || !this.aborter.abortRequested()) continue;
                throw new UserAbortException();
            }
        }
        ((FilterInputStream)stream).close();
    }

    protected void displayStatus(String description, char status) {
        Main.sucker.frame_control.setThreadStatus(description, this.thread_index, status);
    }

    protected void setConnectionRequestProperties(URL url, URLConnection connection) {
        if (Main.sucker.hashtable_authentications != null) {
            String encoded_login;
            String host = url.getHost();
            int port = url.getPort();
            String netloc = host;
            if (port != -1) {
                netloc = String.valueOf(netloc) + ':';
                netloc = String.valueOf(netloc) + String.valueOf(port);
            }
            if ((encoded_login = (String)Main.sucker.hashtable_authentications.get(netloc)) != null) {
                connection.setRequestProperty("Authorization", "Basic " + encoded_login);
            }
        }
    }

    protected boolean isURLValid(URL url, String url_string_wo_ref) {
        try {
            URLConnection connection = this.openURLConnection(url);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    static {
        try {
            alphabet_not_javascript_special = new Alphabet(Parser.alphabet_not_tag_start);
            alphabet_not_javascript_special.sub("'\"/");
            alphabet_js_tag = new Alphabet(Parser.alphabet_not_tag_end_or_whitespace);
            alphabet_js_tag.sub("'\"<");
            alphabet_single_quoted_string = new Alphabet('\'');
            alphabet_single_quoted_string.invert();
            alphabet_url_characters = new Alphabet('A', 'Z');
            alphabet_url_characters.add(new Alphabet('a', 'z'));
            alphabet_url_characters.add("0123456789$-_.+!,*()'%/:#?;=&@");
            alphabet_not_star = new Alphabet('*');
            alphabet_not_star.invert();
            alphabet_not_single_quote = new Alphabet('\'');
            alphabet_not_single_quote.invert();
            Perl5Compiler compiler = new Perl5Compiler();
            pattern_javascript_close_tag = (Perl5Pattern)compiler.compile(".*-->[ \t]*</script[^>]*>", 1);
        }
        catch (AlphabetException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (MalformedPatternException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

