/*
 * Decompiled with CFR 0.152.
 */
package jfr.util;

import java.io.IOException;
import java.io.InputStream;
import jfr.util.CharacterStack;

public class StackInputStream {
    protected InputStream in_stream;
    protected CharacterStack in_stack;

    public StackInputStream(InputStream in) {
        this.in_stream = in;
        this.in_stack = new CharacterStack();
    }

    public int read() throws IOException {
        if (!this.in_stack.empty()) {
            return this.in_stack.pop();
        }
        return this.in_stream.read();
    }

    public int peek() throws IOException {
        if (!this.in_stack.empty()) {
            return this.in_stack.peek();
        }
        int v = this.in_stream.read();
        if (v != -1) {
            this.in_stack.push(v);
        }
        return v;
    }

    public void pushBack(int v) {
        if (v != -1) {
            this.in_stack.push(v);
        }
    }

    public void pushBack(String str) {
        this.in_stack.push(str);
    }

    public void close() throws IOException {
        this.in_stream.close();
        this.in_stream = null;
        this.in_stack = null;
    }
}

