:
# Sample Shell Script -
#          how to address the WINDOWS printer
#          via "Eric's Telnet98" from a UNIX host
#
#          this script can be used as a filter and as a command
#
# - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# Notice:  the printer can be managed more precisely 
#          with the following additional escapes:
#
#
# EOL          ESC[5;2 i       set printposition to pos 0 in the current line
# LFBACK       ESC[5;3 i       linefeed one line back
# CPI          ESC[5;6;n i     characters per inch
# POSITION     ESC[5;12;n i    set printposition in the current line
#                              n= column
# BOLD         ESC[5;14;n i    n=0 => bold mode OFF
#                              n=1 => bold mode ON
# RESET        ESC[5;17 i      reset all attributes to default
# UNDERLINE    ESC[5;18;n i    n=0 => underline mode OFF
#                              n=1 => underline mode ON
# STRIKE       ESC[5;19;n i    n=0 => strikeout mode OFF
#                              n=1 => strikeout mode ON
# SUBSCRIPT    ESC[5;20;n i    n=0 => subscript mode OFF
#                              n=1 => subscript mode ON
# SUPERSCRIPT  ESC[5;21;n i    n=0 => superscript mode OFF
#                              n=1 => superscript mode ON
# DOUBLEHEIGHT ESC[5;22;n i    n=0 => double height mode OFF
#                              n=1 => double height mode ON
# DOUBLEWIDTH  ESC[5;23;n i    n=0 => double width mode OFF
#                              n=1 => double width mode ON
# PAGELENGTH   ESC[5;24;n i    n= lines per page
# LPI          ESC[5;26;n i    n= lines per inch
# ITALIC       ESC[5;27;n i    n=0 => italic mode OFF
#                              n=1 => italic mode ON
#########################################################################

OPEN_PRINTER="\033[5i"
CLOSE_PRINTER="\033[4i"
export OPEN_PRINTER CLOSE_PRINTER



filter()
{
        /bin/echo "${OPEN_PRINTER}\c"
	cat
        /bin/echo "${CLOSE_PRINTER}\c"
}



PrintFile()
{
	MY_NAME=$1
	shift 1
        for FILE in $*
	do
                echo ${FILE}
                [ -r ${FILE} ] || {
                        echo "${MY_NAME}: cannot open ${FILE}">&2
			continue
		} 
                /bin/echo "${OPEN_PRINTER}\c"
                cat ${FILE}
                /bin/echo "${CLOSE_PRINTER}\c"
	done
} 



#
# main
#------------------------------------
#
trap "" 1 2 3
if expr $# \> 0 >/dev/null 2>&1
then
	PrintFile $0 $*
else
	filter
fi
